/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisVersionCalcApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisVersionCalcApiResult;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingDynamicObjectEffDateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.calc.EnumVersionDataChangeType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HisVersionCalcApiService {
    private static volatile HisVersionCalcApiService service = null;

    private HisVersionCalcApiService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisVersionCalcApiService getInstance() {
        if (service != null) return service;
        Class<HisVersionCalcApiService> clazz = HisVersionCalcApiService.class;
        synchronized (HisVersionCalcApiService.class) {
            if (service != null) return service;
            service = new HisVersionCalcApiService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public HrApiResponse<HisVersionCalcApiResult> calcTipsVo(HisVersionCalcApiParam hisVersionCalcApiParam) {
        String errorMessage = this.validateBaseParam(hisVersionCalcApiParam);
        if (errorMessage != null) {
            return this.buildErrorResponse(errorMessage);
        }
        DynamicObject dynamicObject = hisVersionCalcApiParam.getDynamicObject();
        String entityNumber = dynamicObject.getDynamicObjectType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Long boId = dynamicObject.getLong("boid");
        Object[] oldEffVersionDys = HisCommonEntityRepository.loadOldEffVersionByBoIdWithoutNoInit(serviceHelper, boId);
        SortingDynamicObjectEffDateService.getInstance().quickSort(oldEffVersionDys);
        errorMessage = this.validateData(hisVersionCalcApiParam, (DynamicObject[])oldEffVersionDys);
        if (errorMessage != null) {
            return this.buildErrorResponse(errorMessage);
        }
        HisVersionCalcApiResult hisVersionCalcApiResult = this.processVersion(serviceHelper, dynamicObject, (DynamicObject[])oldEffVersionDys);
        HrApiResponse hrApiResponse = new HrApiResponse();
        hrApiResponse.setData((Object)hisVersionCalcApiResult);
        return hrApiResponse;
    }

    private String validateBaseParam(HisVersionCalcApiParam hisVersionCalcApiParam) {
        if (hisVersionCalcApiParam == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionCalcApiService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        DynamicObject dynamicObject = hisVersionCalcApiParam.getDynamicObject();
        if (dynamicObject == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570dynamicObject\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisVersionCalcApiService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        if (dynamicObjectType == null) {
            return ResManager.loadKDString((String)"\u83b7\u53d6\u52a8\u6001\u5bf9\u8c61\u7c7b\u578b\u51fa\u9519\u3002", (String)"HisVersionCalcApiService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        String entityNumber = dynamicObjectType.getName();
        if (StringUtils.isEmpty((String)entityNumber)) {
            return ResManager.loadKDString((String)"\u83b7\u53d6\u5b9e\u4f53\u7f16\u7801\u51fa\u9519\u3002", (String)"HisVersionCalcApiService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        Long boId = dynamicObject.getLong("boid");
        if (boId == null || boId == 0L) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u201cBOID\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionCalcApiService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        Date startDate = dynamicObject.getDate("bsed");
        if (startDate == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570dynamicObject\u4e2d\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisVersionCalcApiService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        Date endDate = dynamicObject.getDate("bsled");
        if (endDate == null) {
            endDate = HRDateTimeUtils.getSysMaxDate();
        }
        if (endDate.getTime() < startDate.getTime()) {
            return ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"HisVersionCalcApiService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        return null;
    }

    private String validateData(HisVersionCalcApiParam hisVersionCalcApiParam, DynamicObject[] oldEffVersionDys) {
        if (oldEffVersionDys == null || oldEffVersionDys.length == 0) {
            return ResManager.loadKDString((String)"\u65e7\u751f\u6548\u7248\u672c\u4e3a\u7a7a\uff0c\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"HisVersionCalcApiService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        DynamicObject dynamicObject = oldEffVersionDys[0];
        Date firstEffDate = dynamicObject.getDate("bsed");
        if (firstEffDate == null) {
            return ResManager.loadKDString((String)"\u65e7\u7248\u751f\u6548\u65e5\u671f\u7a7a\uff0c\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"HisVersionCalcApiService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        if (!hisVersionCalcApiParam.isValidateContinuity()) {
            return null;
        }
        Date effEndDate = hisVersionCalcApiParam.getDynamicObject().getDate("bsled");
        if (firstEffDate.getTime() - effEndDate.getTime() > 86400000L) {
            return ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u53d8\u66f4\u6709\u6548\u671f\u4e0e\u5f53\u524d\u6570\u636e\u7684\u6709\u6548\u671f\u4e0d\u8fde\u7eed\u3002", (String)"HisVersionCalcApiService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        return null;
    }

    private HrApiResponse<HisVersionCalcApiResult> buildErrorResponse(String errorMessage) {
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            HrApiResponse response = new HrApiResponse();
            response.setSuccess(false);
            response.setCode(EnumResponseCode.FAIL.getCode());
            response.setErrorMessage(errorMessage);
            return response;
        }
        return null;
    }

    private HisVersionCalcApiResult processVersion(HRBaseServiceHelper serviceHelper, DynamicObject dyNew, DynamicObject[] oldEffVersionDys) {
        HisVersionCalcApiResult hisVersionCalcApiResult = new HisVersionCalcApiResult();
        HashMap mapHisVersionCalcData = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject dyNewCopy = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dyNew, (DynamicObject)dyNewCopy, (boolean)true);
        ArrayList newDyList = Lists.newArrayListWithExpectedSize((int)10);
        newDyList.add(dyNewCopy);
        mapHisVersionCalcData.put(EnumVersionDataChangeType.NEW.getType(), newDyList);
        Date effStartDate = dyNewCopy.getDate("bsed");
        Date effEndDate = dyNewCopy.getDate("bsled");
        if (effEndDate == null) {
            effEndDate = HRDateTimeUtils.getSysMaxDate();
            dyNewCopy.set("bsled", (Object)effEndDate);
        }
        for (DynamicObject dyOldVersion : oldEffVersionDys) {
            Date oldEffStartDate = dyOldVersion.getDate("bsed");
            Date oldEffEndDate = dyOldVersion.getDate("bsled");
            if (oldEffStartDate == null || oldEffEndDate == null) continue;
            if (effStartDate.getTime() < oldEffStartDate.getTime()) {
                this.processBeforeVersion(serviceHelper, effEndDate, oldEffStartDate, oldEffEndDate, mapHisVersionCalcData, dyOldVersion);
                continue;
            }
            if (effStartDate.getTime() > oldEffStartDate.getTime()) {
                this.processAfterVersion(serviceHelper, effStartDate, effEndDate, oldEffEndDate, mapHisVersionCalcData, dyOldVersion);
                continue;
            }
            this.processEqualsVersion(serviceHelper, effEndDate, oldEffEndDate, mapHisVersionCalcData, dyOldVersion);
        }
        List updateDyList = (List)mapHisVersionCalcData.get(EnumVersionDataChangeType.UPDATE.getType());
        HisCommonService.getInstance().calcVersionStatus(updateDyList);
        HisCommonService.getInstance().calcVersionStatus(newDyList);
        hisVersionCalcApiResult.setHisVersionCalcData(mapHisVersionCalcData);
        return hisVersionCalcApiResult;
    }

    private void processBeforeVersion(HRBaseServiceHelper serviceHelper, Date effEndDate, Date oldEffStartDate, Date oldEffEndDate, Map<String, List<DynamicObject>> mapHisVersionCalcData, DynamicObject dyOldVersion) {
        if (effEndDate.getTime() >= oldEffStartDate.getTime() && effEndDate.getTime() < oldEffEndDate.getTime()) {
            List<DynamicObject> updateDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.UPDATE.getType());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            Date newDate = calendar.getTime();
            DynamicObject newUpdateDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newUpdateDy, (boolean)true);
            newUpdateDy.set("bsed", (Object)newDate);
            updateDyList.add(newUpdateDy);
        }
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            List<DynamicObject> deleteDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.DELETE.getType());
            DynamicObject newDeleteDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newDeleteDy, (boolean)true);
            newDeleteDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            deleteDyList.add(newDeleteDy);
        }
    }

    private void processAfterVersion(HRBaseServiceHelper serviceHelper, Date effStartDate, Date effEndDate, Date oldEffEndDate, Map<String, List<DynamicObject>> mapHisVersionCalcData, DynamicObject dyOldVersion) {
        if (effStartDate.getTime() <= oldEffEndDate.getTime() && effEndDate.getTime() >= oldEffEndDate.getTime()) {
            List<DynamicObject> updateDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.UPDATE.getType());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            DynamicObject newUpdateDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newUpdateDy, (boolean)true);
            newUpdateDy.set("bsled", (Object)calendar.getTime());
            updateDyList.add(newUpdateDy);
        }
        if (effEndDate.getTime() < oldEffEndDate.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            DynamicObject newUpdateDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newUpdateDy, (boolean)true);
            newUpdateDy.set("bsled", (Object)calendar.getTime());
            List<DynamicObject> updateDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.UPDATE.getType());
            updateDyList.add(newUpdateDy);
            DynamicObject newDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newDy, (boolean)true);
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            newDy.set("bsed", (Object)calendar.getTime());
            newDy.set("hisversion", (Object)"");
            List<DynamicObject> newList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.NEW.getType());
            newList.add(newDy);
        }
    }

    private void processEqualsVersion(HRBaseServiceHelper serviceHelper, Date effEndDate, Date oldEffEndDate, Map<String, List<DynamicObject>> mapHisVersionCalcData, DynamicObject dyOldVersion) {
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            DynamicObject newDeleteDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newDeleteDy, (boolean)true);
            newDeleteDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            List<DynamicObject> deleteDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.DELETE.getType());
            deleteDyList.add(newDeleteDy);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            DynamicObject newUpdateDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyOldVersion, (DynamicObject)newUpdateDy, (boolean)true);
            newUpdateDy.set("bsed", (Object)calendar.getTime());
            List<DynamicObject> updateDyList = this.getDyListByKey(mapHisVersionCalcData, EnumVersionDataChangeType.UPDATE.getType());
            updateDyList.add(newUpdateDy);
        }
    }

    private List<DynamicObject> getDyListByKey(Map<String, List<DynamicObject>> mapHisVersionCalcData, String key) {
        ArrayList updateDyList = mapHisVersionCalcData.get(key);
        if (updateDyList == null) {
            updateDyList = Lists.newArrayListWithExpectedSize((int)10);
            mapHisVersionCalcData.put(key, updateDyList);
        }
        return updateDyList;
    }
}

