/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.calc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransVersionBo;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachmentSourceIdBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.service.newhismodel.calc.IHisVersionCalcService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HisVersionCalcService
implements IHisVersionCalcService {
    private static volatile HisVersionCalcService hisVersionCalcService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisVersionCalcService getInstance() {
        if (hisVersionCalcService != null) return hisVersionCalcService;
        Class<HisVersionCalcService> clazz = HisVersionCalcService.class;
        synchronized (HisVersionCalcService.class) {
            if (hisVersionCalcService != null) return hisVersionCalcService;
            hisVersionCalcService = new HisVersionCalcService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisVersionCalcService;
        }
    }

    @Override
    public void processVersion(List<DynamicObject> newDynamicObjectList, EffStartEndDateBo[] effStartEndDateBos, DynamicObject[] oldDynamicObjects, HisTransBusinessBo hisTransBusinessBo, HRBaseServiceHelper serviceHelper, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, List<DynamicObject> updateDateVersionList) {
        if (oldDynamicObjects == null || oldDynamicObjects.length == 0) {
            ArrayList<HisTransVersionBo> hisTransVersionBoList = new ArrayList<HisTransVersionBo>(4);
            hisTransBusinessBo.setListHisTransVersionBo(hisTransVersionBoList);
            return;
        }
        int size = oldDynamicObjects.length;
        ArrayList<HisTransVersionBo> hisTransVersionBoList = new ArrayList<HisTransVersionBo>(size);
        hisTransBusinessBo.setListHisTransVersionBo(hisTransVersionBoList);
        HashMap<Long, HisTransVersionBo> mapVersion = new HashMap<Long, HisTransVersionBo>(size);
        ArrayList<DynamicObject> newSplitVersionDyList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> oldDynamicObjectList = new ArrayList<DynamicObject>(size);
        HashSet<Long> oldDataIdSet = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : oldDynamicObjects) {
            oldDataIdSet.add((Long)dynamicObject.getPkValue());
        }
        Collections.addAll(oldDynamicObjectList, oldDynamicObjects);
        for (EffStartEndDateBo effStartEndDateBo : effStartEndDateBos) {
            Date effStartDate = effStartEndDateBo.getEffectStartDate();
            for (int i = 0; i < size; ++i) {
                DynamicObject oldDynamicObject = (DynamicObject)oldDynamicObjectList.get(i);
                Date oldEffStartDate = oldDynamicObject.getDate("bsed");
                if (effStartDate.getTime() < oldEffStartDate.getTime()) {
                    this.processBeforeVersion(updateDateVersionList, effStartEndDateBo, oldDynamicObject, mapVersion, hisTransVersionBoList, oldDataIdSet);
                    continue;
                }
                if (effStartDate.getTime() > oldEffStartDate.getTime()) {
                    this.processAfterVersion(newSplitVersionDyList, updateDateVersionList, oldDynamicObjectList, effStartEndDateBo, oldDynamicObject, mapVersion, serviceHelper, hisTransVersionBoList, oldDataIdSet, hisAttachmentSourceIdBoList);
                    if (oldDynamicObjectList.size() <= size) continue;
                    size = oldDynamicObjectList.size();
                    continue;
                }
                this.processEqualsVersion(updateDateVersionList, effStartEndDateBo, oldDynamicObject, mapVersion, hisTransVersionBoList, oldDataIdSet);
            }
        }
        if (!CollectionUtils.isEmpty(newSplitVersionDyList)) {
            newDynamicObjectList.addAll(newSplitVersionDyList);
        }
    }

    private void processBeforeVersion(List<DynamicObject> oldReUpdateVersionDys, EffStartEndDateBo effStartEndDateBo, DynamicObject oldDynamicObject, Map<Long, HisTransVersionBo> mapVersion, List<HisTransVersionBo> hisTransVersionBoList, Set<Long> oldDataIdSet) {
        HisTransVersionBo hisTransVersionBo;
        Date effEndDate = effStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldDynamicObject.getDate("bsed");
        Date oldEffEndDate = oldDynamicObject.getDate("bsled");
        Long versionId = oldDynamicObject.getLong("id");
        if (effEndDate.getTime() >= oldEffStartDate.getTime() && oldDataIdSet.contains(versionId) && (hisTransVersionBo = this.buildHisTransVersionBo(oldDynamicObject, mapVersion, versionId, oldEffStartDate, oldEffEndDate)) != null) {
            hisTransVersionBoList.add(hisTransVersionBo);
        }
        if (effEndDate.getTime() >= oldEffStartDate.getTime() && effEndDate.getTime() < oldEffEndDate.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            Date newDate = calendar.getTime();
            oldDynamicObject.set("bsed", (Object)newDate);
            HisTimeZoneService.getInstance().initPlanBsed(oldDynamicObject);
            oldReUpdateVersionDys.add(oldDynamicObject);
        }
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            oldDynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            oldReUpdateVersionDys.add(oldDynamicObject);
        }
    }

    private void processAfterVersion(List<DynamicObject> newSplitVersionDyList, List<DynamicObject> oldReUpdateVersionDys, List<DynamicObject> oldDynamicObjectList, EffStartEndDateBo effStartEndDateBo, DynamicObject oldDynamicObject, Map<Long, HisTransVersionBo> mapVersion, HRBaseServiceHelper serviceHelper, List<HisTransVersionBo> hisTransVersionBoList, Set<Long> oldDataIdSet, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList) {
        HisTransVersionBo hisTransVersionBo;
        Date effStartDate = effStartEndDateBo.getEffectStartDate();
        Date effEndDate = effStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldDynamicObject.getDate("bsed");
        Date oldEffEndDate = oldDynamicObject.getDate("bsled");
        Long versionId = oldDynamicObject.getLong("id");
        if (effStartDate.getTime() <= oldEffEndDate.getTime() && oldDataIdSet.contains(versionId) && (hisTransVersionBo = this.buildHisTransVersionBo(oldDynamicObject, mapVersion, versionId, oldEffStartDate, oldEffEndDate)) != null) {
            hisTransVersionBoList.add(hisTransVersionBo);
        }
        if (effStartDate.getTime() <= oldEffEndDate.getTime() && effEndDate.getTime() >= oldEffEndDate.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            oldDynamicObject.set("bsled", (Object)calendar.getTime());
            oldReUpdateVersionDys.add(oldDynamicObject);
        }
        if (effEndDate.getTime() < oldEffEndDate.getTime()) {
            DynamicObject dyNewVersion = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)oldDynamicObject, (DynamicObject)dyNewVersion, this.getBaseIgnoreKeys(), (boolean)true);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            oldDynamicObject.set("bsled", (Object)calendar.getTime());
            oldDynamicObject.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(oldEffStartDate, calendar.getTime()));
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            dyNewVersion.set("bsed", (Object)calendar.getTime());
            effStartEndDateBo.setEffectStartDate(calendar.getTime());
            HisTimeZoneService.getInstance().initPlanBsed(dyNewVersion);
            dyNewVersion.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(calendar.getTime(), oldEffEndDate));
            newSplitVersionDyList.add(dyNewVersion);
            oldDynamicObjectList.add(dyNewVersion);
            if (hisAttachmentSourceIdBoList != null) {
                HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
                Long id = ORM.create().genLongId(dyNewVersion.getDataEntityType().getName());
                dyNewVersion.set("id", (Object)id);
                hisAttachmentSourceIdBo.setId(id);
                hisAttachmentSourceIdBo.setSourceId(oldDynamicObject.getLong("id"));
                hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
            }
            oldReUpdateVersionDys.add(oldDynamicObject);
        }
    }

    private void processEqualsVersion(List<DynamicObject> oldReUpdateVersionDys, EffStartEndDateBo effStartEndDateBo, DynamicObject oldDynamicObject, Map<Long, HisTransVersionBo> mapVersion, List<HisTransVersionBo> hisTransVersionBoList, Set<Long> oldDataIdSet) {
        HisTransVersionBo hisTransVersionBo;
        Date effEndDate = effStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldDynamicObject.getDate("bsed");
        Date oldEffEndDate = oldDynamicObject.getDate("bsled");
        Long versionId = oldDynamicObject.getLong("id");
        if (oldDataIdSet.contains(versionId) && (hisTransVersionBo = this.buildHisTransVersionBo(oldDynamicObject, mapVersion, versionId, oldEffStartDate, oldEffEndDate)) != null) {
            hisTransVersionBoList.add(hisTransVersionBo);
        }
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            oldDynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
            oldReUpdateVersionDys.add(oldDynamicObject);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            oldDynamicObject.set("bsed", (Object)calendar.getTime());
            HisTimeZoneService.getInstance().initPlanBsed(oldDynamicObject);
            oldDynamicObject.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(oldEffStartDate, oldDynamicObject.getDate("bsled")));
            oldReUpdateVersionDys.add(oldDynamicObject);
        }
    }

    private HisTransVersionBo buildHisTransVersionBo(DynamicObject oldDynamicObject, Map<Long, HisTransVersionBo> mapVersion, Long versionId, Date oldEffStartDate, Date oldEffEndDate) {
        if (mapVersion.containsKey(versionId)) {
            return null;
        }
        HisTransVersionBo hisTransVersionBo = new HisTransVersionBo();
        hisTransVersionBo.setVersionId(versionId);
        hisTransVersionBo.setBeforeEffStartDate(oldEffStartDate);
        hisTransVersionBo.setBeforeEffEndDate(oldEffEndDate);
        mapVersion.put(versionId, hisTransVersionBo);
        String beforeStatus = oldDynamicObject.getString("datastatus");
        hisTransVersionBo.setBeforeStatus(beforeStatus);
        return hisTransVersionBo;
    }

    private Set<String> getBaseIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("id");
        ignoreKeys.add("masterid");
        return ignoreKeys;
    }
}

