/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.event.HisSearchLaterEventBO;
import kd.hr.hbp.business.domain.model.newhismodel.event.HisSearchLaterEventParam;
import kd.hr.hbp.business.domain.model.newhismodel.event.HisSearchLaterEventResult;
import kd.hr.hbp.business.domain.model.newhismodel.event.result.LaterEventBo;
import kd.hr.hbp.business.domain.model.newhismodel.event.result.LaterEventEntityBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRObjectUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class HisModelEventSearchService {
    private static final Log LOGGER = LogFactory.getLog(HisModelEventSearchService.class);
    private static final int MAX_ENTITY_NUM = 60;
    private static final int MAX_DEPTH = 5;
    private static final int MAX_DATA_COUNT = 2000;
    private static final String STRING = "-##-";
    private static volatile HisModelEventSearchService service = null;

    private HisModelEventSearchService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisModelEventSearchService getInstance() {
        if (service != null) return service;
        Class<HisModelEventSearchService> clazz = HisModelEventSearchService.class;
        synchronized (HisModelEventSearchService.class) {
            if (service != null) return service;
            service = new HisModelEventSearchService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public HrApiResponse<HisSearchLaterEventResult> searchLaterEventApi(HisSearchLaterEventParam hisSearchLaterEventParam) {
        try {
            HisSearchLaterEventBO hisSearchLaterEventBO = this.searchLaterEvent(hisSearchLaterEventParam);
            if (!hisSearchLaterEventBO.isSuccess()) {
                HrApiResponse hrApiResponse = new HrApiResponse();
                hrApiResponse.setSuccess(false);
                hrApiResponse.setCode(EnumResponseCode.FAIL.getCode());
                hrApiResponse.setErrorMessage(hisSearchLaterEventBO.getBaseValidateResult());
                hrApiResponse.setData((Object)hisSearchLaterEventBO.getLaterEventBoList());
                return hrApiResponse;
            }
            HisSearchLaterEventResult hisSearchLaterEventResult = new HisSearchLaterEventResult();
            hisSearchLaterEventResult.setLaterEventBoList(hisSearchLaterEventBO.getLaterEventBoList());
            return HrApiResponse.success((Object)hisSearchLaterEventResult);
        }
        catch (Exception ex) {
            LOGGER.info("searchLaterEventApi error:" + ex.getMessage());
            if (ex instanceof KDBizException) {
                return HrApiResponse.fail((String)ex.getMessage());
            }
            String errorMessage = ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisModelEventSearchService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            return HrApiResponse.fail((String)errorMessage);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public HisSearchLaterEventBO searchLaterEvent(HisSearchLaterEventParam hisSearchLaterEventParam) {
        HisSearchLaterEventBO hisSearchLaterEventBO = new HisSearchLaterEventBO();
        if (Objects.isNull(hisSearchLaterEventParam)) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisModelEventSearchService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        String result = this.validateParams(hisSearchLaterEventParam);
        if (StringUtils.isNotEmpty((String)result)) {
            hisSearchLaterEventBO.setBaseValidateResult(result);
            return hisSearchLaterEventBO;
        }
        DynamicObject eventGroupConfigDy = this.getEventTableByNumber(hisSearchLaterEventParam);
        if (eventGroupConfigDy == null) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u901a\u8fc7\u4f20\u53c2\u627e\u4e0d\u5230\u4e8b\u52a1\u7ec4\u6570\u636e\u3002", (String)"HisModelEventSearchService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        Long eventId = hisSearchLaterEventParam.getEventId();
        DynamicObject eventTableConfigDy = eventGroupConfigDy.getDynamicObject("evententity");
        if (eventTableConfigDy == null) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e8b\u52a1\u8868\u914d\u7f6e\u3002", (String)"HisModelEventSearchService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        String eventTableNumber = eventTableConfigDy.getString("number");
        if (StringUtils.isEmpty((String)eventTableNumber)) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e8b\u52a1\u8868\u914d\u7f6e\u3002", (String)"HisModelEventSearchService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper(eventTableNumber);
        DynamicObject eventDy = HisCommonEntityRepository.getEventById(eventHelper, eventId);
        if (eventDy == null) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6b64\u4e8b\u52a1ID\u3002", (String)"HisModelEventSearchService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        if (EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue().equals(eventDy.get("status"))) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u5df2\u88ab\u64a4\u9500\u3002", (String)"HisModelEventSearchService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        DynamicObject busiEventTableConfigDy = eventGroupConfigDy.getDynamicObject("busevententity");
        if (busiEventTableConfigDy == null) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e1a\u52a1\u4e8b\u52a1\u8868\u914d\u7f6e\u3002", (String)"HisModelEventSearchService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        String busiEventTableNumber = busiEventTableConfigDy.getString("number");
        if (StringUtils.isEmpty((String)busiEventTableNumber)) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4e1a\u52a1\u4e8b\u52a1\u8868\u914d\u7f6e\u3002", (String)"HisModelEventSearchService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(busiEventTableNumber);
        Map<String, Set<Long>> entityBoIdMap = HisEventEntityRepository.getBsEventSourceEntityAndBoIds(busiEventHelper, eventId);
        if (MapUtils.isEmpty(entityBoIdMap)) {
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u4e8b\u52a1\u66f4\u65b0\u7684\u5b9e\u4f53\u6570\u636e\u3002", (String)"HisModelEventSearchService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        if (entityBoIdMap.size() > 60) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u7684\u53d8\u52a8\u7684\u5b9e\u4f53\u6570\u91cf\u8d85\u51fa\u6700\u5927\u8ba1\u7b97\u957f\u5ea6\uff1a%s\u3002", (String)"HisModelEventSearchService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), 60);
            hisSearchLaterEventBO.setBaseValidateResult(errorMessage);
            return hisSearchLaterEventBO;
        }
        Date operateDate = eventDy.getDate("operatedate");
        int dataCount = HisEventEntityRepository.queryLaterEventCount(busiEventHelper, entityBoIdMap, operateDate);
        if (dataCount > 2000) {
            return this.buildErrorForMaxCount();
        }
        DynamicObject[] dynamicObjects = HisEventEntityRepository.queryLaterEvent(busiEventHelper, entityBoIdMap, operateDate);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            hisSearchLaterEventBO.setSuccess(true);
            hisSearchLaterEventBO.setBaseValidateResult(ResManager.loadKDString((String)"\u8be5\u4e8b\u52a1\u5373\u6700\u65b0\u4e8b\u52a1\u3002", (String)"HisModelEventSearchService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisSearchLaterEventBO;
        }
        ArrayList dynamicObjectResult = Lists.newArrayListWithExpectedSize((int)10);
        dynamicObjectResult.addAll(Arrays.asList(dynamicObjects));
        Set<Long> newEventIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
        Set<Long> excludeIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if ((dataCount += HisEventEntityRepository.getOtherBsEventSourceEntityAndBoIdsCount(busiEventHelper, newEventIdSet, excludeIdSet)) > 2000) {
            return this.buildErrorForMaxCount();
        }
        DynamicObject[] dynamicObjectsOther = HisEventEntityRepository.getOtherBsEventSourceEntityAndBoIds(busiEventHelper, newEventIdSet, excludeIdSet);
        if (dynamicObjectsOther == null || dynamicObjectsOther.length == 0) {
            return this.buildAndValidateResult(dynamicObjectResult, eventHelper);
        }
        dynamicObjectResult.addAll(dynamicObjectResult.size(), Arrays.asList(dynamicObjectsOther));
        if ((dataCount += HisEventEntityRepository.queryLaterEventByMultiEventCount(busiEventHelper, dynamicObjectsOther)) > 2000) {
            return this.buildErrorForMaxCount();
        }
        DynamicObject[] dynamicObjectsMore = HisEventEntityRepository.queryLaterEventByMultiEvent(busiEventHelper, dynamicObjectsOther);
        if (dynamicObjectsMore == null || dynamicObjectsMore.length == 0) {
            return this.buildAndValidateResult(dynamicObjectResult, eventHelper);
        }
        hisSearchLaterEventBO.setDataCount(dataCount);
        this.recursionCalcMoreData(hisSearchLaterEventBO, busiEventHelper, dynamicObjectsMore, 0, dynamicObjectResult, excludeIdSet);
        if (StringUtils.isNotEmpty((String)hisSearchLaterEventBO.getBaseValidateResult())) {
            return hisSearchLaterEventBO;
        }
        return this.buildAndValidateResult(dynamicObjectResult, eventHelper);
    }

    @ExcludeFromJacocoGeneratedReport
    private HisSearchLaterEventBO buildErrorForMaxCount() {
        String errorMessage = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6570\u636e\u884c\u8d85\u51fa\u957f\u5ea6\uff1a%s\u3002", (String)"HisModelEventSearchService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), 2000);
        HisSearchLaterEventBO hisSearchLaterEventBO = new HisSearchLaterEventBO();
        hisSearchLaterEventBO.setBaseValidateResult(errorMessage);
        return hisSearchLaterEventBO;
    }

    @ExcludeFromJacocoGeneratedReport
    private HisSearchLaterEventBO buildAndValidateResult(List<DynamicObject> dynamicObjectResult, HRBaseServiceHelper eventHelper) {
        HisSearchLaterEventBO hisSearchLaterEventBO = new HisSearchLaterEventBO();
        LaterEventBo[] laterEventBos = this.transformMapData(dynamicObjectResult, eventHelper);
        ArrayList eventIdList = Lists.newArrayListWithExpectedSize((int)10);
        for (LaterEventBo laterEventBo : laterEventBos) {
            String executeWay = laterEventBo.getExecuteWay();
            Long eventId = laterEventBo.getEventId();
            if (!"0".equals(executeWay)) continue;
            eventIdList.add(eventId);
        }
        if (CollectionUtils.isNotEmpty((Collection)eventIdList)) {
            hisSearchLaterEventBO.setSuccess(false);
            StringBuilder sb = new StringBuilder();
            for (Long eventId : eventIdList) {
                sb.append(eventId).append(",");
            }
            String errorEventId = sb.substring(0, sb.length() - 1);
            String errorMessage = String.format(ResManager.loadKDString((String)"\u66f4\u665a\u4e8b\u52a1\u5b58\u5728\u4e8b\u52a1\u7c7b\u578b\u4e3a\u81ea\u52a8\u4e8b\u52a1\uff08\u5b9a\u65f6\u4efb\u52a1\u89e6\u53d1\uff09\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\uff1a\u4e8b\u52a1ID:%s\u3002", (String)"HisModelEventSearchService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]), errorEventId);
            hisSearchLaterEventBO.setSuccess(false);
            hisSearchLaterEventBO.setBaseValidateResult(errorMessage);
            hisSearchLaterEventBO.setLaterEventBoList(laterEventBos);
            return hisSearchLaterEventBO;
        }
        hisSearchLaterEventBO.setSuccess(true);
        hisSearchLaterEventBO.setLaterEventBoList(laterEventBos);
        return hisSearchLaterEventBO;
    }

    @ExcludeFromJacocoGeneratedReport
    private void recursionCalcMoreData(HisSearchLaterEventBO hisSearchLaterEventBO, HRBaseServiceHelper busiEventHelper, DynamicObject[] dynamicObjectsMore, int currentDepth, List<DynamicObject> dynamicObjectResult, Set<Long> excludeIdSet) {
        if (dynamicObjectsMore == null || dynamicObjectsMore.length == 0) {
            return;
        }
        dynamicObjectResult.addAll(dynamicObjectResult.size(), Arrays.asList(dynamicObjectsMore));
        Set<Long> newEventIdSet = Arrays.stream(dynamicObjectsMore).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
        Set idSet = Arrays.stream(dynamicObjectsMore).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        excludeIdSet.addAll(idSet);
        hisSearchLaterEventBO.setDataCount(hisSearchLaterEventBO.getDataCount() + HisEventEntityRepository.getOtherBsEventSourceEntityAndBoIdsCount(busiEventHelper, newEventIdSet, excludeIdSet));
        if (hisSearchLaterEventBO.getDataCount() > 2000) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6570\u636e\u884c\u8d85\u51fa\u957f\u5ea6\uff1a%s\u3002", (String)"HisModelEventSearchService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), 2000);
            hisSearchLaterEventBO.setBaseValidateResult(errorMsg);
            return;
        }
        DynamicObject[] dynamicObjectsOther = HisEventEntityRepository.getOtherBsEventSourceEntityAndBoIds(busiEventHelper, newEventIdSet, excludeIdSet);
        if (dynamicObjectsOther == null || dynamicObjectsOther.length == 0) {
            return;
        }
        dynamicObjectResult.addAll(dynamicObjectResult.size(), Arrays.asList(dynamicObjectsOther));
        hisSearchLaterEventBO.setDataCount(hisSearchLaterEventBO.getDataCount() + HisEventEntityRepository.queryLaterEventByMultiEventCount(busiEventHelper, dynamicObjectsOther));
        if (hisSearchLaterEventBO.getDataCount() > 2000) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6570\u636e\u884c\u8d85\u51fa\u957f\u5ea6\uff1a%s\u3002", (String)"HisModelEventSearchService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), 2000);
            hisSearchLaterEventBO.setBaseValidateResult(errorMsg);
            return;
        }
        dynamicObjectsMore = HisEventEntityRepository.queryLaterEventByMultiEvent(busiEventHelper, dynamicObjectsOther);
        if (dynamicObjectsMore == null || dynamicObjectsMore.length == 0) {
            return;
        }
        if (currentDepth < 4) {
            this.recursionCalcMoreData(hisSearchLaterEventBO, busiEventHelper, dynamicObjectsMore, currentDepth + 1, dynamicObjectResult, excludeIdSet);
        } else if (dynamicObjectsOther != null && dynamicObjectsOther.length > 0) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff0c\u4e8b\u52a1\u5173\u8054\u5f71\u54cd\u7684\u6570\u636e\u5c42\u7ea7\u592a\u6df1\uff0c\u8ba1\u7b97\u66f4\u665a\u4e8b\u52a1\u8d85\u51fa\u9012\u5f52\u6df1\u5ea6\uff1a%s\u3002", (String)"HisModelEventSearchService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), 5);
            hisSearchLaterEventBO.setBaseValidateResult(errorMessage);
            return;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private LaterEventBo[] transformMapData(List<DynamicObject> dynamicObjectResult, HRBaseServiceHelper eventHelper) {
        if (CollectionUtils.isEmpty(dynamicObjectResult)) {
            return null;
        }
        HashMap laterEventBoMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap laterEventEntityBoMap = Maps.newHashMapWithExpectedSize((int)16);
        this.buildMapData(laterEventEntityBoMap, laterEventBoMap, dynamicObjectResult);
        if (MapUtils.isEmpty((Map)laterEventEntityBoMap) || MapUtils.isEmpty((Map)laterEventBoMap)) {
            return null;
        }
        this.fillEntityData(laterEventEntityBoMap, laterEventBoMap);
        Set<Long> eventIdSet = laterEventBoMap.keySet();
        DynamicObject[] eventDys = HisCommonEntityRepository.getEventByIds(eventHelper, eventIdSet);
        if (eventDys == null || eventDys.length == 0) {
            return null;
        }
        LaterEventBo[] laterEventBos = this.fillEventData(eventDys, laterEventBoMap);
        return laterEventBos;
    }

    @ExcludeFromJacocoGeneratedReport
    private void buildMapData(Map<String, LaterEventEntityBo> laterEventEntityBoMap, Map<Long, LaterEventBo> laterEventBoMap, List<DynamicObject> dynamicObjectResult) {
        for (DynamicObject dynamicObject : dynamicObjectResult) {
            ArrayList boIdList;
            Long boId;
            Date operateDate;
            String entityNumber;
            Long eventId = dynamicObject.getLong("event");
            if (eventId == null || eventId == 0L || StringUtils.isEmpty((String)(entityNumber = dynamicObject.getString("sourceentity"))) || (operateDate = dynamicObject.getDate("operatedate")) == null || (boId = Long.valueOf(dynamicObject.getLong("boid"))) == null || boId == 0L) continue;
            LaterEventBo laterEventBo = laterEventBoMap.get(eventId);
            if (laterEventBo == null) {
                laterEventBo = new LaterEventBo();
                laterEventBoMap.put(eventId, laterEventBo);
            }
            laterEventBo.setEventId(eventId);
            laterEventBo.setOperateDate(operateDate);
            String eventIdAndEntityNumber = eventId + STRING + entityNumber;
            LaterEventEntityBo laterEventEntityBo = laterEventEntityBoMap.get(eventIdAndEntityNumber);
            if (laterEventEntityBo == null) {
                laterEventEntityBo = new LaterEventEntityBo();
                laterEventEntityBo.setEntityNumber(entityNumber);
                laterEventEntityBoMap.put(eventIdAndEntityNumber, laterEventEntityBo);
            }
            if ((boIdList = laterEventEntityBo.getBoIdList()) == null) {
                boIdList = Lists.newArrayListWithExpectedSize((int)10);
                laterEventEntityBo.setBoIdList(boIdList);
            }
            boIdList.add(boId);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void fillEntityData(Map<String, LaterEventEntityBo> laterEventEntityBoMap, Map<Long, LaterEventBo> laterEventBoMap) {
        for (Map.Entry<String, LaterEventEntityBo> entry : laterEventEntityBoMap.entrySet()) {
            LaterEventBo laterEventBo;
            Long eventId;
            String strEventId;
            String key = entry.getKey();
            String[] keys = key.split(STRING);
            if (keys == null || keys.length != 2 || StringUtils.isEmpty((String)(strEventId = keys[0]))) continue;
            try {
                eventId = Long.valueOf(strEventId);
            }
            catch (Exception ex) {
                continue;
            }
            if (eventId == null || eventId == 0L || (laterEventBo = laterEventBoMap.get(eventId)) == null) continue;
            ArrayList laterEventEntityBoList = laterEventBo.getLaterEventEntityBoList();
            if (laterEventEntityBoList == null) {
                laterEventEntityBoList = Lists.newArrayListWithExpectedSize((int)10);
                laterEventBo.setLaterEventEntityBoList(laterEventEntityBoList);
            }
            laterEventEntityBoList.add(entry.getValue());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private LaterEventBo[] fillEventData(DynamicObject[] eventDys, Map<Long, LaterEventBo> laterEventBoMap) {
        ArrayList laterEventBoList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dynamicObject : eventDys) {
            Long eventId = dynamicObject.getLong("id");
            LaterEventBo laterEventBo = laterEventBoMap.get(eventId);
            if (laterEventBo == null) continue;
            String eventType = dynamicObject.getString("eventtype");
            laterEventBo.setEventType(eventType);
            String executeWay = dynamicObject.getString("executeway");
            laterEventBo.setExecuteWay(executeWay);
            String eventBatchType = dynamicObject.getString("eventbatchtype");
            laterEventBo.setEventBatchType(eventBatchType);
            String status = dynamicObject.getString("status");
            laterEventBo.setStatus(status);
            Date operateDate = dynamicObject.getDate("operatedate");
            laterEventBo.setOperateDate(operateDate);
            laterEventBoList.add(laterEventBo);
        }
        if (CollectionUtils.isEmpty((Collection)laterEventBoList)) {
            return null;
        }
        return laterEventBoList.toArray(new LaterEventBo[laterEventBoList.size()]);
    }

    @ExcludeFromJacocoGeneratedReport
    private DynamicObject getEventTableByNumber(HisSearchLaterEventParam hisSearchLaterEventParam) {
        DynamicObject dyAppEvent;
        String eventGroupNumber = hisSearchLaterEventParam.getEventGroupNumber();
        if (eventGroupNumber != null) {
            return HisEventEntityRepository.getEventTableByNumber(eventGroupNumber);
        }
        String entityNumber = hisSearchLaterEventParam.getResisterEventGroupEntityNumber();
        if (entityNumber != null) {
            return HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber);
        }
        String appId = hisSearchLaterEventParam.getResisterEventGroupAppId();
        if (appId != null && !HRObjectUtils.isEmpty((Object)(dyAppEvent = HisCommonEntityRepository.getAppDefaultEventDy(appId)))) {
            DynamicObject eventTableConfigDy = dyAppEvent.getDynamicObject("evententity");
            return eventTableConfigDy;
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private String validateParams(HisSearchLaterEventParam hisSearchLaterEventParam) {
        Long eventId = hisSearchLaterEventParam.getEventId();
        if (Objects.isNull(eventId) || eventId == 0L) {
            return ResManager.loadKDString((String)"\u4e8b\u52a1ID\u4e3a\u7a7a\u3002", (String)"HisModelEventSearchService_13", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        String eventGroupNumber = hisSearchLaterEventParam.getEventGroupNumber();
        String resisterEventGroupAppId = hisSearchLaterEventParam.getResisterEventGroupAppId();
        String resisterEventGroupEntityNumber = hisSearchLaterEventParam.getResisterEventGroupEntityNumber();
        if (StringUtils.isEmpty((String)eventGroupNumber) && StringUtils.isEmpty((String)resisterEventGroupAppId) && StringUtils.isEmpty((String)resisterEventGroupEntityNumber)) {
            return ResManager.loadKDString((String)"\u4e8b\u52a1\u7ec4\u7f16\u7801(eventGroupNumber)\u3001\u6ce8\u518c\u4e86\u4e8b\u52a1\u7ec4\u7684\u5e94\u7528ID(resisterEventGroupAppId)\u3001\u6ce8\u518c\u4e86\u4e8b\u52a1\u7ec4\u7684\u5b9e\u4f53\u7f16\u7801(resisterEventGroupEntityNumber)\uff0c\u81f3\u5c11\u4e00\u4e2a\u503c\u4e0d\u4e3a\u7a7a\u3002", (String)"HisModelEventSearchService_14", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        return null;
    }
}

