/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionNumberBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.newhismodel.IVersionNumberGenService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DefaultVersionNumberGenService
implements IVersionNumberGenService {
    private static final Log LOGGER = LogFactory.getLog(DefaultVersionNumberGenService.class);
    private static volatile DefaultVersionNumberGenService service = null;
    private static final String HISVERSION_PREFIX = "V";
    private static final String HISVERSION_DEFAULT = "V0001";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultVersionNumberGenService getInstance() {
        if (service != null) return service;
        Class<DefaultVersionNumberGenService> clazz = DefaultVersionNumberGenService.class;
        synchronized (DefaultVersionNumberGenService.class) {
            if (service != null) return service;
            service = new DefaultVersionNumberGenService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public void getVersionNumber(HisVersionNumberBo hisVersionNumberBo) {
        DynamicObject[] dataCol = hisVersionNumberBo.getHisDyns();
        String entityNumber = hisVersionNumberBo.getEntityNumber();
        boolean cancel_notSupported = hisVersionNumberBo.isCancel_notSupported();
        if (dataCol == null || dataCol.length == 0 || StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        List versionData = Arrays.stream(dataCol).filter(dy -> Boolean.toString(false).equals(dy.getString("iscurrentversion"))).collect(Collectors.toList());
        List currentData = Arrays.stream(dataCol).collect(Collectors.toList());
        currentData.removeAll(versionData);
        for (Object currentDy : currentData) {
            currentDy.set("hisversion", (Object)"");
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : versionData) {
            long boid = dynamicObject.getLong("boid");
            map.computeIfAbsent(boid, key -> new ArrayList(16)).add(dynamicObject);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList versionDataList = Lists.newArrayListWithExpectedSize((int)16);
        Set entrySet = map.entrySet();
        Map<Long, List<String>> mapVersionNumber = null;
        if (cancel_notSupported) {
            mapVersionNumber = HisCommonEntityRepository.getVersionNumber(serviceHelper, map.keySet());
        } else {
            try (TXHandle txHandle = TX.notSupported();){
                mapVersionNumber = HisCommonEntityRepository.getVersionNumber(serviceHelper, map.keySet());
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        for (Map.Entry entry : entrySet) {
            String hisVersion = HISVERSION_DEFAULT;
            Long boid = (Long)entry.getKey();
            List dynamicObjects = (List)entry.getValue();
            if (mapVersionNumber != null && mapVersionNumber.containsKey(boid)) {
                List<String> listVersion = mapVersionNumber.get(boid);
                hisVersion = this.getMaxVersionNum(listVersion);
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("hisversion", (Object)hisVersion);
                hisVersion = this.addVersionNumber(hisVersion);
                versionDataList.add(dynamicObject);
            }
        }
        currentData.addAll(versionDataList);
    }

    private String getMaxVersionNum(List<String> listVersion) {
        if (listVersion != null && listVersion.size() > 0) {
            HashMap<Long, String> map = new HashMap<Long, String>(listVersion.size());
            for (String s : listVersion) {
                if (StringUtils.isEmpty((String)s)) continue;
                map.put(Long.parseLong(s.substring(1)), s);
            }
            ArrayList list = new ArrayList(map.keySet());
            Collections.sort(list);
            if (list.size() > 0) {
                return this.addVersionNumber((String)map.get(list.get(list.size() - 1)));
            }
            return HISVERSION_DEFAULT;
        }
        return HISVERSION_DEFAULT;
    }

    private String addVersionNumber(String hisVersion) {
        String substring = hisVersion.substring(1);
        int number = Integer.parseInt(substring) + 1;
        return this.getVersionByNumber(number);
    }

    public String getVersionByNumber(int number) {
        String hisVersion;
        String numStr = String.valueOf(number);
        if (numStr.length() < 4) {
            int i = 4 - numStr.length();
            StringBuilder stringBuilder = new StringBuilder(HISVERSION_PREFIX);
            for (int j = 0; j < i; ++j) {
                stringBuilder.append("0");
            }
            hisVersion = stringBuilder.append(numStr).toString();
        } else {
            hisVersion = HISVERSION_PREFIX + numStr;
        }
        return hisVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Integer> buildMaxVersionMap(HRBaseServiceHelper serviceHelper, Set<Long> boIdSet) {
        QFilter boIDFilter = new QFilter("boid", "in", boIdSet);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter hisVersionFilter = new QFilter("hisversion", "is not null", (Object)"");
        HashMap mapResult = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dataSet = null;){
            dataSet = serviceHelper.queryDataSet(HisCommonEntityRepository.class.getName() + ".queryVersionNumber", "boid,hisversion", new QFilter[]{boIDFilter, isCurrentFilter, hisVersionFilter}, "boid asc,hisversion asc");
            while (dataSet.hasNext()) {
                int number;
                Row row = dataSet.next();
                Long boId = row.getLong("boid");
                String version = row.getString("hisversion");
                if (version == null || version.length() == 0) {
                    number = 0;
                } else {
                    String substring = version.substring(1);
                    number = Integer.parseInt(substring);
                }
                mapResult.put(boId, number);
            }
        }
        return mapResult;
    }
}

