/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisReviseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.revise.HisReviseRecordParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.revise.HisReviseRecordReturnParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.bubasedata.HisCalcPersonalDataBo;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisReviseValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisNonPersonalDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.EventGroupService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.service.newhismodel.hisversion.IHisVersionReviseService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HisVersionReviseService
implements IHisVersionReviseService {
    public static final String ATTACHEMENT_INFO = "revise_attachmentInfo";
    public static final String PERSIONAL_ATTACHEMENT_INFO = "revise_persional_attachmentInfo";
    private static final String BUSIEVENT = "busievent";
    private static final String BSED = "bsed";
    private static final String BSLED = "bsled";
    private static final String VID = "vid";
    private static volatile HisVersionReviseService hisVersionReviseService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisVersionReviseService getInstance() {
        if (hisVersionReviseService != null) return hisVersionReviseService;
        Class<HisVersionReviseService> clazz = HisVersionReviseService.class;
        synchronized (HisVersionReviseService.class) {
            if (hisVersionReviseService != null) return hisVersionReviseService;
            hisVersionReviseService = new HisVersionReviseService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisVersionReviseService;
        }
    }

    public HrApiResponse<HisVersionReviseResultBo> reviseVersionApi(HisVersionReviseParamBo paramBo) {
        if (paramBo == null || paramBo.getReviseDys() == null || paramBo.getReviseDys().length < 1) {
            HrApiResponse apiResponse = new HrApiResponse();
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisReviseValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        DynamicObject[] reviseDys = paramBo.getReviseDys();
        HrApiResponse<HisVersionReviseResultBo> response = HisReviseValidateService.getInstance().saveValidate(reviseDys);
        if (!response.isSuccess()) {
            return response;
        }
        HisVersionReviseReturnDataBo hisVersionReviseReturnDataBo = this.reviseVersion(paramBo);
        if (hisVersionReviseReturnDataBo == null) {
            return response;
        }
        Map<Long, List<HisAttachmentBo>> attachmentMap = hisVersionReviseReturnDataBo.getAttachmentMap();
        Map<Long, List<HisAttachmentBo>> hisAttachmentBos = paramBo.getMapHisAttachmentBos();
        if (attachmentMap != null) {
            if (hisAttachmentBos != null) {
                attachmentMap.putAll(hisAttachmentBos);
            }
            hisVersionReviseReturnDataBo.setAttachmentMap(attachmentMap);
        } else if (hisAttachmentBos != null) {
            hisVersionReviseReturnDataBo.setAttachmentMap(hisAttachmentBos);
        }
        ArrayList returnDataList = new ArrayList(reviseDys.length * 3);
        DynamicObject[] returnData = hisVersionReviseReturnDataBo.getReturnData();
        if (returnData != null) {
            returnDataList.addAll(Arrays.stream(returnData).collect(Collectors.toList()));
        }
        returnDataList.addAll(Arrays.stream(reviseDys).collect(Collectors.toList()));
        hisVersionReviseReturnDataBo.setReturnData(returnDataList.toArray(new DynamicObject[0]));
        ((HisVersionReviseResultBo)response.getData()).setReturnDataBo(hisVersionReviseReturnDataBo);
        return response;
    }

    @Override
    public HisVersionReviseReturnDataBo reviseVersion(HisVersionReviseParamBo paramBo) {
        String entityNumber = paramBo.getEntityNumber();
        DynamicObject[] reviseDys = paramBo.getReviseDys();
        boolean isPersonalDataSyn = paramBo.isPersonalDataSyn();
        Map<Long, List<HisAttachmentBo>> uploadAttachmentBos = paramBo.getMapHisAttachmentBos();
        Map<Long, List<HisAttachmentBo>> preAttachmentBos = paramBo.getPreHisAttachmentBos();
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entityNumber);
        boolean isCtrlBaseData = HisReviseValidateService.getInstance().isCtrlBaseData(entityNumber);
        List currentDataList = Arrays.stream(reviseDys).filter(dy -> dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        Map<Long, Long> sourceIdMap = currentDataList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("sourcevid")));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        Set ids = Arrays.stream(reviseDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Set boids = Arrays.stream(reviseDys).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        ids.addAll(sourceIdMap.values());
        ids.addAll(boids);
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter qFilter = new QFilter("boid", "in", boids).and("iscurrentversion", "=", (Object)true);
        DynamicObject[] dys = helper.loadDynamicObjectArray(idFilter.or(qFilter).toArray());
        Map<Long, DynamicObject> idMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Map<Long, DynamicObject> boidMap = Arrays.stream(dys).filter(dy -> dy.getBoolean("iscurrentversion")).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        ArrayList<DynamicObject> reviseVersionDys = new ArrayList<DynamicObject>(dys.length);
        HashMap<Long, List<HisAttachmentBo>> saveAttachmentMap = new HashMap<Long, List<HisAttachmentBo>>(8);
        long[] masterIds = ORM.create().genLongIds(entityNumber, reviseDys.length);
        for (int i = 0; i < reviseDys.length; ++i) {
            long id = reviseDys[i].getLong("id");
            if (reviseDys[i].getBoolean("iscurrentversion")) {
                id = sourceIdMap.get(id);
            }
            DynamicObject versionDy = idMap.get(id);
            this.buildReviseDys(inhRelation, versionDy, reviseDys[i], paramBo.isPersonalDataSyn());
            long masterId = masterIds[i];
            this.buildReviseVersion(helper, versionDy, reviseVersionDys, masterId, isPersonalDataSyn, isCtrlBaseData);
            if (preAttachmentBos == null) continue;
            this.buildReviseVersionAttachment(id, entityNumber, masterId, saveAttachmentMap, preAttachmentBos);
        }
        if (inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber()) && paramBo.isPersonalDataSyn()) {
            HisCalcPersonalDataBo hisCalcPersonalDataBo = new HisCalcPersonalDataBo(helper, entityNumber, null, HisCommonService.getInstance().groupByBoIdDyMap(reviseDys));
            hisCalcPersonalDataBo.setOriginRevise(true);
            HisPersonalDataService.getInstance().batchCalcPersonalData(hisCalcPersonalDataBo);
        } else if (inhRelation.equals(EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber()) && paramBo.isPersonalDataSyn()) {
            HisCalcPersonalDataBo hisCalcPersonalDataBo = new HisCalcPersonalDataBo(helper, entityNumber, null, HisCommonService.getInstance().groupByBoIdDyMap(reviseDys));
            HisNonPersonalDataService.getInstance().batchCalcPersonalData(hisCalcPersonalDataBo);
        }
        List<DynamicObject> toWriteBackDys = this.screenToWriteBackDys(reviseDys, boidMap);
        ArrayList<DynamicObject> writeBackDys = new ArrayList<DynamicObject>(toWriteBackDys.size());
        Set<String> ignoreKeys = Stream.of("id", "iscurrentversion", "sourcevid", "hisversion", "masterid", "creator", "createtime", "versionsource", "firstbsed").collect(Collectors.toSet());
        for (DynamicObject dy2 : toWriteBackDys) {
            long id = dy2.getLong("id");
            DynamicObject currentVersionDy = boidMap.get(dy2.getLong("boid"));
            DynamicObject writeDy = !dy2.getBoolean("iscurrentversion") && currentVersionDy.getLong("sourcevid") == id ? currentVersionDy : idMap.get(dy2.getLong("sourcevid"));
            if (writeDy == null) continue;
            this.setFirstBsed(dy2, writeDy, inhRelation);
            this.setIgnoreField(entityNumber, ignoreKeys);
            HRDynamicObjectUtils.copy((DynamicObject)dy2, (DynamicObject)writeDy, ignoreKeys, (boolean)true);
            writeBackDys.add(writeDy);
            this.buildWriteBackAttachment(id, writeDy.getLong("id"), uploadAttachmentBos, saveAttachmentMap, entityNumber);
        }
        reviseVersionDys.addAll(writeBackDys);
        HisVersionReviseReturnDataBo returnDataBo = new HisVersionReviseReturnDataBo();
        returnDataBo.setAttachmentMap(saveAttachmentMap);
        returnDataBo.setEntityNumber(entityNumber);
        returnDataBo.setReturnData(reviseVersionDys.toArray(new DynamicObject[0]));
        return returnDataBo;
    }

    private void setIgnoreField(String entityNumber, Set<String> ignoreKeys) {
        String[] fields;
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService("hrcs", "IHRCSHismodelService", "getHisEntityEventBo", entityNumber);
        if (hisEntityEventMap == null) {
            return;
        }
        String ignorefield = (String)hisEntityEventMap.get("ignorefield");
        if (HRStringUtils.isEmpty((String)ignorefield)) {
            return;
        }
        for (String field : fields = ignorefield.split(",")) {
            if (!HRStringUtils.isNotEmpty((String)field)) continue;
            ignoreKeys.add(field);
        }
    }

    private void setFirstBsed(DynamicObject dynamicObject, DynamicObject writeDy, String inhRelation) {
        if (!inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            return;
        }
        if (dynamicObject.getDate(BSED).getTime() != writeDy.getDate(BSED).getTime()) {
            writeDy.set("firstbsed", (Object)dynamicObject.getDate(BSED));
        }
    }

    private void buildReviseVersion(HRBaseServiceHelper helper, DynamicObject versionDy, List<DynamicObject> reviseVersionDys, long masterId, boolean isPersonalDataSyn, boolean isCtrlBaseData) {
        Set ignoreKeys = Stream.of("id", "iscurrentversion", "sourcevid", "datastatus", "creator", "createtime", "modifier", "modifytime", "masterid", "hisversion", "versionsource", "ismodify").collect(Collectors.toSet());
        DynamicObject newVersionDy = helper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)versionDy, (DynamicObject)newVersionDy, ignoreKeys, (boolean)true);
        newVersionDy.set("datastatus", (Object)EnumHisDataVersionStatus.REVISED.getStatus());
        newVersionDy.set("sourcevid", (Object)versionDy.getLong("id"));
        newVersionDy.set("iscurrentversion", (Object)"0");
        newVersionDy.set("id", (Object)masterId);
        if (versionDy.getDataEntityType().getProperties().containsKey((Object)"masterid")) {
            newVersionDy.set("masterid", (Object)masterId);
        }
        if (isCtrlBaseData) {
            newVersionDy.set("versionsource", (Object)(isPersonalDataSyn ? "1" : "2"));
        }
        reviseVersionDys.add(newVersionDy);
    }

    @ExcludeFromJacocoGeneratedReport
    private void buildReviseDys(String inhRelation, DynamicObject versionDy, DynamicObject reviseDyn, boolean isPersonalDataSyn) {
        if (inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            if (versionDy.getDate(BSED).getTime() != reviseDyn.getDate(BSED).getTime()) {
                Date versionEffStartDate = versionDy.getDate(BSED);
                Date versionEffEndDate = versionDy.getDate(BSLED);
                Date curEffStartDate = reviseDyn.getDate(BSED);
                Date curEffEndDate = reviseDyn.getDate(BSLED);
                String curDataStatus = HisEffDateCommonService.getInstance().calcDataStatus(curEffStartDate, curEffEndDate);
                String versionDataStatus = HisEffDateCommonService.getInstance().calcDataStatus(versionEffStartDate, versionEffEndDate);
                reviseDyn.set("datastatus", (Object)curDataStatus);
                reviseDyn.set("firstbsed", (Object)curEffStartDate);
                if (EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(versionDataStatus) && EnumHisDataVersionStatus.EFFECTING.getStatus().equals(curDataStatus)) {
                    Date dateNow = new Date();
                    reviseDyn.set("bred", (Object)dateNow);
                }
                if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(versionDataStatus) && EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(curDataStatus)) {
                    reviseDyn.set("bred", null);
                }
                HisTimeZoneService.getInstance().initPlanBsed(reviseDyn);
            } else {
                HisTimeZoneService.getInstance().initToBeEffPlanBsed(reviseDyn);
            }
        }
    }

    private List<DynamicObject> screenToWriteBackDys(DynamicObject[] reviseDys, Map<Long, DynamicObject> boidMap) {
        ArrayList<DynamicObject> toWriteBackDys = new ArrayList<DynamicObject>(reviseDys.length);
        for (DynamicObject dy : reviseDys) {
            if (dy.getString("datastatus").equals(EnumHisDataVersionStatus.EFFECTING.getStatus())) {
                toWriteBackDys.add(dy);
                continue;
            }
            if (!dy.getString("datastatus").equals(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus())) continue;
            if (dy.getBoolean("iscurrentversion")) {
                toWriteBackDys.add(dy);
                continue;
            }
            long sourceVid = boidMap.get(dy.getLong("boid")).getLong("sourcevid");
            if (sourceVid != dy.getLong("id")) continue;
            toWriteBackDys.add(dy);
        }
        return toWriteBackDys;
    }

    private void buildWriteBackAttachment(long id, long writeBackId, Map<Long, List<HisAttachmentBo>> uploadAttachmentBos, Map<Long, List<HisAttachmentBo>> saveAttachmentMap, String entityNumber) {
        if (MapUtils.isNotEmpty(uploadAttachmentBos) && uploadAttachmentBos.containsKey(id)) {
            List<HisAttachmentBo> boList = uploadAttachmentBos.get(id);
            List<HisAttachmentBo> hisAttachmentBos = HisAttachmentService.copyAttachments(writeBackId, entityNumber, boList, true);
            saveAttachmentMap.put(writeBackId, hisAttachmentBos);
        } else {
            saveAttachmentMap.put(writeBackId, new ArrayList());
        }
    }

    private void buildReviseVersionAttachment(long id, String entityNumber, long copyPkId, Map<Long, List<HisAttachmentBo>> saveAttachmentMap, Map<Long, List<HisAttachmentBo>> preAttachmentBos) {
        List<HisAttachmentBo> hisAttachmentBos = null;
        if (preAttachmentBos.containsKey(id)) {
            hisAttachmentBos = preAttachmentBos.get(id);
        }
        List<HisAttachmentBo> copyAttachBos = HisAttachmentService.copyAttachments(copyPkId, entityNumber, hisAttachmentBos, true);
        saveAttachmentMap.put(copyPkId, copyAttachBos);
    }

    public HrApiResponse<List<HisReviseRecordReturnParamBo>> getReviseRecord(HisReviseRecordParamBo hisVersionReviseParamBo) {
        HrApiResponse apiResponse = new HrApiResponse();
        if (hisVersionReviseParamBo == null) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionReviseService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        String entityNumber = hisVersionReviseParamBo.getEntityNumber();
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570'entityNumber'\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionReviseService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        Long boId = hisVersionReviseParamBo.getBoId();
        if (boId == null || boId == 0L) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570\u201cBOID\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionReviseService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        List<Long> versionIds = hisVersionReviseParamBo.getVersionIds();
        if (CollectionUtils.isEmpty(versionIds)) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570'versionIds'\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionReviseService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        for (Long versionId : versionIds) {
            if (versionId != null && versionId != 0L) continue;
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570'versionId'\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisVersionReviseService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        ArrayList hisReviseRecordReturnParamBoList = Lists.newArrayListWithExpectedSize((int)10);
        for (Long versionId : versionIds) {
            HisReviseRecordReturnParamBo hisReviseRecordReturnParamBo = new HisReviseRecordReturnParamBo();
            String record = this.getReviseRecord(entityNumber, boId, String.valueOf(versionId));
            if (StringUtils.isEmpty((CharSequence)record)) continue;
            hisReviseRecordReturnParamBo.setVersionId(versionId);
            hisReviseRecordReturnParamBo.setReviseRecord(record);
            hisReviseRecordReturnParamBoList.add(hisReviseRecordReturnParamBo);
        }
        apiResponse.setData((Object)hisReviseRecordReturnParamBoList);
        return apiResponse;
    }

    @Override
    public String getReviseRecord(String entity, Long boid, String pkId) {
        DynamicObject[] dys;
        ArrayList<HisReviseBo> result = new ArrayList<HisReviseBo>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        QFilter qFilter = new QFilter("sourcevid", "=", (Object)Long.parseLong(pkId)).and("datastatus", "=", (Object)EnumHisDataVersionStatus.REVISED.getStatus());
        boolean isCtrlBaseData = HisReviseValidateService.getInstance().isCtrlBaseData(entity);
        String selectFields = isCtrlBaseData ? "id,modifytime,modifier,hisversion,versionsource" : "id,modifytime,modifier,hisversion";
        for (DynamicObject dy : dys = helper.queryOriginalArray(selectFields, qFilter.toArray())) {
            if (HRObjectUtils.isEmpty((Object)dy)) continue;
            HisReviseBo bo = new HisReviseBo();
            Map<Long, String> userMap = HisReviseValidateService.getInstance().getUserAvatarPath(Stream.of(Long.valueOf(dy.getLong("modifier"))).collect(Collectors.toList()));
            bo.setName(HisReviseValidateService.getInstance().getNameByUserId(dy.getLong("modifier")));
            bo.setAvatar(userMap.get(dy.getLong("modifier")));
            if (isCtrlBaseData) {
                bo.setOperateType(dy.getString("versionsource").equals("2") ? HisReviseBo.getSync_str() : HisReviseBo.getRevise_str());
            } else {
                bo.setOperateType(HisReviseBo.getRevise_str());
            }
            bo.setOperateTime(dy.getDate("modifytime"));
            bo.setLogId(dy.getLong("id"));
            bo.setEntity(entity);
            bo.setCurrentVersion(dy.getString("hisversion"));
            result.add(bo);
        }
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entity);
        if (inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            this.getVersionRecord(entity, boid, helper, result, pkId);
        }
        result.sort(Comparator.comparing(HisReviseBo::getOperateTime).reversed());
        HashMap<String, ArrayList<HisReviseBo>> map = new HashMap<String, ArrayList<HisReviseBo>>();
        map.put("hisModel", result);
        return JSONObject.toJSONString(map);
    }

    @Override
    public boolean isExistReviseRecord(String entity, String pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        QFilter qFilter = new QFilter("sourcevid", "=", (Object)Long.parseLong(pkId)).and("datastatus", "=", (Object)EnumHisDataVersionStatus.REVISED.getStatus());
        boolean exists = helper.isExists(qFilter);
        if (exists) {
            return true;
        }
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entity);
        if (inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            DynamicObject[] hisEventGroupDys;
            DynamicObject next;
            DynamicObject hisEventEntityDy;
            Map<String, DynamicObject> eventGroup = this.getEventGroup(entity);
            String hisEventEntity = "";
            if (!MapUtils.isEmpty(eventGroup) && !ObjectUtils.isEmpty((Object)(hisEventEntityDy = (next = eventGroup.values().iterator().next()).getDynamicObject("hisevententity")))) {
                hisEventEntity = hisEventEntityDy.getString("number");
            }
            QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(pkId));
            DynamicObject currentDy = helper.queryOriginalOne("id,bsed,bsled,hisversion,iscurrentversion,sourcevid,datastatus", idFilter.toArray());
            HRBaseServiceHelper hisEventHelper = new HRBaseServiceHelper(hisEventEntity);
            String selectFields = "vid,createtime,prestatus,prebsed,prebsled,busievent,creator";
            QFilter vidFilter = new QFilter(VID, "=", (Object)Long.parseLong(pkId));
            DynamicObject[] hisEventDys = hisEventHelper.queryOriginalArray(selectFields, vidFilter.toArray(), "createtime asc");
            if (hisEventDys.length < 1) {
                return false;
            }
            HashMap<Long, List> groupMap = new HashMap<Long, List>(hisEventDys.length);
            List busiEventIds = Arrays.stream(hisEventDys).map(dy -> dy.getLong(BUSIEVENT)).distinct().collect(Collectors.toList());
            QFilter busiEventIdQFilter = new QFilter(BUSIEVENT, "in", busiEventIds);
            for (DynamicObject dy2 : hisEventGroupDys = hisEventHelper.queryOriginalArray(selectFields, busiEventIdQFilter.toArray())) {
                groupMap.computeIfAbsent(dy2.getLong(BUSIEVENT), key -> new ArrayList()).add(dy2);
            }
            for (int i = 0; i < busiEventIds.size(); ++i) {
                DynamicObject nextDy;
                List nextList;
                Optional<DynamicObject> firstDy;
                DynamicObject dy2;
                List list = (List)groupMap.get(busiEventIds.get(i));
                List collect = list.stream().filter(e -> e.getLong(VID) == Long.parseLong(pkId)).collect(Collectors.toList());
                if (collect.size() == 0) continue;
                dy2 = (DynamicObject)collect.get(0);
                String preStatus = dy2.getString("prestatus");
                if (dy2.getDate("prebsed") == null || dy2.getDate("prebsled") == null || !(i == busiEventIds.size() - 1 ? preStatus.equals(currentDy.getString("datastatus")) : (firstDy = (nextList = (List)groupMap.get(busiEventIds.get(i + 1))).stream().filter(e -> e.getLong(VID) == Long.parseLong(pkId)).findFirst()).isPresent() && preStatus.equals((nextDy = firstDy.get()).getString("prestatus")))) continue;
                return true;
            }
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private void getVersionRecord(String entity, Long boid, HRBaseServiceHelper helper, List<HisReviseBo> result, String pkId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)boid);
        DynamicObject[] allDys = helper.queryOriginalArray("id,bsed,bsled,hisversion,iscurrentversion,sourcevid,datastatus", qFilter.toArray());
        List<Long> ids = Arrays.stream(allDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List pkIdList = Arrays.stream(allDys).filter(dy -> dy.getLong("id") == Long.parseLong(pkId)).collect(Collectors.toList());
        if (pkIdList.size() < 1) {
            return;
        }
        DynamicObject currentDy = (DynamicObject)pkIdList.get(0);
        String hisEventEntity = "";
        String eventEntity = "";
        String busEventEntity = "";
        Map<String, DynamicObject> eventGroup = this.getEventGroup(entity);
        if (!MapUtils.isEmpty(eventGroup)) {
            DynamicObject busEventEntityDy;
            DynamicObject eventEntityDy;
            DynamicObject next = eventGroup.values().iterator().next();
            DynamicObject hisEventEntityDy = next.getDynamicObject("hisevententity");
            if (!ObjectUtils.isEmpty((Object)hisEventEntityDy)) {
                hisEventEntity = hisEventEntityDy.getString("number");
            }
            if (!ObjectUtils.isEmpty((Object)(eventEntityDy = next.getDynamicObject("evententity")))) {
                eventEntity = eventEntityDy.getString("number");
            }
            if (!ObjectUtils.isEmpty((Object)(busEventEntityDy = next.getDynamicObject("busevententity")))) {
                busEventEntity = busEventEntityDy.getString("number");
            }
        }
        this.calculationVersion(hisEventEntity, eventEntity, busEventEntity, ids, entity, result, currentDy, allDys, pkId);
    }

    @ExcludeFromJacocoGeneratedReport
    private void calculationVersion(String hisEventEntity, String eventEntity, String busEventEntity, List<Long> ids, String entity, List<HisReviseBo> result, DynamicObject currentDy, DynamicObject[] allDys, String pkId) {
        DynamicObject[] hisEventGroupDys;
        HRBaseServiceHelper hisEventHelper = new HRBaseServiceHelper(hisEventEntity);
        String selectFields = "vid,createtime,prestatus,prebsed,prebsled,busievent,creator";
        QFilter vidFilter = new QFilter(VID, "in", ids);
        DynamicObject[] hisEventDys = hisEventHelper.queryOriginalArray(selectFields, vidFilter.toArray(), "createtime asc");
        if (hisEventDys.length < 1) {
            return;
        }
        HashMap<Long, List<DynamicObject>> groupMap = new HashMap<Long, List<DynamicObject>>(hisEventDys.length);
        List<Long> busiEventIdList = Arrays.stream(hisEventDys).filter(e -> e.getLong(VID) == Long.parseLong(pkId)).map(e -> e.getLong(BUSIEVENT)).distinct().collect(Collectors.toList());
        QFilter busiEventIdQFilter = new QFilter(BUSIEVENT, "in", busiEventIdList);
        for (DynamicObject dy2 : hisEventGroupDys = hisEventHelper.queryOriginalArray(selectFields, busiEventIdQFilter.toArray())) {
            groupMap.computeIfAbsent(dy2.getLong(BUSIEVENT), key -> new ArrayList()).add(dy2);
        }
        HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(busEventEntity);
        List busiEventIds = Arrays.stream(hisEventDys).map(dy -> dy.getLong(BUSIEVENT)).distinct().collect(Collectors.toList());
        QFilter busiEventFilter = new QFilter("id", "in", busiEventIds);
        DynamicObject[] busiEventDys = busiEventHelper.queryOriginalArray("id,event", busiEventFilter.toArray());
        if (busiEventDys == null || busiEventDys.length == 0) {
            return;
        }
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper(eventEntity);
        Set eventIds = Arrays.stream(busiEventDys).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
        QFilter eventFilter = new QFilter("id", "in", eventIds);
        DynamicObject[] eventDys = eventHelper.queryOriginalArray("id,eventtype", eventFilter.toArray());
        if (eventDys == null || eventDys.length == 0) {
            return;
        }
        this.calculationEvent(busiEventIdList, groupMap, pkId, entity, currentDy, allDys, busiEventDys, eventDys, result);
    }

    @ExcludeFromJacocoGeneratedReport
    private void calculationEvent(List<Long> busiEventIdList, Map<Long, List<DynamicObject>> groupMap, String pkId, String entity, DynamicObject currentDy, DynamicObject[] allDys, DynamicObject[] busiEventDys, DynamicObject[] eventDys, List<HisReviseBo> result) {
        for (int i = 0; i < busiEventIdList.size(); ++i) {
            List<DynamicObject> list = groupMap.get(busiEventIdList.get(i));
            List collect = list.stream().filter(e -> e.getLong(VID) == Long.parseLong(pkId)).collect(Collectors.toList());
            if (collect.size() == 0) continue;
            DynamicObject dy = (DynamicObject)collect.get(0);
            String preStatus = dy.getString("prestatus");
            if (dy.getDate("prebsed") == null || dy.getDate("prebsled") == null) continue;
            HisReviseBo bo = new HisReviseBo();
            bo.setEntity(entity);
            bo.setCurrentVersion(currentDy.getString("hisversion"));
            bo.setBeforeBsed(dy.getDate("prebsed"));
            bo.setBeforeBsled(dy.getDate("prebsled"));
            if (i == busiEventIdList.size() - 1) {
                if (!preStatus.equals(currentDy.getString("datastatus"))) continue;
                bo.setAfterBsed(currentDy.getDate(BSED));
                bo.setAfterBsled(currentDy.getDate(BSLED));
            } else {
                List<DynamicObject> nextList = groupMap.get(busiEventIdList.get(i + 1));
                if (nextList == null) continue;
                Optional<DynamicObject> firstDy = nextList.stream().filter(e -> e.getLong(VID) == Long.parseLong(pkId)).findFirst();
                if (firstDy.isPresent()) {
                    DynamicObject nextDy = firstDy.get();
                    if (!preStatus.equals(nextDy.getString("prestatus"))) continue;
                    bo.setAfterBsed(nextDy.getDate("prebsed"));
                    bo.setAfterBsled(nextDy.getDate("prebsled"));
                }
            }
            ArrayList<Long> effectId = new ArrayList<Long>();
            HashMap<String, String> map = new HashMap<String, String>(list.size());
            for (DynamicObject obj : list) {
                if (obj.getLong(VID) == Long.parseLong(pkId) || obj.getDate("prebsed") != null && obj.getDate("prebsled") != null) continue;
                effectId.add(obj.getLong(VID));
            }
            for (DynamicObject obj : allDys) {
                if (!effectId.contains(obj.getLong("id"))) continue;
                map.put(obj.getString("hisversion"), String.valueOf(obj.getLong("id")));
            }
            bo.setChangeVersion(map);
            long busieventId = dy.getLong(BUSIEVENT);
            String eventType = this.getEventType(busiEventDys, eventDys, busieventId);
            bo.setOperateType(eventType.equals("2") ? HisReviseBo.getCancel_str() : HisReviseBo.getNew_str());
            bo.setOperateTime(dy.getDate("createtime"));
            bo.setName(HisReviseValidateService.getInstance().getNameByUserId(dy.getLong("creator")));
            Map<Long, String> userMap = HisReviseValidateService.getInstance().getUserAvatarPath(Stream.of(Long.valueOf(dy.getLong("creator"))).collect(Collectors.toList()));
            bo.setAvatar(userMap.get(dy.getLong("creator")));
            this.setChangeContent(bo);
            result.add(bo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void setChangeContent(HisReviseBo bo) {
        String changeContent = "";
        Date beforeBsed = bo.getBeforeBsed();
        Date beforeBsled = bo.getBeforeBsled();
        Date afterBsed = bo.getAfterBsed();
        Date afterBsled = bo.getAfterBsled();
        String currentVersion = bo.getCurrentVersion();
        if (StringUtils.isEmpty((CharSequence)currentVersion) || beforeBsled == null || beforeBsed == null || afterBsled == null || afterBsed == null) {
            bo.setChangeContent(changeContent);
            return;
        }
        SimpleDateFormat sdf = HRDateTimeUtils.getUserSettingFormat();
        changeContent = String.format(ResManager.loadKDString((String)"%1$s\u6709\u6548\u671f\u7531%2$s~%3$s\u53d8\u66f4\u4e3a%4$s~%5$s\u3002", (String)"ReviseOperateType_4", (String)"hrmp-hbp-business", (Object[])new Object[0]), currentVersion, sdf.format(beforeBsed), sdf.format(beforeBsled), sdf.format(afterBsed), sdf.format(afterBsled));
        bo.setChangeContent(changeContent);
    }

    @ExcludeFromJacocoGeneratedReport
    private String getEventType(DynamicObject[] busiEventDys, DynamicObject[] eventDys, long busieventId) {
        String eventType = "";
        for (DynamicObject busiEventDy : busiEventDys) {
            if (busiEventDy.getLong("id") != busieventId) continue;
            for (DynamicObject eventDy : eventDys) {
                if (eventDy.getLong("id") != busiEventDy.getLong("event") || (eventType = eventDy.getString("eventtype")).equals("")) continue;
                return eventType;
            }
        }
        return eventType;
    }

    private Map<String, DynamicObject> getEventGroup(String entity) {
        List<String> list = Stream.of(entity).collect(Collectors.toList());
        Map<String, DynamicObject> eventGroupMap = EventGroupService.getInstance().getEntityToEventMap(list);
        if (MapUtils.isEmpty(eventGroupMap)) {
            Map<String, String> entityToAppMap = EventGroupService.getInstance().getEntityToAppMap(list);
            eventGroupMap = EventGroupService.getInstance().getAppDefaultEventMap(entityToAppMap);
        }
        return eventGroupMap;
    }
}

