/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransVersionBo;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisInitBoApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisInitBoApiResult;
import kd.hr.hbp.business.domain.model.newhismodel.init.HisInitDataAndError;
import kd.hr.hbp.business.domain.model.newhismodel.init.HisInitValidateDataAndError;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisModelEventService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.DefaultVersionNumberGenService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.BoInitGroupKey;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.HisInitBoValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.SortingDyEffDateWithNoTipsService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.writeback.HisWriteBackCurrentService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HisInitBoService {
    private static volatile HisInitBoService service = null;

    private HisInitBoService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisInitBoService getInstance() {
        if (service != null) return service;
        Class<HisInitBoService> clazz = HisInitBoService.class;
        synchronized (HisInitBoService.class) {
            if (service != null) return service;
            service = new HisInitBoService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public HisInitDataAndError initBo(HisInitBoApiParam hisInitBoApiParam) {
        HisInitValidateDataAndError hisInitValidateDataAndError = HisInitBoValidateService.getInstance().initBoValidate(hisInitBoApiParam);
        HisInitDataAndError hisInitDataAndError = new HisInitDataAndError();
        hisInitDataAndError.setBaseValidateResult(hisInitValidateDataAndError.getBaseValidateResult());
        hisInitDataAndError.setErrorMessageListMap(hisInitValidateDataAndError.getErrorMessageListMap());
        if (hisInitValidateDataAndError.getBaseValidateResult() != null) {
            return hisInitDataAndError;
        }
        Map<Long, List<String>> errorMessageListMap = hisInitValidateDataAndError.getErrorMessageListMap();
        Map<BoInitGroupKey, List<DynamicObject>> boInitGroupKeyListMap = hisInitValidateDataAndError.getData();
        Map<BoInitGroupKey, List<DynamicObject>> realBoGroupData = this.rebuildDataAndErrorMsg(errorMessageListMap, boInitGroupKeyListMap);
        IDataEntityType dataEntityTypes = hisInitBoApiParam.getDynamicObjects()[0].getDataEntityType();
        String entityNumber = dataEntityTypes.getName();
        Map<BoInitGroupKey, HisInitBoApiResult> hisInitBoApiResultMap = this.realBoGroupData(entityNumber, realBoGroupData);
        this.buildHisTransBoAndSaveEvent(hisInitBoApiResultMap, entityNumber);
        String errorMessage = this.saveData(hisInitBoApiResultMap, entityNumber);
        hisInitDataAndError.setBaseValidateResult(errorMessage);
        hisInitDataAndError.setData(hisInitBoApiResultMap);
        return hisInitDataAndError;
    }

    public Map<BoInitGroupKey, List<DynamicObject>> rebuildDataAndErrorMsg(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> boInitGroupKeyListMap) {
        if (MapUtils.isEmpty(errorMessageListMap) || MapUtils.isEmpty(boInitGroupKeyListMap)) {
            return boInitGroupKeyListMap;
        }
        Set<Long> errorIdSet = errorMessageListMap.keySet();
        LinkedHashMap realBoGroupData = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : boInitGroupKeyListMap.entrySet()) {
            Long id;
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) {
                boInitGroupKeyListMap.remove(entry.getKey());
            }
            boolean boHasErrorRow = false;
            for (DynamicObject dynamicObject : dynamicObjectList) {
                id = dynamicObject.getLong("id");
                if (id != null && id != 0L && !errorIdSet.contains(id)) continue;
                boHasErrorRow = true;
                break;
            }
            if (boHasErrorRow) {
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    ArrayList errorMsgList;
                    id = dynamicObject.getLong("id");
                    if (id == null || id == 0L || !CollectionUtils.isEmpty(errorMsgList = errorMessageListMap.get(id))) continue;
                    errorMsgList = Lists.newArrayListWithExpectedSize((int)dynamicObjectList.size());
                    errorMessageListMap.put(id, errorMsgList);
                    String errorMessage = String.format(ResManager.loadKDString((String)"\u672c\u5206\u7ec4\u5185\u6709\u5176\u4ed6\u7248\u672c\u6570\u636e\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"HisInitBoService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                    errorMsgList.add(errorMessage);
                }
                continue;
            }
            realBoGroupData.put(entry.getKey(), dynamicObjectList);
        }
        return realBoGroupData;
    }

    private Map<BoInitGroupKey, HisInitBoApiResult> realBoGroupData(String entityNumber, Map<BoInitGroupKey, List<DynamicObject>> realBoGroupData) {
        if (MapUtils.isEmpty(realBoGroupData)) {
            return Maps.newHashMap();
        }
        HashMap hisInitBoApiResultMap = Maps.newHashMapWithExpectedSize((int)realBoGroupData.size());
        Set<String> ignoreKeys = HisWriteBackCurrentService.getInstance().getBaseIgnoreKeys();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        long[] ids = ORM.create().genLongIds(entityNumber, realBoGroupData.size());
        int step = 0;
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : realBoGroupData.entrySet()) {
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            Object[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
            Long boId = this.getBoId((DynamicObject[])dynamicObjects, ids[step]);
            ++step;
            SortingDyEffDateWithNoTipsService.getInstance().quickSort(dynamicObjects);
            int length = dynamicObjects.length;
            Date endDate = null;
            DynamicObject dynamicObjectCurrent = serviceHelper.generateEmptyDynamicObject();
            Object effDynamicObject = null;
            ArrayList newDynamicObjectList = Lists.newArrayListWithExpectedSize((int)(length + 1));
            for (int i = length - 1; i >= 0; --i) {
                Object dynamicObject = dynamicObjects[i];
                Date startDate = dynamicObject.getDate("bsed");
                if (i == length - 1) {
                    endDate = HisEffDateCommonService.getInstance().getDate2999(null);
                }
                dynamicObject.set("bsled", (Object)endDate);
                String dataStatus = HisEffDateCommonService.getInstance().calcDataStatus(startDate, endDate);
                if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus)) {
                    effDynamicObject = dynamicObject;
                }
                endDate = HRDateTimeUtils.addDays((int)-1, (Date)startDate);
                this.setVersion((DynamicObject)dynamicObject, boId, dataStatus, i + 1);
                newDynamicObjectList.add(dynamicObject);
            }
            if (effDynamicObject == null) continue;
            HRDynamicObjectUtils.copy(effDynamicObject, (DynamicObject)dynamicObjectCurrent, ignoreKeys, (boolean)true);
            this.setCurrentVersion(dynamicObjectCurrent, boId, (DynamicObject)effDynamicObject);
            HisInitBoApiResult hisInitBoApiResult = new HisInitBoApiResult();
            hisInitBoApiResult.setBoId(boId);
            newDynamicObjectList.add(dynamicObjectCurrent);
            hisInitBoApiResult.setDynamicObjectList(newDynamicObjectList);
            hisInitBoApiResultMap.put(entry.getKey(), hisInitBoApiResult);
        }
        return hisInitBoApiResultMap;
    }

    private void setVersion(DynamicObject dynamicObject, Long boId, String dataStatus, int number) {
        dynamicObject.set("datastatus", (Object)dataStatus);
        dynamicObject.set("iscurrentversion", (Object)false);
        String versionNumber = DefaultVersionNumberGenService.getInstance().getVersionByNumber(number);
        dynamicObject.set("hisversion", (Object)versionNumber);
        dynamicObject.set("boid", (Object)boId);
        DynamicObjectCommonService.getInstance().setMastId(dynamicObject);
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObject);
    }

    private void setCurrentVersion(DynamicObject dynamicObjectCurrent, Long boId, DynamicObject effDynamicObject) {
        dynamicObjectCurrent.set("iscurrentversion", (Object)true);
        dynamicObjectCurrent.set("sourcevid", effDynamicObject.get("id"));
        dynamicObjectCurrent.set("id", (Object)boId);
        dynamicObjectCurrent.set("boid", (Object)boId);
        dynamicObjectCurrent.set("ismodify", (Object)"0");
        DynamicObjectCommonService.getInstance().setMastId(dynamicObjectCurrent);
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObjectCurrent);
    }

    private Long getBoId(DynamicObject[] dynamicObjects, Long newBoId) {
        Long[] defineBoIds;
        Set<Long> defineBoIdSet = Arrays.stream(dynamicObjects).map(x -> x.getLong("boid")).collect(Collectors.toSet());
        if (defineBoIdSet != null && defineBoIdSet.size() == 1 && (defineBoIds = defineBoIdSet.toArray(new Long[1]))[0] != 0L) {
            return defineBoIds[0];
        }
        return newBoId;
    }

    private void buildHisTransBoAndSaveEvent(Map<BoInitGroupKey, HisInitBoApiResult> hisInitBoApiResultMap, String entityNumber) {
        if (MapUtils.isEmpty(hisInitBoApiResultMap)) {
            return;
        }
        for (Map.Entry<BoInitGroupKey, HisInitBoApiResult> entry : hisInitBoApiResultMap.entrySet()) {
            HisInitBoApiResult hisInitBoApiResult = entry.getValue();
            Long boId = hisInitBoApiResult.getBoId();
            List<DynamicObject> dynamicObjectList = hisInitBoApiResult.getDynamicObjectList();
            if (boId != null || CollectionUtils.isEmpty(dynamicObjectList)) continue;
            HisTransBo hisTransBo = new HisTransBo();
            if (dynamicObjectList.size() == 1) {
                hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_SINGLE.getValue());
            } else {
                hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
            }
            ArrayList hisTransBusinessBoList = Lists.newArrayListWithExpectedSize((int)1);
            HisTransBusinessBo hisTransBusinessBo = new HisTransBusinessBo();
            hisTransBusinessBo.setBoId(boId);
            hisTransBusinessBo.setEntityNumber(entityNumber);
            hisTransBusinessBoList.add(hisTransBusinessBo);
            hisTransBo.setListHisTransBusinessBo(hisTransBusinessBoList);
            ArrayList hisTransVersionBoList = Lists.newArrayListWithExpectedSize((int)dynamicObjectList.size());
            for (DynamicObject dynamicObject : dynamicObjectList) {
                HisTransVersionBo hisTransVersionBo = new HisTransVersionBo();
                hisTransVersionBo.setVersionId(dynamicObject.getLong("id"));
                hisTransVersionBoList.add(hisTransVersionBo);
            }
            hisTransBusinessBo.setListHisTransVersionBo(hisTransVersionBoList);
            HisModelEventService.getInstance().saveEvent(hisTransBo);
        }
    }

    private String saveData(Map<BoInitGroupKey, HisInitBoApiResult> hisInitBoApiResultMap, String entityNumber) {
        if (MapUtils.isEmpty(hisInitBoApiResultMap)) {
            return null;
        }
        HisInitBoApiResult[] hisInitBoApiResults = hisInitBoApiResultMap.values().toArray(new HisInitBoApiResult[hisInitBoApiResultMap.size()]);
        if (hisInitBoApiResults == null || hisInitBoApiResults.length == 0) {
            return null;
        }
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)10);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        for (HisInitBoApiResult hisInitBoApiResult : hisInitBoApiResults) {
            dynamicObjectList.addAll(hisInitBoApiResult.getDynamicObjectList());
        }
        if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
            return null;
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
        try {
            serviceHelper.save(dynamicObjects);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return null;
    }
}

