/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.personal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.assistant.plugin.util.BdCtrlStrtgyUtils;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisPersonalVersionBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.bubasedata.HisCalcPersonalDataBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisPersonalDataRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingDynamicObjectEffDateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingHisPersonalVersionBoService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.service.newhismodel.HisModelServiceFactory;
import kd.hr.hbp.business.domain.service.newhismodel.IHisSaveVersion;
import kd.hr.hbp.business.domain.service.newhismodel.personal.IHisPersonalDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisPersonalDataType;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HisPersonalDataService
implements IHisPersonalDataService {
    private static volatile HisPersonalDataService hisPersonalDataService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisPersonalDataService getInstance() {
        if (hisPersonalDataService != null) return hisPersonalDataService;
        Class<HisPersonalDataService> clazz = HisPersonalDataService.class;
        synchronized (HisPersonalDataService.class) {
            if (hisPersonalDataService != null) return hisPersonalDataService;
            hisPersonalDataService = new HisPersonalDataService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisPersonalDataService;
        }
    }

    @Override
    public void batchCalcPersonalData(HisCalcPersonalDataBo hisCalcPersonalDataBo) {
        Map<Long, List<DynamicObject>> mapBoIdGroupData = hisCalcPersonalDataBo.getMapBoIdGroupData();
        String entityNumber = hisCalcPersonalDataBo.getEntityNumber();
        HRBaseServiceHelper serviceHelper = hisCalcPersonalDataBo.getServiceHelper();
        Integer personalDataType = hisCalcPersonalDataBo.getPersonalDataType() != null ? hisCalcPersonalDataBo.getPersonalDataType() : EnumHisPersonalDataType.UNKNOWN_DATA.getType();
        if (personalDataType.intValue() == EnumHisPersonalDataType.NO_PROCESS_DATA.getType().intValue()) {
            return;
        }
        if (CollectionUtils.isEmpty(mapBoIdGroupData)) {
            return;
        }
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return;
        }
        if (personalDataType.intValue() == EnumHisPersonalDataType.PERSONAL_DATA_SAVE.getType().intValue()) {
            this.firstSavePersonalData(mapBoIdGroupData, serviceHelper);
            return;
        }
        boolean needSyncData = BaseDataCommonService.isSyncData((String)entityNumber);
        Boolean isOriginRevise = hisCalcPersonalDataBo.getOriginRevise();
        Set<Long> boIdSet = mapBoIdGroupData.keySet();
        HashSet<Long> originBoIdSet = new HashSet(16);
        HisTransBo hisTransBo = hisCalcPersonalDataBo.getHisTransBo();
        HashMap<Long, Long> mapPersonalBoIdAndMasterId = new HashMap<Long, Long>(16);
        if (personalDataType.intValue() == EnumHisPersonalDataType.UNKNOWN_DATA.getType().intValue()) {
            Map<Long, Long> mapBoIdAndMasterId = this.getMasterIdBoIds(serviceHelper, boIdSet, personalDataType);
            if (CollectionUtils.isEmpty(mapBoIdAndMasterId)) {
                return;
            }
            for (Map.Entry<Long, Long> entry : mapBoIdAndMasterId.entrySet()) {
                Long boId = entry.getKey();
                Long masterId = entry.getValue();
                if (boId == null || masterId == null || boId == 0L || masterId == 0L) continue;
                if (boId.longValue() == masterId.longValue()) {
                    originBoIdSet.add(boId);
                    continue;
                }
                mapPersonalBoIdAndMasterId.put(boId, masterId);
            }
        } else if (personalDataType.intValue() == EnumHisPersonalDataType.ALL_ORIGIN_DATA.getType().intValue()) {
            originBoIdSet = boIdSet;
        } else {
            return;
        }
        if (!CollectionUtils.isEmpty(mapPersonalBoIdAndMasterId) && needSyncData) {
            this.batchCalcPToPData(serviceHelper, mapPersonalBoIdAndMasterId, entityNumber, mapBoIdGroupData);
        }
        if (!CollectionUtils.isEmpty(originBoIdSet)) {
            List<DynamicObject> dyPersonalNewVersionList = this.batchOtoPData(serviceHelper, originBoIdSet, entityNumber, mapBoIdGroupData, isOriginRevise, needSyncData);
            if (!needSyncData && dyPersonalNewVersionList == null) {
                dyPersonalNewVersionList = new ArrayList<DynamicObject>(16);
                this.additionSinkVersionForNoSync(serviceHelper, originBoIdSet, mapBoIdGroupData, dyPersonalNewVersionList);
            }
            if (CollectionUtils.isEmpty(dyPersonalNewVersionList)) {
                return;
            }
            if (isOriginRevise.booleanValue()) {
                ArrayList<DynamicObject> oldDy = new ArrayList<DynamicObject>(dyPersonalNewVersionList.size());
                ArrayList<DynamicObject> newDy = new ArrayList<DynamicObject>(dyPersonalNewVersionList.size());
                for (DynamicObject dynamicObject : dyPersonalNewVersionList) {
                    Long id = dynamicObject.getLong("id");
                    if (id != null && id != 0L) {
                        oldDy.add(dynamicObject);
                        continue;
                    }
                    newDy.add(dynamicObject);
                }
                if (!CollectionUtils.isEmpty(newDy)) {
                    this.newEventForSync(newDy, serviceHelper, entityNumber, isOriginRevise, hisTransBo);
                }
                if (!CollectionUtils.isEmpty(oldDy) && isOriginRevise.booleanValue()) {
                    this.reviseForSync(oldDy, serviceHelper, entityNumber);
                }
            } else {
                this.newEventForSync(dyPersonalNewVersionList, serviceHelper, entityNumber, isOriginRevise, hisTransBo);
            }
        }
    }

    private List<DynamicObject> batchOtoPData(HRBaseServiceHelper serviceHelper, Set<Long> originBoIdSet, String entityNumber, Map<Long, List<DynamicObject>> mapBoIdGroupData, Boolean isOriginRevise, boolean needSyncData) {
        Map<Long, Long> mapBoIdAndMasterId = HisPersonalDataRepository.getCurrentBoIdsByMasterId(serviceHelper, originBoIdSet);
        DynamicObject[] dynamicObjectPersonals = HisPersonalDataRepository.loadSinkPersonalEffVersionByBoIds(serviceHelper, mapBoIdAndMasterId.keySet(), needSyncData);
        if (dynamicObjectPersonals == null || dynamicObjectPersonals.length == 0) {
            return null;
        }
        Map<Long, List<DynamicObject>> mapPersonalDyListGroup = HisCommonService.getInstance().groupByBoIdDyMap(dynamicObjectPersonals);
        HashMap<Long, ArrayList<Long>> mapPersonalMasterBoId = new HashMap<Long, ArrayList<Long>>(16);
        HashSet<Long> allBoIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> masterIdEntry : mapBoIdAndMasterId.entrySet()) {
            Long boId = masterIdEntry.getKey();
            Long masterId = masterIdEntry.getValue();
            ArrayList<Long> listBoId = (ArrayList<Long>)mapPersonalMasterBoId.get(masterId);
            if (listBoId == null) {
                listBoId = new ArrayList<Long>(mapBoIdAndMasterId.size());
                mapPersonalMasterBoId.put(masterId, listBoId);
            }
            listBoId.add(boId);
            allBoIds.add(boId);
        }
        ArrayList<DynamicObject> dyPersonalNewVersionList = new ArrayList<DynamicObject>(16);
        Map<Long, Date> allFirstEffDateMap = HisCommonService.getInstance().getFirstEffDateMap(entityNumber, allBoIds);
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupData.entrySet()) {
            List<DynamicObject> originDyList;
            Long masterId = entry.getKey();
            List boIdList = (List)mapPersonalMasterBoId.get(masterId);
            if (boIdList == null || boIdList.size() == 0 || this.isOnlyToBeEffectVersion(originDyList = entry.getValue())) continue;
            for (Long boId : boIdList) {
                Date firstEffDate;
                List<DynamicObject> calcResultDy;
                List<DynamicObject> personalVersionDyList = mapPersonalDyListGroup.getOrDefault(boId, Lists.newArrayListWithCapacity((int)10));
                if (CollectionUtils.isEmpty(personalVersionDyList) || CollectionUtils.isEmpty(calcResultDy = this.calcPersonalData(serviceHelper, entityNumber, masterId, originDyList, personalVersionDyList, true, isOriginRevise, firstEffDate = allFirstEffDateMap.get(boId)))) continue;
                dyPersonalNewVersionList.addAll(calcResultDy);
            }
        }
        this.setBatchBitIndex(dyPersonalNewVersionList, mapPersonalDyListGroup);
        return dyPersonalNewVersionList;
    }

    private void batchCalcPToPData(HRBaseServiceHelper serviceHelper, Map<Long, Long> mapPersonalBoIdAndMasterId, String entityNumber, Map<Long, List<DynamicObject>> mapBoIdGroupData) {
        DynamicObject[] personalVersionDys = HisPersonalDataRepository.loadNoSinkPersonalEffVersionByBoIds(serviceHelper, mapPersonalBoIdAndMasterId.keySet());
        if (personalVersionDys == null || personalVersionDys.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> mapDyListGroup = HisCommonService.getInstance().groupByBoIdDyMap(personalVersionDys);
        for (Map.Entry<Long, Long> entry : mapPersonalBoIdAndMasterId.entrySet()) {
            Long boId = entry.getKey();
            Long masterId = mapPersonalBoIdAndMasterId.get(boId);
            List<DynamicObject> dynamicObjectList = mapBoIdGroupData.get(boId);
            List<DynamicObject> dynamicObjectOriginList = mapDyListGroup.get(boId);
            List<DynamicObject> calcResultDy = this.calcPersonalData(serviceHelper, entityNumber, masterId, dynamicObjectOriginList, dynamicObjectList, false, false, null);
            if (CollectionUtils.isEmpty(calcResultDy)) continue;
            mapBoIdGroupData.put(boId, calcResultDy);
        }
    }

    private List<DynamicObject> calcPersonalData(HRBaseServiceHelper serviceHelper, String entityNumber, Long masterId, List<DynamicObject> dynamicObjectOriginList, List<DynamicObject> personalVersionDyList, boolean isOriginSync, Boolean isOriginRevise, Date firstEffDate) {
        HashMap<String, Boolean> mapShare = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> mapUpdate = new HashMap<String, Boolean>(16);
        Long createOrgId = HisPersonalCommonService.getInstance().getMasterCurrentDyOrgId(entityNumber, masterId);
        BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy((String)entityNumber, (Long)createOrgId, mapShare, mapUpdate);
        Object[] dynamicObjectOrigins = dynamicObjectOriginList.toArray(new DynamicObject[dynamicObjectOriginList.size()]);
        SortingDynamicObjectEffDateService.getInstance().quickSort(dynamicObjectOrigins);
        ArrayList<DynamicObject> calcResultDy = new ArrayList<DynamicObject>(16);
        if (isOriginSync && firstEffDate != null) {
            List<DynamicObject> dyOriginalNewList = this.sinkBeforeVersion(serviceHelper, (DynamicObject[])dynamicObjectOrigins, firstEffDate, personalVersionDyList.get(0), calcResultDy);
            if (CollectionUtils.isEmpty(dyOriginalNewList)) {
                return calcResultDy;
            }
            dynamicObjectOrigins = dyOriginalNewList.toArray(new DynamicObject[dyOriginalNewList.size()]);
        }
        List<HisPersonalVersionBo> hisPersonalVersionBoList = this.handleMergeOriginVersions((DynamicObject[])dynamicObjectOrigins, mapUpdate, isOriginSync);
        Set<String> validField = HisPersonalCommonService.getInstance().getValidFieldSetNew(dynamicObjectOriginList.get(0).getDataEntityType().getProperties(), mapUpdate, mapShare);
        if (CollectionUtils.isEmpty(validField)) {
            return calcResultDy;
        }
        for (DynamicObject personalVersionDy : personalVersionDyList) {
            Date personalStartDate = personalVersionDy.getDate("bsed");
            Date personalEndDate = personalVersionDy.getDate("bsled");
            List<HisPersonalVersionBo> hisPersonalVersionBoListNew = this.getInterSectList(personalStartDate, personalEndDate, hisPersonalVersionBoList);
            Object[] hisPersonalVersionBos = hisPersonalVersionBoListNew.toArray(new HisPersonalVersionBo[hisPersonalVersionBoListNew.size()]);
            SortingHisPersonalVersionBoService.getInstance().quickSort(hisPersonalVersionBos);
            ArrayList<DynamicObject> dynamicObjectListResult = new ArrayList<DynamicObject>(16);
            if (hisPersonalVersionBos == null || hisPersonalVersionBos.length == 0 || CollectionUtils.isEmpty(mapUpdate)) continue;
            List<DynamicObject> mergedDyOriginList = this.mergeVersion(serviceHelper, (HisPersonalVersionBo[])hisPersonalVersionBos, personalVersionDy, mapUpdate, dynamicObjectListResult, validField, isOriginSync, isOriginRevise);
            HisCommonService.getInstance().calcVersionStatus(mergedDyOriginList);
            calcResultDy.addAll(mergedDyOriginList);
        }
        return calcResultDy;
    }

    private List<DynamicObject> sinkBeforeVersion(HRBaseServiceHelper serviceHelper, DynamicObject[] dynamicObjectOrigins, Date personalFirstBsed, DynamicObject personalCopy, List<DynamicObject> calcResultDy) {
        if (personalFirstBsed == null) {
            return null;
        }
        ArrayList<DynamicObject> dyOriginalNewList = new ArrayList<DynamicObject>(dynamicObjectOrigins.length);
        for (DynamicObject dyOriginal : dynamicObjectOrigins) {
            Date effStartDate = dyOriginal.getDate("bsed");
            Date effEndDate = dyOriginal.getDate("bsled");
            if (effStartDate == null) continue;
            if (effEndDate == null) {
                effEndDate = HisEffDateCommonService.getInstance().getDate2999(null);
                dyOriginal.set("bsled", (Object)effEndDate);
            }
            if (effStartDate.getTime() < personalFirstBsed.getTime()) {
                DynamicObject personalDyNew = serviceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)personalCopy, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
                HRDynamicObjectUtils.copy((DynamicObject)dyOriginal, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getSinkBaseIgnoreKeys(), (boolean)true);
                personalDyNew.set("iscurrentversion", (Object)Character.valueOf('0'));
                personalDyNew.set("bsed", (Object)effStartDate);
                if (personalDyNew.getDynamicObjectType().getProperties().containsKey((Object)"versionsource")) {
                    personalDyNew.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType());
                }
                calcResultDy.add(personalDyNew);
                if (effEndDate.getTime() >= personalFirstBsed.getTime()) {
                    effEndDate = HisCommonService.getInstance().getCalcDay(personalFirstBsed, -1);
                    dyOriginalNewList.add(dyOriginal);
                }
                personalDyNew.set("bsled", (Object)effEndDate);
                continue;
            }
            dyOriginalNewList.add(dyOriginal);
        }
        return dyOriginalNewList;
    }

    private List<HisPersonalVersionBo> handleMergeOriginVersions(DynamicObject[] dynamicObjectOrigins, Map<String, Boolean> mapUpdate, boolean isOriginSync) {
        Set<String> validField = HisPersonalCommonService.getInstance().getValidFieldSet(dynamicObjectOrigins[0].getDynamicObjectType().getProperties(), mapUpdate);
        if (CollectionUtils.isEmpty(validField)) {
            return Collections.emptyList();
        }
        Date now = new Date();
        ArrayList hisPersonalVersionBoList = Lists.newArrayListWithExpectedSize((int)dynamicObjectOrigins.length);
        DynamicObject preDy = dynamicObjectOrigins[0];
        Date preStartDate = preDy.getDate("bsed");
        if (isOriginSync && preStartDate.getTime() > now.getTime()) {
            return Collections.emptyList();
        }
        Date preEndDate = preDy.getDate("bsled");
        HisPersonalVersionBo hisPersonalVersionBo = new HisPersonalVersionBo(preStartDate, preEndDate, preDy);
        hisPersonalVersionBoList.add(hisPersonalVersionBo);
        if (dynamicObjectOrigins.length == 1) {
            return hisPersonalVersionBoList;
        }
        for (int i = 1; i < dynamicObjectOrigins.length; ++i) {
            Date startDate = dynamicObjectOrigins[i].getDate("bsed");
            if (isOriginSync && startDate.getTime() > now.getTime()) break;
            Date endDate = dynamicObjectOrigins[i].getDate("bsled");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(5, -1);
            if (calendar.getTime().getTime() == preEndDate.getTime()) {
                if (!HisPersonalCommonService.getInstance().isDiff(preDy, dynamicObjectOrigins[i], mapUpdate)) {
                    hisPersonalVersionBo.setData(dynamicObjectOrigins[i]);
                    hisPersonalVersionBo.setEffEndDate(endDate);
                } else {
                    hisPersonalVersionBo = new HisPersonalVersionBo(startDate, endDate, dynamicObjectOrigins[i]);
                    hisPersonalVersionBoList.add(hisPersonalVersionBo);
                }
            } else {
                hisPersonalVersionBo = new HisPersonalVersionBo(startDate, endDate, dynamicObjectOrigins[i]);
                hisPersonalVersionBoList.add(hisPersonalVersionBo);
            }
            preDy = dynamicObjectOrigins[i];
            preEndDate = endDate;
        }
        return hisPersonalVersionBoList;
    }

    private List<DynamicObject> mergeVersion(HRBaseServiceHelper serviceHelper, HisPersonalVersionBo[] hisPersonalVersionBos, DynamicObject dyPersonal, Map<String, Boolean> mapUpdate, List<DynamicObject> dynamicObjectListResult, Set<String> validField, boolean isOriginSync, Boolean isOriginRevise) {
        for (int i = 0; i < hisPersonalVersionBos.length; ++i) {
            HisPersonalVersionBo hisPersonalVersionBo = hisPersonalVersionBos[i];
            Date compareEffStartDate = hisPersonalVersionBo.getEffStartDate();
            Date dyPersonalEffStartDate = dyPersonal.getDate("bsed");
            Date dyPersonalEffEndDate = dyPersonal.getDate("bsled");
            if (dyPersonalEffStartDate.before(compareEffStartDate)) {
                if (isOriginSync) {
                    this.oToPBeforeDate(serviceHelper, i, hisPersonalVersionBos, dyPersonalEffEndDate, dyPersonal, mapUpdate, dynamicObjectListResult, validField);
                    continue;
                }
                this.pToPBeforeDate(serviceHelper, i, hisPersonalVersionBos, dyPersonalEffEndDate, dyPersonal, mapUpdate, dynamicObjectListResult, validField);
                continue;
            }
            if (isOriginSync) {
                this.oToPEqualAndAfterDate(serviceHelper, i, hisPersonalVersionBos, dyPersonalEffStartDate, dyPersonalEffEndDate, dyPersonal, mapUpdate, dynamicObjectListResult, validField, isOriginRevise);
                continue;
            }
            this.pToPEqualAndAfterDate(serviceHelper, i, hisPersonalVersionBos, dyPersonalEffStartDate, dyPersonalEffEndDate, dyPersonal, mapUpdate, dynamicObjectListResult, validField);
        }
        return dynamicObjectListResult;
    }

    private void oToPBeforeDate(HRBaseServiceHelper serviceHelper, int i, HisPersonalVersionBo[] hisPersonalVersionBos, Date dyPersonalEffEndDate, DynamicObject dyPersonal, Map<String, Boolean> mapUpdate, List<DynamicObject> dynamicObjectListResult, Set<String> validField) {
        HisPersonalVersionBo hisPersonalVersionBo = hisPersonalVersionBos[i];
        Date compareEffStartDate = hisPersonalVersionBo.getEffStartDate();
        Date compareEffEndDate = hisPersonalVersionBo.getEffEndDate();
        DynamicObject dyCompare = hisPersonalVersionBo.getData();
        if (dyPersonalEffEndDate.before(compareEffStartDate)) {
            return;
        }
        boolean isSink = EnumHisVersionSource.ORIGIN_DATA_SINK.getType().equals(dyPersonal.getString("versionsource"));
        Set<String> ignoreKeys = this.getIgnoreKeys(isSink, dyPersonal, dyCompare, validField, mapUpdate);
        if (ignoreKeys == null) {
            return;
        }
        if (dyPersonalEffEndDate.getTime() <= compareEffEndDate.getTime()) {
            DynamicObject personalDyNew = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            personalDyNew.set("bsed", (Object)compareEffStartDate);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew, ignoreKeys, (boolean)true);
            if (!isSink && personalDyNew.getDynamicObjectType().getProperties().containsKey((Object)"versionsource")) {
                personalDyNew.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SYNC.getType());
            }
            dynamicObjectListResult.add(personalDyNew);
        } else {
            DynamicObject personalDyNew2 = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew2, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            personalDyNew2.set("bsed", (Object)compareEffStartDate);
            personalDyNew2.set("bsled", (Object)compareEffEndDate);
            dynamicObjectListResult.add(personalDyNew2);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew2, ignoreKeys, (boolean)true);
            if (!isSink && personalDyNew2.getDynamicObjectType().getProperties().containsKey((Object)"versionsource")) {
                personalDyNew2.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SYNC.getType());
            }
            Date newEndDate = HisCommonService.getInstance().getCalcDay(compareEffEndDate, 1);
            if (i != hisPersonalVersionBos.length - 1) {
                dyPersonal.set("bsed", (Object)newEndDate);
            }
        }
    }

    private void oToPEqualAndAfterDate(HRBaseServiceHelper serviceHelper, int i, HisPersonalVersionBo[] hisPersonalVersionBos, Date dyPersonalEffStartDate, Date dyPersonalEffEndDate, DynamicObject dyPersonal, Map<String, Boolean> mapUpdate, List<DynamicObject> dynamicObjectListResult, Set<String> validField, Boolean isOriginRevise) {
        HisPersonalVersionBo hisPersonalVersionBo = hisPersonalVersionBos[i];
        Date compareEffEndDate = hisPersonalVersionBo.getEffEndDate();
        DynamicObject dyCompare = hisPersonalVersionBo.getData();
        if (compareEffEndDate.before(dyPersonalEffStartDate)) {
            return;
        }
        boolean isSink = EnumHisVersionSource.ORIGIN_DATA_SINK.getType().equals(dyPersonal.getString("versionsource"));
        Set<String> ignoreKeys = this.getIgnoreKeys(isSink, dyPersonal, dyCompare, validField, mapUpdate);
        if (ignoreKeys == null) {
            return;
        }
        if (dyPersonalEffEndDate.getTime() <= compareEffEndDate.getTime()) {
            if (isOriginRevise.booleanValue()) {
                HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)dyPersonal, ignoreKeys, (boolean)true);
                dynamicObjectListResult.add(dyPersonal);
            } else {
                DynamicObject personalDyNew = serviceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
                HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew, ignoreKeys, (boolean)true);
                if (!isSink && personalDyNew.getDynamicObjectType().getProperties().containsKey((Object)"versionsource")) {
                    personalDyNew.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SYNC.getType());
                }
                dynamicObjectListResult.add(personalDyNew);
            }
        } else {
            DynamicObject personalDyNew = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            personalDyNew.set("bsled", (Object)compareEffEndDate);
            dynamicObjectListResult.add(personalDyNew);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew, ignoreKeys, (boolean)true);
            if (!isSink && personalDyNew.getDynamicObjectType().getProperties().containsKey((Object)"versionsource")) {
                personalDyNew.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SYNC.getType());
            }
            Date newEndDate = HisCommonService.getInstance().getCalcDay(compareEffEndDate, 1);
            if (i != hisPersonalVersionBos.length - 1) {
                dyPersonal.set("bsed", (Object)newEndDate);
            }
        }
    }

    private Set<String> getIgnoreKeys(boolean isSink, DynamicObject dyPersonal, DynamicObject dyCompare, Set<String> validField, Map<String, Boolean> mapUpdate) {
        Set<String> ignoreKeys;
        if (isSink) {
            ignoreKeys = HisPersonalCommonService.getInstance().getSinkBaseIgnoreKeys();
            Set<String> noIgnoreKeys = HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, ignoreKeys);
            if (!HisPersonalCommonService.getInstance().isDiff(dyPersonal, dyCompare, noIgnoreKeys)) {
                return null;
            }
        } else {
            if (!HisPersonalCommonService.getInstance().isDiff(dyPersonal, dyCompare, mapUpdate)) {
                return null;
            }
            ignoreKeys = HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, validField);
        }
        return ignoreKeys;
    }

    private void pToPBeforeDate(HRBaseServiceHelper serviceHelper, int i, HisPersonalVersionBo[] hisPersonalVersionBos, Date dyPersonalEffEndDate, DynamicObject dyPersonal, Map<String, Boolean> mapUpdate, List<DynamicObject> dynamicObjectListResult, Set<String> validField) {
        HisPersonalVersionBo hisPersonalVersionBo = hisPersonalVersionBos[i];
        Date compareEffStartDate = hisPersonalVersionBo.getEffStartDate();
        Date compareEffEndDate = hisPersonalVersionBo.getEffEndDate();
        DynamicObject dyCompare = hisPersonalVersionBo.getData();
        if (dyPersonalEffEndDate.before(compareEffStartDate)) {
            dynamicObjectListResult.add(dyPersonal);
            return;
        }
        if (!HisPersonalCommonService.getInstance().isDiff(dyPersonal, dyCompare, mapUpdate)) {
            return;
        }
        if (dyPersonalEffEndDate.getTime() <= compareEffEndDate.getTime()) {
            DynamicObject personalDyNew = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            dyPersonal.set("bsled", (Object)HisCommonService.getInstance().getCalcDay(compareEffStartDate, -1));
            dynamicObjectListResult.add(dyPersonal);
            personalDyNew.set("bsed", (Object)compareEffStartDate);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew, HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, validField), (boolean)true);
            dynamicObjectListResult.add(personalDyNew);
        } else {
            DynamicObject personalDyNewA = serviceHelper.generateEmptyDynamicObject();
            DynamicObject personalDyNewB = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNewA, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNewB, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            personalDyNewA.set("bsled", (Object)HisCommonService.getInstance().getCalcDay(compareEffStartDate, -1));
            dynamicObjectListResult.add(personalDyNewA);
            personalDyNewB.set("bsed", (Object)compareEffStartDate);
            personalDyNewB.set("bsled", (Object)compareEffEndDate);
            dynamicObjectListResult.add(personalDyNewB);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNewB, HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, validField), (boolean)true);
            Date newEndDate = HisCommonService.getInstance().getCalcDay(compareEffEndDate, 1);
            dyPersonal.set("bsed", (Object)newEndDate);
            if (i == hisPersonalVersionBos.length - 1) {
                dynamicObjectListResult.add(dyPersonal);
            }
        }
    }

    private void pToPEqualAndAfterDate(HRBaseServiceHelper serviceHelper, int i, HisPersonalVersionBo[] hisPersonalVersionBos, Date dyPersonalEffStartDate, Date dyPersonalEffEndDate, DynamicObject dyPersonal, Map<String, Boolean> mapUpdate, List<DynamicObject> dynamicObjectListResult, Set<String> validField) {
        HisPersonalVersionBo hisPersonalVersionBo = hisPersonalVersionBos[i];
        Date compareEffEndDate = hisPersonalVersionBo.getEffEndDate();
        DynamicObject dyCompare = hisPersonalVersionBo.getData();
        if (compareEffEndDate.before(dyPersonalEffStartDate)) {
            return;
        }
        if (!HisPersonalCommonService.getInstance().isDiff(dyPersonal, dyCompare, mapUpdate)) {
            return;
        }
        if (dyPersonalEffEndDate.getTime() <= compareEffEndDate.getTime()) {
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)dyPersonal, HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, validField), (boolean)true);
            dynamicObjectListResult.add(dyPersonal);
        } else {
            DynamicObject personalDyNew1 = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyPersonal, (DynamicObject)personalDyNew1, HisPersonalCommonService.getInstance().getBaseIgnoreKeys(), (boolean)true);
            personalDyNew1.set("bsled", (Object)compareEffEndDate);
            dynamicObjectListResult.add(personalDyNew1);
            HRDynamicObjectUtils.copy((DynamicObject)dyCompare, (DynamicObject)personalDyNew1, HisPersonalCommonService.getInstance().getDiffSet(dyPersonal, validField), (boolean)true);
            Date newEndDate = HisCommonService.getInstance().getCalcDay(compareEffEndDate, 1);
            dyPersonal.set("bsed", (Object)newEndDate);
            if (i == hisPersonalVersionBos.length - 1) {
                dynamicObjectListResult.add(dyPersonal);
            }
        }
    }

    private List<HisPersonalVersionBo> getInterSectList(Date startDate, Date endDate, Collection<HisPersonalVersionBo> hisPersonalVersionBos) {
        ArrayList<HisPersonalVersionBo> hisPersonalVersionBoList = new ArrayList<HisPersonalVersionBo>(hisPersonalVersionBos.size());
        for (HisPersonalVersionBo bo : hisPersonalVersionBos) {
            Date originStartDate = bo.getEffStartDate();
            Date originEndDate = bo.getEffEndDate();
            if (originStartDate.getTime() < startDate.getTime()) {
                if (originEndDate.getTime() < startDate.getTime()) continue;
                hisPersonalVersionBoList.add(bo);
                continue;
            }
            if (originStartDate.getTime() > startDate.getTime()) {
                if (originStartDate.getTime() > endDate.getTime()) continue;
                hisPersonalVersionBoList.add(bo);
                continue;
            }
            hisPersonalVersionBoList.add(bo);
        }
        return hisPersonalVersionBoList;
    }

    private Map<Long, Long> getMasterIdBoIds(HRBaseServiceHelper serviceHelper, Set<Long> boIdSet, int personalData) {
        if (personalData == 1) {
            HashMap<Long, Long> mapBoIdAndMasterId = new HashMap<Long, Long>(boIdSet.size());
            boIdSet.forEach(boId -> mapBoIdAndMasterId.put((Long)boId, (Long)boId));
            return mapBoIdAndMasterId;
        }
        return HisPersonalDataRepository.getMasterIdBoIds(serviceHelper, boIdSet);
    }

    private void newEventForSync(List<DynamicObject> dyPersonalNewVersionList, HRBaseServiceHelper serviceHelper, String entityNumber, Boolean isOriginRevise, HisTransBo hisTransBo) {
        if (dyPersonalNewVersionList == null || dyPersonalNewVersionList.size() == 0) {
            return;
        }
        IHisSaveVersion hisSaveVersion = HisModelServiceFactory.getHisSaveVersionInstance(entityNumber);
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(dyPersonalNewVersionList.toArray(new DynamicObject[dyPersonalNewVersionList.size()]));
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setNeedValidateDate(false);
        hisVersionParamBo.setPersonalDataType(4);
        if (hisTransBo == null) {
            hisTransBo = new HisTransBo();
        }
        boolean onlySinkVersion = true;
        for (DynamicObject dynamicObject : dyPersonalNewVersionList) {
            String versionSource = dynamicObject.getString("versionsource");
            if (EnumHisVersionSource.ORIGIN_DATA_SINK.getType().equals(versionSource)) continue;
            onlySinkVersion = false;
            break;
        }
        if (onlySinkVersion) {
            hisTransBo.setTransType(EventOperateEnums.EVENT_TYPE_ORIGIN_ONLY_SINK.getValue());
            if (!isOriginRevise.booleanValue()) {
                hisTransBo.setRecursionNoSave(true);
            }
        } else {
            hisTransBo.setTransExecuteMode(EventOperateEnums.EVENT_EXECUTE_HANDLE.getValue());
            if (isOriginRevise.booleanValue()) {
                hisTransBo.setTransType(EventOperateEnums.EVENT_TYPE_ORIGIN_REVISE.getValue());
            } else {
                hisTransBo.setTransType(EventOperateEnums.EVENT_TYPE_ORIGIN_CHANGE.getValue());
                hisTransBo.setRecursionNoSave(true);
            }
        }
        hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
        DynamicObject[] dynamicObjects = hisSaveVersion.saveEffVersion(hisVersionParamBo, hisTransBo, serviceHelper, false);
        HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, dynamicObjects);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            serviceHelper.save(dynamicObjects);
        }
    }

    private void reviseForSync(List<DynamicObject> oldDy, HRBaseServiceHelper serviceHelper, String entityNumber) {
        HisVersionReviseParamBo bo = new HisVersionReviseParamBo();
        Object[] dynamicObjects = oldDy.toArray(new DynamicObject[oldDy.size()]);
        bo.setReviseDys((DynamicObject[])dynamicObjects);
        bo.setEntityNumber(entityNumber);
        bo.setPersonalDataSyn(false);
        HisVersionReviseReturnDataBo hisVersionReviseReturnDataBo = HisVersionReviseService.getInstance().reviseVersion(bo);
        DynamicObject[] dyAll = (DynamicObject[])ArrayUtils.addAll((Object[])dynamicObjects, (Object[])hisVersionReviseReturnDataBo.getReturnData());
        serviceHelper.save(dyAll);
    }

    private void firstSavePersonalData(Map<Long, List<DynamicObject>> mapBoIdGroupData, HRBaseServiceHelper serviceHelper) {
        DynamicObject[] dynamicObjects;
        Set<Long> boIdSet = mapBoIdGroupData.keySet();
        Map<Long, Long> mapBoIdAndMasterId = HisPersonalDataRepository.getCurrentMasterIdsByBoIds(serviceHelper, boIdSet);
        boolean isNewModel = BaseDataCommonService.isNewModel((String)serviceHelper.getEntityName());
        if (!isNewModel) {
            this.reBuildParentBoIds(serviceHelper, mapBoIdGroupData, mapBoIdAndMasterId);
        }
        if ((dynamicObjects = HisCommonEntityRepository.loadOldEffVersionByBoIdsWithoutNoInit(serviceHelper, mapBoIdAndMasterId.keySet())) == null) {
            return;
        }
        Map<Long, List<DynamicObject>> mapBoIdGroupOriginVersion = Stream.of(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupOriginVersion.entrySet()) {
            Long personalBoId;
            List<DynamicObject> dyListPersonal;
            Long originBoId = entry.getKey();
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList) || CollectionUtils.isEmpty(dyListPersonal = mapBoIdGroupData.get(personalBoId = mapBoIdAndMasterId.get(originBoId)))) continue;
            DynamicObject firstPersonalVersion = dyListPersonal.get(0);
            Date maskToday = firstPersonalVersion.getDate("bsed");
            Object[] dynamicObjectArray = dynamicObjectList.toArray(new DynamicObject[0]);
            SortingDynamicObjectEffDateService.getInstance().quickSort(dynamicObjectArray);
            Date firstEffDate = dynamicObjectArray[0].getDate("bsed");
            if (firstEffDate != null && maskToday != null && maskToday.getTime() < firstEffDate.getTime()) {
                maskToday = firstEffDate;
                firstPersonalVersion.set("bsed", (Object)maskToday);
            }
            for (Object dynamicObject2 : dynamicObjectArray) {
                Date effStartDate = dynamicObject2.getDate("bsed");
                Date effEndDate = dynamicObject2.getDate("bsled");
                if (effStartDate.getTime() >= maskToday.getTime()) continue;
                if (effEndDate.getTime() >= maskToday.getTime()) {
                    this.addPersonalVersion(dyListPersonal, serviceHelper, (DynamicObject)dynamicObject2, firstPersonalVersion, personalBoId, maskToday, true);
                    continue;
                }
                this.addPersonalVersion(dyListPersonal, serviceHelper, (DynamicObject)dynamicObject2, firstPersonalVersion, personalBoId, maskToday, false);
            }
            this.setBitIndex(dyListPersonal, firstPersonalVersion);
            Date today = HRDateTimeUtils.getUserTimeZoneToday();
            for (DynamicObject dynamicObject3 : dyListPersonal) {
                Date effStartDate = dynamicObject3.getDate("bsed");
                if (today.getTime() < effStartDate.getTime() || !EnumHisVersionSource.CHANGE.getType().equals(dynamicObject3.getString("versionsource"))) continue;
                HisTimeZoneService.getInstance().firstInitPlanBsedAndStatus(dynamicObject3);
            }
        }
    }

    private void reBuildParentBoIds(HRBaseServiceHelper serviceHelper, Map<Long, List<DynamicObject>> mapBoIdGroupData, Map<Long, Long> mapBoIdAndMasterId) {
        Long masterId = null;
        Long personalId = null;
        for (Map.Entry<Long, Long> entry : mapBoIdAndMasterId.entrySet()) {
            masterId = entry.getKey();
            personalId = entry.getValue();
        }
        if (masterId == null || personalId == null) {
            return;
        }
        for (Map.Entry<Long, Object> entry : mapBoIdGroupData.entrySet()) {
            Long useDataId;
            Long parentOrgId;
            DynamicObject dynamicObject;
            String ctrlstrategy;
            boolean notAssignStrategy;
            List dynamicObjectList = (List)entry.getValue();
            if (dynamicObjectList == null || dynamicObjectList.size() == 0 || (notAssignStrategy = !"1".equals(ctrlstrategy = (dynamicObject = (DynamicObject)dynamicObjectList.get(0)).getString("ctrlstrategy")) && !"2".equals(ctrlstrategy)) || !"1".equals(ctrlstrategy)) continue;
            DynamicObject dyOrg = (DynamicObject)dynamicObject.get("org");
            long orgId = dyOrg.getLong("id");
            Long ctrlview_id = HisPersonalDataRepository.getView(serviceHelper.getEntityName());
            if (ctrlview_id == null || ctrlview_id == 0L || (parentOrgId = HisPersonalDataRepository.getOrgParentId(orgId, String.valueOf(ctrlview_id))) == null || (useDataId = HisPersonalDataRepository.getParentUseDataId(serviceHelper.getEntityName(), parentOrgId, masterId)) == null || useDataId == 0L && masterId.longValue() != useDataId.longValue()) continue;
            mapBoIdAndMasterId.remove(masterId);
            mapBoIdAndMasterId.put(useDataId, personalId);
        }
    }

    public Long getParentUseDataId(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        String entityName = dynamicObject.getDataEntityType().getName();
        if (entityName == null) {
            return null;
        }
        DynamicObject dyOrg = (DynamicObject)dynamicObject.get("org");
        long orgId = dyOrg.getLong("id");
        Long masterId = dynamicObject.getLong("masterid");
        if (masterId == null) {
            return null;
        }
        Long ctrlview_id = HisPersonalDataRepository.getView(entityName);
        if (ctrlview_id == null || ctrlview_id == 0L) {
            return null;
        }
        Long parentOrgId = HisPersonalDataRepository.getOrgParentId(orgId, String.valueOf(ctrlview_id));
        if (parentOrgId != null) {
            Long useDataId = HisPersonalDataRepository.getParentUseDataId(entityName, parentOrgId, masterId);
            return useDataId;
        }
        return null;
    }

    private void addPersonalVersion(List<DynamicObject> dyListPersonal, HRBaseServiceHelper serviceHelper, DynamicObject originDy, DynamicObject firstPersonalVersion, Long personalBoId, Date maskToday, boolean existsIntersection) {
        DynamicObject newDy = serviceHelper.generateEmptyDynamicObject();
        Set<String> ignoreKeys = HisPersonalCommonService.getInstance().getBaseIgnoreKeys();
        Set<String> bdFields = Stream.of("createorg", "org", "useorg", "ctrlstrategy").collect(Collectors.toSet());
        ignoreKeys.addAll(bdFields);
        HRDynamicObjectUtils.copy((DynamicObject)originDy, (DynamicObject)newDy, ignoreKeys);
        DynamicObjectCommonService.getInstance().setMastId(newDy);
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(newDy);
        if (existsIntersection) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(maskToday);
            calendar.add(5, -1);
            newDy.set("bsled", (Object)calendar.getTime());
        } else {
            newDy.set("bsled", (Object)originDy.getDate("bsled"));
        }
        newDy.set("boid", (Object)personalBoId);
        newDy.set("versionsource", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType());
        HRDynamicObjectUtils.copy((DynamicObject)firstPersonalVersion, (DynamicObject)newDy, HisPersonalCommonService.getInstance().getDiffSet(newDy, bdFields));
        dyListPersonal.add(newDy);
        HisCommonService.getInstance().calcVersionStatus(dyListPersonal);
    }

    private void additionSinkVersionForNoSync(HRBaseServiceHelper serviceHelper, Set<Long> originBoIdSet, Map<Long, List<DynamicObject>> mapBoIdGroupData, List<DynamicObject> dyPersonalNewVersionList) {
        if (CollectionUtils.isEmpty(originBoIdSet) || CollectionUtils.isEmpty(mapBoIdGroupData)) {
            return;
        }
        ArrayList masterIds = Lists.newArrayListWithCapacity((int)originBoIdSet.size());
        masterIds.addAll(originBoIdSet);
        List<Long> personalBoIdSet = HisPersonalDataRepository.getBoIdListByMasterId(serviceHelper, masterIds);
        if (CollectionUtils.isEmpty(personalBoIdSet)) {
            return;
        }
        DynamicObject[] personalCurrentVersions = serviceHelper.loadDynamicObjectArray(personalBoIdSet.toArray(new Long[personalBoIdSet.size()]));
        Map<Long, DynamicObject> personalCurrMap = HisCommonService.getInstance().groupByBoIdCurrentDyMap(personalCurrentVersions);
        Map<Long, Date> mapBoIdFirstDate = HisPersonalDataRepository.batchQueryPersonalDate(serviceHelper, personalBoIdSet);
        if (CollectionUtils.isEmpty(mapBoIdFirstDate)) {
            return;
        }
        for (Map.Entry<Long, Date> entry : mapBoIdFirstDate.entrySet()) {
            List<DynamicObject> originalVersions;
            Long boId = entry.getKey();
            Date personalDate = entry.getValue();
            DynamicObject personalCurrentVersion = personalCurrMap.get(boId);
            Long masterId = personalCurrentVersion.getLong("masterid");
            if (masterId == null || masterId == 0L || CollectionUtils.isEmpty(originalVersions = mapBoIdGroupData.get(masterId))) continue;
            if (this.isOnlyToBeEffectVersion(originalVersions)) {
                return;
            }
            this.sinkBeforeVersion(serviceHelper, originalVersions.toArray(new DynamicObject[originalVersions.size()]), personalDate, personalCurrentVersion, dyPersonalNewVersionList);
        }
        this.setBatchBitIndex2(dyPersonalNewVersionList, personalCurrMap);
    }

    private boolean isOnlyToBeEffectVersion(List<DynamicObject> originDyList) {
        for (DynamicObject dynamicObject : originDyList) {
            String dataStatus = dynamicObject.getString("datastatus");
            if (!EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus) && !EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus)) continue;
            return false;
        }
        return true;
    }

    private void setBatchBitIndex2(List<DynamicObject> dyListPersonal, Map<Long, DynamicObject> mapOldPersonalDy) {
        if (CollectionUtils.isEmpty(dyListPersonal) || CollectionUtils.isEmpty(mapOldPersonalDy)) {
            return;
        }
        DataEntityPropertyCollection dataEntityProperties = dyListPersonal.get(0).getDynamicObjectType().getProperties();
        boolean hasBitField = this.hasBitField(dataEntityProperties);
        if (!hasBitField) {
            return;
        }
        for (DynamicObject personData : dyListPersonal) {
            DynamicObject oldDy;
            Long boId = personData.getLong("boid");
            if (boId == null || (oldDy = mapOldPersonalDy.get(boId)) == null) continue;
            this.copyBitValue(oldDy, personData);
        }
    }

    private void setBatchBitIndex(List<DynamicObject> dyListPersonal, Map<Long, List<DynamicObject>> mapOldPersonalDyListGroup) {
        if (CollectionUtils.isEmpty(dyListPersonal) || CollectionUtils.isEmpty(mapOldPersonalDyListGroup)) {
            return;
        }
        DataEntityPropertyCollection dataEntityProperties = dyListPersonal.get(0).getDynamicObjectType().getProperties();
        boolean hasBitField = this.hasBitField(dataEntityProperties);
        if (!hasBitField) {
            return;
        }
        for (DynamicObject personData : dyListPersonal) {
            DynamicObject oldDy;
            List<DynamicObject> oldPersonDataList;
            Long boId = personData.getLong("boid");
            if (boId == null || CollectionUtils.isEmpty(oldPersonDataList = mapOldPersonalDyListGroup.get(boId)) || (oldDy = oldPersonDataList.get(0)) == null) continue;
            this.copyBitValue(oldDy, personData);
        }
    }

    private void setBitIndex(List<DynamicObject> dyListPersonal, DynamicObject firstPersonalVersion) {
        DataEntityPropertyCollection dataEntityProperties = firstPersonalVersion.getDynamicObjectType().getProperties();
        boolean hasBitField = this.hasBitField(dataEntityProperties);
        if (!hasBitField) {
            return;
        }
        for (DynamicObject dynamicObject : dyListPersonal) {
            this.copyBitValue(firstPersonalVersion, dynamicObject);
        }
    }

    private boolean hasBitField(DataEntityPropertyCollection dataEntityProperties) {
        boolean hasBitIndex = dataEntityProperties.containsKey((Object)"bitindex");
        boolean hasSourceBitIndex = dataEntityProperties.containsKey((Object)"srcindex");
        boolean hasSourceData = dataEntityProperties.containsKey((Object)"sourcedata");
        return hasBitIndex && hasSourceBitIndex && hasSourceData;
    }

    private void copyBitValue(DynamicObject dyForm, DynamicObject dyTo) {
        dyTo.set("bitindex", dyForm.get("bitindex"));
        dyTo.set("srcindex", dyForm.get("srcindex"));
        dyTo.set("sourcedata", dyForm.get("sourcedata"));
    }
}

