/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.revocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class HisModelEventDataService {
    private static volatile HisModelEventDataService hisModelEventDataService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisModelEventDataService getInstance() {
        if (hisModelEventDataService != null) return hisModelEventDataService;
        Class<HisModelEventDataService> clazz = HisModelEventDataService.class;
        synchronized (HisModelEventDataService.class) {
            if (hisModelEventDataService != null) return hisModelEventDataService;
            hisModelEventDataService = new HisModelEventDataService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisModelEventDataService;
        }
    }

    public void processEventData(HRBaseServiceHelper eventHelper, DynamicObject eventDy, long newEventId, Date operationDate, boolean isPartRevocation, HRBaseServiceHelper busiEventHelper) {
        this.addNewEvent(eventHelper, eventDy, newEventId, operationDate);
        this.updateOldEvent(eventHelper, isPartRevocation, eventDy, busiEventHelper);
    }

    public DynamicObject getEventGroupDyByEntity(String entityNumber) {
        DynamicObject eventTableConfigDy;
        if (entityNumber == null) {
            return null;
        }
        DynamicObject entityConfig = HisCommonEntityRepository.getEntityToEventDy(entityNumber);
        if (entityConfig != null && (eventTableConfigDy = entityConfig.getDynamicObject("evententity")) != null) {
            return eventTableConfigDy;
        }
        DynamicObject dyEntityApp = HisCommonEntityRepository.getEntityToAppDy(entityNumber);
        if (dyEntityApp == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u5b9e\u4f53\u7f16\u7801\uff1a%s\u3002", (String)"HisModelEventDataService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber));
        }
        String appID = dyEntityApp.getString("bizappid.id");
        if (StringUtils.isEmpty((String)appID)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u7684\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u5b9e\u4f53\u7f16\u7801\uff1a%s\u3002", (String)"HisModelEventDataService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber));
        }
        DynamicObject dyAppEvent = HisCommonEntityRepository.getAppDefaultEventDy(appID);
        if (!HRObjectUtils.isEmpty((Object)dyAppEvent)) {
            return dyAppEvent.getDynamicObject("evententity");
        }
        return null;
    }

    public void buildHisTransRevocationBoList(HisTransRevocationListBo hisTransRevocationListBo, Set<String> entityNumberSet) {
        if (hisTransRevocationListBo == null) {
            return;
        }
        List<HisTransRevocationBo> hisTransRevocationBoList = hisTransRevocationListBo.getListHisTransRevocationBo();
        if (CollectionUtils.isEmpty(hisTransRevocationBoList)) {
            if (entityNumberSet == null) {
                return;
            }
            hisTransRevocationBoList = new ArrayList<HisTransRevocationBo>(entityNumberSet.size());
            for (String entityNumber : entityNumberSet) {
                HisTransRevocationBo hisTransRevocationBo = new HisTransRevocationBo();
                hisTransRevocationBo.setEntityNumber(entityNumber);
                hisTransRevocationBoList.add(hisTransRevocationBo);
            }
            hisTransRevocationListBo.setListHisTransRevocationBo(hisTransRevocationBoList);
        }
    }

    private void addNewEvent(HRBaseServiceHelper eventHelper, DynamicObject eventDy, long newEventId, Date operationDate) {
        QFilter qFilter = new QFilter("id", "=", (Object)newEventId);
        DynamicObject newEventDy = eventHelper.loadDynamicObject(qFilter);
        if (!HRObjectUtils.isEmpty((Object)newEventDy)) {
            newEventDy.set("eventbatchtype", (Object)EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(newEventDy);
        } else {
            newEventDy = eventHelper.generateEmptyDynamicObject();
            newEventDy.set("id", (Object)newEventId);
            newEventDy.set("eventbatchtype", eventDy.get("eventbatchtype"));
            DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(newEventDy, operationDate);
        }
        newEventDy.set("eventtype", (Object)EventOperateEnums.EVENT_TYPE_REVOCATION.getValue());
        newEventDy.set("executeway", (Object)EventOperateEnums.EVENT_EXECUTE_HANDLE.getValue());
        newEventDy.set("status", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue());
        newEventDy.set("canceledeventid", (Object)eventDy.getLong("id"));
        DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(newEventDy, operationDate);
        eventHelper.saveOne(newEventDy);
    }

    private void updateOldEvent(HRBaseServiceHelper eventHelper, boolean isPartRevocation, DynamicObject eventDy, HRBaseServiceHelper busiEventHelper) {
        if (isPartRevocation) {
            QFilter busiEventQfilter = new QFilter("event", "=", (Object)eventDy.getLong("id"));
            DynamicObject[] allBusiEventDys = busiEventHelper.query("id,sourceentity,boid,isbusinesseventbo,status,canceledeventid", busiEventQfilter.toArray());
            List filterAllBusiEventDys = Arrays.stream(allBusiEventDys).filter(dy -> !HRStringUtils.equals((String)dy.getString("status"), (String)EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue())).collect(Collectors.toList());
            if (filterAllBusiEventDys.size() > 0) {
                eventDy.set("status", (Object)EventOperateEnums.EVENT_STATUS_PART_REVOCATION.getValue());
            } else {
                eventDy.set("status", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue());
            }
        } else {
            eventDy.set("status", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_REVOCATION.getValue());
        }
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(eventDy);
        eventHelper.updateOne(eventDy);
    }
}

