/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.timezone;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import org.apache.commons.collections.MapUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class HisTimeZoneService {
    private static volatile HisTimeZoneService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisTimeZoneService getInstance() {
        if (service != null) return service;
        Class<HisTimeZoneService> clazz = HisTimeZoneService.class;
        synchronized (HisTimeZoneService.class) {
            if (service != null) return service;
            service = new HisTimeZoneService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void initPlanBsedByArray(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Long diffOffSet = this.getDiffOffSetOfUserAndSysTZ();
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.initPlanBsed(dynamicObject, diffOffSet);
        }
    }

    public void initPlanBsedByList(List<DynamicObject> dynamicObjectList, Set<Long> canNotUpdatePlanBsedIdSet) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        boolean setIsNotEmpty = !CollectionUtils.isEmpty(canNotUpdatePlanBsedIdSet);
        Long diffOffSet = this.getDiffOffSetOfUserAndSysTZ();
        boolean hasVersionSource = dynamicObjectList.get(0).getDynamicObjectType().getProperties().containsKey((Object)"versionsource");
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Long id = dynamicObject.getLong("id");
            if (setIsNotEmpty && canNotUpdatePlanBsedIdSet.contains(id)) continue;
            if (hasVersionSource) {
                if (!EnumHisVersionSource.CHANGE.getType().equals(dynamicObject.getString("versionsource"))) continue;
                this.initPlanBsed(dynamicObject, diffOffSet);
                continue;
            }
            this.initPlanBsed(dynamicObject, diffOffSet);
        }
    }

    public Set<Long> canNotUpdatePlanBsedSet(HRBaseServiceHelper serviceHelper, DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = dynamicObject.getLong("id");
            if (id == null || id == 0L) continue;
            idSet.add(id);
        }
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        Map<Long, Date> mapEffStartDate = HisCommonEntityRepository.getEffStartDateByIds(serviceHelper, idSet);
        if (MapUtils.isEmpty(mapEffStartDate)) {
            return null;
        }
        HashSet canNotUpdatePlanBsedIdSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date effStartDate;
            Date effStartDateFromDb;
            Long id = dynamicObject.getLong("id");
            if (id == null || id == 0L || (effStartDateFromDb = mapEffStartDate.get(id)) == null || (effStartDate = dynamicObject.getDate("bsed")) == null || effStartDate.getTime() != effStartDateFromDb.getTime()) continue;
            canNotUpdatePlanBsedIdSet.add(id);
        }
        return canNotUpdatePlanBsedIdSet;
    }

    public String firstInitPlanBsedAndStatus(DynamicObject dynamicObject) {
        this.initPlanBsed(dynamicObject);
        Date planBsed = dynamicObject.getDate("changebsed");
        Date effEndDate = dynamicObject.getDate("bsled");
        String dataStatus = HisEffDateCommonService.getInstance().calcDataStatus(planBsed, effEndDate);
        return dataStatus;
    }

    private void initPlanBsed(DynamicObject dynamicObject, Long diffOffSet) {
        Date startDate = dynamicObject.getDate("bsed");
        Date userDate = this.getNewDateByUserTimeZone(dynamicObject, diffOffSet);
        boolean hasPlanBsedField = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
        if (hasPlanBsedField) {
            if (userDate == null) {
                dynamicObject.set("changebsed", (Object)startDate);
            } else {
                dynamicObject.set("changebsed", (Object)userDate);
            }
        }
    }

    public void initPlanBsed(DynamicObject dynamicObject) {
        this.initPlanBsed(dynamicObject, null);
    }

    public void initToBeEffPlanBsed(DynamicObject dynamicObject) {
        Date userDate = this.getNewDateByUserTimeZone(dynamicObject);
        Date nowDate = new Date();
        String dataStatus = dynamicObject.getString("datastatus");
        boolean hasPlanBsedField = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
        if (hasPlanBsedField && userDate != null && userDate.getTime() > nowDate.getTime() && EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus)) {
            dynamicObject.set("changebsed", (Object)userDate);
        }
    }

    private Date getNewDateByUserTimeZone(DynamicObject dynamicObject) {
        return this.getNewDateByUserTimeZone(dynamicObject, null);
    }

    private Date getNewDateByUserTimeZone(DynamicObject dynamicObject, Long diffOffSet) {
        Date startDate = dynamicObject.getDate("bsed");
        if (startDate == null) {
            return null;
        }
        if (diffOffSet == null) {
            diffOffSet = this.getDiffOffSetOfUserAndSysTZ();
        }
        Date userDate = new Date(startDate.getTime() + diffOffSet);
        return userDate;
    }

    private long getDiffOffSetOfUserAndSysTZ() {
        TimeZone userTimeZone = KDDateUtils.getUserTimeZone();
        TimeZone sysTimeZone = KDDateUtils.getSysTimeZone();
        if (userTimeZone == null || sysTimeZone == null) {
            return 0L;
        }
        return sysTimeZone.getRawOffset() - userTimeZone.getRawOffset();
    }
}

