/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.EventGroupService;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import org.apache.commons.collections.MapUtils;

public class HisModelNonEventUtil {
    private static final Log LOGGER = LogFactory.getLog(HisModelNonEventUtil.class);

    public static Map<String, Object> saveNonDatasEvent(String entityNumber, DynamicObject[] dynamicObjects, Map<Object, Object> effectRelMap) {
        return HisModelNonEventUtil.saveNonDatasEvent(entityNumber, dynamicObjects, effectRelMap, 0L);
    }

    public static Map<String, Object> saveNonDatasEvent(String entityNumber, DynamicObject[] dynamicObjects, Map<Object, Object> effectRelMap, Long eventId) {
        Collection<DynamicObject> eventGroupDys;
        Date operationDate = new Date();
        ArrayList entityNumberList = Lists.newArrayListWithExpectedSize((int)16);
        entityNumberList.add(entityNumber);
        Map<String, DynamicObject> eventGroupMap = EventGroupService.getInstance().getEntityToEventMap(entityNumberList);
        if (MapUtils.isEmpty(eventGroupMap)) {
            Map<String, String> entityToAppMap = EventGroupService.getInstance().getEntityToAppMap(entityNumberList);
            eventGroupMap = EventGroupService.getInstance().getAppDefaultEventMap(entityToAppMap);
        }
        if (CollectionUtils.isEmpty(eventGroupDys = eventGroupMap.values())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u6ce8\u518c\u5b9e\u4f53%1$s\u6216\u5e94\u7528%2$s\u7684\u4e8b\u52a1\u7ec4\u3002", (String)"HisModelEvent_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber, EventGroupService.getInstance().getEntityToAppMap(entityNumberList).get(entityNumber)));
        }
        return HisModelNonEventUtil.saveEventGroup(entityNumber, eventGroupDys, dynamicObjects, effectRelMap, eventId, operationDate);
    }

    private static Map<String, Object> saveEventGroup(String entityNumber, Collection<DynamicObject> eventGroupDys, DynamicObject[] dynamicObjects, Map<Object, Object> effectRelMap, Long eventId, Date operationDate) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        LOGGER.info("saveEventGroup-effectRelMap : {}", effectRelMap);
        DynamicObject eventGroup = eventGroupDys.iterator().next();
        DynamicObject eventDy = eventGroup.getDynamicObject("evententity");
        String eventEntityNumber = eventDy.getString("number");
        HRBaseServiceHelper eventHelper = new HRBaseServiceHelper(eventEntityNumber);
        DynamicObject saveEventDy = HisModelNonEventUtil.getNewEventDy(eventHelper, eventId, effectRelMap, operationDate);
        String nonEventIdKey = String.format("HismodelEventId_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix());
        HRAppCache.get((String)"hbp").put(nonEventIdKey, (Object)saveEventDy.getLong("id"));
        LOGGER.info("saveEventGroup-saveEventDy : {}", (Object)saveEventDy);
        DynamicObject busiEventDy = eventGroup.getDynamicObject("busevententity");
        String busiEventEntityNumber = busiEventDy.getString("number");
        HRBaseServiceHelper busiEventHelper = new HRBaseServiceHelper(busiEventEntityNumber);
        DynamicObjectCollection busiEventCol = new DynamicObjectCollection();
        DynamicObject hisEventDy = eventGroup.getDynamicObject("hisevententity");
        String hisEventEntityNumber = hisEventDy.getString("number");
        HRBaseServiceHelper hisEventHelper = new HRBaseServiceHelper(hisEventEntityNumber);
        DynamicObjectCollection hisEventCol = new DynamicObjectCollection();
        ORM orm = ORM.create();
        long[] busiEventDyIds = orm.genLongIds(hisEventHelper.getEntityName(), dynamicObjects.length);
        int size = 0;
        for (int i = 0; i < dynamicObjects.length; ++i) {
            List relMapLists = (List)effectRelMap.get(dynamicObjects[i].getLong("id"));
            if (CollectionUtils.isEmpty((Collection)relMapLists)) continue;
            size += relMapLists.size();
        }
        long[] hisEventDyIds = orm.genLongIds(hisEventHelper.getEntityName(), size);
        int num = 0;
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject saveBusiEventDy = HisModelNonEventUtil.getNewBusiEventDy(dynamicObjects[i], busiEventHelper, entityNumber, saveEventDy.getLong("id"), busiEventDyIds[i], operationDate);
            busiEventCol.add((Object)saveBusiEventDy);
            List relMapLists = (List)effectRelMap.get(dynamicObjects[i].getLong("id"));
            if (CollectionUtils.isEmpty((Collection)relMapLists)) continue;
            for (int j = 0; j < relMapLists.size(); ++j) {
                DynamicObject saveHisEventDy = HisModelNonEventUtil.getNewHisEventDy((Map)relMapLists.get(j), hisEventHelper, saveBusiEventDy, hisEventDyIds[num], operationDate);
                hisEventCol.add((Object)saveHisEventDy);
                ++num;
            }
        }
        eventHelper.saveOne(saveEventDy);
        busiEventHelper.save(busiEventCol);
        hisEventHelper.save(hisEventCol);
        returnMap.put("eventId", saveEventDy.getLong("id"));
        return returnMap;
    }

    private static DynamicObject getNewEventDy(HRBaseServiceHelper eventHelper, Long eventId, Map<Object, Object> effectRelMap, Date operationDate) {
        DynamicObject saveEventDy;
        if (Objects.isNull(eventId) || eventId == 0L) {
            eventId = ORM.create().genLongId(eventHelper.getEntityName());
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)eventId);
            saveEventDy = eventHelper.loadDynamicObject(qFilter);
            if (!HRObjectUtils.isEmpty((Object)saveEventDy)) {
                DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveEventDy, operationDate);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(saveEventDy);
                saveEventDy.set("eventbatchtype", Objects.isNull(effectRelMap.get("eventbatchtype")) ? "1" : effectRelMap.get("eventbatchtype"));
                saveEventDy.set("eventtype", Objects.isNull(effectRelMap.get("eventtype")) ? "1" : effectRelMap.get("eventtype"));
                return saveEventDy;
            }
        }
        saveEventDy = eventHelper.generateEmptyDynamicObject();
        saveEventDy.set("id", (Object)eventId);
        saveEventDy.set("eventtype", (Object)"1");
        saveEventDy.set("executeway", Objects.isNull(effectRelMap.get("executeway")) ? "1" : effectRelMap.get("executeway"));
        saveEventDy.set("status", (Object)"1");
        saveEventDy.set("eventbatchtype", Objects.isNull(effectRelMap.get("eventbatchtype")) ? "1" : effectRelMap.get("eventbatchtype"));
        DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveEventDy, operationDate);
        DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveEventDy, operationDate);
        return saveEventDy;
    }

    private static DynamicObject getNewHisEventDy(Map<String, Object> relMap, HRBaseServiceHelper hisEventHelper, DynamicObject saveBusiEventDy, long hisEventDyId, Date operationDate) {
        DynamicObject saveHisEventDy = hisEventHelper.generateEmptyDynamicObject();
        saveHisEventDy.set("id", (Object)hisEventDyId);
        saveHisEventDy.set("prestatus", relMap.get("datastatus"));
        saveHisEventDy.set("vid", relMap.get("id"));
        saveHisEventDy.set("busievent", saveBusiEventDy.get("id"));
        DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveHisEventDy, operationDate);
        return saveHisEventDy;
    }

    private static DynamicObject getNewBusiEventDy(DynamicObject dy, HRBaseServiceHelper busiEventHelper, String entityNumber, Long newEventId, long busiEventDyId, Date operationDate) {
        DynamicObject saveBusiEventDy = busiEventHelper.generateEmptyDynamicObject();
        saveBusiEventDy.set("id", (Object)busiEventDyId);
        saveBusiEventDy.set("sourceentity", (Object)entityNumber);
        saveBusiEventDy.set("boid", dy.get("boid"));
        saveBusiEventDy.set("isbusinesseventbo", (Object)"2");
        saveBusiEventDy.set("event", (Object)newEventId);
        saveBusiEventDy.set("status", (Object)"1");
        DynamicObjectCommonService.getInstance().setSimpleOperateInfoByTime(saveBusiEventDy, operationDate);
        DynamicObjectCommonService.getInstance().setSimpleNewInfoByTime(saveBusiEventDy, operationDate);
        return saveBusiEventDy;
    }

    public static Map<String, Object> getRelToEventMap(DynamicObject dy) {
        HashMap relMap = Maps.newHashMapWithExpectedSize((int)16);
        relMap.put("id", dy.getLong("id"));
        relMap.put("datastatus", dy.getString("datastatus"));
        return relMap;
    }
}

