/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.export.MultiExParam;
import kd.hr.hbp.business.export.MultiLangHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MultiEntityService {
    private static final Log LOG = LogFactory.getLog(MultiEntityService.class);
    public static final String ZH_CN = "zh_CN";
    public static final String ZH_TW = "zh_TW";
    public static final String EN_US = "en_US";

    public static List<ExportWriterFormat> loadExportFormat(String entityNumber, Long templateId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(entityNumber, templateId.longValue(), (String)null, (String)null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        return formats;
    }

    public static Map<String, Object> getMultiEntityNoBindDbProps(List<ExportWriterFormat> formators, Map<String, Header> tplHeaders) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < formators.size(); ++i) {
            ExportWriterFormat formator = formators.get(i);
            String propKeyFront = "";
            if (i > 0) {
                propKeyFront = formator.name + ".";
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formator.name);
            for (Map.Entry item : dataEntityType.getAllFields().entrySet()) {
                IDataEntityProperty prop = (IDataEntityProperty)item.getValue();
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prop.getAlias()) && !(prop instanceof MulBasedataProp)) continue;
                for (String key : tplHeaders.keySet()) {
                    if (!key.startsWith(propKeyFront + (String)item.getKey())) continue;
                    map.put(key, prop);
                }
            }
        }
        return map;
    }

    public static DynamicObjectCollection queryMultiEntityData(MultiExParam multiExParam, List<String> qFilterStr) {
        HashMap multiLangKey = new HashMap(5);
        StringBuilder builder = new StringBuilder("id,");
        multiExParam.getTplHeaders().forEach((key, header) -> {
            if (!multiExParam.getNoBindDbProps().containsKey(key)) {
                if ("multilang".equals(header.getInputType())) {
                    String parentKey = key.substring(0, key.lastIndexOf(46));
                    if (!multiLangKey.containsKey(parentKey)) {
                        builder.append(parentKey).append(',');
                        multiLangKey.put(parentKey, null);
                    }
                } else {
                    builder.append((String)key).append(',');
                }
            }
        });
        if (multiExParam.getCusQueryAttrs() != null) {
            multiExParam.getCusQueryAttrs().forEach(attr -> builder.append((String)attr).append(','));
        }
        String field = MultiEntityService.getSelectFields(multiExParam, builder);
        if (LOG.isInfoEnabled()) {
            LOG.info("MultiEntityService headers : " + field);
        }
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper(multiExParam.getEntitynumber());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty(qFilterStr)) {
            for (String filter : qFilterStr) {
                qFilters.add(QFilter.fromSerializedString((String)filter));
            }
        }
        qFilters.add(new QFilter("id", "in", multiExParam.getSubList()));
        DataSet ds = userHelper.queryMultiEntityDataSet(field, qFilters.toArray(new QFilter[0]), null, false, 0, 0);
        RowMeta rowMeta = ds.getRowMeta();
        Iterator iter = ds.iterator();
        DynamicObjectCollection data = ORMUtil.toDynamicObjectCollection((Iterator)iter, (RowMeta)rowMeta, (String)multiExParam.getEntitynumber());
        return data;
    }

    private static String getSelectFields(MultiExParam multiExParam, StringBuilder builder) {
        String field = builder.length() == 0 ? builder.toString() : builder.substring(0, builder.length() - 1) + "," + multiExParam.getKsqlId();
        String[] fieldArr = field.split(",");
        List fieldList = Arrays.stream(fieldArr).distinct().collect(Collectors.toList());
        field = String.join((CharSequence)",", fieldList);
        return field;
    }

    public static List<Header> getTplHeader(List<ExportWriterFormat> formators) {
        LinkedList<Header> headers = new LinkedList<Header>();
        boolean isMainEntityType = true;
        for (int k = 0; k < formators.size(); ++k) {
            ExportWriterFormat formator = formators.get(k);
            String propKeyFront = "";
            if (k > 0) {
                propKeyFront = formator.name + ".";
            }
            for (String field : formator.fields) {
                MultiEntityService.parseFormatField(headers, formator, propKeyFront, field, isMainEntityType);
            }
            isMainEntityType = false;
        }
        return headers;
    }

    public static Map<String, Header> translateMapHeader(List<Header> headers) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)headers.size());
        headers.forEach(header -> map.put(header.getKey(), header));
        return map;
    }

    public static Map<String, Header> getCustomHeader(List<Header> newHeaders, Map<String, Header> tplHeaders) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)tplHeaders.size());
        for (Header header : newHeaders) {
            if (tplHeaders.containsKey(header.getKey())) continue;
            map.put(header.getKey(), header);
        }
        return map;
    }

    public static DynamicObjectCollection addCustomProp(Map<String, Header> cusHeaders, DynamicObjectCollection data) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return data;
        }
        for (Map.Entry<String, Header> item : cusHeaders.entrySet()) {
            MultiEntityService.addCustomField((DynamicObject)data.get(0), item.getKey(), (DataType)DataType.StringType);
        }
        return data;
    }

    public static DynamicObjectCollection addNoBindDbProps(Map<String, Object> noBindDbProps, DynamicObjectCollection data) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return data;
        }
        for (Map.Entry<String, Object> item : noBindDbProps.entrySet()) {
            MultiEntityService.addCustomField((DynamicObject)data.get(0), item.getKey(), (DataType)DataType.StringType);
        }
        return data;
    }

    public static Class<?> getPluginClass(String plugin) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(plugin);
        }
        catch (ClassNotFoundException e) {
            LOG.error("getPluginClass error:{}", (Object)e.getMessage());
        }
        return aClass;
    }

    public static Set<String> getFieldControlRules(String formId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules rules = permissionService.getFieldControlRules(userId, appId, formId);
        if (rules != null && rules.getFieldControlRuleDtos().size() > 0) {
            FieldControlRuleDto fieldControlRuleDto = (FieldControlRuleDto)rules.getFieldControlRuleDtos().get(0);
            FieldControlRule fieldControlRule = fieldControlRuleDto.getFieldControlRule();
            return fieldControlRule.getCanNotReadFields();
        }
        return null;
    }

    public static List<List<Object>> splitPKIDs(Object[] allPkids, int batchSize) {
        if (batchSize < 0) {
            batchSize = 1;
        }
        LinkedList<List<Object>> list = new LinkedList<List<Object>>();
        LinkedList<Object> subList = new LinkedList<Object>();
        for (int i = 0; i < allPkids.length; ++i) {
            subList.add(allPkids[i]);
            if (subList.size() < batchSize) continue;
            list.add(subList);
            subList = new LinkedList();
        }
        if (subList.size() > 0) {
            list.add(subList);
        }
        return list;
    }

    private static void addCustomField(DynamicObject row, String key, DataType dataType) {
        Field usedefdimension = new Field(key, dataType);
        DynamicSimpleProperty usedefdimensionProperty = new DynamicSimpleProperty(key, usedefdimension.getDataType().getJavaType(), null);
        row.getDynamicObjectType().addProperty((DynamicProperty)usedefdimensionProperty);
    }

    private static Map<String, String> getEmumValueMap(JSONArray inputType) {
        HashMap<String, String> keyVaue = new HashMap<String, String>(3);
        JSONArray arrayInputType = inputType;
        for (int i = 0; i < arrayInputType.size(); ++i) {
            String temp = (String)arrayInputType.get(i);
            String[] split = temp.split("#");
            if (split.length == 2) {
                keyVaue.put(org.apache.commons.lang3.StringUtils.trim((String)split[1]), org.apache.commons.lang3.StringUtils.trim((String)split[0]));
                continue;
            }
            keyVaue.put(i == 0 ? "1" : "0", org.apache.commons.lang3.StringUtils.trim((String)split[0]));
        }
        return keyVaue;
    }

    private static Header getHeader(String key, String displayName, String inputType, Boolean mustInput, Map<String, String> keyVaue) {
        Header header = new Header(key, displayName);
        header.setInputType(inputType);
        header.setMustInput(mustInput);
        header.setKeyValues(keyVaue);
        return header;
    }

    private static void parseFormatField(List<Header> headers, ExportWriterFormat formator, String propKeyFront, String field, boolean isMainEntityType) {
        String strInputType;
        Map item = (Map)formator.properties.get(field);
        String displayName = (String)item.get("DisplayName");
        Object importProp = item.get("ImportProp");
        Object importPropName = item.get("ImportPropName");
        Object inputType = item.get("InputType");
        Map<String, String> keyVaue = null;
        if (inputType instanceof JSONArray) {
            strInputType = "JSONArray";
            keyVaue = MultiEntityService.getEmumValueMap((JSONArray)inputType);
        } else {
            strInputType = (String)inputType;
        }
        Boolean mustInput = (Boolean)item.get("MustInput");
        if (importProp != null) {
            int i;
            JSONArray arrayImportProp = (JSONArray)importProp;
            String[] keys = new String[arrayImportProp.size()];
            for (int i2 = 0; i2 < arrayImportProp.size(); ++i2) {
                String subkey = (String)arrayImportProp.get(i2);
                keys[i2] = propKeyFront + field + "." + subkey;
            }
            JSONArray arrayImportPropName = (JSONArray)importPropName;
            String[] displayNames = new String[arrayImportProp.size()];
            for (i = 0; i < arrayImportPropName.size(); ++i) {
                String subName = (String)arrayImportPropName.get(i);
                displayNames[i] = displayName + "." + subName;
            }
            for (i = 0; i < keys.length; ++i) {
                MultiLangHelper.initLangField(headers, formator, keys[i], displayNames[i], strInputType, mustInput, keyVaue, isMainEntityType, field);
            }
        } else {
            MultiLangHelper.initLangField(headers, formator, propKeyFront + field, displayName, strInputType, mustInput, keyVaue, isMainEntityType, field);
        }
    }
}

