/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.poi.ss.usermodel.Cell;

public class MultiLangHelper {
    public static Multimap getMultiLangField(List<Header> headers, String mainEntity) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)mainEntity);
        MainEntityType mainEntityType = queryEntityType.getMainEntityType();
        List joinEntities = queryEntityType.getJoinEntitys();
        HashMultimap result = HashMultimap.create();
        headers.forEach(arg_0 -> MultiLangHelper.lambda$getMultiLangField$0(joinEntities, mainEntityType, (Multimap)result, arg_0));
        return result;
    }

    private static String getEntityIdByField(List<JoinEntity> joinEntitys, MainEntityType mainEntityType, String field) {
        String column;
        Map allFields = mainEntityType.getAllFields();
        if (allFields.containsKey(column = field.substring(0, field.lastIndexOf(46)))) {
            return mainEntityType.getName();
        }
        Optional<JoinEntity> any = joinEntitys.stream().filter(el -> {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)el.getEntityName());
            Map allSubFields = dataEntityType.getAllFields();
            List collect = allSubFields.keySet().stream().map(key -> el.getEntityName() + "." + key).collect(Collectors.toList());
            return collect.contains(column);
        }).findAny();
        return any.map(JoinEntity::getEntityName).orElse(null);
    }

    public static Table<String, Long, DynamicObject> fillLang(Multimap<String, String> multiLangField, DynamicObjectCollection data, List<Header> headers) {
        HashBasedTable pkIds = HashBasedTable.create();
        for (DynamicObject dynamicObject : data) {
            multiLangField.forEach((arg_0, arg_1) -> MultiLangHelper.lambda$fillLang$3(dynamicObject, (Table)pkIds, arg_0, arg_1));
        }
        HashBasedTable langTable = HashBasedTable.create();
        Set cells = pkIds.cellSet();
        for (Table.Cell next : cells) {
            DynamicObject[] query;
            String rowKey = (String)next.getRowKey();
            List value = (List)next.getValue();
            if (langTable.containsRow((Object)rowKey)) continue;
            String queryField = MultiLangHelper.parseFields(multiLangField, rowKey);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(rowKey);
            QFilter pkFiler = new QFilter("id", "in", (Object)value.toArray());
            for (DynamicObject obj : query = serviceHelper.query(queryField, new QFilter[]{pkFiler}, null)) {
                langTable.put((Object)rowKey, (Object)obj.getLong("id"), (Object)obj);
            }
        }
        Set<String> subEntities = headers.stream().filter(el -> !el.isMainEntity()).map(Header::getName).collect(Collectors.toSet());
        MultiLangHelper.checkSubEntityNumber(headers, subEntities);
        if (subEntities.size() == 0) {
            return langTable;
        }
        MultiLangHelper.initMainData(data, (Table<String, Long, DynamicObject>)langTable, subEntities);
        return langTable;
    }

    private static String parseFields(Multimap<String, String> multiLangField, String rowKey) {
        ArrayList entities = new ArrayList(multiLangField.get((Object)rowKey));
        List collect = entities.stream().map(el -> {
            if (el.contains(rowKey)) {
                return el.split(rowKey + ".")[1];
            }
            return el;
        }).collect(Collectors.toList());
        return String.join((CharSequence)",", collect);
    }

    private static void initMainData(DynamicObjectCollection data, Table<String, Long, DynamicObject> langTable, Set<String> subEntities) {
        if (CollectionUtils.isEmpty(subEntities)) {
            return;
        }
        data.forEach(el -> subEntities.forEach(entity -> {
            DynamicObject obj = (DynamicObject)langTable.get(entity, (Object)el.getLong(entity + "." + "id"));
            if (Objects.nonNull(obj)) {
                el.set(entity + "." + "number", obj.get("number"));
            }
        }));
    }

    private static void checkSubEntityNumber(List<Header> headers, Set<String> subEntities) {
        Iterator<String> iterator = subEntities.iterator();
        if (iterator.hasNext()) {
            do {
                String entityId = iterator.next();
                boolean result = headers.stream().anyMatch(el -> el.getKey().contains(entityId + "." + "number"));
                if (result) continue;
                iterator.remove();
            } while (iterator.hasNext());
        }
    }

    public static String getJoinEntityKsqlId(String mainEntity) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)mainEntity);
        List joinEntities = queryEntityType.getJoinEntitys();
        return joinEntities.stream().map(el -> el.getEntityName() + "." + "id").collect(Collectors.joining(",")) + "," + queryEntityType.getEntityName() + "." + "id";
    }

    public static void initLangField(List<Header> headers, ExportWriterFormat exportWriterFormat, String key, String displayName, String strInputType, boolean mustInput, Map<String, String> keyVaue, boolean isMainEntity, String field) {
        List flexColumn = (List)exportWriterFormat.flexColumn.get(field);
        if (CollectionUtils.isEmpty((Collection)flexColumn)) {
            Header header = new Header(key, displayName, strInputType, exportWriterFormat.name, isMainEntity);
            header.setMustInput(mustInput);
            header.setKeyValues(keyVaue);
            headers.add(header);
        } else {
            Header header = null;
            int size = flexColumn.size();
            for (int index = 0; index < size; ++index) {
                header = isMainEntity ? new Header((String)flexColumn.get(index), (String)((List)exportWriterFormat.flexColumnDisplay.get(field)).get(index), strInputType, exportWriterFormat.name, true) : new Header(exportWriterFormat.name + "." + (String)flexColumn.get(index), (String)((List)exportWriterFormat.flexColumnDisplay.get(field)).get(index), strInputType, exportWriterFormat.name, false);
                header.setMustInput(mustInput);
                header.setKeyValues(keyVaue);
                headers.add(header);
            }
        }
    }

    public static String getLangTag(String headerKey) {
        return headerKey.substring(headerKey.lastIndexOf(46) + 1);
    }

    public static String getLangKeyProp(String headerKey) {
        String headerKeyProp = headerKey.substring(0, headerKey.lastIndexOf(46));
        if (HRStringUtils.isEmpty((String)headerKeyProp) || !headerKeyProp.contains(".")) {
            return headerKeyProp;
        }
        headerKeyProp = headerKeyProp.substring(headerKeyProp.lastIndexOf(46) + 1);
        return headerKeyProp;
    }

    public static boolean isViewRight(Header header, Set<String> canNotReadFields, Cell cell) {
        boolean viewRight = true;
        if (!CollectionUtils.isEmpty(canNotReadFields)) {
            for (String item : canNotReadFields) {
                if (!header.getKey().equals(item) && !header.getKey().startsWith(item + ".")) continue;
                cell.setCellValue("******");
                viewRight = false;
                break;
            }
        }
        return viewRight;
    }

    private static /* synthetic */ void lambda$fillLang$3(DynamicObject dynamicObject, Table pkIds, String key, String val) {
        Object pk = dynamicObject.get(key + "." + "id");
        if (pkIds.contains((Object)key, (Object)val)) {
            ((List)pkIds.get((Object)key, (Object)val)).add(pk);
        } else {
            ArrayList pkList = Lists.newArrayList((Object[])new Object[]{16});
            pkList.add(pk);
            pkIds.put((Object)key, (Object)val, (Object)pkList);
        }
    }

    private static /* synthetic */ void lambda$getMultiLangField$0(List joinEntities, MainEntityType mainEntityType, Multimap result, Header el) {
        String key;
        if (el.getInputType().equals("multilang") && HRStringUtils.isNotEmpty((String)(key = MultiLangHelper.getEntityIdByField(joinEntities, mainEntityType, el.getKey())))) {
            result.put((Object)key, (Object)el.getKey().substring(0, el.getKey().lastIndexOf(46)));
        }
    }
}

