/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.flow.helper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.flow.JobNode;
import kd.hr.hbp.business.flow.chart.FlowChartVo;
import kd.hr.hbp.business.flow.chart.NodeInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.flow.FlowChartStatusEnum;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.common.constants.flow.FlowJobTypeEnum;
import kd.hr.hbp.common.constants.flow.FlowStatusEnum;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class FlowJobHelper {
    private static final Log LOGGER = LogFactory.getLog(FlowJobHelper.class);
    private static final IHRAppCache CACHE = HRAppCache.get((String)"hr-flow");
    private static final String CACHE_FLOW_TREE = "cache-flow-tree";
    private static final String CACHE_FLOW_ID_TO_NODE = "cache-flow-id-to-node";
    private static final String CACHE_FLOW_NEXT = "cache-flow-next";
    private static final String CACHE_FLOW_PRE = "cache-flow-pre";
    private static final String CACHE_STRING_SPLIT = ":";
    private static final Map<String, Map<String, List<Object>>> FLOW_ENTRY_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, JobNode> FLOW_JOB_NODE_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, Map<String, JobNode>> NODE_ID_TO_JOB_NODE_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, String> TRANSFER_KEY_MAP = ImmutableMap.builder().put((Object)"defaultvalue", (Object)"runvalue").build();

    public static JobNode getFlowNodeTree(Long flowInstanceId) {
        String key = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_TREE, String.valueOf(flowInstanceId));
        JobNode jobNode = FLOW_JOB_NODE_MAP.get(key);
        if (null == jobNode) {
            jobNode = (JobNode)CACHE.get(key, JobNode.class);
        }
        if (null != jobNode) {
            FLOW_JOB_NODE_MAP.put(key, jobNode);
        }
        return jobNode;
    }

    public static List<Object> getEntryNextList(Long rootNodeId, Long jobNodeId) {
        return FlowJobHelper.getEntryNextList(rootNodeId, jobNodeId, true);
    }

    public static List<Object> getEntryNextList(Long rootNodeId, Long jobNodeId, boolean isAutoClearCache) {
        String key = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_NEXT, String.valueOf(rootNodeId));
        Map flowEntryNextMap = FLOW_ENTRY_MAP.get(key);
        if (MapUtils.isEmpty(flowEntryNextMap)) {
            flowEntryNextMap = (Map)CACHE.get(key, Map.class);
        }
        if (MapUtils.isNotEmpty(flowEntryNextMap)) {
            FLOW_ENTRY_MAP.put(key, flowEntryNextMap);
        }
        if (isAutoClearCache) {
            FlowJobHelper.clearEndFlow(rootNodeId, jobNodeId);
        }
        return (List)flowEntryNextMap.get(String.valueOf(jobNodeId));
    }

    public static List<Object> getEntryPreList(Long flowInstanceId, Long jobInstanceId) {
        String key = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_PRE, String.valueOf(flowInstanceId));
        Map flowEntryPreMap = FLOW_ENTRY_MAP.get(key);
        if (MapUtils.isEmpty(flowEntryPreMap)) {
            flowEntryPreMap = (Map)CACHE.get(key, Map.class);
        }
        if (MapUtils.isNotEmpty(flowEntryPreMap)) {
            FLOW_ENTRY_MAP.put(key, flowEntryPreMap);
        }
        FlowJobHelper.clearEndFlow(flowInstanceId, jobInstanceId);
        return (List)flowEntryPreMap.get(String.valueOf(jobInstanceId));
    }

    public static void clearEndFlow(Long flowInstanceId, Long jobInstanceId) {
        if (-1L == jobInstanceId) {
            FlowJobHelper.clearFlow(flowInstanceId);
        }
    }

    public static boolean clearFlow(Long flowInstanceId) {
        String preKey = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_PRE, String.valueOf(flowInstanceId));
        CACHE.remove(preKey);
        FLOW_ENTRY_MAP.remove(preKey);
        String nextKey = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_NEXT, String.valueOf(flowInstanceId));
        CACHE.remove(nextKey);
        FLOW_ENTRY_MAP.remove(nextKey);
        String flowTreeKey = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_TREE, String.valueOf(flowInstanceId));
        CACHE.remove(flowTreeKey);
        FLOW_JOB_NODE_MAP.remove(flowTreeKey);
        String nodeIdToJobNodeKey = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_ID_TO_NODE, String.valueOf(flowInstanceId));
        CACHE.remove(nodeIdToJobNodeKey);
        NODE_ID_TO_JOB_NODE_MAP.remove(nodeIdToJobNodeKey);
        return Boolean.TRUE;
    }

    public static JobNode buildTreeModel(DynamicObject dy) {
        return FlowJobHelper.buildTreeModel(dy, true);
    }

    public static JobNode buildTreeModel(DynamicObject dy, boolean isInstance) {
        JobNode rootNode = new JobNode();
        rootNode.setId(Long.parseLong(String.valueOf(dy.getPkValue())));
        rootNode.setNodeType(FlowJobTypeEnum.TYPE_FLOW.getType());
        BasedataEntityType basedataEntityType = (BasedataEntityType)dy.getDynamicObjectType();
        String nameProperty = basedataEntityType.getNameProperty();
        rootNode.setName(dy.getString(nameProperty));
        FlowJobHelper.findAllChildren(rootNode, dy, isInstance);
        Map<String, JobNode> nodeIdToNodeMap = FlowJobHelper.getNodeIdToNodeMap(rootNode);
        CACHE.put(String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_TREE, String.valueOf(dy.getPkValue())), (Object)rootNode);
        CACHE.put(String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_ID_TO_NODE, String.valueOf(dy.getPkValue())), nodeIdToNodeMap);
        LOGGER.info("********** buildTreeModel,key:{},value:{}", dy.getPkValue(), (Object)SerializationUtils.toJsonString((Object)rootNode));
        FlowJobHelper.buildFlowEntryNextMap(rootNode);
        FlowJobHelper.buildFlowEntryPreMap(rootNode);
        return rootNode;
    }

    private static void buildFlowEntryNextMap(JobNode rootNode) {
        HashMap entryNextMap = Maps.newHashMapWithExpectedSize((int)16);
        FlowJobHelper.buildEntryNextMap(rootNode, entryNextMap, null, Boolean.TRUE, Boolean.FALSE);
        CACHE.put(String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_NEXT, String.valueOf(rootNode.getId())), (Object)entryNextMap);
        LOGGER.info("********** buildFlowEntryNextMap,key:{},value:{}", (Object)rootNode.getId(), (Object)SerializationUtils.toJsonString((Object)entryNextMap));
    }

    private static void buildFlowEntryPreMap(JobNode rootNode) {
        HashMap entryPreMap = Maps.newHashMapWithExpectedSize((int)16);
        FlowJobHelper.buildEntryPreMap(rootNode, entryPreMap, null, Boolean.TRUE, Boolean.TRUE);
        CACHE.put(String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_PRE, String.valueOf(rootNode.getId())), (Object)entryPreMap);
        LOGGER.info("********** buildFlowEntryPreMap,key:{},value:{}", (Object)rootNode.getId(), (Object)SerializationUtils.toJsonString((Object)entryPreMap));
    }

    public static JobNode findAllChildren(JobNode rootNode, DynamicObject dy, boolean isInstance) {
        rootNode.setEntityName(dy.getDataEntityType().getName());
        DynamicObjectCollection entirety = dy.getDynamicObjectCollection("hrflowentry");
        DynamicObjectType dynamicObjectType = entirety.getDynamicObjectType();
        for (DynamicObject dynamicObject : entirety) {
            BasedataProp property;
            String jobType = dynamicObject.getString("type");
            if (rootNode.getChildren() == null) {
                rootNode.setChildren(new ArrayList<JobNode>());
            }
            JobNode node = new JobNode();
            node.setNodeType(jobType);
            long boId = dynamicObject.getLong("entryboid");
            node.setRelId(boId);
            if (FlowJobTypeEnum.TYPE_START.getType().equalsIgnoreCase(jobType)) {
                node.setId(0L);
                node.setName(FlowJobTypeEnum.TYPE_START.getName().loadKDString());
            } else if (FlowJobTypeEnum.TYPE_END.getType().equalsIgnoreCase(jobType)) {
                node.setId(-1L);
                node.setName(FlowJobTypeEnum.TYPE_END.getName().loadKDString());
            } else if (FlowJobTypeEnum.TYPE_JOB.getType().equalsIgnoreCase(jobType)) {
                Object job;
                if (isInstance) {
                    job = dynamicObject.get("jobins");
                    property = (BasedataProp)dynamicObjectType.getProperty("jobins");
                } else {
                    job = dynamicObject.get("job");
                    property = (BasedataProp)dynamicObjectType.getProperty("job");
                }
                if (job instanceof DynamicObject) {
                    node.setName(((DynamicObject)job).getString(property.getDisplayProp()));
                    node.setId(Long.parseLong(String.valueOf(((DynamicObject)job).getPkValue())));
                } else {
                    DynamicObject jobDy = new HRBaseServiceHelper(property.getBaseEntityId()).queryOne(job);
                    node.setName(jobDy.getString(property.getDisplayProp()));
                    node.setId(Long.parseLong(String.valueOf(job)));
                }
                node.setEntityName(property.getBaseEntityId());
                if (!isInstance) {
                    node.setId(boId);
                }
            } else if (FlowJobTypeEnum.TYPE_FLOW.getType().equalsIgnoreCase(jobType)) {
                Object jobFlow;
                if (isInstance) {
                    jobFlow = dynamicObject.get("jobflowins");
                    property = (BasedataProp)dynamicObjectType.getProperty("jobflowins");
                } else {
                    jobFlow = dynamicObject.get("jobflow");
                    property = (BasedataProp)dynamicObjectType.getProperty("jobflow");
                }
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(property.getBaseEntityId());
                if (jobFlow instanceof DynamicObject) {
                    node.setId(Long.parseLong(String.valueOf(((DynamicObject)jobFlow).getPkValue())));
                } else {
                    node.setId(Long.parseLong(String.valueOf(jobFlow)));
                }
                DynamicObject suDy = serviceHelper.queryOne(node.getId());
                node.setName(suDy.getString(property.getDisplayProp()));
                node.setEntityName(property.getBaseEntityId());
                if (!isInstance) {
                    node.setId(boId);
                }
                FlowJobHelper.findAllChildren(node, suDy, isInstance);
            }
            String preIds = dynamicObject.getString("frontnodeentryids");
            if (HRStringUtils.isNotEmpty((String)preIds)) {
                String[] preIdArray = preIds.split(";");
                node.setPid(Arrays.stream(preIdArray).filter(HRStringUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList()));
            }
            rootNode.getChildren().add(node);
        }
        return rootNode;
    }

    private static void buildEntryNextMap(JobNode jobNode, Map<String, List<Object>> entryNextMap, List<Object> preJobs, boolean isRoot, boolean isPre) {
        List<JobNode> childrenList = jobNode.getChildren();
        for (JobNode children : childrenList) {
            String jobType = children.getNodeType();
            Long entryBoId = children.getRelId();
            if (!isRoot && FlowJobTypeEnum.TYPE_END.getType().equalsIgnoreCase(jobType) || !isRoot && FlowJobTypeEnum.TYPE_START.getType().equalsIgnoreCase(jobType) && isPre) continue;
            ArrayList nextFlowJobs = Lists.newArrayListWithCapacity((int)10);
            block1: for (JobNode children2 : childrenList) {
                List<Long> pidList = children2.getPid();
                if (CollectionUtils.isEmpty(pidList)) continue;
                for (Long pid : pidList) {
                    if (!Objects.nonNull(pid) || !pid.equals(entryBoId)) continue;
                    String children2NodeType = children2.getNodeType();
                    Long children2Id = children2.getId();
                    if (FlowJobTypeEnum.TYPE_JOB.getType().equalsIgnoreCase(children2NodeType)) {
                        nextFlowJobs.add(children2Id);
                        continue block1;
                    }
                    if (FlowJobTypeEnum.TYPE_FLOW.getType().equalsIgnoreCase(children2NodeType)) {
                        FlowJobHelper.buildEntryNextMap(children2, entryNextMap, nextFlowJobs, Boolean.FALSE, Boolean.FALSE);
                        continue block1;
                    }
                    if (!FlowJobTypeEnum.TYPE_END.getType().equalsIgnoreCase(children2NodeType)) continue block1;
                    if (isRoot) {
                        nextFlowJobs.add(children2Id);
                        continue block1;
                    }
                    nextFlowJobs.addAll(preJobs);
                    continue block1;
                }
            }
            if (!isRoot && FlowJobTypeEnum.TYPE_START.getType().equalsIgnoreCase(jobType) && !isPre) {
                preJobs.addAll(nextFlowJobs);
                break;
            }
            if (FlowJobTypeEnum.TYPE_FLOW.getType().equalsIgnoreCase(jobType)) {
                FlowJobHelper.buildEntryNextMap(children, entryNextMap, nextFlowJobs, Boolean.FALSE, Boolean.TRUE);
                continue;
            }
            entryNextMap.put(String.valueOf(children.getId()), nextFlowJobs);
        }
    }

    private static void buildEntryPreMap(JobNode jobNode, Map<Long, List<Long>> entryPreMap, List<Long> preJobs, boolean isRoot, boolean isPre) {
        List<JobNode> childrenList = jobNode.getChildren();
        for (JobNode children : childrenList) {
            List<Long> pidList;
            String jobType = children.getNodeType();
            long jobId = children.getId();
            ArrayList preFlowJobs = Lists.newArrayListWithCapacity((int)10);
            if (isRoot && FlowJobTypeEnum.TYPE_START.getType().equalsIgnoreCase(jobType)) {
                entryPreMap.put(jobId, preFlowJobs);
            }
            if (CollectionUtils.isEmpty(pidList = children.getPid())) continue;
            block1: for (Long pid : pidList) {
                for (JobNode children2 : childrenList) {
                    String children2NodeType = children2.getNodeType();
                    long children2Id = children2.getId();
                    if (!Objects.nonNull(pid) || !pid.equals(children2.getRelId())) continue;
                    if (FlowJobTypeEnum.TYPE_JOB.getType().equalsIgnoreCase(children2NodeType)) {
                        preFlowJobs.add(children2Id);
                        continue block1;
                    }
                    if (FlowJobTypeEnum.TYPE_FLOW.getType().equalsIgnoreCase(children2NodeType)) {
                        FlowJobHelper.buildEntryPreMap(children2, entryPreMap, preFlowJobs, Boolean.FALSE, Boolean.FALSE);
                        continue block1;
                    }
                    if (!FlowJobTypeEnum.TYPE_START.getType().equalsIgnoreCase(children2NodeType)) continue block1;
                    if (isRoot) {
                        preFlowJobs.add(children2Id);
                        continue block1;
                    }
                    preFlowJobs.addAll(preJobs);
                    continue block1;
                }
            }
            if (!isRoot && FlowJobTypeEnum.TYPE_END.getType().equalsIgnoreCase(jobType) && !isPre) {
                preJobs.addAll(preFlowJobs);
                break;
            }
            if (FlowJobTypeEnum.TYPE_FLOW.getType().equalsIgnoreCase(jobType)) {
                FlowJobHelper.buildEntryPreMap(children, entryPreMap, preFlowJobs, Boolean.FALSE, Boolean.TRUE);
                continue;
            }
            entryPreMap.put(jobId, preFlowJobs);
        }
    }

    public static FlowChartVo getFlowChartVo(DynamicObject dy, boolean isInstance) {
        FlowChartVo flowChartVo = new FlowChartVo();
        long parentFlowId = dy.getLong("id");
        DynamicObjectCollection flowEntryDys = dy.getDynamicObjectCollection("hrflowentry");
        Map<String, List<String>> nodeIdToNextIdMap = flowChartVo.getNodeIdToNextIdMap();
        Map<String, NodeInfo> nodeInfoMap = flowChartVo.getNodeInfoMap();
        HashMap nodeStatus = Maps.newHashMapWithExpectedSize((int)flowEntryDys.size());
        if (isInstance) {
            FlowJobHelper.getInsStatus(parentFlowId, dy, flowEntryDys, nodeStatus);
        }
        for (DynamicObject entry : flowEntryDys) {
            NodeInfo nodeInfo = new NodeInfo();
            String entryBoId = entry.getString("entryboid");
            String type = entry.getString("type");
            nodeInfo.setName(FlowJobHelper.getFlowEntryEntityName(entry, isInstance));
            nodeInfo.setType(FlowJobTypeEnum.getEnumByType((String)type).getChartType());
            nodeInfoMap.put(entryBoId, nodeInfo);
            String frontNodeIdStr = entry.getString("frontnodeentryids");
            if (HRStringUtils.isNotEmpty((String)frontNodeIdStr)) {
                for (String frontNodeBoId : frontNodeIdStr.split(";")) {
                    nodeIdToNextIdMap.putIfAbsent(frontNodeBoId, new ArrayList(10));
                    nodeIdToNextIdMap.computeIfPresent(frontNodeBoId, (oldKey, list) -> {
                        list.add(entryBoId);
                        return list;
                    });
                }
            }
            if ("end".equals(type)) {
                nodeIdToNextIdMap.putIfAbsent(entryBoId, new ArrayList(0));
                flowChartVo.setEndNodeId(entryBoId);
            } else if ("start".equals(type)) {
                flowChartVo.setStartNodeId(entryBoId);
            }
            if (!isInstance) {
                nodeInfo.setStatus(FlowChartStatusEnum.USE);
                continue;
            }
            long entityId = "jobflow".equals(type) ? entry.getDynamicObject("jobflowins").getLong("id") : ("job".equals(type) ? entry.getDynamicObject("jobins").getLong("id") : parentFlowId);
            String status = (String)nodeStatus.get(entityId);
            nodeInfo.setStatus(FlowJobHelper.getFlowChartStatus(type, status));
        }
        return flowChartVo;
    }

    private static FlowChartStatusEnum getFlowChartStatus(String type, String status) {
        if ("jobflow".equals(type)) {
            return FlowStatusEnum.getEnumByType((String)status).getChartStatus();
        }
        if ("job".equals(type)) {
            return FlowJobStatusEnum.getEnumByType((String)status).getChartStatus();
        }
        if ("start".equals(type)) {
            FlowStatusEnum flowStatus = FlowStatusEnum.getEnumByType((String)status);
            if (FlowStatusEnum.STATUS_DEFAULT == flowStatus) {
                return FlowChartStatusEnum.USE;
            }
            return FlowChartStatusEnum.TRAVERSED;
        }
        if ("end".equals(type)) {
            FlowStatusEnum flowStatus = FlowStatusEnum.getEnumByType((String)status);
            if (FlowStatusEnum.STATUS_RUN_SUCCESS == flowStatus) {
                return FlowChartStatusEnum.TRAVERSED;
            }
            return FlowChartStatusEnum.USE;
        }
        return FlowChartStatusEnum.USE;
    }

    private static void getInsStatus(long parentFlowInsId, DynamicObject parentDy, DynamicObjectCollection flowEntryDys, Map<Long, String> nodeStatus) {
        BasedataProp jobInsProperty = (BasedataProp)flowEntryDys.getDynamicObjectType().getProperty("jobins");
        BasedataProp flowInsProperty = (BasedataProp)flowEntryDys.getDynamicObjectType().getProperty("jobflowins");
        HRBaseServiceHelper parentHelper = new HRBaseServiceHelper(parentDy.getDataEntityType().getName());
        HRBaseServiceHelper jobInsHelper = new HRBaseServiceHelper(jobInsProperty.getBaseEntityId());
        HRBaseServiceHelper flowInsHelper = new HRBaseServiceHelper(flowInsProperty.getBaseEntityId());
        ArrayList jobInsIds = Lists.newArrayListWithExpectedSize((int)flowEntryDys.size());
        ArrayList flowInsIds = Lists.newArrayListWithExpectedSize((int)flowEntryDys.size());
        for (DynamicObject entry : flowEntryDys) {
            DynamicObject jobIns = entry.getDynamicObject((IDataEntityProperty)jobInsProperty);
            DynamicObject flowIns = entry.getDynamicObject((IDataEntityProperty)flowInsProperty);
            if (Objects.nonNull(jobIns)) {
                jobInsIds.add(jobIns.getLong("id"));
                continue;
            }
            if (!Objects.nonNull(flowIns)) continue;
            flowInsIds.add(flowIns.getLong("id"));
        }
        if (!jobInsIds.isEmpty()) {
            QFilter jobInsIdFilter = new QFilter("id", "in", (Object)jobInsIds);
            nodeStatus.putAll(Arrays.stream(jobInsHelper.queryOriginalArray("id,jobstatus", new QFilter[]{jobInsIdFilter})).collect(Collectors.toMap(query -> query.getLong("id"), query -> query.getString("jobstatus"))));
        }
        if (!flowInsIds.isEmpty()) {
            QFilter flowInsIdFilter = new QFilter("id", "in", (Object)flowInsIds);
            nodeStatus.putAll(Arrays.stream(flowInsHelper.queryOriginalArray("id,flowstatus", new QFilter[]{flowInsIdFilter})).collect(Collectors.toMap(query -> query.getLong("id"), query -> query.getString("flowstatus"))));
        }
        DynamicObject dbParent = parentHelper.loadSingle(parentDy.getPkValue());
        nodeStatus.put(parentFlowInsId, dbParent.getString("flowstatus"));
    }

    public static void updateFlowJobStatus(DynamicObject jobInsDy) {
        Date time;
        FlowStatusEnum flowStatus;
        if (Objects.isNull(jobInsDy)) {
            return;
        }
        long currentFlowInsId = jobInsDy.getLong("curjobflowinsid");
        long rootFlowInsId = jobInsDy.getLong("rootjobflowinsid");
        if (currentFlowInsId == 0L || rootFlowInsId == 0L) {
            return;
        }
        IDataEntityType entityType = jobInsDy.getDataEntityType();
        HRBaseServiceHelper jobInsHelper = new HRBaseServiceHelper(entityType.getName());
        jobInsHelper.saveOne(jobInsDy);
        Map<String, JobNode> nodeIdToNodeMap = FlowJobHelper.getNodeIdToNodeMapFromCache(rootFlowInsId);
        if (Objects.isNull(nodeIdToNodeMap)) {
            return;
        }
        String jobStatus = jobInsDy.getString("jobstatus");
        if (FlowJobStatusEnum.STATUS_RUN_SUCCESS.getStatus().equals(jobStatus)) {
            flowStatus = FlowStatusEnum.STATUS_RUN_SUCCESS;
            time = jobInsDy.getDate("endtime");
        } else if (FlowJobStatusEnum.STATUS_RUNNING.getStatus().equals(jobStatus)) {
            flowStatus = FlowStatusEnum.STATUS_RUNNING;
            time = jobInsDy.getDate("starttime");
        } else if (FlowJobStatusEnum.STATUS_RUN_FAIL.getStatus().equals(jobStatus)) {
            flowStatus = FlowStatusEnum.STATUS_RUN_FAIL;
            time = jobInsDy.getDate("endtime");
        } else {
            flowStatus = FlowStatusEnum.STATUS_RUN_SUCCESS;
            time = jobInsDy.getDate("endtime");
        }
        FlowJobHelper.updateFlowStatus(nodeIdToNodeMap, currentFlowInsId, flowStatus, time);
    }

    private static void updateFlowStatus(Map<String, JobNode> nodeIdToNodeMap, long currentFlowInsId, FlowStatusEnum flowStatus, Date time) {
        if (currentFlowInsId == 0L) {
            return;
        }
        JobNode jobNode = nodeIdToNodeMap.get(String.valueOf(currentFlowInsId));
        if (Objects.isNull(jobNode) || HRStringUtils.isEmpty((String)jobNode.getEntityName())) {
            return;
        }
        MainEntityType mainFlowEntityType = EntityMetadataCache.getDataEntityType((String)jobNode.getEntityName());
        EntityType detailEntryEntityType = (EntityType)mainFlowEntityType.getAllEntities().get("hrflowentry");
        BasedataProp flowEntryInsProp = (BasedataProp)detailEntryEntityType.getProperty("jobflowins");
        BasedataProp jobEntryInsProp = (BasedataProp)detailEntryEntityType.getProperty("jobins");
        HRBaseServiceHelper mainFlowInsHelper = new HRBaseServiceHelper(mainFlowEntityType.getName());
        HRBaseServiceHelper subFlowInsHelper = null;
        if (!"hbp_hrflowins_tpl".equals(flowEntryInsProp.getBaseEntityId())) {
            subFlowInsHelper = new HRBaseServiceHelper(flowEntryInsProp.getBaseEntityId());
        }
        HRBaseServiceHelper subJobInsHelper = null;
        if (!"hbp_hrjobins_tpl".equals(jobEntryInsProp.getBaseEntityId())) {
            subJobInsHelper = new HRBaseServiceHelper(jobEntryInsProp.getBaseEntityId());
        }
        try (DLock lock = DLock.create((String)("hrmp_hbp_flow_lock_key_" + currentFlowInsId));){
            lock.lock();
            if (FlowStatusEnum.STATUS_RUN_SUCCESS == flowStatus) {
                QFilter jobUnFinishFilter = new QFilter("jobstatus", "!=", (Object)FlowJobStatusEnum.STATUS_RUN_SUCCESS.getStatus());
                QFilter flowFilter = new QFilter("curjobflowinsid", "=", (Object)currentFlowInsId);
                QFilter flowUnFinishFilter = new QFilter("flowstatus", "!=", (Object)FlowStatusEnum.STATUS_RUN_SUCCESS.getStatus());
                boolean jobFinish = true;
                boolean flowFinish = true;
                if (subJobInsHelper != null) {
                    boolean bl = jobFinish = !subJobInsHelper.isExists(new QFilter[]{flowFilter, jobUnFinishFilter});
                }
                if (subFlowInsHelper != null) {
                    boolean bl = flowFinish = !subFlowInsHelper.isExists(new QFilter[]{flowFilter, flowUnFinishFilter});
                }
                if (jobFinish && flowFinish) {
                    DynamicObject flowIns = mainFlowInsHelper.loadSingle(currentFlowInsId);
                    flowIns.set("flowstatus", (Object)FlowStatusEnum.STATUS_RUN_SUCCESS.getStatus());
                    flowIns.set("endtime", (Object)time);
                    mainFlowInsHelper.updateOne(flowIns);
                    long parentFlowInsId = flowIns.getLong("curjobflowinsid");
                    FlowJobHelper.updateFlowStatus(nodeIdToNodeMap, parentFlowInsId, flowStatus, time);
                }
            } else if (FlowStatusEnum.STATUS_RUNNING == flowStatus) {
                QFilter flowWaitingRunFilter = new QFilter("flowstatus", "=", (Object)FlowStatusEnum.STATUS_DEFAULT.getStatus());
                QFilter idFilter = new QFilter("id", "=", (Object)currentFlowInsId);
                if (mainFlowInsHelper.isExists(new QFilter[]{idFilter, flowWaitingRunFilter})) {
                    DynamicObject flowIns = mainFlowInsHelper.loadSingle(currentFlowInsId);
                    flowIns.set("flowstatus", (Object)FlowStatusEnum.STATUS_RUNNING.getStatus());
                    flowIns.set("starttime", (Object)time);
                    mainFlowInsHelper.updateOne(flowIns);
                    long parentFlowInsId = flowIns.getLong("curjobflowinsid");
                    FlowJobHelper.updateFlowStatus(nodeIdToNodeMap, parentFlowInsId, flowStatus, time);
                }
            } else if (FlowStatusEnum.STATUS_RUN_FAIL == flowStatus) {
                QFilter flowFailFilter = new QFilter("flowstatus", "=", (Object)FlowStatusEnum.STATUS_RUN_FAIL.getStatus());
                QFilter idFilter = new QFilter("id", "=", (Object)currentFlowInsId);
                if (!mainFlowInsHelper.isExists(new QFilter[]{idFilter, flowFailFilter})) {
                    DynamicObject flowIns = mainFlowInsHelper.loadSingle(currentFlowInsId);
                    flowIns.set("flowstatus", (Object)FlowStatusEnum.STATUS_RUN_FAIL.getStatus());
                    flowIns.set("endtime", (Object)time);
                    mainFlowInsHelper.updateOne(flowIns);
                    long parentFlowInsId = flowIns.getLong("curjobflowinsid");
                    FlowJobHelper.updateFlowStatus(nodeIdToNodeMap, parentFlowInsId, flowStatus, time);
                } else {
                    QFilter jobRunningFilter = new QFilter("jobstatus", "=", (Object)FlowJobStatusEnum.STATUS_RUNNING.getStatus());
                    QFilter flowFilter = new QFilter("curjobflowinsid", "=", (Object)currentFlowInsId);
                    QFilter flowRunningFilter = new QFilter("flowstatus", "=", (Object)FlowStatusEnum.STATUS_RUNNING.getStatus());
                    boolean jobNotRunning = true;
                    boolean flowNotRunning = true;
                    if (subJobInsHelper != null) {
                        boolean bl = jobNotRunning = !subJobInsHelper.isExists(new QFilter[]{flowFilter, jobRunningFilter});
                    }
                    if (subFlowInsHelper != null) {
                        boolean bl = flowNotRunning = !subFlowInsHelper.isExists(new QFilter[]{flowFilter, flowRunningFilter});
                    }
                    if (jobNotRunning && flowNotRunning) {
                        DynamicObject flowIns = mainFlowInsHelper.loadSingle(currentFlowInsId);
                        flowIns.set("endtime", (Object)time);
                        mainFlowInsHelper.updateOne(flowIns);
                        long parentFlowInsId = flowIns.getLong("curjobflowinsid");
                        FlowJobHelper.updateFlowStatus(nodeIdToNodeMap, parentFlowInsId, flowStatus, time);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("update_flow_status_error:{}", (Object)CommonUtil.getStackTrace((Exception)exception));
            throw exception;
        }
    }

    public static long createFlowInstance(DynamicObject flowSettingDy, DynamicObjectType flowInsEntityType) {
        return FlowJobHelper.createFlowInstance(flowSettingDy, flowInsEntityType, null);
    }

    public static long createFlowInstance(DynamicObject flowSettingDy, DynamicObjectType flowInsEntityType, Map<String, String> transKeyMap) {
        HashMap transKeyMapIns = Maps.newHashMapWithExpectedSize((int)16);
        transKeyMapIns.putAll(TRANSFER_KEY_MAP);
        if (Objects.nonNull(transKeyMap)) {
            transKeyMapIns.putAll(transKeyMap);
        }
        long flowInsId = ORM.create().genLongId((IDataEntityType)flowInsEntityType);
        DynamicObject flowInsDy = FlowJobHelper.generateInsDy(flowInsEntityType, flowSettingDy, flowInsId, transKeyMapIns);
        LOGGER.info("createFlowInstance_root_flow_copy_success_{}", (Object)flowInsId);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, DynamicObject> allSettingDyObj = FlowJobHelper.getAllSettingDyObj(flowSettingDy);
        LOGGER.info("createFlowInstance_get_all_setting_dy_success_{}", (Object)flowInsId);
        FlowJobHelper.buildInsDynamicObj(map, flowInsId, flowInsDy, flowSettingDy, allSettingDyObj, transKeyMapIns, 100);
        LOGGER.info("createFlowInstance_build_ins_dy_success_{}", (Object)flowInsId);
        try (TXHandle required = TX.required();){
            for (Map.Entry entry : map.entrySet()) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)entry.getKey()));
                FlowJobHelper.saveInsDys((DynamicObjectType)dataEntityType, (List)entry.getValue());
            }
            LOGGER.info("createFlowInstance_save_ins_dy_success_{}", (Object)flowInsId);
        }
        return flowInsId;
    }

    private static void buildInsDynamicObj(Map<String, List<DynamicObject>> dyObjMap, long rootInsDyId, DynamicObject flowInsDy, DynamicObject flowSettingDy, Map<Long, DynamicObject> idToDyMap, Map<String, String> transKeyMap, int recursionDepth) {
        DynamicObjectType settingDyType = flowSettingDy.getDynamicObjectType();
        String settingMetaDisplayName = settingDyType.getDisplayName().getLocaleValue();
        if (--recursionDepth == 0) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u5d4c\u5957\u4e2a\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236,\u8bf7\u68c0\u67e5", (String)"FlowJobHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), settingMetaDisplayName));
        }
        long parentFlowId = flowInsDy.getLong("id");
        IDataEntityType flowInsDyDataEntityType = flowInsDy.getDataEntityType();
        FlowJobHelper.putIntoListMap(dyObjMap, flowInsDyDataEntityType.getName(), flowInsDy);
        DynamicObjectCollection settingDetailEntry = flowSettingDy.getDynamicObjectCollection("hrflowentry");
        DynamicObjectCollection insDetailEntry = flowInsDy.getDynamicObjectCollection("hrflowentry");
        if (settingDetailEntry.size() != insDetailEntry.size()) {
            String settingName = flowSettingDy.getString("name");
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"[{0}][{1}]\u751f\u6210\u5b9e\u4f8b\u5931\u8d25,\u5b9e\u4f8b\u6001\u660e\u7ec6\u5206\u5f55\u884c\u4e0e\u914d\u7f6e\u6001\u590d\u5236\u6570\u91cf\u4e0d\u76f8\u7b49", (String)"FlowJobHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), settingMetaDisplayName, settingName));
        }
        BasedataProp insEntryJobFlowInsProp = (BasedataProp)insDetailEntry.getDynamicObjectType().getProperty("jobflowins");
        MainEntityType flowInsEntityType = EntityMetadataCache.getDataEntityType((String)insEntryJobFlowInsProp.getBaseEntityId());
        BasedataProp insEntryJobInsProp = (BasedataProp)insDetailEntry.getDynamicObjectType().getProperty("jobins");
        MainEntityType jobInsEntityType = EntityMetadataCache.getDataEntityType((String)insEntryJobInsProp.getBaseEntityId());
        int flowInsCount = 0;
        int jobInsCount = 0;
        for (DynamicObject detail : settingDetailEntry) {
            String type = detail.getString("type");
            if ("jobflow".equals(type)) {
                ++flowInsCount;
                continue;
            }
            if (!"job".equals(type)) continue;
            ++jobInsCount;
        }
        long[] flowInsIds = null;
        if (flowInsCount > 0) {
            flowInsIds = ORM.create().genLongIds((IDataEntityType)flowInsEntityType, flowInsCount);
        }
        long[] jobInsIds = null;
        if (jobInsCount > 0) {
            jobInsIds = ORM.create().genLongIds((IDataEntityType)jobInsEntityType, jobInsCount);
        }
        int flowInsIndex = 0;
        int jobInsIndex = 0;
        for (int entryIndex = 0; entryIndex < settingDetailEntry.size(); ++entryIndex) {
            DynamicObject completeSettingDy;
            long settingId;
            DynamicObject settingDy;
            DynamicObject settingDetail = (DynamicObject)settingDetailEntry.get(entryIndex);
            String type = settingDetail.getString("type");
            DynamicObject insDetail = (DynamicObject)insDetailEntry.get(entryIndex);
            if ("jobflow".equals(type) && flowInsIds != null) {
                settingDy = settingDetail.getDynamicObject("jobflow");
                settingId = settingDy.getLong("id");
                completeSettingDy = idToDyMap.get(settingId);
                DynamicObject detailFlowInsDy = FlowJobHelper.generateInsDy((DynamicObjectType)flowInsEntityType, completeSettingDy, flowInsIds[flowInsIndex], transKeyMap);
                detailFlowInsDy.set("rootjobflowinsid", (Object)rootInsDyId);
                detailFlowInsDy.set("curjobflowinsid", (Object)parentFlowId);
                insDetail.set("jobflowins", (Object)detailFlowInsDy);
                ++flowInsIndex;
                FlowJobHelper.buildInsDynamicObj(dyObjMap, rootInsDyId, detailFlowInsDy, completeSettingDy, idToDyMap, transKeyMap, recursionDepth);
                continue;
            }
            if (!"job".equals(type) || jobInsIds == null) continue;
            settingDy = settingDetail.getDynamicObject("job");
            settingId = settingDy.getLong("id");
            completeSettingDy = idToDyMap.get(settingId);
            DynamicObject detailJobInsDy = FlowJobHelper.generateInsDy((DynamicObjectType)jobInsEntityType, completeSettingDy, jobInsIds[jobInsIndex], transKeyMap);
            detailJobInsDy.set("rootjobflowinsid", (Object)rootInsDyId);
            detailJobInsDy.set("curjobflowinsid", (Object)parentFlowId);
            insDetail.set("jobins", (Object)detailJobInsDy);
            ++jobInsIndex;
            FlowJobHelper.putIntoListMap(dyObjMap, jobInsEntityType.getName(), detailJobInsDy);
        }
    }

    private static <T> void putIntoListMap(Map<String, List<T>> listMap, String key, T dy) {
        listMap.putIfAbsent(key, Lists.newArrayListWithExpectedSize((int)10));
        listMap.computeIfPresent(key, (oldKey, list) -> {
            list.add(dy);
            return list;
        });
    }

    private static <T> void putAllIntoListMap(Map<String, List<T>> allListMap, Map<String, List<T>> putListMap) {
        for (Map.Entry<String, List<T>> entry : putListMap.entrySet()) {
            allListMap.putIfAbsent(entry.getKey(), entry.getValue());
            allListMap.computeIfPresent(entry.getKey(), (oldKey, list) -> {
                list.addAll((Collection)putListMap.get(oldKey));
                return list;
            });
        }
    }

    private static DynamicObject generateInsDy(DynamicObjectType insEntityType, DynamicObject completeSettingDy, long insId, Map<String, String> transKeyMap) {
        DynamicObject insDy = new DynamicObject(insEntityType);
        HRDynamicObjectUtils.copy((DynamicObject)completeSettingDy, (DynamicObject)insDy, transKeyMap);
        insDy.set((IDataEntityProperty)insEntityType.getPrimaryKey(), (Object)insId);
        insDy.set("settingid", completeSettingDy.getPkValue());
        if (HRDynamicObjectUtils.isPropertyExist((DynamicObject)insDy, (String)"flowstatus")) {
            insDy.set("flowstatus", (Object)FlowStatusEnum.STATUS_DEFAULT.getStatus());
        } else if (HRDynamicObjectUtils.isPropertyExist((DynamicObject)insDy, (String)"jobstatus")) {
            insDy.set("jobstatus", (Object)FlowJobStatusEnum.STATUS_DEFAULT.getStatus());
        }
        return insDy;
    }

    private static void saveInsDys(DynamicObjectType objectType, List<DynamicObject> insData) {
        if (Objects.nonNull(insData) && Objects.nonNull(objectType) && !insData.isEmpty()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(objectType.getName());
            helper.save(insData.toArray(new DynamicObject[0]));
        }
    }

    private static Map<Long, DynamicObject> getAllSettingDyObj(DynamicObject flowSettingDy) {
        Map<String, List<Object>> settingFlowIds = FlowJobHelper.getSettingFlowIds(flowSettingDy);
        HashMap idToDyMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<Object>> entry : settingFlowIds.entrySet()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entry.getKey());
            QFilter idFilter = new QFilter("id", "in", entry.getValue());
            idToDyMap.putAll(Arrays.stream(helper.loadDynamicObjectArray(new QFilter[]{idFilter})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy)));
        }
        return idToDyMap;
    }

    private static Map<String, List<Object>> getSettingFlowIds(DynamicObject flowSettingDy) {
        HashMap idsMap = Maps.newHashMapWithExpectedSize((int)16);
        IDataEntityType dataEntityType = flowSettingDy.getDataEntityType();
        FlowJobHelper.putIntoListMap(idsMap, dataEntityType.getName(), flowSettingDy.getPkValue());
        DynamicObjectCollection flowEntryDys = flowSettingDy.getDynamicObjectCollection("hrflowentry");
        DynamicObjectType entryDyType = flowEntryDys.getDynamicObjectType();
        BasedataProp flowEntryProp = (BasedataProp)entryDyType.getProperty("jobflow");
        BasedataProp jobEntryProp = (BasedataProp)entryDyType.getProperty("job");
        HRBaseServiceHelper flowHelper = new HRBaseServiceHelper(flowEntryProp.getBaseEntityId());
        for (DynamicObject entry : flowEntryDys) {
            Object id;
            String type = entry.getString("type");
            if ("jobflow".equals(type)) {
                id = entry.get((IDataEntityProperty)flowEntryProp) instanceof DynamicObject ? ((DynamicObject)entry.get((IDataEntityProperty)flowEntryProp)).getPkValue() : entry.get((IDataEntityProperty)flowEntryProp);
                DynamicObject subFlow = flowHelper.loadSingle(id);
                FlowJobHelper.putAllIntoListMap(idsMap, FlowJobHelper.getSettingFlowIds(subFlow));
                continue;
            }
            if (!"job".equals(type)) continue;
            id = entry.get((IDataEntityProperty)jobEntryProp) instanceof DynamicObject ? ((DynamicObject)entry.get((IDataEntityProperty)jobEntryProp)).getPkValue() : entry.get((IDataEntityProperty)jobEntryProp);
            FlowJobHelper.putIntoListMap(idsMap, jobEntryProp.getBaseEntityId(), id);
        }
        return idsMap;
    }

    public static String getFlowEntryEntityName(DynamicObject node) {
        return FlowJobHelper.getFlowEntryEntityName(node, false);
    }

    public static String getFlowEntryEntityName(DynamicObject node, boolean isInstance) {
        DynamicObject jobFlow;
        String nodeName = "";
        String type = node.getString("type");
        if ("start".equals(type) || "end".equals(type)) {
            IDataEntityProperty property = (IDataEntityProperty)node.getDataEntityType().getProperties().get((Object)"type");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                nodeName = comboProp.getItemByName(type);
            }
        } else if ("job".equals(type)) {
            DynamicObject job = isInstance ? node.getDynamicObject("jobins") : node.getDynamicObject("job");
            if (Objects.nonNull(job)) {
                nodeName = job.getString("name");
            }
        } else if ("jobflow".equals(type) && Objects.nonNull(jobFlow = isInstance ? node.getDynamicObject("jobflowins") : node.getDynamicObject("jobflow"))) {
            nodeName = jobFlow.getString("name");
        }
        return nodeName;
    }

    public static Map<String, JobNode> getNodeIdToNodeMapFromCache(Long flowInstanceId) {
        Map cacheMap;
        String key = String.join((CharSequence)CACHE_STRING_SPLIT, CACHE_FLOW_ID_TO_NODE, String.valueOf(flowInstanceId));
        HashMap nodeIdToJobNodeMap = NODE_ID_TO_JOB_NODE_MAP.get(key);
        if (null == nodeIdToJobNodeMap && null != (cacheMap = (Map)CACHE.get(key, Map.class))) {
            nodeIdToJobNodeMap = Maps.newHashMapWithExpectedSize((int)cacheMap.size());
            for (Map.Entry entry : cacheMap.entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodeIdToJobNodeMap.put(entry.getKey(), FlowJobHelper.convertMapToObject((Map)entry.getValue(), JobNode.class));
            }
            NODE_ID_TO_JOB_NODE_MAP.put(key, nodeIdToJobNodeMap);
        }
        return nodeIdToJobNodeMap;
    }

    private static Map<String, JobNode> getNodeIdToNodeMap(JobNode jobNode) {
        HashMap idToJobNodeMap = Maps.newHashMapWithExpectedSize((int)16);
        idToJobNodeMap.put(String.valueOf(jobNode.getId()), jobNode);
        List<JobNode> children = jobNode.getChildren();
        if (Objects.nonNull(children) && !children.isEmpty()) {
            for (JobNode childNode : children) {
                idToJobNodeMap.putAll(FlowJobHelper.getNodeIdToNodeMap(childNode));
            }
        }
        return idToJobNodeMap;
    }

    public static <T> T convertMapToObject(Map map, Class<T> clazz) {
        if (Objects.nonNull(map)) {
            return (T)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map), clazz);
        }
        return null;
    }
}

