/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.flow.job;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.common.constants.flow.ServiceResultModeEnum;

public class HRFlowJobResponse
implements Serializable {
    private static final long serialVersionUID = 2873378566105194014L;
    private static final String DEFAULT_SUCCESS_CODE = "success";
    private static final String DEFAULT_ERROR_CODE = "fail";
    private FlowJobStatusEnum jobStatus = FlowJobStatusEnum.STATUS_DEFAULT;
    private Map<String, Object> returnData = Maps.newHashMapWithExpectedSize((int)16);
    private ServiceResultModeEnum serviceMode = ServiceResultModeEnum.MODE_SYN;
    private String returnCode;
    private String message;

    public HRFlowJobResponse() {
    }

    public HRFlowJobResponse(Map<String, Object> returnData, String returnCode, String message, ServiceResultModeEnum serviceMode) {
        this.returnData = returnData;
        this.returnCode = returnCode;
        this.message = message;
        this.serviceMode = serviceMode;
    }

    public FlowJobStatusEnum getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(FlowJobStatusEnum jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Map<String, Object> getReturnData() {
        return this.returnData;
    }

    public void setReturnData(Map<String, Object> returnData) {
        this.returnData = returnData;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ServiceResultModeEnum getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(ServiceResultModeEnum serviceMode) {
        this.serviceMode = serviceMode;
    }

    public static HRFlowJobResponse fail(String errorMsg, ServiceResultModeEnum serviceMode) {
        HRFlowJobResponse response = new HRFlowJobResponse();
        response.setJobStatus(FlowJobStatusEnum.STATUS_RUN_FAIL);
        response.setMessage(errorMsg);
        response.setReturnCode(DEFAULT_ERROR_CODE);
        response.setReturnData(null);
        response.setServiceMode(serviceMode);
        return response;
    }

    public static HRFlowJobResponse empty() {
        return HRFlowJobResponse.fail(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"HRFlowJobResponse_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), ServiceResultModeEnum.MODE_SYN);
    }
}

