/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.flow.job.service;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import kd.hr.hbp.common.constants.flow.ServiceResultModeEnum;

public class HRJobServiceResult
implements Serializable {
    private static final long serialVersionUID = 2873378566105194014L;
    private static final String DEFAULT_SUCCESS_CODE = "success";
    private static final String DEFAULT_ERROR_CODE = "fail";
    private boolean success;
    private boolean isEnd;
    private String flowJobId;
    private ServiceResultModeEnum serviceMode = ServiceResultModeEnum.MODE_SYN;
    private Map<String, Object> returnData = Maps.newHashMapWithExpectedSize((int)16);
    private String returnCode;
    private String message;

    public String getFlowJobId() {
        return this.flowJobId;
    }

    public void setFlowJobId(String flowJobId) {
        this.flowJobId = flowJobId;
    }

    public static HRJobServiceResult fail(String message, String errorCode) {
        HRJobServiceResult result = new HRJobServiceResult();
        result.setSuccess(false);
        result.setEnd(true);
        result.setMessage(message);
        result.setReturnCode(errorCode);
        return result;
    }

    public static HRJobServiceResult fail(String msg) {
        return HRJobServiceResult.fail(msg, DEFAULT_ERROR_CODE);
    }

    public static HRJobServiceResult synSuccess() {
        return HRJobServiceResult.synSuccess(null, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult synSuccess(Map<String, Object> returnData) {
        return HRJobServiceResult.synSuccess(returnData, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult synSuccess(Map<String, Object> returnData, String returnCode) {
        return HRJobServiceResult.success(returnData, returnCode, true, ServiceResultModeEnum.MODE_SYN);
    }

    public static HRJobServiceResult asynSuccess() {
        return HRJobServiceResult.asynSuccess(null, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult asynSuccess(Map<String, Object> returnData) {
        return HRJobServiceResult.asynSuccess(returnData, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult asynSuccess(Map<String, Object> returnData, String returnCode) {
        return HRJobServiceResult.success(returnData, returnCode, false, ServiceResultModeEnum.MODE_ASYN);
    }

    public static HRJobServiceResult asynEndSuccess() {
        return HRJobServiceResult.asynEndSuccess(null, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult asynEndSuccess(Map<String, Object> returnData) {
        return HRJobServiceResult.asynEndSuccess(returnData, DEFAULT_SUCCESS_CODE);
    }

    public static HRJobServiceResult asynEndSuccess(Map<String, Object> returnData, String returnCode) {
        return HRJobServiceResult.success(returnData, returnCode, true, ServiceResultModeEnum.MODE_ASYN);
    }

    private static HRJobServiceResult success(Map<String, Object> returnData, String returnCode, boolean isEnd, ServiceResultModeEnum serviceMode) {
        HRJobServiceResult result = new HRJobServiceResult();
        result.setSuccess(true);
        result.setEnd(isEnd);
        result.setReturnData(returnData);
        result.setReturnCode(returnCode);
        result.setServiceMode(serviceMode);
        return result;
    }

    public Map<String, Object> getReturnData() {
        return this.returnData;
    }

    public void setReturnData(Map<String, Object> returnData) {
        this.returnData = returnData;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ServiceResultModeEnum getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(ServiceResultModeEnum serviceMode) {
        this.serviceMode = serviceMode;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }
}

