/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class HRDefineFunction
implements Cloneable {
    private static final Log log = LogFactory.getLog(HRDefineFunction.class);

    public BigDecimal plus(BigDecimal param1, BigDecimal param2) {
        return param1.add(param2);
    }

    public Integer plus(Integer param1, Integer param2) throws Exception {
        BigDecimal result = new BigDecimal(String.valueOf(param1)).add(new BigDecimal(String.valueOf(param2)));
        if (result.compareTo(new BigDecimal(String.valueOf(Integer.MAX_VALUE))) > 0) {
            throw new Exception(ResManager.loadKDString((String)"\u4e24\u4e2a\u6574\u6570\u76f8\u52a0\u7684\u7ed3\u679c\u6570\u636e\u8fc7\u5927\uff0c\u8d85\u51fa\u4e86\u6574\u6570\u7684\u6700\u5927\u503c(2147483647)\u3002", (String)"ParentFormulaParse_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return result.intValue();
    }

    public BigDecimal subtract(BigDecimal param1, BigDecimal param2) {
        return param1.subtract(param2);
    }

    public Integer subtract(Integer param1, Integer param2) throws Exception {
        BigDecimal result = new BigDecimal(String.valueOf(param1)).subtract(new BigDecimal(String.valueOf(param2)));
        if (result.compareTo(new BigDecimal(String.valueOf(Integer.MIN_VALUE))) < 0) {
            throw new Exception(ResManager.loadKDString((String)"\u4e24\u4e2a\u6574\u6570\u76f8\u51cf\u7684\u7ed3\u679c\u6570\u636e\u8fc7\u5c0f\uff0c\u5c0f\u4e8e\u6574\u6570\u7684\u6700\u5c0f\u503c(-2147483648)\u3002", (String)"ParentFormulaParse_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return result.intValue();
    }

    public BigDecimal multiply(BigDecimal param1, BigDecimal param2) {
        return param1.multiply(param2);
    }

    public BigDecimal multiply(Integer param1, Integer param2) {
        return new BigDecimal(param1).multiply(new BigDecimal(param2));
    }

    public BigDecimal divide(BigDecimal param1, BigDecimal param2) throws Exception {
        if (param2.compareTo(new BigDecimal("0")) == 0) {
            throw new Exception(ResManager.loadKDString((String)"\u9664\u6570\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"ParentFormulaParse_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return param1.divide(param2, 10, 4);
    }

    public BigDecimal divide(Integer param1, Integer param2) throws Exception {
        if (param2 == 0) {
            throw new Exception(ResManager.loadKDString((String)"\u9664\u6570\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"ParentFormulaParse_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return new BigDecimal(param1).divide(new BigDecimal(param2), 10, 4);
    }

    public BigDecimal rounding(BigDecimal value, Integer scale) {
        return value.setScale((int)scale, 4);
    }

    public boolean isEqual(String string1, String string2) {
        if (string1 != null) {
            return string1.equals(string2);
        }
        return string2 == null;
    }

    public boolean isEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 != null && value2 != null) {
            return value1.compareTo(value2) == 0;
        }
        return value1 == null && value2 == null;
    }

    public boolean isEqual(Integer value1, Integer value2) {
        if (value1 != null) {
            return value1.equals(value2);
        }
        return value2 == null;
    }

    public boolean isEqual(Boolean value1, Boolean value2) {
        if (value1 != null) {
            return value1.equals(value2);
        }
        return value2 == null;
    }

    public boolean isEqual(Date date1, Date date2) {
        return this.isEqual(date1, date2, true);
    }

    public boolean isEqual(Date date1, Date date2, boolean checkHourMinSec) {
        if (date1 == null || date2 == null) {
            return date1 == null && date2 == null;
        }
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        dateTime1 = dateTime1.withMillisOfSecond(0);
        dateTime2 = dateTime2.withMillisOfSecond(0);
        if (!checkHourMinSec) {
            dateTime1 = dateTime1.withTimeAtStartOfDay();
            dateTime2 = dateTime2.withTimeAtStartOfDay();
        }
        return dateTime1.equals((Object)dateTime2);
    }

    public boolean isEqual(DynamicObject value1, DynamicObject value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 != null) {
            Object pkValue1 = value1.getPkValue();
            Object pkValue2 = value2.getPkValue();
            return String.valueOf(pkValue1).equals(String.valueOf(pkValue2));
        }
        return false;
    }

    public boolean isEqual(Object value1, Object value2) {
        return HRObjectUtils.equals((Object)value1, (Object)value2);
    }

    public boolean unEqual(BigDecimal value1, BigDecimal value2) {
        return !this.isEqual(value1, value2);
    }

    public boolean unEqual(Integer value1, Integer value2) {
        return !this.isEqual(value1, value2);
    }

    public boolean unEqual(String string1, String string2) {
        return !this.isEqual(string1, string2);
    }

    public boolean unEqual(Boolean value1, Boolean value2) {
        return !this.isEqual(value1, value2);
    }

    public boolean unEqual(Date date1, Date date2) {
        return !this.isEqual(date1, date2, true);
    }

    public boolean unEqual(Object value1, Object value2) {
        return !this.isEqual(value1, value2);
    }

    public boolean unEqual(Date date1, Date date2, boolean checkHourMinSec) {
        return !this.isEqual(date1, date2, checkHourMinSec);
    }

    public boolean unEqual(DynamicObject value1, DynamicObject value2) {
        return !this.isEqual(value1, value2);
    }

    public boolean gt(Integer value1, Integer value2) {
        if (value1 == null) {
            value1 = 0;
        }
        if (value2 == null) {
            value2 = 0;
        }
        return value1.compareTo(value2) > 0;
    }

    public boolean gt(Calendar param1, Calendar param2) {
        return param1.compareTo(param2) > 0;
    }

    public boolean gt(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            value1 = new BigDecimal(0);
        }
        if (value2 == null) {
            value2 = new BigDecimal(0);
        }
        return value1.compareTo(value2) > 0;
    }

    public boolean gt(Date date1, Date date2) {
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        return this.gt(date1, date2, true);
    }

    public boolean gt(Date date1, Date date2, boolean checkHourMinSec) {
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        dateTime1 = dateTime1.withMillisOfSecond(0);
        dateTime2 = dateTime2.withMillisOfSecond(0);
        if (!checkHourMinSec) {
            dateTime1 = dateTime1.withTimeAtStartOfDay();
            dateTime2 = dateTime2.withTimeAtStartOfDay();
        }
        return dateTime1.isAfter((ReadableInstant)dateTime2);
    }

    public boolean lt(Integer value1, Integer value2) {
        if (value1 == null) {
            value1 = 0;
        }
        if (value2 == null) {
            value2 = 0;
        }
        return value1.compareTo(value2) < 0;
    }

    public boolean lt(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            value1 = new BigDecimal(0);
        }
        if (value2 == null) {
            value2 = new BigDecimal(0);
        }
        return value1.compareTo(value2) < 0;
    }

    public boolean lt(Date date1, Date date2) {
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return false;
        }
        return this.lt(date1, date2, true);
    }

    public boolean lt(Date date1, Date date2, boolean checkHourMinSec) {
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return false;
        }
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        dateTime1 = dateTime1.withMillisOfSecond(0);
        dateTime2 = dateTime2.withMillisOfSecond(0);
        if (!checkHourMinSec) {
            dateTime1 = dateTime1.withTimeAtStartOfDay();
            dateTime2 = dateTime2.withTimeAtStartOfDay();
        }
        return dateTime1.isBefore((ReadableInstant)dateTime2);
    }

    public boolean lt(Calendar param1, Calendar param2) {
        return param1.compareTo(param2) < 0;
    }

    public boolean gtOrEqual(Integer value1, Integer value2) {
        if (value1 == null) {
            value1 = 0;
        }
        if (value2 == null) {
            value2 = 0;
        }
        return value1.compareTo(value2) >= 0;
    }

    public boolean gtOrEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            value1 = new BigDecimal(0);
        }
        if (value2 == null) {
            value2 = new BigDecimal(0);
        }
        return value1.compareTo(value2) >= 0;
    }

    public boolean gtOrEqual(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        return this.gtOrEqual(date1, date2, true);
    }

    public boolean gtOrEqual(Date date1, Date date2, boolean checkHourMinSec) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        dateTime1 = dateTime1.withMillisOfSecond(0);
        dateTime2 = dateTime2.withMillisOfSecond(0);
        if (!checkHourMinSec) {
            dateTime1 = dateTime1.withTimeAtStartOfDay();
            dateTime2 = dateTime2.withTimeAtStartOfDay();
        }
        return dateTime1.compareTo((ReadableInstant)dateTime2) >= 0;
    }

    public boolean ltOrEqual(Integer value1, Integer value2) {
        if (value1 == null) {
            value1 = 0;
        }
        if (value2 == null) {
            value2 = 0;
        }
        return value1.compareTo(value2) <= 0;
    }

    public boolean ltOrEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            value1 = new BigDecimal(0);
        }
        if (value2 == null) {
            value2 = new BigDecimal(0);
        }
        return value1.compareTo(value2) <= 0;
    }

    public boolean ltOrEqual(Calendar param1, Calendar param2) {
        return param1.compareTo(param2) <= 0;
    }

    public boolean ltOrEqual(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return true;
        }
        if (date2 == null) {
            return false;
        }
        return this.ltOrEqual(date1, date2, true);
    }

    public boolean ltOrEqual(Date date1, Date date2, boolean checkHourMinSec) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return true;
        }
        if (date2 == null) {
            return false;
        }
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        dateTime1 = dateTime1.withMillisOfSecond(0);
        dateTime2 = dateTime2.withMillisOfSecond(0);
        if (!checkHourMinSec) {
            dateTime1 = dateTime1.withTimeAtStartOfDay();
            dateTime2 = dateTime2.withTimeAtStartOfDay();
        }
        return dateTime1.compareTo((ReadableInstant)dateTime2) <= 0;
    }

    public Boolean[] getBooleanArray(Object obj) {
        if (obj instanceof Boolean[]) {
            return (Boolean[])obj;
        }
        if (obj instanceof boolean[]) {
            int length = ((boolean[])obj).length;
            ArrayList booleanList = Lists.newArrayListWithExpectedSize((int)length);
            for (boolean bo : (boolean[])obj) {
                booleanList.add(bo);
            }
            return booleanList.toArray(new Boolean[0]);
        }
        if (obj instanceof String[]) {
            int length = ((String[])obj).length;
            ArrayList booleanList = Lists.newArrayListWithExpectedSize((int)length);
            for (String bo : (String[])obj) {
                if ("1".equals(bo) || "true".equalsIgnoreCase(bo)) {
                    booleanList.add(Boolean.TRUE);
                    continue;
                }
                booleanList.add(Boolean.FALSE);
            }
            return booleanList.toArray(new Boolean[0]);
        }
        return null;
    }

    public Integer[] getIntArray(Object obj) {
        if (obj instanceof Integer[]) {
            return (Integer[])obj;
        }
        if (obj instanceof BigDecimal[]) {
            int length = ((BigDecimal[])obj).length;
            ArrayList integerList = Lists.newArrayListWithExpectedSize((int)length);
            for (BigDecimal decimal : (BigDecimal[])obj) {
                integerList.add(decimal.intValue());
            }
            return integerList.toArray(new Integer[0]);
        }
        if (obj instanceof String[]) {
            int length = ((String[])obj).length;
            ArrayList integerList = Lists.newArrayListWithExpectedSize((int)length);
            for (String str : (String[])obj) {
                if (StringUtils.isNumeric((CharSequence)str)) {
                    integerList.add(Integer.parseInt(str));
                    continue;
                }
                integerList.add(0);
            }
            return integerList.toArray(new Integer[0]);
        }
        return null;
    }

    public Date[] getDateArray(Object obj) {
        if (obj instanceof Date[]) {
            return (Date[])obj;
        }
        if (obj instanceof String[]) {
            int length = ((String[])obj).length;
            ArrayList dateList = Lists.newArrayListWithExpectedSize((int)length);
            for (String str : (String[])obj) {
                dateList.add(this.parseDate(str));
            }
            return dateList.toArray(new Date[0]);
        }
        return null;
    }

    public Date parseDate(String dateStr) {
        Date date = null;
        try {
            date = HRDateTimeUtils.parseDateLocal((String)dateStr);
        }
        catch (ParseException ex) {
            log.error("parse date error, dateStr = {}", (Object)dateStr, (Object)ex);
        }
        return date;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Can't clone CloneInstance", ex);
        }
    }
}

