/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.helper.OrgHistoryHelper;
import kd.hr.hbp.business.history.service.AbstractAttachService;
import kd.hr.hbp.business.history.service.CompositionAttachService;
import kd.hr.hbp.business.history.service.HistoryEntityRegister;
import kd.hr.hbp.business.history.util.HistoryEntityFieldValueConverter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.EntityHisDynamicObjectModel;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.history.model.HistoryObjectInfoMdoel;
import kd.hr.hbp.common.history.model.ModifyHistoryObjectInfoModel;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRTypesContainer;

public class EntityHistoryFacade {
    private SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(EntityHistoryFacade.class);
    private String entityType;
    private List<HistoryEntityModel> historyEntityModels;
    private Map<String, CompositionAttachService> mainPartServiceMap;
    private Map<String, CompositionAttachService> otherPartServiceMap;
    private Map<String, AbstractAttachService> normalServiceMap;
    private String mainEntityField;

    public EntityHistoryFacade(String entityType, String mainEntityField) {
        this.entityType = entityType;
        this.mainEntityField = mainEntityField;
        this.historyEntityModels = HistoryEntityRegister.getEntityHistoryList(entityType);
        this.mainPartServiceMap = new LinkedHashMap<String, CompositionAttachService>();
        this.otherPartServiceMap = new LinkedHashMap<String, CompositionAttachService>();
        this.normalServiceMap = new LinkedHashMap<String, AbstractAttachService>();
        Map<String, AbstractAttachService> attachServiceMap = this.getAttachService();
        for (Map.Entry<String, AbstractAttachService> entityEntry : attachServiceMap.entrySet()) {
            AbstractAttachService attachService = entityEntry.getValue();
            if (attachService instanceof CompositionAttachService) {
                Boolean isMainPart = ((CompositionAttachService)attachService).getIsMainPart();
                if (isMainPart.booleanValue()) {
                    this.mainPartServiceMap.put(entityEntry.getKey(), (CompositionAttachService)attachService);
                    continue;
                }
                this.otherPartServiceMap.put(entityEntry.getKey(), (CompositionAttachService)attachService);
                continue;
            }
            this.normalServiceMap.put(entityEntry.getKey(), attachService);
        }
    }

    private EntityHistoryFacade() {
    }

    public void batchAddNewBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewBoDatas(historyOrgInfoMdoels);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewBoDataHis(dynList);
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewBoDataHis(dynList);
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewBoDataHis(dynList);
            }
        });
    }

    public Map<String, Object> batchSaveNewBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)historyOrgInfoMdoels.size());
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeSaveNewBoDatas(historyOrgInfoMdoels, result);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveNewBoDataHis(dynList);
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveNewBoDataHis(dynList);
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveNewBoDataHis(dynList);
            }
        });
        return result;
    }

    public void batchUpdateNewBoDataHis(List<ModifyHistoryObjectInfoModel> modifyHistoryObjectInfoModels) {
        HashMap vidListMap = Maps.newHashMapWithExpectedSize((int)modifyHistoryObjectInfoModels.size());
        HashMap hisDynListMap = Maps.newHashMapWithExpectedSize((int)16);
        modifyHistoryObjectInfoModels.forEach(model -> this.setVidListMap(vidListMap, model.getVidMap()));
        vidListMap.forEach((hisEntityNumber, vidList) -> {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper((String)hisEntityNumber);
            DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(vidList.toArray(new Long[0]));
            hisDynListMap.put(hisEntityNumber, Arrays.stream(dys).collect(Collectors.toList()));
        });
        modifyHistoryObjectInfoModels.forEach(model -> {
            DynamicObject modifyDynamicObject = model.getModifyDynamicObject();
            MainEntityType mainEntityType = (MainEntityType)modifyDynamicObject.getDataEntityType();
            List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
            Map vidMap = model.getVidMap();
            vidMap.forEach((number, vid) -> this.setNewFieldValueToHisDyn((String)number, (Long)vid, pageFieldsNameList, modifyDynamicObject, hisDynListMap));
        });
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)hisDynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchUpdateNewBoDataHis(dynList);
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)hisDynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchUpdateNewBoDataHis(dynList);
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)hisDynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchUpdateNewBoDataHis(dynList);
            }
        });
    }

    protected DynamicObject genCurrentDynamicObject(String entityName, DynamicObject hisDynamic) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dynamic = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)hisDynamic, (DynamicObject)dynamic);
        return dynamic;
    }

    private void setNewFieldValueToHisDyn(String number, Long vid, List<String> pageFieldsNameList, DynamicObject modifyDynamicObject, Map<String, List<DynamicObject>> hisDynListMap) {
        List<DynamicObject> hisDynList = hisDynListMap.get(number);
        hisDynList.forEach(hisDyn -> {
            Long hisVid = hisDyn.getLong("id");
            if (hisVid.equals(vid)) {
                MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)number);
                List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
                List<String> ignoreKeyList = HistoryEntityUtils.getCompareIgnoreKeyList();
                for (String fieldName : fieldsNameList) {
                    if (ignoreKeyList.contains(fieldName) || !pageFieldsNameList.contains(fieldName)) continue;
                    this.setHisFieldValue(modifyDynamicObject, (DynamicObject)hisDyn, fieldName);
                }
            }
        });
        hisDynListMap.put(number, hisDynList);
    }

    private void setHisFieldValue(DynamicObject dataDyn, DynamicObject hisDyn, String fieldName) {
        Object value = dataDyn.get(fieldName);
        if (value instanceof DynamicObjectCollection) {
            MainEntityType mainEntityType = (MainEntityType)hisDyn.getDynamicObjectType();
            EntityType entryType = (EntityType)mainEntityType.getAllEntities().get(fieldName);
            if (entryType == null) {
                hisDyn.set(fieldName, value);
            } else {
                hisDyn.set(fieldName, (Object)this.getNewEntry((DynamicObjectCollection)value, entryType));
            }
        } else {
            hisDyn.set(fieldName, value);
        }
    }

    private DynamicObjectCollection getNewEntry(DynamicObjectCollection entryCollll, EntityType entryType) {
        DynamicObjectCollection newEntryObjColl = new DynamicObjectCollection();
        int cunt = 0;
        long[] entryIds = ORM.create().genLongIds((IDataEntityType)entryType, entryCollll.size());
        for (DynamicObject entry : entryCollll) {
            DynamicObject newEntry = new DynamicObject((DynamicObjectType)entryType);
            HRDynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)newEntry);
            newEntry.set("id", (Object)entryIds[cunt]);
            try {
                newEntry.set("seq", (Object)cunt++);
            }
            catch (Exception exception) {
                logger.info("has not seq");
            }
            newEntryObjColl.add((Object)newEntry);
        }
        return newEntryObjColl;
    }

    private void setVidListMap(Map<String, List<Long>> vidListMap, Map<String, Long> vidMap) {
        vidMap.forEach((number, vid) -> {
            List vidList = (List)vidListMap.get(number);
            if (vidList == null) {
                vidList = Lists.newArrayListWithExpectedSize((int)16);
            }
            vidList.add(vid);
            vidListMap.put((String)number, vidList);
        });
    }

    public void batchSaveAndEffectBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewBoDatas(historyOrgInfoMdoels);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectBoDataHis(dynList);
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectBoDataHis(dynList);
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectBoDataHis(dynList);
            }
        });
    }

    public void batchModifyAndEffectBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchModifyAndEffectBoDatas(dynList);
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchModifyAndEffectBoDatas(dynList);
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchModifyAndEffectBoDatas(dynList);
            }
        });
    }

    public void batchModifyAndEffectBoDataHis(String hisEntityNumber, List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        this.attachServiceModifyRunner(this.normalServiceMap.get(hisEntityNumber), dynListMap, hisEntityNumber);
        this.attachServiceModifyRunner(this.mainPartServiceMap.get(hisEntityNumber), dynListMap, hisEntityNumber);
        this.attachServiceModifyRunner(this.otherPartServiceMap.get(hisEntityNumber), dynListMap, hisEntityNumber);
    }

    private void attachServiceModifyRunner(AbstractAttachService attachService, Map<String, List<DynamicObject>> dynListMap, String hisEntityNumber) {
        Optional.ofNullable(attachService).ifPresent(service -> Optional.ofNullable(dynListMap.get(hisEntityNumber)).ifPresent(dynList -> service.batchModifyAndEffectBoDatas((List<DynamicObject>)dynList)));
    }

    public void batchAddNewDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewDataHis((List)dynListMap.get(entityNumber));
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewDataHis((List)dynListMap.get(entityNumber));
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchAddNewDataHis((List)dynListMap.get(entityNumber));
            }
        });
    }

    public void batchSaveAndEffectDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        Map<String, List<DynamicObject>> dynListMap = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        this.normalServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectDataHis((List)dynListMap.get(entityNumber));
            }
        });
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectDataHis((List)dynListMap.get(entityNumber));
            }
        });
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> {
            List dynList = (List)dynListMap.get(entityNumber);
            if (dynList != null) {
                attachService.batchSaveAndEffectDataHis((List)dynListMap.get(entityNumber));
            }
        });
    }

    public void batchDiscardBoDataHis(List<Long> eventIds) {
        this.normalServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardBoDataHis(eventIds));
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardBoDataHis(eventIds));
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardBoDataHis(eventIds));
    }

    public void batchDiscardDataHis(List<Long> eventIds) {
        this.normalServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardDataHis(eventIds));
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardDataHis(eventIds));
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchDiscardDataHis(eventIds));
    }

    @Deprecated
    public void batchEffectBoDataHis(List<Long> eventIds) {
        this.normalServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectBoDataHis(eventIds));
        this.mainPartServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectBoDataHis(eventIds));
        this.otherPartServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectBoDataHis(eventIds));
    }

    public void batchEffectBoDataHis(List<Long> eventIdList, String eventPageNumber) {
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchEffectBoDataHis(eventIdList));
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchEffectBoDataHis(eventIdList));
        this.normalServiceMap.forEach((entityNumber, attachService) -> attachService.batchEffectBoDataHis(eventIdList));
        this.effectEvent(eventIdList, eventPageNumber);
    }

    @Deprecated
    public void batchEffectDataHis(List<Long> eventIdColl) {
        this.normalServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectDataHis(eventIdColl));
        this.mainPartServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectDataHis(eventIdColl));
        this.otherPartServiceMap.forEach((entityNum, attachService) -> attachService.batchEffectDataHis(eventIdColl));
    }

    public void batchEffectDataHis(List<Long> eventIds, String eventPageNum) {
        this.normalServiceMap.forEach((entityNumber, hrAttachService) -> hrAttachService.batchEffectDataHis(eventIds));
        this.mainPartServiceMap.forEach((entityNumber, hrAttachService) -> hrAttachService.batchEffectDataHis(eventIds));
        this.otherPartServiceMap.forEach((entityNumber, hrAttachService) -> hrAttachService.batchEffectDataHis(eventIds));
        this.effectEvent(eventIds, eventPageNum);
    }

    public void batchSaveAndEffectDataHis(String hisEntityNumber, List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        AbstractAttachService service;
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(this.entityType, this.mainEntityField);
        ArrayList newDys = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        DynamicObjectCollection eventColl = new DynamicObjectCollection();
        String eventNumber = "";
        Map<Long, Map<String, DynamicObject>> effectingHisDynamicObjectMap = this.getEffectingHisDynamicObjectMap(historyOrgInfoMdoels);
        for (HistoryObjectInfoMdoel historyOrgInfoModel : historyOrgInfoMdoels) {
            DynamicObject eventDyn = historyOrgInfoModel.getEventDynObj();
            eventNumber = eventDyn.getDataEntityType().getName();
            String prepareEffectDateFieldName = historyOrgInfoModel.getPrepareEffectDateFieldName();
            Long eventId = eventDyn.getLong("id");
            if (eventId == null || eventId == 0L) {
                eventId = EntityHistoryFacade.genEventId(eventNumber);
                eventDyn.set("id", (Object)eventId);
            }
            eventColl.add((Object)eventDyn);
            DynamicObject modifiedDynObj = historyOrgInfoModel.getModifiedDynObj();
            DynamicObject newDyn = converter.assembleHistoryDynamicObjectFromDynamicObject(hisEntityNumber, modifiedDynObj);
            Date prepareEffectDate = modifiedDynObj.getDate(prepareEffectDateFieldName);
            String prepareString = this.SDF.format(prepareEffectDate);
            try {
                Date date = this.SDF.parse(prepareString);
                newDyn.set("bsed", (Object)date);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            newDyn.set("ce", (Object)eventId);
            this.setDataBoValue(effectingHisDynamicObjectMap, hisEntityNumber, newDyn, modifiedDynObj);
            newDys.add(newDyn);
        }
        this.saveEventDatas(eventColl, eventNumber);
        if (this.normalServiceMap.get(hisEntityNumber) != null) {
            service = this.normalServiceMap.get(hisEntityNumber);
            service.batchSaveAndEffectDataHis(newDys);
        }
        if (this.mainPartServiceMap.get(hisEntityNumber) != null) {
            service = this.mainPartServiceMap.get(hisEntityNumber);
            service.batchSaveAndEffectDataHis(newDys);
        }
        if (this.otherPartServiceMap.get(hisEntityNumber) != null) {
            service = this.otherPartServiceMap.get(hisEntityNumber);
            service.batchSaveAndEffectDataHis(newDys);
        }
    }

    private void setDataBoValue(Map<Long, Map<String, DynamicObject>> effectingHisDynamicObjectMap, String hisNumber, DynamicObject dyn, DynamicObject modifyDynObj) {
        Long objId = this.getMainEntityIdFromDyn(modifyDynObj);
        Map<String, DynamicObject> dynamicObjectMap = effectingHisDynamicObjectMap.get(objId);
        DynamicObject hisDynamicObject = dynamicObjectMap.get(hisNumber);
        Long bo = hisDynamicObject.getLong("bo");
        dyn.set("bo", (Object)bo);
    }

    private Map<Long, Map<String, DynamicObject>> getEffectingHisDynamicObjectMap(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        ArrayList objIds = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        HashMap bsedMap = Maps.newHashMapWithExpectedSize((int)historyOrgInfoMdoels.size());
        historyOrgInfoMdoels.forEach(historyOrgInfoMdoel -> {
            DynamicObject modifiedInfoDyn = historyOrgInfoMdoel.getModifiedDynObj();
            Long objId = this.getMainEntityIdFromDyn(modifiedInfoDyn);
            objIds.add(objId);
            bsedMap.put(objId, modifiedInfoDyn.getDate(historyOrgInfoMdoel.getPrepareEffectDateFieldName()));
        });
        OrgHistoryHelper historyHelper = new OrgHistoryHelper(this.entityType, this.mainEntityField);
        List<EntityHisDynamicObjectModel> effectingModels = historyHelper.getEntityHistoryDynamicObjectByBsed(objIds, bsedMap);
        Map<Long, Map<String, DynamicObject>> effectingHisDynamicObjectMap = this.changeHisDynListToMap(effectingModels);
        return effectingHisDynamicObjectMap;
    }

    public void batchPhysicalDeletionDataHis(List<Long> boList) {
        this.normalServiceMap.forEach((entityNumber, attachService) -> attachService.batchPhysicalDeletionDataHis(boList, this.mainEntityField));
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchPhysicalDeletionDataHis(boList, this.mainEntityField));
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchPhysicalDeletionDataHis(boList, this.mainEntityField));
    }

    public void batchLogicDeletionDataHis(List<Long> boList) {
        this.normalServiceMap.forEach((entityNumber, attachService) -> attachService.batchLogicDeletionDataHis(boList, this.mainEntityField));
        this.mainPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchLogicDeletionDataHis(boList, this.mainEntityField));
        this.otherPartServiceMap.forEach((entityNumber, attachService) -> attachService.batchLogicDeletionDataHis(boList, this.mainEntityField));
    }

    private void effectEvent(List<Long> eventIds, String eventPageNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(eventPageNumber);
        DynamicObject[] eventDys = serviceHelper.loadDynamicObjectArray(eventIds.toArray());
        Arrays.stream(eventDys).forEach(eventDyc -> eventDyc.set("status", (Object)"1"));
        serviceHelper.updateDatas(eventDys);
    }

    private Map<String, AbstractAttachService> getAttachService() {
        LinkedHashMap<String, AbstractAttachService> attachServiceMap = new LinkedHashMap<String, AbstractAttachService>(this.historyEntityModels.size());
        for (HistoryEntityModel historyEntityModel : this.historyEntityModels) {
            String entityNumber = historyEntityModel.getHisEntityNumber();
            String hisHandleName = historyEntityModel.getHisHandlerName();
            AbstractAttachService abstractAttachService = (AbstractAttachService)HRTypesContainer.createInstance((String)hisHandleName);
            abstractAttachService.initHistoryProp(entityNumber, historyEntityModel.getBsedFieldName(), historyEntityModel.getBsledFieldName(), historyEntityModel.getHisVerFieldName());
            attachServiceMap.put(entityNumber, abstractAttachService);
        }
        return attachServiceMap;
    }

    private Map<String, List<DynamicObject>> getHistoryDynamicObjectBeforeAddNewBoDatas(List<HistoryObjectInfoMdoel> hisOrgModels) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection eventDynCollection = new DynamicObjectCollection();
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(this.entityType, this.mainEntityField);
        String eventNo = "";
        for (HistoryObjectInfoMdoel hisOrgModel : hisOrgModels) {
            DynamicObject eventDyn = hisOrgModel.getEventDynObj();
            eventNo = eventDyn.getDataEntityType().getName();
            Long eventDynId = eventDyn.getLong("id");
            if (eventDynId == null || eventDynId == 0L) {
                eventDynId = EntityHistoryFacade.genEventId(eventNo);
                eventDyn.set("id", (Object)eventDynId);
            }
            eventDynCollection.add((Object)eventDyn);
            DynamicObject modifiedDynObj = hisOrgModel.getModifiedDynObj();
            Map<String, DynamicObject> dynMap = converter.assembleHistoryDynamicObjectFromDynamicObject(modifiedDynObj);
            this.replenishHistoryDynamicObjectInfoBeforeAddNewBoData(dynMap, modifiedDynObj, hisOrgModel);
            for (HistoryEntityModel historyEntityModel : this.historyEntityModels) {
                String entityNumber = historyEntityModel.getHisEntityNumber();
                DynamicObject dyn = dynMap.get(entityNumber);
                dyn.set("ce", (Object)eventDynId);
                ArrayList<DynamicObject> dynList = (ArrayList<DynamicObject>)result.get(entityNumber);
                if (dynList == null) {
                    dynList = new ArrayList<DynamicObject>();
                }
                dynList.add(dyn);
                result.put(entityNumber, dynList);
            }
        }
        this.saveEventDatas(eventDynCollection, eventNo);
        return result;
    }

    private Map<String, List<DynamicObject>> getHistoryDynamicObjectBeforeSaveNewBoDatas(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels, Map<String, Object> vidMap) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection eventColl = new DynamicObjectCollection();
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(this.entityType, this.mainEntityField);
        String eventNumber = "";
        for (HistoryObjectInfoMdoel historyOrgInfoModel : historyOrgInfoMdoels) {
            DynamicObject eventDyn = historyOrgInfoModel.getEventDynObj();
            eventNumber = eventDyn.getDataEntityType().getName();
            Long eventId = eventDyn.getLong("id");
            if (eventId == null || eventId == 0L) {
                eventId = EntityHistoryFacade.genEventId(eventNumber);
                eventDyn.set("id", (Object)eventId);
            }
            eventColl.add((Object)eventDyn);
            DynamicObject modifiedDynObj = historyOrgInfoModel.getModifiedDynObj();
            Map<String, DynamicObject> dynMap = converter.assembleHistoryDynamicObjectFromDynamicObject(modifiedDynObj);
            this.replenishHistoryDynamicObjectInfoBeforeAddNewBoData(dynMap, modifiedDynObj, historyOrgInfoModel);
            for (HistoryEntityModel historyEntityModel : this.historyEntityModels) {
                String entityNumber = historyEntityModel.getHisEntityNumber();
                DynamicObject dyn = dynMap.get(entityNumber);
                dyn.set("ce", (Object)eventId);
                ArrayList<DynamicObject> dynList = (ArrayList<DynamicObject>)result.get(entityNumber);
                if (dynList == null) {
                    dynList = new ArrayList<DynamicObject>();
                }
                dynList.add(dyn);
                this.setHisVid(vidMap, modifiedDynObj, dyn, entityNumber);
                result.put(entityNumber, dynList);
            }
        }
        this.saveEventDatas(eventColl, eventNumber);
        return result;
    }

    private void setHisVid(Map<String, Object> vidMap, DynamicObject modifiedDynObj, DynamicObject hisDyn, String entityNumber) {
        String number = modifiedDynObj.getString("id");
        Long vid = EntityHistoryFacade.genEntityBo(entityNumber);
        hisDyn.set("id", (Object)vid);
        Object val = vidMap.get(number);
        if (val == null) {
            val = Maps.newHashMapWithExpectedSize((int)16);
        }
        ((Map)val).put(entityNumber, vid);
        vidMap.put(number, val);
    }

    protected void replenishHistoryDynamicObjectInfoBeforeAddNewBoData(Map<String, DynamicObject> dynamicMap, DynamicObject modifiedDynamicObj, HistoryObjectInfoMdoel hisOrgInfoModel) {
        HashMap newBoMap = new HashMap();
        Map<String, HistoryEntityModel> modelMap = this.changeHisModelListToMap(this.historyEntityModels);
        dynamicMap.forEach((entityNum, dynamic) -> {
            String prepEffectDateFieldName = hisOrgInfoModel.getPrepareEffectDateFieldName();
            Date prepEffectDate = modifiedDynamicObj.getDate(prepEffectDateFieldName);
            String prepString = this.SDF.format(prepEffectDate);
            try {
                Date prepDate = this.SDF.parse(prepString);
                dynamic.set("bsed", (Object)prepDate);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            Long bo = dynamic.getLong("bo");
            if (bo == null || bo == 0L) {
                HistoryEntityModel model = (HistoryEntityModel)modelMap.get(entityNum);
                String index = model.getIndex();
                Long newBo = (Long)newBoMap.get(index);
                if (newBo == null || newBo == 0L) {
                    newBo = EntityHistoryFacade.genEntityBo(entityNum);
                    dynamic.set("bo", (Object)newBo);
                    newBoMap.put(index, newBo);
                } else {
                    dynamic.set("bo", (Object)newBo);
                }
            }
        });
    }

    private Map<String, List<DynamicObject>> getHistoryDynamicObjectBeforeAddNewDatas(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        ArrayList objIds = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        HashMap bsedMap = Maps.newHashMapWithExpectedSize((int)historyOrgInfoMdoels.size());
        historyOrgInfoMdoels.forEach(historyOrgInfoMdoel -> {
            DynamicObject modifiedInfoDyn = historyOrgInfoMdoel.getModifiedDynObj();
            Long objId = this.getMainEntityIdFromDyn(modifiedInfoDyn);
            objIds.add(objId);
            bsedMap.put(objId, modifiedInfoDyn.getDate(historyOrgInfoMdoel.getPrepareEffectDateFieldName()));
        });
        OrgHistoryHelper historyHelper = new OrgHistoryHelper(this.entityType, this.mainEntityField);
        List<EntityHisDynamicObjectModel> effectingModels = historyHelper.getEntityHistoryDynamicObjectByBsed(objIds, bsedMap);
        Map<Long, Map<String, DynamicObject>> effectingHisDynamicObjectMap = this.changeHisDynListToMap(effectingModels);
        ArrayList addHisDataIds = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        objIds.forEach(objId -> {
            if (!effectingHisDynamicObjectMap.containsKey(objId)) {
                addHisDataIds.add(objId);
            }
        });
        List<EntityHisDynamicObjectModel> addNewHisEffectingModels = historyHelper.getEntityHistoryDynamicObjectByOrgIds(addHisDataIds, "1");
        Map<Long, Map<String, DynamicObject>> addNewHisEffectingHisDynamicObjectMap = this.changeHisDynListToMap(addNewHisEffectingModels);
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection eventColl = new DynamicObjectCollection();
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(this.entityType, this.mainEntityField);
        List<HistoryEntityModel> entityHistoryList = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        String eventNumber = "";
        for (HistoryObjectInfoMdoel historyOrgInfoModel : historyOrgInfoMdoels) {
            eventNumber = this.setHisOrgModel(effectingHisDynamicObjectMap, addNewHisEffectingHisDynamicObjectMap, result, eventColl, converter, entityHistoryList, historyOrgInfoModel);
        }
        this.saveEventDatas(eventColl, eventNumber);
        return result;
    }

    private String setHisOrgModel(Map<Long, Map<String, DynamicObject>> effectingHisDynamicObjectMap, Map<Long, Map<String, DynamicObject>> addNewHisEffectingHisDynamicObjectMap, Map<String, List<DynamicObject>> result, DynamicObjectCollection eventColl, HistoryEntityFieldValueConverter converter, List<HistoryEntityModel> entityHistoryList, HistoryObjectInfoMdoel historyOrgInfoModel) {
        DynamicObject eventDyn = historyOrgInfoModel.getEventDynObj();
        String eventNumber = eventDyn.getDataEntityType().getName();
        Long eventId = eventDyn.getLong("id");
        if (eventId == null || eventId == 0L) {
            eventId = EntityHistoryFacade.genEventId(eventNumber);
            eventDyn.set("id", (Object)eventId);
        }
        DynamicObject modifiedDynObj = historyOrgInfoModel.getModifiedDynObj();
        Map<String, DynamicObject> newDynMap = converter.assembleHistoryDynamicObjectFromDynamicObject(modifiedDynObj, entityHistoryList);
        Long orgId = this.getMainEntityIdFromDyn(modifiedDynObj);
        Map<String, DynamicObject> effectingHisDynMap = effectingHisDynamicObjectMap.get(orgId);
        Map<String, DynamicObject> addNewDataHisEffectingHisDynMap = addNewHisEffectingHisDynamicObjectMap.get(orgId);
        Map<String, DynamicObject> historyDynamicObjectMap = HistoryEntityUtils.compareHistoryDynamicObject(newDynMap, effectingHisDynMap, entityHistoryList, addNewDataHisEffectingHisDynMap);
        this.replenishHistoryDynamicObjectInfoBeforeAddNewData(historyDynamicObjectMap, modifiedDynObj, historyOrgInfoModel);
        if (historyDynamicObjectMap.size() > 0) {
            eventColl.add((Object)eventDyn);
        }
        for (Map.Entry<String, DynamicObject> entityEntry : historyDynamicObjectMap.entrySet()) {
            DynamicObject dyn = entityEntry.getValue();
            dyn.set("ce", (Object)eventId);
            List<DynamicObject> dynList = result.get(entityEntry.getKey());
            if (dynList == null) {
                dynList = new ArrayList<DynamicObject>();
            }
            dynList.add(dyn);
            result.put(entityEntry.getKey(), dynList);
        }
        return eventNumber;
    }

    private void saveEventDatas(DynamicObjectCollection eventColl, String eventNumber) {
        HashSet<Long> eventIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> eventDycMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject eventDyn : eventColl) {
            Long eventId2 = eventDyn.getLong("id");
            eventIdSet.add(eventId2);
            eventDycMap.put(eventId2, eventDyn);
        }
        HRBaseServiceHelper helperService = new HRBaseServiceHelper(eventNumber);
        QFilter idFilter = new QFilter("id", "in", eventIdSet);
        DynamicObject[] oldEventDys = helperService.query(new QFilter[]{idFilter});
        ArrayList oldEventIds = new ArrayList();
        Arrays.stream(oldEventDys).forEach(oldEventDyn -> oldEventIds.add(oldEventDyn.getLong("id")));
        DynamicObjectCollection dynamic = new DynamicObjectCollection();
        eventIdSet.forEach(eventId -> {
            if (!oldEventIds.contains(eventId)) {
                dynamic.add(eventDycMap.get(eventId));
            }
        });
        helperService.save(dynamic);
    }

    private Long getMainEntityIdFromDyn(DynamicObject modifiedInfoDyn) {
        if (modifiedInfoDyn != null) {
            Object obj = modifiedInfoDyn.get(this.mainEntityField);
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getLong("id");
            }
            if (obj != null) {
                return (Long)obj;
            }
        }
        return 0L;
    }

    protected void replenishHistoryDynamicObjectInfoBeforeAddNewData(Map<String, DynamicObject> dynMap, DynamicObject modifiedDynObj, HistoryObjectInfoMdoel historyOrgInfoModel) {
        dynMap.forEach((entityNumber, dyn) -> {
            String prepareEffectDateFieldName = historyOrgInfoModel.getPrepareEffectDateFieldName();
            Date prepareEffectDate = modifiedDynObj.getDate(prepareEffectDateFieldName);
            String prepareString = this.SDF.format(prepareEffectDate);
            try {
                Date date = this.SDF.parse(prepareString);
                dyn.set("bsed", (Object)date);
            }
            catch (Exception e) {
                logger.error("EntityHistoryFacade replenishHistoryDynamicObjectInfoBeforeAddNewData error", (Throwable)e);
            }
        });
    }

    private Map<Long, Map<String, DynamicObject>> changeHisDynListToMap(List<EntityHisDynamicObjectModel> entityHisDynamicObjectModels) {
        HashMap<Long, Map<String, DynamicObject>> entityHisDynamicObjectMap = new HashMap<Long, Map<String, DynamicObject>>();
        entityHisDynamicObjectModels.forEach(entityHisDynamicObjectModel -> {
            Long orgId = entityHisDynamicObjectModel.getOrgId();
            Map entityHisDynMap = entityHisDynamicObjectModel.getEntityHisDynMap();
            entityHisDynamicObjectMap.put(orgId, entityHisDynMap);
        });
        return entityHisDynamicObjectMap;
    }

    private Map<String, HistoryEntityModel> changeHisModelListToMap(List<HistoryEntityModel> models) {
        return models.stream().collect(Collectors.toMap(model -> model.getHisEntityNumber(), Function.identity()));
    }

    private static long genEventId(String eventNumber) {
        return ORM.create().genLongId(eventNumber);
    }

    private static long genEntityBo(String entityNumber) {
        return ORM.create().genLongId(entityNumber);
    }
}

