/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.facade.EntityHistoryFacade;
import kd.hr.hbp.business.history.helper.OrgHistoryHelper;
import kd.hr.hbp.business.history.service.AbstractAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityFieldValueConverter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.history.model.HistoryObjectInfoMdoel;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.HRTypesContainer;

public class SingleEntityHistoryFacade {
    private static final Log logger = LogFactory.getLog(EntityHistoryFacade.class);
    private AbstractAttachService service;
    private String mainEntityField;
    private String hisEntityNumber;

    public SingleEntityHistoryFacade(HistoryEntityModel model, String mainEntityField) {
        String handleClassName = model.getHisHandlerName();
        String entityNumber = model.getHisEntityNumber();
        AbstractAttachService abstractAttachService = (AbstractAttachService)HRTypesContainer.createInstance((String)handleClassName);
        abstractAttachService.initHistoryProp(entityNumber, model.getBsedFieldName(), model.getBsledFieldName(), model.getHisVerFieldName());
        this.service = abstractAttachService;
        this.mainEntityField = mainEntityField;
        this.hisEntityNumber = entityNumber;
    }

    private static long genEventId(String eventNumber) {
        return ORM.create().genLongId(eventNumber);
    }

    private static long genEntityBo(String entityNumber) {
        return ORM.create().genLongId(entityNumber);
    }

    public void batchAddNewBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewBoDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchAddNewBoDataHis(dynList);
        }
    }

    public Map<String, Long> batchSaveNewBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewBoDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchAddNewBoDataHis(dynList);
        }
        return Maps.newHashMapWithExpectedSize((int)16);
    }

    public void batchSaveAndEffectBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewBoDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchSaveAndEffectBoDataHis(dynList);
        }
    }

    public void batchModifyAndEffectBoDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchModifyAndEffectBoDatas(dynList);
        }
    }

    public void batchAddNewDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchAddNewDataHis(dynList);
        }
    }

    public void batchSaveAndEffectDataHis(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        List<DynamicObject> dynList = this.getHistoryDynamicObjectBeforeAddNewDatas(historyOrgInfoMdoels);
        if (dynList != null && dynList.size() > 0) {
            this.service.batchSaveAndEffectDataHis(dynList);
        }
    }

    public void batchDiscardBoDataHis(List<Long> eventIds) {
        this.service.batchDiscardBoDataHis(eventIds);
    }

    public void batchDiscardDataHis(List<Long> eventIds) {
        this.service.batchDiscardDataHis(eventIds);
    }

    @Deprecated
    public void batchEffectBoDataHis(List<Long> eventIds) {
        this.service.batchEffectBoDataHis(eventIds);
    }

    public void batchEffectBoDataHis(List<Long> eventIds, String eventPageNumber) {
        this.service.batchEffectBoDataHis(eventIds);
        this.effectEvent(eventIds, eventPageNumber);
    }

    @Deprecated
    public void batchEffectDataHis(List<Long> eventIds) {
        this.service.batchEffectDataHis(eventIds);
    }

    public void batchEffectDataHis(List<Long> eventIds, String eventPageNumber) {
        this.service.batchEffectDataHis(eventIds);
        this.effectEvent(eventIds, eventPageNumber);
    }

    public void batchPhysicalDeletionDataHis(List<Long> boList) {
        this.service.batchPhysicalDeletionDataHis(boList, this.mainEntityField);
    }

    public void batchLogicDeletionDataHis(List<Long> boList) {
        this.service.batchLogicDeletionDataHis(boList, this.mainEntityField);
    }

    private void effectEvent(List<Long> eventIds, String eventPageNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(eventPageNumber);
        DynamicObject[] eventDys = serviceHelper.loadDynamicObjectArray(eventIds.toArray());
        Arrays.stream(eventDys).forEach(eventDyc -> eventDyc.set("status", (Object)"1"));
        serviceHelper.updateDatas(eventDys);
    }

    private List<DynamicObject> getHistoryDynamicObjectBeforeAddNewBoDatas(List<HistoryObjectInfoMdoel> hisOrgInfoModelList) {
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)hisOrgInfoModelList.size());
        DynamicObjectCollection eventCollection = new DynamicObjectCollection();
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(null, this.mainEntityField);
        String eventNum = "";
        for (HistoryObjectInfoMdoel hisOrgInfoModel : hisOrgInfoModelList) {
            DynamicObject eventDynamic = hisOrgInfoModel.getEventDynObj();
            eventNum = eventDynamic.getDataEntityType().getName();
            Long eventId = eventDynamic.getLong("id");
            if (eventId == null || eventId == 0L) {
                eventId = SingleEntityHistoryFacade.genEventId(eventNum);
                eventDynamic.set("id", (Object)eventId);
            }
            eventCollection.add((Object)eventDynamic);
            DynamicObject modifiedDynamicObj = hisOrgInfoModel.getModifiedDynObj();
            DynamicObject dyn = converter.assembleHistoryDynamicObjectFromDynamicObject(this.hisEntityNumber, modifiedDynamicObj);
            this.replenishHistoryDynamicObjectInfoBeforeAddNewBoData(dyn, modifiedDynamicObj, hisOrgInfoModel);
            dyn.set("ce", (Object)eventId);
            dynList.add(dyn);
        }
        this.saveEventDatas(eventCollection, eventNum);
        return dynList;
    }

    protected void replenishHistoryDynamicObjectInfoBeforeAddNewBoData(DynamicObject hisDyn, DynamicObject modifiedDynObj, HistoryObjectInfoMdoel historyOrgInfoModel) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String prepareEffectDateFieldName = historyOrgInfoModel.getPrepareEffectDateFieldName();
        Date prepareEffectDate = modifiedDynObj.getDate(prepareEffectDateFieldName);
        String prepareString = sdf.format(prepareEffectDate);
        try {
            Date date = sdf.parse(prepareString);
            hisDyn.set("bsed", (Object)date);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        Long bo = hisDyn.getLong("bo");
        if (bo == null || bo == 0L) {
            bo = SingleEntityHistoryFacade.genEntityBo(this.hisEntityNumber);
            hisDyn.set("bo", (Object)bo);
        }
    }

    private List<DynamicObject> getHistoryDynamicObjectBeforeAddNewDatas(List<HistoryObjectInfoMdoel> historyOrgInfoMdoels) {
        ArrayList objIds = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        HashMap bsedMap = Maps.newHashMapWithExpectedSize((int)historyOrgInfoMdoels.size());
        historyOrgInfoMdoels.forEach(historyOrgInfoMdoel -> {
            DynamicObject modifiedInfoDyn = historyOrgInfoMdoel.getModifiedDynObj();
            Long objId = this.getOrgIdFromDyn(modifiedInfoDyn, this.mainEntityField);
            objIds.add(objId);
            bsedMap.put(objId, modifiedInfoDyn.getDate(historyOrgInfoMdoel.getPrepareEffectDateFieldName()));
        });
        OrgHistoryHelper historyHelper = new OrgHistoryHelper(null, this.mainEntityField);
        Map<Long, DynamicObject> effectingModels = historyHelper.getEntityHistoryDynamicObjectByBsed(this.hisEntityNumber, objIds, bsedMap);
        ArrayList addHisDataIds = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        objIds.forEach(objId -> {
            if (!effectingModels.containsKey(objId)) {
                addHisDataIds.add(objId);
            }
        });
        Map<Long, DynamicObject> addNewHisEffectingModels = historyHelper.getEntityHistoryDynamicObjectByObjIds(this.hisEntityNumber, addHisDataIds, "1");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)historyOrgInfoMdoels.size());
        DynamicObjectCollection eventDynamicColl = new DynamicObjectCollection();
        HistoryEntityFieldValueConverter converter = new HistoryEntityFieldValueConverter(null, this.mainEntityField);
        String eventNumber = "";
        for (HistoryObjectInfoMdoel historyOrgInfoModel : historyOrgInfoMdoels) {
            eventNumber = this.valHistoryOrg(effectingModels, addNewHisEffectingModels, result, eventDynamicColl, converter, historyOrgInfoModel);
        }
        this.saveEventDatas(eventDynamicColl, eventNumber);
        return result;
    }

    private String valHistoryOrg(Map<Long, DynamicObject> effectingModels, Map<Long, DynamicObject> addNewHisEffectingModels, List<DynamicObject> result, DynamicObjectCollection eventDynamicColl, HistoryEntityFieldValueConverter converter, HistoryObjectInfoMdoel historyOrgInfoModel) {
        DynamicObject eventDy = historyOrgInfoModel.getEventDynObj();
        String eventNumber = eventDy.getDataEntityType().getName();
        Long eventId = eventDy.getLong("id");
        if (eventId == null || eventId == 0L) {
            eventId = SingleEntityHistoryFacade.genEventId(eventNumber);
            eventDy.set("id", (Object)eventId);
        }
        eventDynamicColl.add((Object)eventDy);
        DynamicObject modifiedDynamic = historyOrgInfoModel.getModifiedDynObj();
        DynamicObject newDyn = converter.assembleHistoryDynamicObjectFromDynamicObject(this.hisEntityNumber, modifiedDynamic);
        Long orgId = this.getOrgIdFromDyn(modifiedDynamic, this.mainEntityField);
        DynamicObject effectingHisDyn = effectingModels.get(orgId);
        DynamicObject addNewDataHisEffectingHisDyn = addNewHisEffectingModels.get(orgId);
        if (effectingHisDyn == null) {
            newDyn.set("bo", Objects.nonNull(addNewDataHisEffectingHisDyn) ? addNewDataHisEffectingHisDyn.get("bo") : orgId);
        } else if (!HistoryEntityUtils.compareDynamicObjectData(newDyn, effectingHisDyn).booleanValue()) {
            newDyn.set("bo", effectingHisDyn.get("bo"));
        } else {
            return eventNumber;
        }
        this.replenishHistoryDynamicObjectInfoBeforeAddNewData(newDyn, modifiedDynamic, historyOrgInfoModel);
        newDyn.set("ce", (Object)eventId);
        result.add(newDyn);
        return eventNumber;
    }

    private void saveEventDatas(DynamicObjectCollection eventCollection, String eventNum) {
        if (HRStringUtils.isEmpty((String)eventNum)) {
            return;
        }
        HashSet<Long> eventIdColl = new HashSet<Long>();
        HashMap<Long, DynamicObject> eventDynamicMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject eventDynamic : eventCollection) {
            Long eventId2 = eventDynamic.getLong("id");
            eventIdColl.add(eventId2);
            eventDynamicMap.put(eventId2, eventDynamic);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(eventNum);
        QFilter idFieldFilter = new QFilter("id", "in", eventIdColl);
        DynamicObject[] oldEventDynamicArray = hrBaseServiceHelper.query(new QFilter[]{idFieldFilter});
        ArrayList oldEventIdList = new ArrayList();
        Arrays.stream(oldEventDynamicArray).forEach(oldEventDynamic -> oldEventIdList.add(oldEventDynamic.getLong("id")));
        DynamicObjectCollection dynamicColl = new DynamicObjectCollection();
        eventIdColl.forEach(eventId -> {
            if (!oldEventIdList.contains(eventId)) {
                dynamicColl.add(eventDynamicMap.get(eventId));
            }
        });
        hrBaseServiceHelper.save(dynamicColl);
    }

    private Long getOrgIdFromDyn(DynamicObject modifiedInfoDyn, String mainEntityField) {
        if (modifiedInfoDyn != null) {
            Object obj = modifiedInfoDyn.get(mainEntityField);
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getLong("id");
            }
            if (obj != null) {
                return (Long)obj;
            }
        }
        return 0L;
    }

    protected void replenishHistoryDynamicObjectInfoBeforeAddNewData(DynamicObject dyn, DynamicObject modifiedDynObj, HistoryObjectInfoMdoel historyOrgInfoModel) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String prepareEffectDateFieldName = historyOrgInfoModel.getPrepareEffectDateFieldName();
        Date prepareEffectDate = modifiedDynObj.getDate(prepareEffectDateFieldName);
        String prepareString = sdf.format(prepareEffectDate);
        try {
            Date date = sdf.parse(prepareString);
            dyn.set("bsed", (Object)date);
        }
        catch (Exception e) {
            logger.error("SingleEntityHistoryFacade replenishHistoryDynamicObjectInfoBeforeAddNewData error", (Throwable)e);
        }
    }
}

