/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.service.HistoryEntityRegister;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.EntityHisDynamicObjectModel;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class OrgHistoryHelper {
    private String entityType;
    private String mainEntityField;
    private boolean registed;

    public OrgHistoryHelper(String entityType, String mainEntityField) {
        this(entityType, mainEntityField, true);
    }

    public OrgHistoryHelper(String entityType, String mainEntityField, boolean registed) {
        this.entityType = entityType;
        this.mainEntityField = mainEntityField;
        this.registed = registed;
    }

    public Map<String, DynamicObject> getEntityHistoryDynamicObjectByLmeEventId(Long ce) {
        return this.getEntityHistoryDynamicObjectByEventIdAndEventProperty("lme", ce);
    }

    public Map<String, DynamicObject> getEntityHistoryDynamicObjectByCeEventId(Long lme) {
        return this.getEntityHistoryDynamicObjectByEventIdAndEventProperty("ce", lme);
    }

    public Map<String, DynamicObject> getEntityHistoryDynamicObjectByEventIdAndEventProperty(String eventPro, Long ceEventId) {
        return this.getSingleEntityHistoryDynamicObjectByQFilter(id -> new QFilter(eventPro, "=", (Object)ceEventId));
    }

    public Map<String, DynamicObject> getSingleEntityHistoryDynamicObjectByQFilter(Function<String, QFilter> qfFunc) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)12);
        this.queryEntityHistoryDynamicObject(hisEntityNumber -> {
            DynamicObject[] dyn = this.getEntityHistoryDynamicObject(qfFunc, (String)hisEntityNumber);
            return dyn;
        }, (hisEntityNumber, dyn) -> {
            if (Objects.nonNull(dyn)) {
                Arrays.stream(dyn).filter(Objects::nonNull).findFirst().ifPresent(dy -> resultMap.put(hisEntityNumber, dy));
            }
        });
        return resultMap;
    }

    private DynamicObject[] getEntityHistoryDynamicObject(Function<String, QFilter> qfFunc, String hisEntityNumber) {
        MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
        String fieldsNameString = this.changeListToString(fieldsNameList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
        String idProp = null;
        idProp = fieldsNameList.contains(this.mainEntityField) ? this.mainEntityField : "bo";
        QFilter filter = qfFunc.apply(idProp);
        DynamicObject[] dyn = serviceHelper.query(fieldsNameString, new QFilter[]{filter});
        return dyn;
    }

    public Map<String, List<DynamicObject>> getEntityHistoryDynamicObjectByQFilter(Function<String, QFilter> qfFunc) {
        HashMap resultMaps = Maps.newHashMapWithExpectedSize((int)16);
        this.queryEntityHistoryDynamicObject(hisEntityNumber -> {
            DynamicObject[] dyn = this.getEntityHistoryDynamicObject(qfFunc, (String)hisEntityNumber);
            return dyn;
        }, (hisEntityNumber, dyn) -> resultMaps.put(hisEntityNumber, Lists.newArrayList((Object[])dyn)));
        return resultMaps;
    }

    private void queryEntityHistoryDynamicObject(Function<String, DynamicObject[]> funcQuery, BiConsumer<String, DynamicObject[]> consumerQuery) {
        if (this.registed) {
            List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
            for (HistoryEntityModel historyEntityModel : historyEntityModels) {
                String hisEntityNumber = historyEntityModel.getHisEntityNumber();
                DynamicObject[] dyn = funcQuery.apply(hisEntityNumber);
                consumerQuery.accept(hisEntityNumber, dyn);
            }
        } else {
            DynamicObject[] dyn = funcQuery.apply(this.entityType);
            consumerQuery.accept(this.entityType, dyn);
        }
    }

    public boolean isExistsEntityHistoryByQFilters(Function<String, QFilter> qfFunc) {
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        HRBaseServiceHelper serviceHelper = null;
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
            String idProp = null;
            idProp = fieldsNameList.contains(this.mainEntityField) ? this.mainEntityField : "bo";
            if (!serviceHelper.isExists(qfFunc.apply(idProp))) continue;
            return true;
        }
        return false;
    }

    public List<EntityHisDynamicObjectModel> getEntityHistoryDynamicObjectByOrgIds(List<Long> orgIds, String dataStatus) {
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        if (orgIds.size() == 0) {
            return new ArrayList<EntityHisDynamicObjectModel>();
        }
        HashMap<Long, Map<String, DynamicObject>> resultMap = new HashMap<Long, Map<String, DynamicObject>>();
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)dataStatus);
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisMainEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldNameList = HistoryEntityUtils.getFieldsNameList(hisMainEntityType);
            String fieldsNameString = this.changeListToString(fieldNameList);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
            QFilter mainEntityFilter = null;
            mainEntityFilter = fieldNameList.contains(this.mainEntityField) ? new QFilter(this.mainEntityField, "in", orgIds) : new QFilter("bo", "in", orgIds);
            DynamicObject[] dyn = serviceHelper.query(fieldsNameString, new QFilter[]{statusFilter, mainEntityFilter});
            this.putReSultMap(resultMap, hisEntityNumber, fieldNameList, dyn);
        }
        ArrayList models = Lists.newArrayListWithExpectedSize((int)resultMap.size());
        for (Map.Entry orgEntry : resultMap.entrySet()) {
            EntityHisDynamicObjectModel model = new EntityHisDynamicObjectModel((Long)orgEntry.getKey(), (Map)orgEntry.getValue());
            models.add(model);
        }
        return models;
    }

    private void putReSultMap(Map<Long, Map<String, DynamicObject>> resultMap, String hisEntityNumber, List<String> fieldsNameList, DynamicObject[] dyn) {
        for (DynamicObject dyc : dyn) {
            Long orgId = 0L;
            orgId = fieldsNameList.contains(this.mainEntityField) ? HistoryEntityUtils.getDynamicObjectFieldId(dyc, this.mainEntityField) : Long.valueOf(dyc.getLong("bo"));
            Map<String, DynamicObject> entityHistoryMap = resultMap.get(orgId);
            if (entityHistoryMap == null) {
                entityHistoryMap = new HashMap<String, DynamicObject>();
            }
            entityHistoryMap.put(hisEntityNumber, dyc);
            resultMap.put(orgId, entityHistoryMap);
        }
    }

    public Map<Long, DynamicObject> getEntityHistoryDynamicObjectByObjIds(String hisEntityNum, List<Long> orgIdList, String dataStatus) {
        DynamicObject[] dynamicObjects;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)dataStatus);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNum);
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(dataEntityType);
        String fieldsNameString = this.changeListToString(fieldsNameList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNum);
        QFilter entityFilter = null;
        entityFilter = fieldsNameList.contains(this.mainEntityField) ? new QFilter(this.mainEntityField, "in", orgIdList) : new QFilter("bo", "in", orgIdList);
        for (DynamicObject dynamic : dynamicObjects = serviceHelper.query(fieldsNameString, new QFilter[]{statusFilter, entityFilter})) {
            Long orgId = 0L;
            if (fieldsNameList.contains(this.mainEntityField)) {
                Object orgDynData = dynamic.get(this.mainEntityField);
                if (orgDynData != null) {
                    orgId = orgDynData instanceof DynamicObject ? Long.valueOf(((DynamicObject)orgDynData).getLong("id")) : (Long)orgDynData;
                }
            } else {
                orgId = dynamic.getLong("bo");
            }
            resultMap.put(orgId, dynamic);
        }
        return resultMap;
    }

    public Map<Long, Map<String, Long>> getHisVidMap(List<Long> idList) {
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        if (CollectionUtils.isEmpty(idList)) {
            return new HashMap<Long, Map<String, Long>>();
        }
        HashMap orgvidMap = Maps.newHashMapWithExpectedSize((int)idList.size());
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        historyEntityModels.forEach(historyEntityModel -> {
            DynamicObject[] dys;
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
            String filterField = "";
            QFilter entityFilter = null;
            filterField = fieldsNameList.contains(this.mainEntityField) ? this.mainEntityField : "bo";
            entityFilter = new QFilter(filterField, "in", (Object)idList);
            for (DynamicObject dyn : dys = serviceHelper.queryOriginalArray(filterField + ", id", new QFilter[]{statusFilter, entityFilter})) {
                Long bo = dyn.getLong(filterField);
                Long vid = dyn.getLong("id");
                Map vidMap = (Map)orgvidMap.get(bo);
                if (vidMap == null || vidMap.isEmpty()) {
                    vidMap = Maps.newHashMapWithExpectedSize((int)idList.size());
                }
                vidMap.put(hisEntityNumber, vid);
                orgvidMap.put(bo, vidMap);
            }
        });
        return orgvidMap;
    }

    public List<EntityHisDynamicObjectModel> getEntityHistoryDynamicObjectByBsed(List<Long> objIds, Map<Long, Date> bsedMap) {
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        HashMap<Long, Map<String, DynamicObject>> resultMap = new HashMap<Long, Map<String, DynamicObject>>();
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0", "2"});
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
            QFilter entityFilter = null;
            entityFilter = fieldsNameList.contains(this.mainEntityField) ? this.getboFilters(objIds, this.mainEntityField, bsedMap) : this.getboFilters(objIds, "bo", bsedMap);
            DynamicObject[] dyn = serviceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, entityFilter});
            this.putReSultMap(resultMap, hisEntityNumber, fieldsNameList, dyn);
        }
        ArrayList models = Lists.newArrayListWithExpectedSize((int)resultMap.size());
        for (Map.Entry orgEntry : resultMap.entrySet()) {
            EntityHisDynamicObjectModel model = new EntityHisDynamicObjectModel((Long)orgEntry.getKey(), (Map)orgEntry.getValue());
            models.add(model);
        }
        return models;
    }

    public Map<Long, DynamicObject> getEntityHistoryDynamicObjectByBsed(String hisEntityNumber, List<Long> objIds, Map<Long, Date> bsedMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)objIds.size());
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0", "2"});
        MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
        List<String> fieldNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
        String fieldsName = this.changeListToString(fieldNameList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
        QFilter entityFilter = null;
        entityFilter = fieldNameList.contains(this.mainEntityField) ? this.getboFilters(objIds, this.mainEntityField, bsedMap) : this.getboFilters(objIds, "bo", bsedMap);
        if (null != entityFilter) {
            DynamicObject[] dynArr;
            for (DynamicObject dyc : dynArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, entityFilter})) {
                Long orgId = 0L;
                if (fieldNameList.contains(this.mainEntityField)) {
                    Object orgDynData = dyc.get(this.mainEntityField);
                    if (orgDynData != null) {
                        orgId = orgDynData instanceof DynamicObject ? Long.valueOf(((DynamicObject)orgDynData).getLong("id")) : (Long)orgDynData;
                    }
                } else {
                    orgId = dyc.getLong("bo");
                }
                resultMap.put(orgId, dyc);
            }
        }
        return resultMap;
    }

    public List<DynamicObject> getEntityHistoryDatasBeforeTargetDate(String hisEntityNumber, List<Long> boList, Map<Long, Date> boTargetDateMap) {
        QFilter boFilter = new QFilter("bo", "in", boList);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        statusFilter.or(new QFilter("datastatus", "=", (Object)"0"));
        String fieldsNameString = HistoryEntityUtils.getFieldsNamesString(hisEntityNumber);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
        DynamicObject[] hisEntityDatas = serviceHelper.query(fieldsNameString, new QFilter[]{boFilter, statusFilter}, "bsed desc");
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        boList.forEach(bo -> {
            Date targetDate = (Date)boTargetDateMap.get(bo);
            for (DynamicObject hisEntityData : hisEntityDatas) {
                Long entityDataBo = hisEntityData.getLong("bo");
                Date bsed = hisEntityData.getDate("bsed");
                if (!entityDataBo.equals(bo) || targetDate.compareTo(bsed) < 0) continue;
                resultList.add(hisEntityData);
                break;
            }
        });
        return resultList;
    }

    public Map<Long, DynamicObject> getHistoryDatasByBoWithBsed(String hisEntityNumber, List<Long> boList, Map<Long, Date> bsedMap) {
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0", "2"});
        QFilter boFilters = null;
        for (Long bo : boList) {
            QFilter boFilter = new QFilter("bo", "=", (Object)bo);
            boFilter.and(new QFilter("bsed", "<=", (Object)bsedMap.get(bo)));
            boFilter.and(new QFilter("bsled", ">", (Object)bsedMap.get(bo)));
            if (boFilters == null) {
                boFilters = boFilter;
                continue;
            }
            boFilters.or(boFilter);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
        DynamicObject[] datas = serviceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, boFilters});
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>();
        Arrays.stream(datas).forEach(data -> {
            Long bo = data.getLong("bo");
            dataMap.put(bo, (DynamicObject)data);
        });
        return dataMap;
    }

    private QFilter getboFilters(List<Long> boList, String field, Map<Long, Date> bsedMap) {
        QFilter boFilters = null;
        for (Long bo : boList) {
            QFilter boFilter = new QFilter(field, "=", (Object)bo);
            boFilter.and(new QFilter("bsed", "<=", (Object)bsedMap.get(bo)));
            boFilter.and(new QFilter("bsled", ">", (Object)bsedMap.get(bo)));
            if (boFilters == null) {
                boFilters = boFilter;
                continue;
            }
            boFilters.or(boFilter);
        }
        return boFilters;
    }

    private String changeListToString(List<String> nameList) {
        String convertString = "";
        for (String name : nameList) {
            if (HRStringUtils.isEmpty((String)convertString)) {
                convertString = name;
                continue;
            }
            convertString = convertString + "," + name;
        }
        return convertString;
    }
}

