/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.CommonTimeSeqAttachService;
import kd.hr.hbp.business.history.service.IAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractAttachService
implements IAttachService {
    private static final Log logger = LogFactory.getLog(CommonTimeSeqAttachService.class);
    protected String prepareEffectDateFieldName;
    protected String prepareInvalidDateFieldName;
    protected String versionIdFieldName;
    protected HRBaseServiceHelper hisServiceHelper;
    protected HRBaseServiceHelper serviceHelper;

    public void initHistoryProp(String hisEntityNumber, String prepareEffectDateFieldName, String prepareInvalidDateFieldName, String versionIdFieldName) {
        this.serviceHelper = new HRBaseServiceHelper(this.getEntityNumber(hisEntityNumber));
        this.hisServiceHelper = new HRBaseServiceHelper(hisEntityNumber);
        this.prepareEffectDateFieldName = prepareEffectDateFieldName;
        this.prepareInvalidDateFieldName = prepareInvalidDateFieldName;
        this.versionIdFieldName = versionIdFieldName;
    }

    @Override
    public void batchAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchSaveAndEffectBoDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchDiscardBoDataHis(List<Long> eventIds) {
    }

    @Override
    public void batchDiscardDataHis(List<Long> eventIds) {
    }

    @Override
    public void batchEffectBoDataHis(List<Long> eventIds) {
    }

    @Override
    public void batchEffectDataHis(List<Long> eventIds) {
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchSaveNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchPhysicalDeletionDataHis(List<Long> boList, String mainEntityField) {
        List<String> hisFieldsNames = HistoryEntityUtils.getFieldsNameList(this.hisServiceHelper.getEntityName());
        String hisFieldName = "";
        hisFieldName = hisFieldsNames.contains(mainEntityField) ? mainEntityField : "bo";
        QFilter boFilter = new QFilter(hisFieldName, "in", boList);
        this.hisServiceHelper.deleteByFilter(new QFilter[]{boFilter});
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(this.serviceHelper.getEntityName());
        String fieldName = "";
        fieldName = fieldsNameList.contains(mainEntityField) ? mainEntityField : "id";
        QFilter idFilter = new QFilter(fieldName, "in", boList);
        this.serviceHelper.deleteByFilter(new QFilter[]{idFilter});
    }

    @Override
    public void batchLogicDeletionDataHis(List<Long> boList, String mainEntityField) {
        List<String> hisFieldsNameList = HistoryEntityUtils.getFieldsNameList(this.hisServiceHelper.getEntityName());
        String hisFieldName = "";
        hisFieldName = hisFieldsNameList.contains(mainEntityField) ? mainEntityField : "bo";
        QFilter boFilter = new QFilter(hisFieldName, "in", boList);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0"});
        DynamicObject[] dys = this.hisServiceHelper.query("datastatus", new QFilter[]{boFilter, statusFilter});
        Arrays.stream(dys).forEach(dyn -> dyn.set("datastatus", (Object)"-2"));
        this.hisServiceHelper.updateDatas(dys);
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(this.serviceHelper.getEntityName());
        String fieldName = "";
        fieldName = fieldsNameList.contains(mainEntityField) ? mainEntityField : "id";
        QFilter idFilter = new QFilter(fieldName, "in", boList);
        this.serviceHelper.deleteByFilter(new QFilter[]{idFilter});
    }

    protected void setHisField(DynamicObject hisDy, Date date) {
        if (hisDy.getDate("cedt") == null) {
            hisDy.set("cedt", (Object)date);
        }
        if (hisDy.getLong("lme") == 0L) {
            hisDy.set("lme", (Object)hisDy.getLong("ce"));
        }
        if (hisDy.getDate("lmedt") == null) {
            hisDy.set("lmedt", (Object)date);
        }
        hisDy.set("islastversion", (Object)"1");
        hisDy.set("datastatus", (Object)"0");
        if (hisDy.getDate("bsled") == null) {
            hisDy.set("bsled", (Object)this.getDefBsled());
        }
    }

    protected Date getDefBsled() {
        Date endDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            endDate = sdf.parse("2999-12-31");
        }
        catch (Exception e) {
            logger.error("Cast Date Format Fault");
        }
        return endDate;
    }

    protected void setSysField(DynamicObject hisDy, Date date) {
        this.setCreateField(hisDy, date);
        this.setModifyField(hisDy, date);
    }

    protected void setCreateField(DynamicObject hisDy, Date date) {
        if (hisDy.get("creator") == null) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            hisDy.set("creator", (Object)userId);
        }
        if (hisDy.getDate("createtime") == null) {
            hisDy.set("createtime", (Object)date);
        }
    }

    protected void setModifyField(DynamicObject hisDy, Date date) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        hisDy.set("modifier", (Object)userId);
        hisDy.set("modifytime", (Object)date);
    }

    protected void setActualField(DynamicObject hisDy, Date date) {
        if (hisDy.getDate("bred") == null) {
            hisDy.set("bred", (Object)date);
        }
        if (hisDy.getLong("bredt") == 0L) {
            hisDy.set("bredt", (Object)date.getTime());
        }
        if (hisDy.getDate("brled") == null) {
            hisDy.set("brled", (Object)this.getDefBsled());
        }
        if (hisDy.getLong("brledt") == 0L) {
            hisDy.set("brledt", (Object)HRBaseConstants.MAX_LOSEEFFECTDATETIME);
        }
    }

    protected List<String> getBizErrorInfo(List<DynamicObject> hisDyList) {
        return new ArrayList<String>();
    }

    protected List<Long> checkSEDataHisExists(List<DynamicObject> hisDyList) {
        QFilter schEffectFilter = new QFilter("datastatus", "=", (Object)"0");
        List boList = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDynamicFilter = new QFilter("bo", "in", boList);
        DynamicObjectCollection schDyColl = this.hisServiceHelper.queryOriginalCollection("bo", new QFilter[]{schEffectFilter, oldHisDynamicFilter});
        if (schDyColl == null || schDyColl.size() == 0) {
            return null;
        }
        return schDyColl.stream().map(hisDynamicObject -> hisDynamicObject.getLong("bo")).collect(Collectors.toList());
    }

    protected void checkPreparEffectDateBeforeEffectDataHis(DynamicObject[] hisDyArr) {
        Date newDate = new Date();
        List collect = Arrays.stream(hisDyArr).filter(hisDyn -> newDate.compareTo(hisDyn.getDate("bsed")) <= 0).map(hisDyn -> hisDyn.getLong("bo")).collect(Collectors.toList());
        if (collect != null && collect.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectBoDataHis checkPreparEffectDateBeforeEffectDataHis ERROR!");
            String boIdStr = StringUtils.join((Object[])collect.toArray(), (String)",");
            logger.error("bo in:" + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u665a\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u53ef\u751f\u6548\u3002", (String)"AbstractAttachService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    protected String getEntityNumber(String hisEntityNumber) {
        return HRStringUtils.substringBeforeLast((String)hisEntityNumber, (String)"his");
    }

    protected Long genHistoryObjectInfoId() {
        return ORM.create().genLongId(this.hisServiceHelper.getEntityName());
    }
}

