/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.history.service.CompositionAttachService;
import kd.hr.hbp.business.servicehelper.HRHistoryHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CompositionNonTimeSeqAttachService
extends CompositionAttachService {
    private static final Log logger = LogFactory.getLog(CompositionNonTimeSeqAttachService.class);
    private static final String EVENT_ID_IN_S_BO_IN_S = "eventId in:%s,bo in:%s";
    private static final String HRMP_HBP_BUSINESS = "hrmp-hbp-business";

    private String getCommonBoSeo() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5bo\u5f53\u524d\u8868\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CompositionNonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    @Override
    public void batchAddNewBoDataHis(List<DynamicObject> hisDynamicList) {
        this.beforeAddNewBoDataHis(hisDynamicList);
        String errorInfo = this.getErrorInfoByMulDy(hisDynamicList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        Date dateNow = new Date();
        hisDynamicList.forEach(hisDyn -> {
            this.setHisField((DynamicObject)hisDyn, dateNow);
            this.setSysField((DynamicObject)hisDyn, dateNow);
            hisDyn.set("isnewbo", (Object)"1");
        });
        this.hisServiceHelper.save(hisDynamicList.toArray(new DynamicObject[hisDynamicList.size()]));
    }

    @Override
    public void batchSaveAndEffectBoDataHis(List<DynamicObject> hisDynamicList) {
        this.beforeAddNewBoDataHis(hisDynamicList);
        String errInfo = this.getErrorInfoByMulDy(hisDynamicList);
        if (!HRStringUtils.isEmpty((String)errInfo)) {
            throw new KDBizException(errInfo);
        }
        Date dateCurr = new Date();
        hisDynamicList.forEach(hisDynamic -> {
            this.setHisField((DynamicObject)hisDynamic, dateCurr);
            this.setSysField((DynamicObject)hisDynamic, dateCurr);
            hisDynamic.set("ee", (Object)hisDynamic.getLong("ce"));
            hisDynamic.set("eedt", (Object)dateCurr);
            hisDynamic.set("bred", (Object)dateCurr);
            hisDynamic.set("bredt", (Object)dateCurr.getTime());
            hisDynamic.set("datastatus", (Object)"1");
            hisDynamic.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDynamic, dateCurr);
        });
        this.hisServiceHelper.save(hisDynamicList.toArray(new DynamicObject[hisDynamicList.size()]));
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        hisDynamicList.forEach(hisDy -> {
            DynamicObject currentDyn = this.genCurrentDynamicObject(this.serviceHelper.getEntityName(), (DynamicObject)hisDy);
            currentDyn.set("id", hisDy.get("bo"));
            currentCollection.add((Object)currentDyn);
        });
        if (this.isMainPart.booleanValue()) {
            this.serviceHelper.save(currentCollection);
        } else {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])currentCollection.toArray((Object[])new DynamicObject[currentCollection.size()])));
        }
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDynamicList) {
        String errorInfo = this.getErrorInfoByMulDy(hisDynamicList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List bos = hisDynamicList.stream().map(dynamic -> dynamic.getLong("bo")).collect(Collectors.toList());
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter oldHisDynamicFilter = new QFilter("bo", "in", bos);
        DynamicObject[] oldHisStatusArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{dataStatusFilter, oldHisDynamicFilter});
        Arrays.stream(oldHisStatusArray).forEach(dynamic -> dynamic.set("islastversion", (Object)false));
        this.hisServiceHelper.update(oldHisStatusArray);
        Date currDate = new Date();
        hisDynamicList.forEach(dynamic -> {
            this.setHisField((DynamicObject)dynamic, currDate);
            this.setSysField((DynamicObject)dynamic, currDate);
            dynamic.set("isnewbo", (Object)false);
        });
        this.hisServiceHelper.save(hisDynamicList.toArray(new DynamicObject[hisDynamicList.size()]));
    }

    @Override
    public void batchDiscardBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, newHisDyFilter});
        Arrays.stream(newHisDyArr).forEach(dy -> dy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
    }

    @Override
    public void batchDiscardDataHis(List<Long> eventIds) {
        QFilter newHisDynFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)false);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDynFilter, boFilter});
        Arrays.stream(newHisDyArr).forEach(dyn -> dyn.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
        List bos = Arrays.stream(newHisDyArr).map(dyn -> dyn.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDynFilter = new QFilter("bo", "in", bos);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] oldHisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDynFilter, statusFilter});
        Arrays.stream(oldHisDynArr).forEach(dyn -> dyn.set("islastversion", (Object)true));
        this.hisServiceHelper.update(oldHisDynArr);
    }

    @Override
    public void batchSaveNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewBoDataHis(hisDyList);
        String nonErrorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)nonErrorInfo)) {
            throw new KDBizException(nonErrorInfo);
        }
        Date nonDateNow = new Date();
        hisDyList.forEach(hisDyn -> {
            this.setHisField((DynamicObject)hisDyn, nonDateNow);
            this.setSysField((DynamicObject)hisDyn, nonDateNow);
            hisDyn.set("isnewbo", (Object)true);
            hisDyn.set("datastatus", (Object)"3");
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[0]));
    }

    @Override
    public void batchEffectBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        newHisDyFilter.and(boFilter);
        QFilter filter = new QFilter("datastatus", "in", (Object)new String[]{"0", "3"});
        newHisDyFilter.and(filter);
        DynamicObject[] newHistoryDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHistoryDyArr == null || newHistoryDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectBoDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId is:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u751f\u6548\u7684\u65b0bo\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_9", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkPreparEffectDateBeforeEffectDataHis(newHistoryDyArr);
        Date dateNow = new Date();
        Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
            newHisDyn.set("ee", (Object)newHisDyn.getLong("ce"));
            newHisDyn.set("eedt", (Object)dateNow);
            newHisDyn.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)newHisDyn, dateNow);
        });
        this.hisServiceHelper.update(newHistoryDyArr);
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        if (this.isMainPart.booleanValue()) {
            Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
                long bo = newHisDyn.getLong("bo");
                DynamicObject currentDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), newHisDyn);
                currentDy.set("id", (Object)bo);
                currentCollection.add((Object)currentDy);
            });
            this.serviceHelper.save(currentCollection);
        } else {
            this.updateCurrent(newHistoryDyArr, currentCollection);
        }
    }

    private void updateCurrent(DynamicObject[] newHistoryDyArr, DynamicObjectCollection currentCollection) {
        List idList = Arrays.stream(newHistoryDyArr).map(dyn -> dyn.getLong("bo")).collect(Collectors.toList());
        DynamicObject[] currentDyn = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idList)});
        Map<Long, DynamicObject> currentDynList = Arrays.stream(currentDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
            long bo = newHisDyn.getLong("bo");
            DynamicObject currDyn = (DynamicObject)currentDynList.get(bo);
            Set<String> ignoreKeysSet = this.getIgnoreKeysSet();
            Map<String, String> transKeyMap = this.getTransKeyMap();
            HRDynamicObjectUtils.copy((DynamicObject)newHisDyn, (DynamicObject)currDyn, ignoreKeysSet, transKeyMap);
            currentCollection.add((Object)currDyn);
        });
        this.serviceHelper.update((DynamicObject[])currentCollection.toArray((Object[])new DynamicObject[currentCollection.size()]));
    }

    @Override
    public void batchEffectDataHis(List<Long> eventIdList) {
        QFilter dataStatusFilter;
        QFilter newHisDynFilter = new QFilter("ce", "in", eventIdList);
        QFilter boFieldFilter = new QFilter("isnewbo", "=", (Object)false);
        newHisDynFilter.and(boFieldFilter);
        QFilter seFieldFilter = HRHistoryHelper.getScheduleEffectHisFilter();
        newHisDynFilter.and(seFieldFilter);
        DynamicObject[] newHisDynArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDynFilter, boFieldFilter});
        if (!(this.isMainPart.booleanValue() || newHisDynArray != null && newHisDynArray.length != 0)) {
            return;
        }
        Map<Long, Long> boCeNewHisDyMap = Arrays.stream(newHisDynArray).collect(Collectors.toMap(newHisDyna -> newHisDyna.getLong("bo"), newHisDyna -> newHisDyna.getLong("ce")));
        List<Long> boList = Arrays.stream(newHisDynArray).map(dy -> dy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        DynamicObject[] oldHisDynamics = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter, dataStatusFilter = new QFilter("datastatus", "=", (Object)"1")});
        if (oldHisDynamics == null || oldHisDynamics.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String boIdMsg = StringUtils.join((Object[])boList.toArray(), (String)",");
            String ceMsg = StringUtils.join((Object[])eventIdList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IN_S_BO_IN_S, ceMsg, boIdMsg));
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonNonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkBoList(boList, oldHisDynamics, "bo", ResManager.loadKDString((String)"\u8be5bo\u5931\u6548\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonNonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        QFilter idFilter = new QFilter("id", "in", boList);
        DynamicObject[] currentDyns = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDyns == null || currentDyns.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String ceInfoMsg = StringUtils.join((Object[])eventIdList.toArray(), (String)",");
            String boIdInfoMsg = StringUtils.join((Object[])boList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IN_S_BO_IN_S, ceInfoMsg, boIdInfoMsg));
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(boList, currentDyns, "id", this.getCommonBoSeo());
        Arrays.stream(oldHisDynamics).forEach(dy -> {
            long bo = dy.getLong("bo");
            dy.set("lde", boCeNewHisDyMap.get(bo));
            dy.set("datastatus", (Object)"-2");
        });
        this.hisServiceHelper.update(oldHisDynamics);
        this.updateNewHisDynArray(newHisDynArray);
        this.updateCurrentDyns(newHisDynArray, currentDyns);
    }

    private void updateNewHisDynArray(DynamicObject[] newHisDynArray) {
        Date currDate = new Date();
        Arrays.stream(newHisDynArray).forEach(dy -> {
            dy.set("ee", (Object)dy.getLong("ce"));
            dy.set("eedt", (Object)currDate);
            dy.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)dy, currDate);
        });
        this.hisServiceHelper.update(newHisDynArray);
    }

    private void updateCurrentDyns(DynamicObject[] newHistoryDyArr, DynamicObject[] currentDyn) {
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        Map<Long, DynamicObject> currentDynList = Arrays.stream(currentDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
            long bo = newHisDyn.getLong("bo");
            DynamicObject currDyn = (DynamicObject)currentDynList.get(bo);
            Set<String> ignoreKeysSet = this.getIgnoreKeysSet();
            Map<String, String> transKeyMap = this.getTransKeyMap();
            HRDynamicObjectUtils.copy((DynamicObject)newHisDyn, (DynamicObject)currDyn, ignoreKeysSet, transKeyMap);
            currentCollection.add((Object)currDyn);
        });
        this.serviceHelper.update((DynamicObject[])currentCollection.toArray((Object[])new DynamicObject[currentCollection.size()]));
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDynamicList) {
        String errorInfo = this.getErrorInfoByMulDy(hisDynamicList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List<Long> schBoList = this.checkSEDataHisExists(hisDynamicList);
        if (schBoList != null && schBoList.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoList.toArray(), (String)",");
            logger.error("bo in:" + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonNonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> boList = hisDynamicList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDynamicArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        List hisDyCe = hisDynamicList.stream().map(hisDy -> hisDy.getLong("ce")).collect(Collectors.toList());
        if (oldHisDynamicArr == null || oldHisDynamicArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            String ceStr = StringUtils.join((Object[])hisDyCe.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IN_S_BO_IN_S, ceStr, boIdStr));
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonNonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkBoList(boList, oldHisDynamicArr, "bo", ResManager.loadKDString((String)"\u8be5bo\u5931\u6548\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonNonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        QFilter idFilter = new QFilter("id", "in", boList);
        DynamicObject[] currentDynamicArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDynamicArr == null || currentDynamicArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String ceStr = StringUtils.join((Object[])hisDyCe.toArray(), (String)",");
            String boIdStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IN_S_BO_IN_S, ceStr, boIdStr));
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(boList, currentDynamicArr, "id", this.getCommonBoSeo());
        Date currDate = this.updateOldHisDynamicArr(hisDynamicList, oldHisDynamicArr);
        this.updateHisDynList(hisDynamicList, currDate);
        this.updateCurrentDynamicArr(hisDynamicList, currentDynamicArr);
    }

    @NotNull
    private Date updateOldHisDynamicArr(List<DynamicObject> hisDynamicList, DynamicObject[] oldHisDynamicArr) {
        Map<Long, Long> hisDynamicBoCeMap = hisDynamicList.stream().collect(Collectors.toMap(hisDynamic -> hisDynamic.getLong("bo"), hisDynamic -> hisDynamic.getLong("ce")));
        Date currDate = new Date();
        Arrays.stream(oldHisDynamicArr).forEach(oldHisDynamic -> {
            long boId = oldHisDynamic.getLong("bo");
            oldHisDynamic.set("lme", hisDynamicBoCeMap.get(boId));
            oldHisDynamic.set("lmedt", (Object)currDate);
            oldHisDynamic.set("lde", hisDynamicBoCeMap.get(boId));
            oldHisDynamic.set("datastatus", (Object)"-2");
        });
        this.hisServiceHelper.update(oldHisDynamicArr);
        return currDate;
    }

    private void updateHisDynList(List<DynamicObject> hisDynamicList, Date currDate) {
        hisDynamicList.forEach(hisDynamic -> {
            this.setHisField((DynamicObject)hisDynamic, currDate);
            this.setSysField((DynamicObject)hisDynamic, currDate);
            hisDynamic.set("isnewbo", (Object)"0");
            hisDynamic.set("ee", hisDynamic.get("ce"));
            hisDynamic.set("eedt", (Object)currDate);
            hisDynamic.set("datastatus", (Object)"1");
            hisDynamic.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDynamic, currDate);
        });
        this.hisServiceHelper.save(hisDynamicList.toArray(new DynamicObject[hisDynamicList.size()]));
    }

    private void updateCurrentDynamicArr(List<DynamicObject> hisDynamicList, DynamicObject[] currentDynamicArr) {
        Map hisDynBoMap = hisDynamicList.stream().collect(Collectors.toMap(hisDy -> hisDy.getLong("bo"), Function.identity()));
        Arrays.stream(currentDynamicArr).forEach(currentDynamic -> {
            long currentId = currentDynamic.getLong("id");
            HRHistoryHelper.updateCurrentDynamicObject((DynamicObject)hisDynBoMap.get(currentId), currentDynamic, this.versionIdFieldName);
            currentDynamic.set("id", (Object)currentId);
        });
        this.serviceHelper.update(currentDynamicArr);
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDyList) {
        this.batchSaveAndEffectDataHis(hisDyList);
    }

    private void checkBoList(List<Long> oldBoList, DynamicObject[] currentDynamics, String fieldName, String errorMsg) {
        List currentIdList = Arrays.stream(currentDynamics).map(currentDynamic -> currentDynamic.getLong(fieldName)).collect(Collectors.toList());
        List diffIdAndBo = oldBoList.stream().filter(bo -> !currentIdList.contains(bo)).collect(Collectors.toList());
        if (diffIdAndBo != null && diffIdAndBo.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " checkBoList currentDyArr ERROR!");
            String boIdString = StringUtils.join((Object[])diffIdAndBo.toArray(), (String)",");
            logger.error("bo in:" + boIdString);
            throw new KDBizException(errorMsg);
        }
    }

    protected String getErrorInfoByMulDy(List<DynamicObject> dynamicObjectList) {
        ArrayList<String> errorInfoList = new ArrayList<String>();
        if (dynamicObjectList == null || dynamicObjectList.size() == 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        } else {
            this.validateHisDyList(dynamicObjectList, errorInfoList);
            List repeatDatas = dynamicObjectList.stream().map(dy -> dy.getDynamicObjectType().getName()).distinct().collect(Collectors.toList());
            if (repeatDatas.size() != 1) {
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u5386\u53f2\u6570\u636e\u5fc5\u987b\u6765\u81ea\u540c\u4e00\u5b9e\u4f53\uff01", (String)"CommonTimeSeqAttachService_4", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
        }
        StringBuilder errorMessage = new StringBuilder();
        List<String> bizErrorInfoList = this.getBizErrorInfo(dynamicObjectList);
        if (bizErrorInfoList != null && bizErrorInfoList.size() > 0) {
            errorInfoList.addAll(bizErrorInfoList);
        }
        if (errorInfoList.size() > 0) {
            int size = errorInfoList.size();
            for (int i = 0; i < size; ++i) {
                errorMessage.append("(").append(i).append(")").append((String)errorInfoList.get(i)).append(System.lineSeparator());
            }
        }
        return errorMessage.toString();
    }

    private void validateHisDyList(List<DynamicObject> hisDynamicObjList, List<String> errMsgList) {
        for (DynamicObject hisDyObj : hisDynamicObjList) {
            if (hisDyObj.getLong("bo") == 0L) {
                errMsgList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u5bf9\u5e94\u7684\u4e1a\u52a1\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if (hisDyObj.getLong("ce") != 0L) continue;
            errMsgList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u521b\u5efa\u4e8b\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            break;
        }
    }

    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void beforeAddNewDataHis(List<DynamicObject> hisDyList) {
    }
}

