/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.history.helper.OrgHistoryHelper;
import kd.hr.hbp.business.history.service.CompositionAttachService;
import kd.hr.hbp.business.servicehelper.HRHistoryHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CompositionTimeSeqAttachService
extends CompositionAttachService {
    private static final Log logger = LogFactory.getLog(CompositionTimeSeqAttachService.class);
    private static final String HRMP_HBP_BUSINESS = "hrmp-hbp-business";
    private static final String BRLED = "brled";
    private static final String BRLEDT = "brledt";
    private static final String EVENT_ID_IN = "eventId in:";
    private static final String BO_IS = "bo is:";
    private static final String BO_IN = "bo in:";
    private static final String EVENT_ID_IS_S_BO_IS_S = "eventId is:%s,bo is:%s";

    private String getBoDataNotExist() {
        return ResManager.loadKDString((String)"\u8be5bo\u65e7\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CompositionTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    private String getCommonBoSeo() {
        return ResManager.loadKDString((String)"\u65b0\u589e\u7ba1\u7406\u5458\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u653e\u5f03\u4fdd\u5b58\uff1f", (String)"CompositionTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    @Override
    public void batchAddNewBoDataHis(List<DynamicObject> list) {
        this.beforeAddNewBoDataHis(list);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(list);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        Date dateNow = new Date();
        list.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)"1");
        });
        this.hisServiceHelper.save(list.toArray(new DynamicObject[list.size()]));
        this.afterAddNewBoDataHis(list);
    }

    @Override
    public void batchSaveNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewBoDataHis(hisDyList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        Date now = new Date();
        hisDyList.forEach(object -> {
            this.setHisField((DynamicObject)object, now);
            this.setSysField((DynamicObject)object, now);
            object.set("isnewbo", (Object)"1");
            object.set("datastatus", (Object)"3");
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
        this.afterAddNewBoDataHis(hisDyList);
    }

    @Override
    public void batchUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeUpdateNewBoDataHis(hisDyList);
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[0]));
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        HashMap boHisDyMap = Maps.newHashMapWithExpectedSize((int)hisDyList.size());
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            boHisDyMap.put(bo, hisDyn);
            boList.add(bo);
        });
        QFilter idFilter = new QFilter("id", "in", (Object)boList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        Arrays.stream(currentDyArr).forEach(currentDy -> {
            long id = currentDy.getLong("id");
            DynamicObject hisDy = (DynamicObject)boHisDyMap.get(id);
            DynamicObject newDy = this.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy);
            HRDynamicObjectUtils.copy((DynamicObject)newDy, (DynamicObject)currentDy);
            currentDy.set("id", (Object)id);
        });
        this.serviceHelper.save(currentDyArr);
    }

    @Override
    public void batchSaveAndEffectBoDataHis(List<DynamicObject> hisDynList) {
        this.beforeAddNewBoDataHis(hisDynList);
        String errorInfo = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        this.checkPreparEffectDateBeforeEffectDataHis(hisDynList.toArray(new DynamicObject[0]));
        Date dateNow = new Date();
        hisDynList.forEach(hisDyn -> {
            this.setHisField((DynamicObject)hisDyn, dateNow);
            this.setSysField((DynamicObject)hisDyn, dateNow);
            hisDyn.set("isnewbo", (Object)"1");
            hisDyn.set("ee", (Object)hisDyn.getLong("ce"));
            hisDyn.set("eedt", (Object)dateNow);
            hisDyn.set("bred", (Object)dateNow);
            hisDyn.set("bredt", (Object)dateNow.getTime());
            hisDyn.set("datastatus", (Object)"1");
            hisDyn.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDyn, dateNow);
        });
        this.hisServiceHelper.save(hisDynList.toArray(new DynamicObject[hisDynList.size()]));
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        hisDynList.forEach(hisDy -> {
            DynamicObject currentDy = this.genCurrentDynamicObject(this.serviceHelper.getEntityName(), (DynamicObject)hisDy);
            currentDy.set("id", hisDy.get("bo"));
            currentCollection.add((Object)currentDy);
        });
        if (this.isMainPart.booleanValue()) {
            this.serviceHelper.save(currentCollection);
        } else {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])currentCollection.toArray((Object[])new DynamicObject[currentCollection.size()])));
        }
        this.afterSaveAndEffectBoDataHis(hisDynList);
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDyList) {
        this.beforeSaveAndEffectDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        this.saveAndEffectDataHis(hisDyList, "-1", true);
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List<Long> schBoLists = this.checkSEDataHisExists(hisDyList);
        if (schBoLists != null && schBoLists.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchAddNewDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoLists.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonTimeSeqAttachService_5", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List boLists = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDynFilter = new QFilter("bo", "in", boLists);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDynFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDynFilter});
        if (oldHisDynArr == null || oldHisDynArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchAddNewDataHis oldHisDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])boLists.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(this.getBoDataNotExist());
        }
        Arrays.stream(oldHisDynArr).forEach(oldHisDy -> oldHisDy.set("islastversion", (Object)false));
        this.hisServiceHelper.update(oldHisDynArr);
        Date dateNow = new Date();
        hisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)false);
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
        this.afterAddNewDataHis(hisDyList);
    }

    @Override
    public void batchDiscardBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        newHisDyFilter.and(boFilter);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            if (this.isMainPart.booleanValue()) {
                logger.error("{} batchDiscardBoDataHis newHisDyArr ERROR! event_id_in:{}", (Object)this.hisServiceHelper.getEntityName(), (Object)eventStr);
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5e9f\u5f03\u7684\u65b0bo\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_7", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
            logger.info("{} batchDiscardBoDataHis newHisDyArr no new bo discarded version! event_id_in:{}", (Object)this.hisServiceHelper.getEntityName(), (Object)eventStr);
            return;
        }
        Arrays.stream(newHisDyArr).forEach(newHisDy -> newHisDy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
        this.afterDiscardBoDataHis(eventIds);
    }

    @Override
    public void batchDiscardDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)false);
        newHisDyFilter.and(boFilter);
        DynamicObject[] newHisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHisDynArr == null || newHisDynArr.length == 0) {
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            if (this.isMainPart.booleanValue()) {
                logger.error("{} batchDiscardDataHis newHisDyArr ERROR! event_id_in:{}", (Object)this.hisServiceHelper.getEntityName(), (Object)eventStr);
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5e9f\u5f03\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_8", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
            logger.info("{} batchDiscardDataHis newHisDyArr no new bo discarded version! event_id_in:{}", (Object)this.hisServiceHelper.getEntityName(), (Object)eventStr);
            return;
        }
        Arrays.stream(newHisDynArr).forEach(newHisDy -> newHisDy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDynArr);
        List boList = Arrays.stream(newHisDynArr).map(newHisDyn -> newHisDyn.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDynFilter = new QFilter("bo", "in", boList);
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDynFilter.and(datastatusFilter);
        DynamicObject[] oldHisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDynFilter});
        if (oldHisDynArr == null || oldHisDynArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchDiscardDataHis oldHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String boStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            logger.error(EVENT_ID_IN + eventStr + ",bo in:" + boStr);
            throw new KDBizException(this.getBoDataNotExist());
        }
        Arrays.stream(oldHisDynArr).forEach(oldHisDy -> oldHisDy.set("isnewbo", (Object)true));
        this.hisServiceHelper.update(oldHisDynArr);
        this.afterDiscardDataHis(eventIds);
    }

    @Override
    public void batchEffectBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        newHisDyFilter.and(boFilter);
        QFilter filter = new QFilter("datastatus", "in", (Object)new String[]{"0", "3"});
        newHisDyFilter.and(filter);
        DynamicObject[] newHistoryDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHistoryDyArr == null || newHistoryDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectBoDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId is:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u751f\u6548\u7684\u65b0bo\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_9", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkPreparEffectDateBeforeEffectDataHis(newHistoryDyArr);
        this.beforeEffectBoDataHis(newHistoryDyArr);
        Date dateNow = new Date();
        Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
            newHisDyn.set("ee", (Object)newHisDyn.getLong("ce"));
            newHisDyn.set("eedt", (Object)dateNow);
            newHisDyn.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)newHisDyn, dateNow);
        });
        this.hisServiceHelper.update(newHistoryDyArr);
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        if (this.isMainPart.booleanValue()) {
            Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
                long bo = newHisDyn.getLong("bo");
                DynamicObject currentDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), newHisDyn);
                currentDy.set("id", (Object)bo);
                currentCollection.add((Object)currentDy);
            });
            this.serviceHelper.save(currentCollection);
        } else {
            this.updateCurrent(newHistoryDyArr, currentCollection);
        }
        this.afterEffectBoDataHis(eventIds);
    }

    private void updateCurrent(DynamicObject[] newHistoryDyArr, DynamicObjectCollection currentCollection) {
        List idList = Arrays.stream(newHistoryDyArr).map(dyn -> dyn.getLong("bo")).collect(Collectors.toList());
        DynamicObject[] currentDyn = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idList)});
        Map<Long, DynamicObject> currentDynList = Arrays.stream(currentDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        Arrays.stream(newHistoryDyArr).forEach(newHisDyn -> {
            long bo = newHisDyn.getLong("bo");
            DynamicObject currDyn = (DynamicObject)currentDynList.get(bo);
            Set<String> ignoreKeysSet = this.getIgnoreKeysSet();
            Map<String, String> transKeyMap = this.getTransKeyMap();
            HRDynamicObjectUtils.copy((DynamicObject)newHisDyn, (DynamicObject)currDyn, ignoreKeysSet, transKeyMap);
            currentCollection.add((Object)currDyn);
        });
        this.serviceHelper.update((DynamicObject[])currentCollection.toArray((Object[])new DynamicObject[currentCollection.size()]));
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
        this.beforeSaveAndEffectDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        ArrayList<Long> boLists = new ArrayList<Long>();
        HashMap<Long, Date> bsedMap = new HashMap<Long, Date>();
        HashMap<Long, List> hisDynMap = new HashMap<Long, List>();
        hisDyList.forEach(dynamicObject -> {
            Long bo = dynamicObject.getLong("bo");
            Date date = dynamicObject.getDate("bsed");
            boLists.add(bo);
            bsedMap.put(bo, date);
            List dynList = (List)hisDynMap.get(bo);
            if (dynList == null) {
                dynList = Lists.newArrayListWithExpectedSize((int)16);
            }
            dynList.add(dynamicObject);
            hisDynMap.put(bo, dynList);
        });
        OrgHistoryHelper orgHistoryHelper = new OrgHistoryHelper(null, null);
        Map<Long, DynamicObject> dynMap = orgHistoryHelper.getHistoryDatasByBoWithBsed(this.hisServiceHelper.getEntityName(), boLists, bsedMap);
        ArrayList<DynamicObject> savaAndNewDataHistoryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> modifyDataHistoryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> modifyNewBoDataHistoryList = new ArrayList<DynamicObject>();
        hisDynMap.forEach((bo, dynList) -> {
            DynamicObject oldDyn = (DynamicObject)dynMap.get(bo);
            if (oldDyn != null) {
                dynList.forEach(dyn -> {
                    Date oldBsed = oldDyn.getDate("bsed");
                    Date bsed = dyn.getDate("bsed");
                    Long oldBsedTime = oldBsed.getTime();
                    Long bsedTime = bsed.getTime();
                    if (HRStringUtils.equals((String)"1", (String)oldDyn.getString("datastatus")) && !oldBsedTime.equals(bsedTime)) {
                        savaAndNewDataHistoryList.add((DynamicObject)dyn);
                    } else {
                        modifyDataHistoryList.add((DynamicObject)dyn);
                    }
                });
            } else {
                modifyNewBoDataHistoryList.addAll((Collection)hisDynMap.get(bo));
            }
        });
        this.handlerData(dynMap, savaAndNewDataHistoryList, modifyDataHistoryList, modifyNewBoDataHistoryList);
    }

    private void handlerData(Map<Long, DynamicObject> dynMap, List<DynamicObject> savaAndNewDataHistoryList, List<DynamicObject> modifyDataHistoryList, List<DynamicObject> modifyNewBoDataHistoryList) {
        if (savaAndNewDataHistoryList.size() > 0) {
            this.saveAndEffectDataHis(savaAndNewDataHistoryList, "2", false);
        }
        if (modifyDataHistoryList.size() > 0) {
            this.modifyDataHis(modifyDataHistoryList, dynMap);
        }
        if (modifyNewBoDataHistoryList.size() > 0) {
            this.modifyNewBoDataHis(modifyNewBoDataHistoryList);
        }
    }

    private void saveAndEffectDataHis(List<DynamicObject> hisDyList, String operate, boolean isCheckScheduleEffect) {
        List<Long> schBoList = this.checkSEDataHisExists(hisDyList);
        this.checkPreparEffectDateBeforeEffectDataHis(hisDyList.toArray(new DynamicObject[0]));
        if (schBoList != null && schBoList.size() > 0 && isCheckScheduleEffect) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoList.toArray(), (String)",");
            logger.error(BO_IS + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonTimeSeqAttachService_5", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> oldBoList = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", oldBoList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        this.validateOldHisDyArr(oldBoList, oldHisDyArr);
        this.checkBoList(oldBoList, oldHisDyArr, "bo", this.getBoDataNotExist());
        this.beforeLoseEffectDataHis(oldHisDyArr);
        Map<Long, DynamicObject> boHisDyMap = hisDyList.stream().collect(Collectors.toMap(hisDy -> hisDy.getLong("bo"), Function.identity()));
        QFilter idFilter = new QFilter("id", "in", oldBoList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDyArr == null || currentDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.error(BO_IS + oldBoStr);
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(oldBoList, currentDyArr, "id", this.getCommonBoSeo());
        Date now = new Date();
        Map<Long, Long> boCeNewHisDyMap = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), newHisDy -> newHisDy.getLong("ce")));
        this.updateOldHisDyArr(operate, oldHisDyArr, boHisDyMap, now, boCeNewHisDyMap);
        this.updateDy(hisDyList, boHisDyMap, currentDyArr, now);
        this.afterSaveAndEffectDataHis(hisDyList);
    }

    private void updateOldHisDyArr(String operate, DynamicObject[] oldHisDyArr, Map<Long, DynamicObject> boHisDyMap, Date now, Map<Long, Long> boCeNewHisDyMap) {
        for (DynamicObject oldHisDyn : oldHisDyArr) {
            long bo = oldHisDyn.getLong("bo");
            DynamicObject hisDy = boHisDyMap.get(bo);
            Date newBsed = hisDy.getDate("bsed");
            long eventId = hisDy.getLong("ce");
            oldHisDyn.set("lme", (Object)boCeNewHisDyMap.get(oldHisDyn.getLong("bo")));
            oldHisDyn.set("lmedt", (Object)now);
            if (HRStringUtils.equals((String)operate, (String)"2")) {
                this.setInvalidDynamicObject(oldHisDyn, eventId, newBsed, now);
            } else if (HRStringUtils.equals((String)operate, (String)"-1")) {
                this.setDiscardDynamicObject(oldHisDyn, eventId, newBsed, now);
            }
            this.setModifyField(oldHisDyn, now);
        }
        this.hisServiceHelper.update(oldHisDyArr);
    }

    private void updateDy(List<DynamicObject> hisDyList, Map<Long, DynamicObject> boHisDyMap, DynamicObject[] currentDyArr, Date now) {
        for (DynamicObject hisDyn : hisDyList) {
            this.setHisField(hisDyn, now);
            this.setSysField(hisDyn, now);
            hisDyn.set("isnewbo", (Object)"0");
            hisDyn.set("ee", (Object)hisDyn.getLong("ce"));
            hisDyn.set("eedt", (Object)now);
            hisDyn.set("id", (Object)this.genHistoryObjectInfoId());
            hisDyn.set("datastatus", (Object)"1");
            this.setActualField(hisDyn, now);
        }
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
        Arrays.stream(currentDyArr).forEach(currentDy -> {
            long id = currentDy.getLong("id");
            DynamicObject hisDy = (DynamicObject)boHisDyMap.get(id);
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)currentDy, this.getIgnoreKeysSet(), this.getTransKeyMap());
            currentDy.set("id", (Object)id);
        });
        this.serviceHelper.update(currentDyArr);
    }

    private void validateOldHisDyArr(List<Long> oldBoList, DynamicObject[] oldHisDyArr) {
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.error(BO_IS + oldBoStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_12", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void setInvalidDynamicObject(DynamicObject dynamicObject, Long eventId, Date bsled, Date date) {
        dynamicObject.set("lee", (Object)eventId);
        dynamicObject.set("leedt", (Object)date);
        dynamicObject.set("bsled", (Object)bsled);
        dynamicObject.set(BRLED, (Object)date);
        dynamicObject.set(BRLEDT, (Object)System.currentTimeMillis());
        dynamicObject.set("datastatus", (Object)"2");
    }

    private void setDiscardDynamicObject(DynamicObject dynamicObject, Long eventId, Date bsled, Date date) {
        dynamicObject.set("de", (Object)eventId);
        dynamicObject.set("dedt", (Object)date);
        dynamicObject.set("datastatus", (Object)"-1");
    }

    private void modifyDataHis(List<DynamicObject> modifyDataHisList, Map<Long, DynamicObject> oldHisDynMap) {
        ArrayList<DynamicObject> oldHisDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> oldHisDynCopyList = new ArrayList<DynamicObject>();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.hisServiceHelper.getEntityName());
        Date now = new Date();
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)modifyDataHisList.size());
        HashMap newDynMap = Maps.newHashMapWithExpectedSize((int)modifyDataHisList.size());
        HashSet ignoreSet = Sets.newHashSetWithExpectedSize((int)3);
        ignoreSet.add("creator");
        ignoreSet.add("createtime");
        this.setModifyData(modifyDataHisList, oldHisDynMap, oldHisDynList, oldHisDynCopyList, mainEntityType, now, boList, newDynMap, ignoreSet);
        this.hisServiceHelper.save(oldHisDynCopyList.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(oldHisDynList.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(modifyDataHisList.toArray(new DynamicObject[0]));
        QFilter idFilter = new QFilter("id", "in", (Object)boList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (boList.size() > 0 && (currentDyArr == null || currentDyArr.length == 0)) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String oldBoStr = StringUtils.join((Iterable)boList, (String)",");
            logger.error(BO_IS + oldBoStr);
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(boList, currentDyArr, "id", this.getCommonBoSeo());
        List<DynamicObject> modifyDynList = this.updateCurrentDyArr(newDynMap, currentDyArr);
        this.afterSaveAndEffectDataHis(modifyDynList);
    }

    private void setModifyData(List<DynamicObject> modifyDataHisList, Map<Long, DynamicObject> oldHisDynMap, List<DynamicObject> oldHisDynList, List<DynamicObject> oldHisDynCopyList, MainEntityType mainEntityType, Date now, List<Long> boList, Map<Long, DynamicObject> newDynMap, Set<String> ignoreSet) {
        modifyDataHisList.forEach(modifyDataHistory -> {
            Long bsedTime;
            Long bo = modifyDataHistory.getLong("bo");
            Long ce = modifyDataHistory.getLong("ce");
            Date bsed = modifyDataHistory.getDate("bsed");
            DynamicObject oldHisDy = (DynamicObject)oldHisDynMap.get(bo);
            Date oldBsled = oldHisDy.getDate("bsled");
            Date oldBsed = oldHisDy.getDate("bsed");
            Long lee = oldHisDy.getLong("lee");
            Date leeDt = oldHisDy.getDate("leedt");
            String status = oldHisDy.getString("datastatus");
            Long oldBsedTime = oldBsed.getTime();
            if (!oldBsedTime.equals(bsedTime = Long.valueOf(bsed.getTime()))) {
                DynamicObject oldHisDyCopy = new DynamicObject((DynamicObjectType)mainEntityType);
                HRDynamicObjectUtils.copy((DynamicObject)oldHisDy, (DynamicObject)oldHisDyCopy, (Set)ignoreSet);
                oldHisDyCopy.set("lme", (Object)ce);
                oldHisDyCopy.set("bsled", (Object)bsed);
                this.setSysField(oldHisDyCopy, now);
                oldHisDynCopyList.add(oldHisDyCopy);
            }
            oldHisDy.set("datastatus", (Object)"-2");
            oldHisDy.set("lme", (Object)ce);
            this.setModifyField(oldHisDy, now);
            oldHisDynList.add(oldHisDy);
            this.setHisField((DynamicObject)modifyDataHistory, now);
            this.setSysField((DynamicObject)modifyDataHistory, now);
            this.setActualField((DynamicObject)modifyDataHistory, now);
            modifyDataHistory.set("bsled", (Object)oldBsled);
            modifyDataHistory.set("lee", (Object)lee);
            modifyDataHistory.set("leedt", (Object)leeDt);
            modifyDataHistory.set("datastatus", (Object)status);
            modifyDataHistory.set(BRLED, oldHisDy.get(BRLED));
            modifyDataHistory.set(BRLEDT, oldHisDy.get(BRLEDT));
            modifyDataHistory.set("ee", (Object)oldHisDy.getLong("ce"));
            modifyDataHistory.set("eedt", (Object)now);
            if (oldBsedTime.equals(bsedTime)) {
                modifyDataHistory.set("isnewbo", oldHisDy.get("isnewbo"));
            } else {
                modifyDataHistory.set("isnewbo", (Object)false);
            }
            if (HRStringUtils.equals((String)"1", (String)status)) {
                boList.add(bo);
                newDynMap.put(bo, (DynamicObject)modifyDataHistory);
            }
        });
    }

    @NotNull
    private List<DynamicObject> updateCurrentDyArr(Map<Long, DynamicObject> newDynMap, DynamicObject[] currentDyArr) {
        ArrayList<DynamicObject> modifyDynList = new ArrayList<DynamicObject>();
        Arrays.stream(currentDyArr).forEach(currentDy -> {
            long id = currentDy.getLong("id");
            DynamicObject hisDy = (DynamicObject)newDynMap.get(id);
            modifyDynList.add(hisDy);
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)currentDy, this.getIgnoreKeysSet(), this.getTransKeyMap());
            currentDy.set("id", (Object)id);
        });
        this.serviceHelper.update(currentDyArr);
        return modifyDynList;
    }

    protected void modifyNewBoDataHis(List<DynamicObject> modifyNewBoDataHisList) {
        if (modifyNewBoDataHisList == null || modifyNewBoDataHisList.isEmpty()) {
            return;
        }
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)modifyNewBoDataHisList.size());
        HashMap dataHisMap = Maps.newHashMapWithExpectedSize((int)modifyNewBoDataHisList.size());
        modifyNewBoDataHisList.forEach(modifyNewBoData -> {
            Long bo = modifyNewBoData.getLong("bo");
            boList.add(bo);
            dataHisMap.put(bo, modifyNewBoData);
        });
        QFilter boFilter = new QFilter("bo", "in", (Object)boList);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        DynamicObject[] oldBoDatas = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, statusFilter});
        Date dateNow = new Date();
        ArrayList newDataHisList = Lists.newArrayListWithExpectedSize((int)modifyNewBoDataHisList.size());
        ArrayList oldBoList = Lists.newArrayListWithExpectedSize((int)modifyNewBoDataHisList.size());
        Arrays.stream(oldBoDatas).forEach(oldBoData -> {
            Long oldBo = oldBoData.getLong("bo");
            if (!oldBoList.contains(oldBo)) {
                oldBoList.add(oldBo);
                Long oldCe = oldBoData.getLong("ce");
                Date oldBsed = oldBoData.getDate("bsed");
                oldBoData.set("isnewbo", (Object)Boolean.FALSE);
                DynamicObject modifyNewBo = (DynamicObject)dataHisMap.get(oldBo);
                this.setHisField(modifyNewBo, dateNow);
                this.setSysField(modifyNewBo, dateNow);
                this.setActualField(modifyNewBo, dateNow);
                modifyNewBo.set("islastversion", (Object)Boolean.FALSE);
                modifyNewBo.set("bsled", (Object)oldBsed);
                modifyNewBo.set("lme", (Object)oldCe);
                modifyNewBo.set("lmedt", (Object)oldBsed);
                modifyNewBo.set("lee", (Object)oldCe);
                modifyNewBo.set("leedt", (Object)oldBsed);
                modifyNewBo.set(BRLED, (Object)dateNow);
                modifyNewBo.set(BRLEDT, (Object)dateNow.getTime());
                modifyNewBo.set("isnewbo", (Object)Boolean.TRUE);
                modifyNewBo.set("datastatus", (Object)"2");
                newDataHisList.add(modifyNewBo);
            }
        });
        this.hisServiceHelper.update(oldBoDatas);
        this.hisServiceHelper.save(newDataHisList.toArray(new DynamicObject[0]));
    }

    protected void checkBoList(List<Long> oldBoList, DynamicObject[] currentDynArr, String fieldName, String errorMsg) {
        List currentIds = Arrays.stream(currentDynArr).map(currentDyn -> currentDyn.getLong(fieldName)).collect(Collectors.toList());
        List diffIdAndBoList = oldBoList.stream().filter(bo -> !currentIds.contains(bo)).collect(Collectors.toList());
        if (diffIdAndBoList != null && diffIdAndBoList.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " checkBoList currentDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])diffIdAndBoList.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(errorMsg);
        }
    }

    @Override
    public List<Long> checkSEDataHisExists(List<DynamicObject> hisDyList) {
        QFilter scheduleEffectFilter = new QFilter("datastatus", "=", (Object)"0");
        List boList = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        DynamicObjectCollection scheDyColl = this.hisServiceHelper.queryOriginalCollection("bo", new QFilter[]{scheduleEffectFilter, oldHisDyFilter});
        if (scheDyColl == null || scheDyColl.size() == 0) {
            return null;
        }
        return scheDyColl.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
    }

    protected String getErrorInfoByMulDy(List<DynamicObject> hisDynList) {
        ArrayList<String> errorInfos = new ArrayList<String>();
        if (hisDynList == null || hisDynList.size() == 0) {
            errorInfos.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        } else {
            this.validateHisDyList(hisDynList, errorInfos);
            List repeatData = hisDynList.stream().map(dy -> dy.getDynamicObjectType().getName()).distinct().collect(Collectors.toList());
            if (repeatData.size() != 1) {
                errorInfos.add(ResManager.loadKDString((String)"\u6240\u6709\u5386\u53f2\u6570\u636e\u5fc5\u987b\u6765\u81ea\u540c\u4e00\u5b9e\u4f53\uff01", (String)"CommonTimeSeqAttachService_4", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
        }
        StringBuilder errorInfoStr = new StringBuilder();
        List<String> bizErrorInfoList = this.getBizErrorInfo(hisDynList);
        if (bizErrorInfoList != null && bizErrorInfoList.size() > 0) {
            errorInfos.addAll(bizErrorInfoList);
        }
        if (errorInfos.size() > 0) {
            int size = errorInfos.size();
            for (int i = 0; i < size; ++i) {
                errorInfoStr.append("(").append(i).append(")").append((String)errorInfos.get(i)).append(System.lineSeparator());
            }
        }
        return errorInfoStr.toString();
    }

    private void validateHisDyList(List<DynamicObject> hisDynList, List<String> errorInfos) {
        for (DynamicObject hisDy : hisDynList) {
            if (hisDy.getLong("bo") == 0L) {
                errorInfos.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u5bf9\u5e94\u7684\u4e1a\u52a1\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if (hisDy.getLong("ce") == 0L) {
                errorInfos.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u521b\u5efa\u4e8b\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if (hisDy.getDate("bsed") != null) continue;
            errorInfos.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_3", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            break;
        }
    }

    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void beforeAddNewDataHis(List<DynamicObject> hisDyList) {
    }

    @Override
    public void batchEffectDataHis(List<Long> eventIds) {
        DynamicObject[] newHisDyArr = this.getnewDyArr(eventIds);
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            if (!this.isMainPart.booleanValue()) {
                return;
            }
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId is:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_10", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> oldBoList = Arrays.stream(newHisDyArr).map(newHisDy -> newHisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", oldBoList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis oldHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String oldBoStr = StringUtils.join((Object[])oldBoList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IS_S_BO_IS_S, eventStr, oldBoStr));
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(oldBoList, oldHisDyArr, "bo", this.getCommonBoSeo());
        QFilter idFilter = new QFilter("id", "in", oldBoList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDyArr == null || currentDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis currentDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String oldBoStr = StringUtils.join((Object[])oldBoList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IS_S_BO_IS_S, eventStr, oldBoStr));
            throw new KDBizException(this.getBoDataNotExist());
        }
        this.checkBoList(oldBoList, currentDyArr, "id", this.getBoDataNotExist());
        Date dateNow = new Date();
        this.beforeLoseEffectDataHis(oldHisDyArr);
        this.updateoldDyArr(newHisDyArr, oldHisDyArr, dateNow);
        this.updateNewHis(newHisDyArr, dateNow);
        this.updateDyArr(newHisDyArr, currentDyArr);
    }

    private DynamicObject[] getnewDyArr(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)false);
        newHisDyFilter.and(boFilter);
        QFilter seFilter = new QFilter("datastatus", "=", (Object)"0");
        newHisDyFilter.and(seFilter);
        return this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
    }

    private void updateoldDyArr(DynamicObject[] newHisDyArr, DynamicObject[] oldHisDyArr, Date dateNow) {
        Map boNewHisDyMap = Arrays.stream(newHisDyArr).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), Function.identity()));
        Arrays.stream(oldHisDyArr).forEach(oldHisDy -> {
            long bo = oldHisDy.getLong("bo");
            DynamicObject newHisDy = (DynamicObject)boNewHisDyMap.get(bo);
            oldHisDy.set("lee", (Object)newHisDy.getLong("ce"));
            oldHisDy.set("leedt", (Object)dateNow);
            oldHisDy.set("bsled", (Object)newHisDy.getDate("bsed"));
            oldHisDy.set(BRLED, (Object)dateNow);
            oldHisDy.set(BRLEDT, (Object)dateNow.getTime());
            oldHisDy.set("datastatus", (Object)"2");
        });
        this.hisServiceHelper.update(oldHisDyArr);
    }

    private void updateNewHis(DynamicObject[] newHisDyArr, Date dateNow) {
        Arrays.stream(newHisDyArr).forEach(newHisDy -> {
            newHisDy.set("ee", (Object)newHisDy.getLong("ce"));
            newHisDy.set("eedt", (Object)dateNow);
            newHisDy.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)newHisDy, dateNow);
        });
        this.hisServiceHelper.update(newHisDyArr);
    }

    private void updateDyArr(DynamicObject[] newHisDyArr, DynamicObject[] currentDyArr) {
        Arrays.stream(newHisDyArr).forEach(hisDy -> Arrays.stream(currentDyArr).filter(curDy -> hisDy.getLong("bo") == curDy.getLong("id")).forEach(curDy -> {
            HRDynamicObjectUtils.copy((DynamicObject)this.genCurrentDynamicObject(this.serviceHelper.getEntityName(), (DynamicObject)hisDy), (DynamicObject)curDy, this.getCopyIgnoreKeySet());
            curDy.set("id", (Object)hisDy.getLong("bo"));
        }));
        this.serviceHelper.update(currentDyArr);
    }

    protected Set<String> getCopyIgnoreKeySet() {
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)20);
        keySet.add("creator");
        keySet.add("createtime");
        keySet.add("multilanguagetext");
        return keySet;
    }

    protected void beforeEffectBoDataHis(DynamicObject[] hisDyArr) {
    }

    protected void beforeLoseEffectDataHis(DynamicObject[] hisDyArr) {
    }

    protected void beforeSaveAndEffectDataHis(List<DynamicObject> hisDyCol) {
    }

    protected void beforeUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void afterAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void afterAddNewDataHis(List<DynamicObject> hisDyList) {
    }

    protected void afterEffectBoDataHis(List<Long> eventIds) {
    }

    protected void afterEffectDataHiss(List<Long> eventIds) {
    }

    protected void afterSaveAndEffectBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void afterSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
    }

    protected void afterDiscardBoDataHis(List<Long> eventIds) {
    }

    protected void afterDiscardDataHis(List<Long> eventIds) {
    }
}

