/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.service.HistoryEntityRegister;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractHistoryEntityFieldValueConverter {
    private static final Log logger = LogFactory.getLog(AbstractHistoryEntityFieldValueConverter.class);
    private String entityType;
    private String mainEntityField;

    public Map<String, DynamicObject> assembleHistoryDynamicObjectFromDataModle(IDataModel dataModel) {
        String type = this.getEntityType();
        if (HRStringUtils.isEmpty((String)type)) {
            return new HashMap<String, DynamicObject>();
        }
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(type);
        MainEntityType mainEntityType = dataModel.getDataEntityType();
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
        HashMap result = Maps.newHashMapWithExpectedSize((int)historyEntityModels.size());
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            DynamicObject hisDyn = this.getHisDynamicObjectFromDataModel(dataModel, pageFieldsNameList, fieldsNameList, hisEntityNumber);
            result.put(hisEntityNumber, hisDyn);
        }
        return result;
    }

    public DynamicObject assembleHistoryDynamicObjectFromDynamicObject(String hisEntityNumber, DynamicObject dyn) {
        MainEntityType mainEntityType = (MainEntityType)dyn.getDataEntityType();
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
        MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
        DynamicObject hisDyn = this.getHisDynamicObjectFromDataModel(dyn, pageFieldsNameList, fieldsNameList, hisEntityNumber);
        return hisDyn;
    }

    public Map<String, DynamicObject> assembleHistoryDynamicObjectFromDynamicObject(DynamicObject dyn) {
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(this.entityType);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)historyEntityModels.size());
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisMainEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisMainEntityType);
            MainEntityType mainEntityType = (MainEntityType)dyn.getDataEntityType();
            List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
            DynamicObject hisDynamic = this.getHisDynamicObjectFromDataModel(dyn, pageFieldsNameList, fieldsNameList, hisEntityNumber);
            resultMap.put(hisEntityNumber, hisDynamic);
        }
        return resultMap;
    }

    public Map<String, DynamicObject> assembleHistoryDynamicObjectFromDynamicObject(DynamicObject dyn, List<HistoryEntityModel> historyEntityModels) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)historyEntityModels.size());
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String hisEntityNum = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNum);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            MainEntityType mainEntityType = (MainEntityType)dyn.getDataEntityType();
            List<String> pageFieldsNames = HistoryEntityUtils.getFieldsNameList(mainEntityType);
            DynamicObject hisDyn = this.getHisDynamicObjectFromDataModel(dyn, pageFieldsNames, fieldsNameList, hisEntityNum);
            resultMap.put(hisEntityNum, hisDyn);
        }
        return resultMap;
    }

    public void assembleHistoryDynamicObjectToDataModle(IDataModel dataModel, Long mainEntityDataId) {
        String type = this.getEntityType();
        String entityField = this.getMainEntityField();
        if (HRStringUtils.isEmpty((String)type) || HRStringUtils.isEmpty((String)entityField)) {
            return;
        }
        List<HistoryEntityModel> hisEntityModels = HistoryEntityRegister.getEntityHistoryList(type);
        MainEntityType mainEntityType = dataModel.getDataEntityType();
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        for (HistoryEntityModel hisEntityModel : hisEntityModels) {
            String bsledField;
            String hisEntityNumStr = hisEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumStr);
            List<String> fieldsNames = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            String fieldsName = this.changeListToString(fieldsNames);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(hisEntityNumStr);
            QFilter entityFilter = null;
            entityFilter = fieldsNames.contains(entityField) ? new QFilter(entityField, "=", (Object)mainEntityDataId) : new QFilter("bo", "=", (Object)mainEntityDataId);
            DynamicObject dyn = hrBaseServiceHelper.loadDynamicObject(new QFilter[]{statusFilter, entityFilter});
            if (dyn == null) continue;
            String bsedField = hisEntityModel.getBsedFieldName();
            if (pageFieldsNameList.contains(bsedField)) {
                dataModel.setValue(bsedField, dyn.get("bsed"));
            }
            if (pageFieldsNameList.contains(bsledField = hisEntityModel.getBsledFieldName())) {
                dataModel.setValue(bsledField, dyn.get("bsled"));
            }
            this.setDateToDateModel(dyn, fieldsNames, pageFieldsNameList, dataModel);
        }
    }

    public Map<String, DynamicObject> assembleHistoryDynamicObjectToDataModel(List<DynamicObject> orgDynList, MainEntityType hisEntityType) {
        String type = this.getEntityType();
        String entityField = this.getMainEntityField();
        if (HRStringUtils.isEmpty((String)type) || HRStringUtils.isEmpty((String)entityField) || CollectionUtils.isEmpty(orgDynList)) {
            return Maps.newHashMap();
        }
        List<Long> orgIdList = orgDynList.stream().map(orgDyn -> orgDyn.getLong("id")).collect(Collectors.toList());
        Map<Long, String> orgIdNumMap = orgDynList.stream().collect(Collectors.toMap(orgDyn -> orgDyn.getLong("id"), orgDyn -> orgDyn.getString("number")));
        List<HistoryEntityModel> hisEntityModels = HistoryEntityRegister.getEntityHistoryList(type);
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
        HashMap orgMaps = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fieldsMaps = Maps.newHashMapWithExpectedSize((int)16);
        this.handleOrgMap(hisEntityModels, orgIdList, entityField, orgMaps, fieldsMaps);
        HashMap orgInfoMap = Maps.newHashMapWithExpectedSize((int)orgDynList.size());
        if (orgMaps != null && !orgMaps.isEmpty()) {
            orgIdList.forEach(orgId -> {
                DynamicObject dyn = new DynamicObject((DynamicObjectType)hisEntityType);
                orgMaps.forEach((entityNum, DynList) -> {
                    DynamicObject fromDyn = (DynamicObject)DynList.get(orgId);
                    List fieldsNames = (List)fieldsMaps.get(entityNum);
                    if (!fieldsNames.contains(entityField) && fieldsNames.containsAll(this.getCompareIgnoreKeyList())) {
                        this.getCompareIgnoreKeyList().forEach(fieldName -> dyn.set(fieldName, fromDyn.get(fieldName)));
                    }
                    this.getHisDynamicObjectFromDataModel(fromDyn, dyn, pageFieldsNameList, fieldsNames, this.getCompareIgnoreKeyList());
                });
                dyn.set("id", orgId);
                dyn.set("adminorg", orgId);
                orgInfoMap.put(orgIdNumMap.get(orgId), dyn);
            });
        }
        return orgInfoMap;
    }

    private void handleOrgMap(List<HistoryEntityModel> hisEntityModels, List<Long> orgIdList, String entityField, Map<String, Map<Long, DynamicObject>> orgMaps, Map<String, List<String>> fieldsMaps) {
        for (HistoryEntityModel hisEntityModel : hisEntityModels) {
            String hisEntityNumStr = hisEntityModel.getHisEntityNumber();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumStr);
            List<String> fieldsNames = HistoryEntityUtils.getFieldsNameList(mainEntityType);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(hisEntityNumStr);
            QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
            QFilter entityFilter = null;
            entityFilter = fieldsNames.contains(entityField) ? new QFilter(entityField, "in", orgIdList) : new QFilter("bo", "in", orgIdList);
            DynamicObject[] dynList = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, entityFilter});
            if (dynList == null || dynList.length == 0) continue;
            Map<Object, Object> dynMap = Maps.newHashMapWithExpectedSize((int)16);
            dynMap = fieldsNames.contains(entityField) ? Arrays.stream(dynList).collect(Collectors.toMap(dyn -> this.getIdValue(dyn.get(entityField)), dyn -> dyn)) : Arrays.stream(dynList).collect(Collectors.toMap(dyn -> dyn.getLong("bo"), dyn -> dyn));
            orgMaps.put(hisEntityNumStr, dynMap);
            fieldsMaps.put(hisEntityNumStr, fieldsNames);
        }
    }

    private Long getIdValue(Object value) {
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    private List<String> getCompareIgnoreKeyList() {
        ArrayList keyList = Lists.newArrayListWithExpectedSize((int)30);
        keyList.add("effdt");
        keyList.add("leffdt");
        return keyList;
    }

    private void getHisDynamicObjectFromDataModel(DynamicObject fromDyn, DynamicObject toDyn, List<String> pageFieldsNameList, List<String> fieldsNameList, List<String> ignoreKeyList) {
        for (String fieldName : fieldsNameList) {
            if (ignoreKeyList.contains(fieldName) || !pageFieldsNameList.contains(fieldName)) continue;
            this.setHisFieldValue(fromDyn, toDyn, fieldName);
        }
    }

    public List<DynamicObject> assembleHistoryDynamicObjectToDynamicObject(String entityNumber, List<Long> mainEntityDataIdList) {
        String type = this.getEntityType();
        String entityField = this.getMainEntityField();
        if (HRStringUtils.isEmpty((String)type) || HRStringUtils.isEmpty((String)entityField)) {
            return new ArrayList<DynamicObject>();
        }
        List<HistoryEntityModel> historyEntityModelList = HistoryEntityRegister.getEntityHistoryList(type);
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(entityNumber);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        HashMap dynMap = Maps.newHashMapWithExpectedSize((int)mainEntityDataIdList.size());
        mainEntityDataIdList.forEach(mainEntityDataId -> {
            DynamicObject dyn = new DynamicObject((DynamicObjectType)dataEntityType);
            dynMap.put(mainEntityDataId, dyn);
        });
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        for (HistoryEntityModel historyEntityModel : historyEntityModelList) {
            this.putDynMap(mainEntityDataIdList, entityField, pageFieldsNameList, dynMap, statusFilter, historyEntityModel);
        }
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)dynMap.size());
        for (Map.Entry entry : dynMap.entrySet()) {
            dynList.add(entry.getValue());
        }
        return dynList;
    }

    private void putDynMap(List<Long> mainEntityDataIdList, String entityField, List<String> pageFieldsNameList, Map<Long, DynamicObject> dynMap, QFilter statusFilter, HistoryEntityModel historyEntityModel) {
        DynamicObject[] dys;
        String historyEntityNumber = historyEntityModel.getHisEntityNumber();
        MainEntityType historyEntityType = EntityMetadataCache.getDataEntityType((String)historyEntityNumber);
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(historyEntityType);
        String fieldsNameString = this.changeListToString(fieldsNameList);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(historyEntityNumber);
        QFilter entityFilter = null;
        String field = "";
        if (fieldsNameList.contains(entityField)) {
            entityFilter = new QFilter(entityField, "in", mainEntityDataIdList);
            field = entityField;
        } else {
            entityFilter = new QFilter("bo", "in", mainEntityDataIdList);
            field = "bo";
        }
        for (DynamicObject dyn : dys = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, entityFilter})) {
            String bsledField;
            Long mainEntityId = HistoryEntityUtils.getDynamicObjectFieldId(dyn, field);
            DynamicObject dynamicObject = dynMap.get(mainEntityId);
            String bsedField = historyEntityModel.getBsedFieldName();
            if (pageFieldsNameList.contains(bsedField)) {
                dynamicObject.set(bsedField, dyn.get("bsed"));
            }
            if (pageFieldsNameList.contains(bsledField = historyEntityModel.getBsledFieldName())) {
                dynamicObject.set(bsledField, dyn.get("bsled"));
            }
            this.setDateToDynamicObject(dyn, fieldsNameList, pageFieldsNameList, dynamicObject);
            dynMap.put(mainEntityId, dynamicObject);
        }
    }

    public void assembleHistoryDynamicObjectToDataModle(IDataModel dataModel, Long mainEntityDataId, Date effectDate) {
        String type = this.getEntityType();
        String entityField = this.getMainEntityField();
        if (HRStringUtils.isEmpty((String)type) || HRStringUtils.isEmpty((String)entityField)) {
            return;
        }
        List<HistoryEntityModel> historyEntityModels = HistoryEntityRegister.getEntityHistoryList(type);
        MainEntityType mainEntityType = dataModel.getDataEntityType();
        List<String> pageFieldsNameList = HistoryEntityUtils.getFieldsNameList(mainEntityType);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            String bsledField;
            String hisEntityNumber = historyEntityModel.getHisEntityNumber();
            MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)hisEntityNumber);
            List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList(hisEntityType);
            String fieldsNameString = this.changeListToString(fieldsNameList);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisEntityNumber);
            QFilter entityFilter = null;
            entityFilter = fieldsNameList.contains(entityField) ? new QFilter(entityField, "=", (Object)mainEntityDataId) : new QFilter("bo", "=", (Object)mainEntityDataId);
            QFilter bsedFilter = new QFilter("bsed", "<=", (Object)effectDate);
            QFilter bsledFilter = new QFilter("bsled", ">", (Object)effectDate);
            bsledFilter.or(new QFilter("bsled", "is null", null));
            DynamicObject dyn = serviceHelper.loadDynamicObject(new QFilter[]{statusFilter, entityFilter, bsledFilter, bsedFilter});
            if (dyn == null) continue;
            String bsedField = historyEntityModel.getBsedFieldName();
            if (pageFieldsNameList.contains(bsedField)) {
                dataModel.setValue(bsedField, dyn.get("bsed"));
            }
            if (pageFieldsNameList.contains(bsledField = historyEntityModel.getBsledFieldName())) {
                dataModel.setValue(bsledField, dyn.get("bsled"));
            }
            this.setDateToDateModel(dyn, fieldsNameList, pageFieldsNameList, dataModel);
        }
    }

    private DynamicObject getHisDynamicObjectFromDataModel(IDataModel dataModel, List<String> pageFieldsNameList, List<String> fieldsNameList, String hisEntityNumber) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)hisEntityNumber));
        for (String fieldName : fieldsNameList) {
            if (!pageFieldsNameList.contains(fieldName)) continue;
            dyn.set(fieldName, dataModel.getValue(fieldName));
        }
        if (!fieldsNameList.contains(this.getMainEntityField())) {
            dyn.set("bo", dataModel.getValue(this.getMainEntityField()));
        }
        return dyn;
    }

    private DynamicObject getHisDynamicObjectFromDataModel(DynamicObject dataDyn, List<String> pageFieldsNameList, List<String> fieldsNameList, String hisEntityNumber) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)hisEntityNumber));
        List<String> ignoreKeyList = HistoryEntityUtils.getCompareIgnoreKeyList();
        for (String fieldName : fieldsNameList) {
            if (ignoreKeyList.contains(fieldName) || !pageFieldsNameList.contains(fieldName)) continue;
            this.setHisFieldValue(dataDyn, dyn, fieldName);
        }
        if (!fieldsNameList.contains(this.getMainEntityField())) {
            Long objId = HistoryEntityUtils.getDynamicObjectFieldId(dataDyn, this.getMainEntityField());
            dyn.set("bo", (Object)objId);
        }
        return dyn;
    }

    private void setHisFieldValue(DynamicObject dataDyn, DynamicObject hisDyn, String fieldName) {
        Object value = dataDyn.get(fieldName);
        if (value instanceof DynamicObjectCollection) {
            MainEntityType mainEntityType = (MainEntityType)hisDyn.getDynamicObjectType();
            EntityType entryType = (EntityType)mainEntityType.getAllEntities().get(fieldName);
            if (entryType == null) {
                hisDyn.set(fieldName, this.getDynamicObjectCollection((DynamicObjectCollection)value));
            } else {
                hisDyn.set(fieldName, (Object)this.getNewEntry((DynamicObjectCollection)value, entryType));
            }
        } else {
            hisDyn.set(fieldName, value);
        }
    }

    private DynamicObjectCollection getNewEntry(DynamicObjectCollection entryCollll, EntityType entryType) {
        if (CollectionUtils.isEmpty((Collection)entryCollll)) {
            return null;
        }
        DynamicObjectCollection newEntryObjColl = new DynamicObjectCollection();
        int cunt = 0;
        long[] entryIds = ORM.create().genLongIds((IDataEntityType)entryType, entryCollll.size());
        for (DynamicObject entry : entryCollll) {
            DynamicObject newEntry = new DynamicObject((DynamicObjectType)entryType);
            HRDynamicObjectUtils.copy((DynamicObject)entry, (DynamicObject)newEntry);
            newEntry.set("id", (Object)entryIds[cunt]);
            newEntry.setParent(entry.getParent());
            try {
                newEntry.set("seq", (Object)cunt++);
            }
            catch (Exception exception) {
                logger.info("has not seq");
            }
            newEntryObjColl.add((Object)newEntry);
        }
        return newEntryObjColl;
    }

    private void copyEntryValue(DynamicObject entry, DynamicObject newEntry) {
        DataEntityPropertyCollection propertyCollection = newEntry.getDataEntityType().getProperties();
        ArrayList newEntryFieldNameList = Lists.newArrayListWithExpectedSize((int)propertyCollection.size());
        propertyCollection.forEach(property -> {
            String propName = property.getName();
            newEntryFieldNameList.add(propName);
        });
        DataEntityPropertyCollection entryPropertyCollection = entry.getDataEntityType().getProperties();
        ArrayList entryFieldNameList = Lists.newArrayListWithExpectedSize((int)entryPropertyCollection.size());
        entryPropertyCollection.forEach(property -> {
            String propName = property.getName();
            entryFieldNameList.add(propName);
        });
        for (String fieldName : newEntryFieldNameList) {
            String baseFieldName;
            if (!entryFieldNameList.contains(fieldName) || HRStringUtils.lastIndexOfIgnoreCase((String)fieldName, (String)"_id") <= 0 || !entryFieldNameList.contains(baseFieldName = HRStringUtils.substringBeforeLast((String)fieldName, (String)"_id")) || !newEntryFieldNameList.contains(baseFieldName)) continue;
            newEntry.set(fieldName, (Object)HistoryEntityUtils.getDynamicObjectFieldId(newEntry, baseFieldName));
        }
    }

    private void setDateToDateModel(DynamicObject dyn, List<String> fieldsNameList, List<String> pageFieldsNameList, IDataModel dataModel) {
        for (String fieldsName : fieldsNameList) {
            if (!pageFieldsNameList.contains(fieldsName)) continue;
            Object value = dyn.get(fieldsName);
            this.setFieldValue(value, fieldsName, dataModel);
        }
    }

    private void setFieldValue(Object value, String fieldName, IDataModel dataModel) {
        if (value instanceof DynamicObject) {
            dataModel.setValue(fieldName, (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)value, "id"));
        } else if (value instanceof DynamicObjectCollection) {
            MainEntityType mainEntityType = dataModel.getDataEntityType();
            EntityType entryType = (EntityType)mainEntityType.getAllEntities().get(fieldName);
            if (entryType == null) {
                dataModel.setValue(fieldName, this.getDynamicObjectCollection((DynamicObjectCollection)value));
            } else if (entryType instanceof EntryType) {
                dataModel.getDataEntity().set(fieldName, (Object)this.getNewEntry((DynamicObjectCollection)value, entryType));
            }
        } else if (value != null) {
            dataModel.setValue(fieldName, value);
        }
    }

    private Object getDynamicObjectCollection(DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return null;
        }
        if (!HistoryEntityUtils.checkNullInDynamicCollection(dynamicObjectCollection, Lists.newArrayList((Object[])new String[]{"fbasedataid"}))) {
            return null;
        }
        DynamicObjectCollection newDynamicObjectCollection = new DynamicObjectCollection();
        int cunt = 0;
        long[] newDynamicObjectCollectionIds = ORM.create().genLongIds((IDataEntityType)dynamicObjectCollection.getDynamicObjectType(), dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject newDynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynamicObject);
            newDynamicObject.set("pkid", (Object)newDynamicObjectCollectionIds[cunt]);
            newDynamicObjectCollection.add((Object)newDynamicObject);
            ++cunt;
        }
        return newDynamicObjectCollection;
    }

    private void setDateToDynamicObject(DynamicObject dyn, List<String> fieldsNameList, List<String> pageFieldsNameList, DynamicObject dynamicObject) {
        for (String fieldsName : fieldsNameList) {
            Object value;
            if (!pageFieldsNameList.contains(fieldsName) || (value = dyn.get(fieldsName)) == null) continue;
            dynamicObject.set(fieldsName, value);
        }
    }

    private String changeListToString(List<String> nameList) {
        String convertString = "";
        for (String name : nameList) {
            if (HRStringUtils.isEmpty((String)convertString)) {
                convertString = name;
                continue;
            }
            convertString = convertString + "," + name;
        }
        return convertString;
    }

    protected String getMainEntityField() {
        return this.mainEntityField;
    }

    protected String getEntityType() {
        return this.entityType;
    }

    protected String setMainEntityField(String mainEntityField) {
        this.mainEntityField = mainEntityField;
        return this.mainEntityField;
    }

    protected String setEntityType(String entityType) {
        this.entityType = entityType;
        return this.entityType;
    }
}

