/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class HistoryEntityUtils {
    private static final Log LOG = LogFactory.getLog(HistoryEntityUtils.class);

    public static Map<String, DynamicObject> compareHistoryDynamicObject(Map<String, DynamicObject> newDataMap, Map<String, DynamicObject> effectingDataMap, List<HistoryEntityModel> historyEntityModels, Map<String, DynamicObject> addNewDataHisEffectingDataMap) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        for (HistoryEntityModel historyEntityModel : historyEntityModels) {
            DynamicObject effectingDyn;
            String entityNumber = historyEntityModel.getHisEntityNumber();
            String modelType = historyEntityModel.getModeType();
            DynamicObject newDyn = newDataMap.get(entityNumber);
            if (effectingDataMap == null) {
                effectingDyn = addNewDataHisEffectingDataMap.get(entityNumber);
                newDyn.set("bo", effectingDyn.get("bo"));
                result.put(entityNumber, newDyn);
                continue;
            }
            effectingDyn = effectingDataMap.get(entityNumber);
            if (HRStringUtils.equals((String)modelType, (String)"2")) {
                if (null == newDyn) {
                    LOG.error("compareHistoryDynamicObject-1," + entityNumber + ":" + newDataMap.keySet());
                }
                if (null == effectingDyn) {
                    LOG.error("compareHistoryDynamicObject-2," + entityNumber + ":" + newDataMap.keySet());
                }
                if (null != newDyn && null != effectingDyn) {
                    newDyn.set("bo", effectingDyn.get("bo"));
                    result.put(entityNumber, newDyn);
                    continue;
                }
            }
            if (null == newDyn || null == effectingDyn || HistoryEntityUtils.compareDynamicObjectData(newDyn, effectingDyn).booleanValue()) continue;
            newDyn.set("bo", effectingDyn.get("bo"));
            result.put(entityNumber, newDyn);
        }
        return result;
    }

    public static Boolean compareDynamicObjectData(DynamicObject newDyn, DynamicObject effectingDyn) {
        if (newDyn == null || effectingDyn == null) {
            return false;
        }
        List<String> fieldsNameList = HistoryEntityUtils.getFieldsNameList((MainEntityType)newDyn.getDataEntityType());
        List<String> ignoreKeyList = HistoryEntityUtils.getCompareIgnoreKeyList();
        for (String fieldName : fieldsNameList) {
            if (ignoreKeyList.contains(fieldName)) continue;
            Object nValue = newDyn.get(fieldName);
            Object effectingValue = effectingDyn.get(fieldName);
            if (nValue instanceof Long && effectingValue == null && nValue.equals(0L) || nValue == null && effectingValue == null) continue;
            if (nValue == null) {
                return false;
            }
            if (effectingValue != null && HistoryEntityUtils.compareValues(nValue, effectingValue)) continue;
            return false;
        }
        return true;
    }

    public static DynamicObject copyHisDynamicObjectWithIgnoreKeySet(DynamicObject hisDy, Set<String> ignoreKeysSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisDy.getDataEntityType().getName());
        DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)dy, ignoreKeysSet);
        return dy;
    }

    public static DynamicObject copyHisDynamicObject(DynamicObject hisDy) {
        return HistoryEntityUtils.copyHisDynamicObjectWithIgnoreKeySet(hisDy, HistoryEntityUtils.getIgnoreKeysSet());
    }

    public static Long getDynamicObjectFieldId(DynamicObject dataDyn, String fieldName) {
        Object obj = dataDyn.get(fieldName);
        if (obj == null) {
            return 0L;
        }
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj != null) {
            objId = (Long)obj;
        }
        return objId;
    }

    public static Set<String> getIgnoreKeysSet() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)25);
        set.add("bsed");
        set.add("bred");
        set.add("bredt");
        set.add("bsled");
        set.add("brled");
        set.add("brledt");
        set.add("ce");
        set.add("cedt");
        set.add("lme");
        set.add("lmedt");
        set.add("ee");
        set.add("eedt");
        set.add("lee");
        set.add("leedt");
        set.add("de");
        set.add("dedt");
        set.add("lde");
        set.add("ldedt");
        set.add("datastatus");
        set.add("islastversion");
        set.add("isnewbo");
        return set;
    }

    public static List<String> getFieldsNameList(MainEntityType entityType) {
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)entityType.getFields().size());
        DataEntityPropertyCollection collection = entityType.getProperties();
        for (IDataEntityProperty property : collection) {
            String propertyName = property.getName();
            if (HRStringUtils.indexOfIgnoreCase((String)propertyName, (String)"_id") != -1 || HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") || HRStringUtils.equals((String)propertyName, (String)"id")) continue;
            fieldsNameList.add(propertyName);
        }
        return fieldsNameList;
    }

    public static String getFieldsNamesString(MainEntityType entityType) {
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)entityType.getFields().size());
        for (IDataEntityProperty property : entityType.getFields().values()) {
            String propertyName = property.getName();
            fieldsNameList.add(propertyName);
        }
        return HistoryEntityUtils.changeListToString(fieldsNameList);
    }

    public static List<String> getFieldsNameList(String entityNumber) {
        MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return HistoryEntityUtils.getFieldsNameList(hisEntityType);
    }

    public static String getFieldsNamesString(String entityNumber) {
        MainEntityType hisEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return HistoryEntityUtils.getFieldsNamesString(hisEntityType);
    }

    private static String changeListToString(List<String> nameList) {
        String convertString = "";
        for (String name : nameList) {
            if (HRStringUtils.isEmpty((String)convertString)) {
                convertString = name;
                continue;
            }
            convertString = convertString + "," + name;
        }
        return convertString;
    }

    public static List<String> getCompareIgnoreKeyList() {
        ArrayList keyList = Lists.newArrayListWithExpectedSize((int)30);
        keyList.add("bsed");
        keyList.add("bred");
        keyList.add("bredt");
        keyList.add("bsled");
        keyList.add("brled");
        keyList.add("brledt");
        keyList.add("ce");
        keyList.add("cedt");
        keyList.add("lme");
        keyList.add("lmedt");
        keyList.add("ee");
        keyList.add("eedt");
        keyList.add("lee");
        keyList.add("leedt");
        keyList.add("de");
        keyList.add("dedt");
        keyList.add("lde");
        keyList.add("ldedt");
        keyList.add("datastatus");
        keyList.add("islastversion");
        keyList.add("isnewbo");
        keyList.add("bo");
        keyList.add("modifier");
        keyList.add("modifytime");
        return keyList;
    }

    public static boolean compareValues(Object newVal, Object oldVal) {
        boolean result = true;
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        if (newVal instanceof OrmLocaleValue) {
            if (!CollectionUtils.isEmpty((Collection)enabledLangList)) {
                for (EnabledLang enabledLang : enabledLangList) {
                    String oldItem;
                    String number = enabledLang.getNumber();
                    String newItem = ((OrmLocaleValue)newVal).getItem(number);
                    if (HRStringUtils.equals((String)newItem, (String)(oldItem = ((OrmLocaleValue)oldVal).getItem(number)))) continue;
                    result = false;
                }
            }
        } else if (newVal instanceof LocaleString) {
            if (!CollectionUtils.isEmpty((Collection)enabledLangList)) {
                for (EnabledLang enabledLang : enabledLangList) {
                    String oldItem;
                    String number = enabledLang.getNumber();
                    String newItem = (String)((LocaleString)newVal).getItem(number);
                    if (HRStringUtils.equals((String)newItem, (String)(oldItem = (String)((LocaleString)oldVal).getItem(number)))) continue;
                    result = false;
                }
            }
        } else if (newVal instanceof DynamicObject) {
            Long oldId;
            Long newId = ((DynamicObject)newVal).getLong("id");
            if (!newId.equals(oldId = Long.valueOf(((DynamicObject)oldVal).getLong("id")))) {
                result = false;
            }
        } else if (newVal instanceof Long && oldVal instanceof DynamicObject) {
            Long newId;
            Long oldId = ((DynamicObject)oldVal).getLong("id");
            if (!oldId.equals(newId = (Long)newVal)) {
                result = false;
            }
        } else if (newVal instanceof DynamicObjectCollection) {
            result = HistoryEntityUtils.compareDynamicObjectCollection((DynamicObjectCollection)newVal, (DynamicObjectCollection)oldVal);
        } else if (!newVal.equals(oldVal)) {
            result = false;
        }
        return result;
    }

    private static boolean compareDynamicObjectCollection(DynamicObjectCollection newColl, DynamicObjectCollection oldColl) {
        boolean result = true;
        if (newColl.size() != oldColl.size()) {
            result = false;
        } else {
            for (DynamicObject newDyn : newColl) {
                DataEntityPropertyCollection propertyCollection = newDyn.getDataEntityType().getProperties();
                List propertyList = propertyCollection.parallelStream().map(property -> property.getName()).collect(Collectors.toList());
                if (propertyList.contains("fbasedataid")) {
                    if (HistoryEntityUtils.compareMulityBaseData(newDyn, oldColl)) continue;
                    result = false;
                    break;
                }
                if (!propertyList.contains("seq") || HistoryEntityUtils.compareEntry(newDyn, oldColl)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static boolean compareMulityBaseData(DynamicObject newDyn, DynamicObjectCollection oldColl) {
        boolean result = true;
        Long id = HistoryEntityUtils.getDynamicObjectFieldId(newDyn, "fbasedataid");
        boolean isSame = false;
        for (DynamicObject oldDyn : oldColl) {
            Long oldId = HistoryEntityUtils.getDynamicObjectFieldId(oldDyn, "fbasedataid");
            if (!id.equals(oldId)) continue;
            isSame = HistoryEntityUtils.compareEntryValue(newDyn, oldDyn);
            break;
        }
        if (!isSame) {
            result = false;
        }
        return result;
    }

    private static boolean compareEntry(DynamicObject newDyn, DynamicObjectCollection oldColl) {
        boolean result = true;
        int seq = newDyn.getInt("seq");
        boolean isSame = false;
        for (DynamicObject oldDyn : oldColl) {
            int oldSeq = oldDyn.getInt("seq");
            if (seq != oldSeq) continue;
            isSame = HistoryEntityUtils.compareEntryValue(newDyn, oldDyn);
            break;
        }
        if (!isSame) {
            result = false;
        }
        return result;
    }

    private static boolean compareEntryValue(DynamicObject newDyn, DynamicObject oldDyn) {
        boolean isSame = true;
        DataEntityPropertyCollection collection = oldDyn.getDataEntityType().getProperties();
        List<String> ignoreKeyList = HistoryEntityUtils.getCompareIgnoreKeyList();
        for (IDataEntityProperty property : collection) {
            String fieldName = property.getName();
            if (ignoreKeyList.contains(fieldName) || fieldName.equals("id")) continue;
            Object newValue = newDyn.get(fieldName);
            Object effectingValue = oldDyn.get(fieldName);
            if (newValue instanceof Long && effectingValue == null && newValue.equals(0L) || newValue == null && effectingValue == null) continue;
            if (newValue == null) {
                return false;
            }
            if (effectingValue != null && HistoryEntityUtils.compareValues(newValue, effectingValue)) continue;
            return false;
        }
        return isSame;
    }

    public static boolean checkNullInDynamicCollection(DynamicObjectCollection doc, Collection<String> fieldNames) {
        if (CollectionUtils.isEmpty((Collection)doc) || CollectionUtils.isEmpty(fieldNames)) {
            return false;
        }
        for (DynamicObject dyn : doc) {
            if (HistoryEntityUtils.checkNullInDynamicObject(dyn, fieldNames)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNullInDynamicObject(DynamicObject dyn, Collection<String> fieldNames) {
        if (dyn == null || CollectionUtils.isEmpty(fieldNames)) {
            return false;
        }
        for (String field : fieldNames) {
            OrmLocaleValue mulProp;
            Object prop = dyn.get(field);
            if (!(prop instanceof String ? StringUtils.isEmpty((String)((String)prop)) : (prop instanceof OrmLocaleValue ? StringUtils.isEmpty((String)(mulProp = (OrmLocaleValue)prop).getLocaleValue()) : prop == null))) continue;
            return false;
        }
        return true;
    }
}

