/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.init;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessagePublisher;
import kd.hr.hbp.business.init.IInitDomainDataService;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public abstract class AbstractConsumerHandleService
implements IInitDomainDataService {
    private static Log LOG = LogFactory.getLog(AbstractConsumerHandleService.class);
    private InitInParam initInParam;
    private InitOutParam initOutParam;
    private String messageStatus;
    private static String MESSAGE_STATUS_ACK = "A";
    private static String MESSAGE_STATUS_DENY = "B";
    private static String MESSAGE_STATUS_DISCARD = "C";
    private MessageAcker acker;
    private String messageId;
    private boolean useTranscationMsg = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(InitInParam initInParam) throws InvocationTargetException, IOException {
        LOG.info("hric_init_consumer_start, execTaskId:{}, batchNumber:{}", (Object)initInParam.getExecTaskId(), (Object)initInParam.getBatchNumber());
        this.initInParam = this.doInitInParam(initInParam);
        this.doInitOutParam();
        MessagePublisher pub = MQFactory.get().createSimplePublisher("hrmp", "hric_init_callback_queue");
        TXHandle required = TX.required();
        try {
            this.invokeMethod();
            if (MESSAGE_STATUS_DENY.equals(this.messageStatus)) {
                LOG.info("biz deny message, messageId = {}, execTaskId = {}", (Object)this.messageId, (Object)initInParam.getExecTaskId());
                return;
            }
            if (MESSAGE_STATUS_DISCARD.equals(this.messageStatus)) {
                LOG.warn("biz discard message, messageId = {}, execTaskId = {}", (Object)this.messageId, (Object)initInParam.getExecTaskId());
                return;
            }
            if (this.useTranscationMsg) {
                if (required.isRollback()) {
                    String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5f02\u5e38\u4e8b\u52a1\u5df2\u56de\u6eda\uff0ctraceid=%1$s", (String)"AbstractConsumerHandleService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), RequestContext.get().getTraceId());
                    this.initOutParam.setSuccess(false);
                    this.initOutParam.addExtendInfo("errorMsg", (Object)message);
                    pub.publish(HRJSONUtils.toString((Object)this.initOutParam));
                    LOG.info("send_transcation_msg_rollback, execTaskId={},batchNumber={},traceid={}", new Object[]{this.initOutParam.getExecTaskId(), this.initOutParam.getBatchNumber(), RequestContext.get().getTraceId()});
                } else {
                    pub.publishInDbTranscation(EntityMetadataCache.getDataEntityType((String)initInParam.getEntityNumber()).getDBRouteKey(), (Object)HRJSONUtils.toString((Object)this.initOutParam));
                    LOG.info("send_transcation_msg_success, execTaskId={},batchNumber={}", (Object)this.initOutParam.getExecTaskId(), (Object)this.initOutParam.getBatchNumber());
                }
            } else {
                pub.publish(HRJSONUtils.toString((Object)this.initOutParam));
                LOG.info("send_msg_success, execTaskId={},batchNumber={}", (Object)this.initOutParam.getExecTaskId(), (Object)this.initOutParam.getBatchNumber());
            }
        }
        catch (Throwable throwable) {
            required.markRollback();
            Throwable targetThrowable = AbstractConsumerHandleService.getTargetEx(throwable);
            LOG.error("messageId, {}", (Object)this.messageId, (Object)targetThrowable);
            this.initOutParam.setSuccess(false);
            this.initOutParam.addExtendInfo("errorMsg", (Object)AbstractConsumerHandleService.getStackTraceString(targetThrowable));
            pub.publish(HRJSONUtils.toString((Object)this.initOutParam));
            this.acker.discard(this.messageId);
        }
        finally {
            required.close();
            pub.close();
        }
    }

    protected void setUseTranscationMsg(boolean useTranscationMsg) {
        this.useTranscationMsg = useTranscationMsg;
    }

    private String getErrorMessage(Exception ex) {
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull(ex.getMessage())) {
            sb.append(ex.getMessage());
            sb.append(",");
        }
        if (Objects.nonNull(ex.getCause()) && Objects.nonNull(ex.getCause().getMessage())) {
            sb.append(ex.getCause().getMessage());
        }
        return sb.toString();
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable.getCause() != null) {
            return AbstractConsumerHandleService.getStackTraceString(throwable.getCause());
        }
        StringBuilder sb = new StringBuilder("traceId:");
        sb.append(RequestContext.get().getTraceId()).append('\n');
        sb.append("message:").append(throwable.getMessage()).append('\n');
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (sb.length() > 8000) {
                return sb.toString();
            }
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }

    private static Throwable getTargetEx(Throwable ex) {
        if (ex.getCause() == null) {
            return ex;
        }
        return AbstractConsumerHandleService.getTargetEx(ex.getCause());
    }

    protected InitInParam doInitInParam(InitInParam initInParam) {
        this.acker = initInParam.getAcker();
        this.messageId = initInParam.getMessageId();
        initInParam.setAcker(null);
        return initInParam;
    }

    protected void doInitOutParam() {
        this.initOutParam = InitOutParam.getInstance();
        this.initOutParam.setExecTaskId(this.initInParam.getExecTaskId());
        this.initOutParam.setBatchNumber(this.initInParam.getBatchNumber());
    }

    private void invokeMethod() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        MethodUtils.invokeMethod((Object)this, (String)this.initInParam.getMethod());
    }

    protected InitInParam getInitInParam() {
        return this.initInParam;
    }

    protected InitOutParam getInitOutParam() {
        return this.initOutParam;
    }

    protected void setInitOutParam(InitOutParam initOutParam) {
        this.initOutParam = initOutParam;
    }

    protected void deny() {
        if (MESSAGE_STATUS_DENY.equals(this.messageStatus)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)this.messageStatus)) {
            this.messageStatus = MESSAGE_STATUS_DENY;
            this.acker.deny(this.messageId);
            return;
        }
        throw new KDBizException("message already response, status:" + this.messageStatus);
    }

    protected void ack() {
        if (MESSAGE_STATUS_ACK.equals(this.messageStatus)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)this.messageStatus)) {
            this.messageStatus = MESSAGE_STATUS_ACK;
            this.acker.ack(this.messageId);
            return;
        }
        throw new KDBizException("message already response, status:" + this.messageStatus);
    }

    protected void discard() {
        if (MESSAGE_STATUS_DISCARD.equals(this.messageStatus)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)this.messageStatus)) {
            this.messageStatus = MESSAGE_STATUS_DISCARD;
            this.acker.discard(this.messageId);
            return;
        }
        throw new KDBizException("message already response, status:" + this.messageStatus);
    }
}

