/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.init;

import java.io.IOException;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.init.InitServiceFactory;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRJSONUtils;

public class CommonInitConsumer
implements MessageConsumer {
    private static Log LOG = LogFactory.getLog(CommonInitConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker messageAcker) {
        InitInParam initInParam = null;
        try {
            initInParam = this.parseBody(body);
            LOG.info("consumer_start: execTaskId:{},batchNumber:{}", (Object)initInParam.getExecTaskId(), (Object)initInParam.getBatchNumber());
            initInParam.setAcker(messageAcker);
            initInParam.setMessageId(messageId);
            initInParam.setResend(resend);
        }
        catch (IOException ex) {
            LOG.error("parse body error, body : {} , message: {}", body, (Object)ex.getMessage());
            messageAcker.discard(messageId);
            return;
        }
        try {
            InitServiceFactory.getService(initInParam).handle(initInParam);
        }
        catch (Throwable ex) {
            LOG.error("Other Exception: ", ex);
            MessagePublisher pub = MQFactory.get().createSimplePublisher("hrmp", "hric_init_callback_queue");
            try {
                pub.publish(HRJSONUtils.toString((Object)this.getInitOutParam(initInParam, ex)));
            }
            catch (IOException ioException) {
                LOG.error((Throwable)ioException);
            }
            messageAcker.discard(messageId);
        }
    }

    private InitOutParam getInitOutParam(InitInParam initInParam, Throwable ex) {
        InitOutParam initOutParam = InitOutParam.getInstance();
        initOutParam.setBatchNumber(initInParam.getBatchNumber());
        initOutParam.setExecTaskId(initInParam.getExecTaskId());
        initOutParam.setSuccess(false);
        initOutParam.addExtendInfo("errorMsg", (Object)this.getErrorMessage(ex));
        return initOutParam;
    }

    private String getErrorMessage(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull(ex.getMessage())) {
            sb.append(ex.getMessage());
            sb.append(",");
        }
        if (Objects.nonNull(ex.getCause()) && Objects.nonNull(ex.getCause().getMessage())) {
            sb.append(ex.getCause().getMessage());
        }
        return sb.toString();
    }

    private InitInParam parseBody(Object body) throws IOException {
        return (InitInParam)JSONUtils.cast((String)((String)body), InitInParam.class);
    }
}

