/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.log.AppLogInfo;
import kd.hr.hbp.business.log.EntityModifyInfo;
import kd.hr.hbp.business.log.FieldModifyInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifyDirtyManager {
    private static final Log LOG = LogFactory.getLog(ModifyDirtyManager.class);
    private MainEntityType mainEntityType;
    private DynamicObject[] successObjs;
    private Map<String, EntityModifyInfo> modifyInfoMap = new HashMap<String, EntityModifyInfo>();
    private String operate;
    private Map<String, IDataEntityProperty> monitorFields;
    private TimeZone userTimeZone;
    private TimeZone sysTimeZone;
    private static final Log LOGGER = LogFactory.getLog(ModifyDirtyManager.class);

    protected List<AppLogInfo> buildLogInfo(DynamicObject[] dys) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dys.length);
        Date now = TimeServiceHelper.now();
        for (DynamicObject mainObj : dys) {
            Object pkValObj = mainObj.getPkValue();
            if (pkValObj == null) continue;
            String pkValStr = pkValObj.toString();
            EntityModifyInfo entityModifyInfo = this.getEntityModifyInfo(pkValStr);
            AppLogInfo logInfo = new AppLogInfo();
            logInfo.setUserID(RequestContext.get().getCurrUserId());
            String formId = mainObj.getDynamicObjectType().getName();
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
            logInfo.setBizAppID(appId);
            logInfo.setBizObjID(formId);
            logInfo.setOpTime(now);
            logInfo.setOpName(this.operate);
            if (entityModifyInfo == null || entityModifyInfo.isEmpty()) continue;
            String flag = entityModifyInfo.getFlag() == null ? "" : entityModifyInfo.getFlag();
            logInfo.setModifyBillID(pkValObj + flag);
            logInfo.setModifyBillNo(entityModifyInfo.getCaption());
            ObjectMapper mapper = new ObjectMapper();
            String modifyContentStr = null;
            try {
                modifyContentStr = mapper.writeValueAsString((Object)entityModifyInfo);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
            if (StringUtils.isBlank((CharSequence)modifyContentStr)) continue;
            logInfo.setModifyContent(modifyContentStr);
            list.add(logInfo);
        }
        return list;
    }

    public EntityModifyInfo getEntityModifyInfo(String pkValue) {
        return this.modifyInfoMap.get(pkValue);
    }

    public void init(DynamicObjectType dynamicObjectType, DynamicObject[] successObjs, String operate) {
        this.mainEntityType = (MainEntityType)dynamicObjectType;
        this.successObjs = successObjs;
        this.operate = operate;
        this.modifyInfoMap = new HashMap<String, EntityModifyInfo>();
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject dyo = service.getSysTimezone();
        this.sysTimeZone = TimeZone.getTimeZone(dyo.getString("number"));
        dyo = service.getUserTimezone(Long.valueOf(RequestContext.get().getCurrUserId()));
        this.userTimeZone = TimeZone.getTimeZone(dyo.getString("number"));
        try {
            this.monitorFields = EntityMetadataCache.getDataEntityType((String)dynamicObjectType.getName()).getAllFields();
            this.build();
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Object)e);
        }
    }

    private void build() {
        List pks = Stream.of(this.successObjs).map(successObj -> successObj.getPkValue()).distinct().collect(Collectors.toList());
        boolean isDeleteMainObj = this.isDeleteOperate();
        Map<Object, DynamicObject> objectDynamicObjectMap = null;
        if (isDeleteMainObj) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.mainEntityType.getName());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)dataEntityType);
            objectDynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        } else {
            objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (DynamicObjectType)this.mainEntityType);
        }
        for (DynamicObject mainObj : this.successObjs) {
            String enable;
            Object pkValObj = mainObj.getPkValue();
            if (pkValObj == null) continue;
            String pkValStr = pkValObj.toString();
            boolean isNewMainObj = !mainObj.getDataEntityState().getFromDatabase() && !isDeleteMainObj;
            DynamicObject cacheObj = objectDynamicObjectMap.get(pkValObj);
            if (cacheObj != null && (enable = cacheObj.getString("enable")) != null) {
                if (HRStringUtils.equals((String)this.operate, (String)"enable") && HRStringUtils.equals((String)enable, (String)"1")) {
                    cacheObj.set("enable", (Object)"0");
                } else if (HRStringUtils.equals((String)this.operate, (String)"disable") && HRStringUtils.equals((String)enable, (String)"0")) {
                    cacheObj.set("enable", (Object)"1");
                }
            }
            EntityModifyInfo info = this.buildMainEntry(mainObj, cacheObj, isDeleteMainObj, isNewMainObj);
            this.modifyInfoMap.put(pkValStr, info);
        }
    }

    protected String getBillNo(DynamicObject dynamicObject) {
        IDataEntityProperty billNoProp = null;
        if (this.mainEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.mainEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.mainEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.mainEntityType instanceof BillEntityType) {
            billNoProp = this.mainEntityType.findProperty(((BillEntityType)this.mainEntityType).getBillNo());
        }
        if (billNoProp != null) {
            return (String)billNoProp.getValue((Object)dynamicObject);
        }
        return "";
    }

    protected EntityModifyInfo buildMainEntry(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDeleteMainObj, boolean isNewMainObj) {
        IDataEntityType mainEntityType = mainObj.getDataEntityType();
        String pkValueStr = mainObj.getPkValue().toString();
        ArrayList<IDataEntityProperty> mainDirtyProps = new ArrayList<IDataEntityProperty>();
        boolean isUpdateMainObj = !isDeleteMainObj && !isNewMainObj;
        EntityModifyInfo mainModifyInfo = new EntityModifyInfo();
        mainModifyInfo.setKeyID(pkValueStr);
        String billNo = this.getBillNo(mainObj);
        if (!StringUtils.isBlank((CharSequence)billNo)) {
            mainModifyInfo.setCaption(billNo);
        }
        this.handleMainEntity(mainObj, oldMainObj, isDeleteMainObj, isNewMainObj, mainDirtyProps, mainModifyInfo);
        if (isDeleteMainObj) {
            mainEntityType = oldMainObj.getDataEntityType();
        }
        for (ICollectionProperty subEntryProperty : mainEntityType.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection oldSubObjs;
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty || HRStringUtils.isEmpty((String)subEntryProperty.getItemType().getAlias())) continue;
            if (subEntryProperty instanceof MulBasedataProp) {
                this.handleMulBasedata(mainObj, oldMainObj, isDeleteMainObj, isNewMainObj, mainModifyInfo, subEntryProperty);
                continue;
            }
            if (isDeleteMainObj) {
                DynamicObjectCollection oldSubObjs2 = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj);
                if (oldSubObjs2 == null) continue;
                for (int index = 0; index < oldSubObjs2.size(); ++index) {
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs2.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(true, isNewMainObj, false, true, subEntryProperty, index, null, oldSubObj, subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                continue;
            }
            DynamicObjectCollection subObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
            DynamicObjectCollection dynamicObjectCollection = oldSubObjs = oldMainObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj) : null;
            if (subObjs != null) {
                for (int index = 0; index < subObjs.size(); ++index) {
                    EntityModifyInfo subModifyInfo;
                    boolean isNewRow;
                    DynamicObject subObj = (DynamicObject)subObjs.get(index);
                    Object subObjPkValue = subObj.getPkValue();
                    if (subObjPkValue == null) continue;
                    DynamicObject oldSubObj = null;
                    boolean bl = isNewRow = oldSubObjs == null || oldSubObjs.stream().noneMatch(y -> y.getPkValue().equals(subObjPkValue));
                    if (!isNewRow && oldSubObjs != null) {
                        oldSubObj = oldSubObjs.stream().filter(o -> o.getPkValue().equals(subObjPkValue)).findFirst().orElse(null);
                    }
                    if ((subModifyInfo = this.buildSubEntry(false, isNewMainObj, isNewRow, false, subEntryProperty, index, subObj, oldSubObj, subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
            }
            if (!isUpdateMainObj || oldSubObjs == null) continue;
            List deletedSubObjs = oldSubObjs.stream().filter(s -> {
                assert (subObjs != null);
                return subObjs.stream().noneMatch(y -> y.getPkValue().equals(s.getPkValue()));
            }).collect(Collectors.toList());
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(false, false, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                mainModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return mainModifyInfo;
    }

    private void handleMulBasedata(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDeleteMainObj, boolean isNewMainObj, EntityModifyInfo mainModifyInfo, ICollectionProperty subEntryProperty) {
        if (subEntryProperty == null) {
            return;
        }
        MulBasedataProp mulbdProp = (MulBasedataProp)subEntryProperty;
        if (isDeleteMainObj) {
            DynamicObjectCollection mulSelObjs = oldMainObj == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(mulBasedataPropValue, null, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        } else if (isNewMainObj) {
            DynamicObjectCollection mulSelObjs = mainObj == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(null, mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        } else {
            DynamicObjectCollection mulSelObjs = mainObj == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            DynamicObjectCollection mulSelObjsOld = oldMainObj == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj);
            String mulBasedataPropValueOld = this.getMulBasedataPropValue(mulSelObjsOld, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue) && !mulBasedataPropValue.equals(mulBasedataPropValueOld) || !StringUtils.isBlank((CharSequence)mulBasedataPropValueOld) && !mulBasedataPropValueOld.equals(mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(mulBasedataPropValueOld, mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        }
    }

    private void handleMainEntity(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDeleteMainObj, boolean isNewMainObj, List<IDataEntityProperty> mainDirtyProps, EntityModifyInfo mainModifyInfo) {
        if (isDeleteMainObj) {
            this.parseDirtyProp(oldMainObj, mainDirtyProps, false);
            for (IDataEntityProperty mainDirtyProp : mainDirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, mainDirtyProp, true);
                if (Objects.isNull(fieldModifyInfo)) continue;
                mainModifyInfo.addField(mainDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("-");
        } else if (isNewMainObj) {
            this.parseDirtyProp(mainObj, mainDirtyProps, false);
            for (IDataEntityProperty mainDirtyProp : mainDirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, mainDirtyProp, false);
                if (Objects.isNull(fieldModifyInfo)) continue;
                mainModifyInfo.addField(mainDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("+");
        } else {
            this.parseDirtyProp(mainObj, mainDirtyProps, true);
            for (IDataEntityProperty mainDirtyProp : mainDirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, mainDirtyProp, false);
                if (Objects.isNull(fieldModifyInfo)) continue;
                mainModifyInfo.addField(mainDirtyProp.getName(), fieldModifyInfo);
            }
        }
    }

    private EntityModifyInfo buildSubEntry(boolean isDeleteMainObj, boolean isNewMainObj, boolean isNewRow, boolean isDeleteRow, ICollectionProperty collectionProperty, int indexOfEntry, DynamicObject obj, DynamicObject oldObj, String parentPropertyPath) {
        IDataEntityProperty entrySeq;
        DynamicObjectType subObjectType;
        String pkValueStr;
        Object newRowPkValue = obj != null ? obj.getPkValue() : null;
        Object oldRowPkValue = oldObj != null ? oldObj.getPkValue() : null;
        String pkValueOldStr = oldRowPkValue != null ? oldRowPkValue.toString() : null;
        String string = pkValueStr = newRowPkValue != null ? newRowPkValue.toString() : pkValueOldStr;
        if (StringUtils.isBlank((CharSequence)pkValueStr)) {
            return null;
        }
        if (oldObj != null) {
            // empty if block
        }
        DynamicObjectType dynamicObjectType = oldObj != null ? oldObj.getDynamicObjectType() : null;
        String entryDisplayName = collectionProperty.getDisplayName().getLocaleValue();
        DynamicObjectType dynamicObjectType2 = subObjectType = obj != null ? obj.getDynamicObjectType() : dynamicObjectType;
        if (subObjectType == null) {
            return null;
        }
        String seqStr = "" + (indexOfEntry + 1);
        if (subObjectType instanceof IEntryType && (entrySeq = ((IEntryType)subObjectType).getSeqProperty()) != null) {
            try {
                Object seqVal = entrySeq.getValue((Object)(obj != null ? obj : oldObj));
                if (seqVal != null) {
                    seqStr = seqVal.toString();
                }
            }
            catch (ORMArgInvalidException e) {
                LOG.error(e.getMessage());
            }
        }
        String caption = entryDisplayName + "." + seqStr;
        EntityModifyInfo entityModifyInfo = new EntityModifyInfo(pkValueStr, caption);
        ArrayList<IDataEntityProperty> dirtyProps = new ArrayList<IDataEntityProperty>();
        this.handleSameEntity(isDeleteMainObj, isNewMainObj, isDeleteRow, obj, oldObj, entityModifyInfo, dirtyProps);
        if (isDeleteRow || isDeleteMainObj) {
            entityModifyInfo.setFlag("-");
        } else if (isNewMainObj || isNewRow) {
            entityModifyInfo.setFlag("+");
        }
        if (isDeleteMainObj && oldObj != null) {
            subObjectType = oldObj.getDynamicObjectType();
        }
        for (ICollectionProperty subEntryProperty : subObjectType.getProperties().getCollectionProperties(false)) {
            this.handleSubEntity(isDeleteMainObj, isNewMainObj, obj, oldObj, parentPropertyPath, entityModifyInfo, subEntryProperty);
        }
        return entityModifyInfo;
    }

    private void handleSubEntity(boolean isDeleteMainObj, boolean isNewMainObj, DynamicObject obj, DynamicObject oldObj, String parentPropertyPath, EntityModifyInfo entityModifyInfo, ICollectionProperty subEntryProperty) {
        block7: {
            String subEntryName;
            block8: {
                DynamicObjectCollection oldSubObjs;
                block6: {
                    subEntryName = subEntryProperty.getName().toLowerCase();
                    if (subEntryProperty instanceof DynamicLocaleProperty) {
                        return;
                    }
                    if (!(subEntryProperty instanceof MulBasedataProp)) break block6;
                    this.handleMulBasedata(obj, oldObj, isDeleteMainObj, isNewMainObj, entityModifyInfo, subEntryProperty);
                    break block7;
                }
                if (!isDeleteMainObj) break block8;
                DynamicObjectCollection dynamicObjectCollection = oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null;
                if (oldSubObjs == null) break block7;
                for (int index = 0; index < oldSubObjs.size(); ++index) {
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(true, isNewMainObj, false, false, subEntryProperty, index, null, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    entityModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                break block7;
            }
            DynamicObjectCollection subObjs = obj == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)obj);
            DynamicObjectCollection oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null;
            for (int index = 0; index < subObjs.size(); ++index) {
                EntityModifyInfo subModifyInfo;
                boolean isSubObjNewRow;
                DynamicObject subObj = (DynamicObject)subObjs.get(index);
                Object subObjPkValue = subObj.getPkValue();
                if (subObjPkValue == null) continue;
                DynamicObject oldSubObj = null;
                boolean bl = isSubObjNewRow = oldSubObjs == null || oldSubObjs.stream().noneMatch(y -> y.getPkValue().equals(subObjPkValue));
                if (!isSubObjNewRow && oldSubObjs != null) {
                    oldSubObj = oldSubObjs.stream().filter(o -> o.getPkValue().equals(subObjPkValue)).findFirst().orElse(null);
                }
                if ((subModifyInfo = this.buildSubEntry(false, isNewMainObj, isSubObjNewRow, false, subEntryProperty, index, subObj, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subModifyInfo);
            }
            if (!isNewMainObj && oldSubObjs != null) {
                List deletedSubObjs = oldSubObjs.stream().filter(s -> subObjs.stream().noneMatch(y -> y.getPkValue().equals(s.getPkValue()))).collect(Collectors.toList());
                for (DynamicObject deletedSubObj : deletedSubObjs) {
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(false, false, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    entityModifyInfo.addChild(subEntryName, subModifyInfo);
                }
            }
        }
    }

    private void handleSameEntity(boolean isDeleteMainObj, boolean isNewMainObj, boolean isDeleteRow, DynamicObject obj, DynamicObject oldObj, EntityModifyInfo entityModifyInfo, List<IDataEntityProperty> dirtyProps) {
        if (isDeleteMainObj) {
            this.parseDirtyProp(oldObj, dirtyProps, false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteMainObj);
                if (Objects.isNull(fieldModifyInfo)) continue;
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("-");
        } else if (isNewMainObj) {
            this.parseDirtyProp(obj, dirtyProps, false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                if (Objects.isNull(fieldModifyInfo)) continue;
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("+");
        } else {
            if (isDeleteRow) {
                this.parseDirtyProp(oldObj, dirtyProps, false);
            } else {
                this.parseDirtyProp(obj, dirtyProps, true);
            }
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                if (Objects.isNull(fieldModifyInfo)) continue;
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
        }
    }

    private String getPropertyValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof DynamicSimpleProperty) {
            if (dynamicProperty instanceof IFieldHandle) {
                return this.getFieldHandle(dynamicObject, dynamicProperty);
            }
            return dynamicObject.getString(dynamicProperty.getName());
        }
        if (dynamicProperty instanceof DynamicComplexProperty) {
            try {
                return this.getComplexProp(dynamicObject, dynamicProperty);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private String getComplexProp(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof FlexProp) {
            List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dynamicObject, (FlexProp)((FlexProp)dynamicProperty), (String)((FlexProp)dynamicProperty).getBasePropertyKey());
            ArrayList<String> displayValues = new ArrayList<String>();
            for (Map item : flexValues) {
                String alias = (String)item.get("alias");
                if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                displayValues.add(alias);
            }
            return String.join((CharSequence)"; ", displayValues);
        }
        DynamicObject obj = dynamicObject.getDynamicObject(dynamicProperty);
        return Objects.requireNonNull(Optional.ofNullable(obj).map(s -> s.getString("name")).orElse(null));
    }

    @Nullable
    private String getFieldHandle(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof TimeProp) {
            TimeProp timeProp = (TimeProp)dynamicProperty;
            Object timePropObj = timeProp.getBasePropDisplayValue((Object)dynamicObject);
            return timePropObj != null ? timePropObj.toString() : null;
        }
        try {
            IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
            ListField listField = new ListField(dynamicProperty.getName());
            listField.setSrcFieldProp(dynamicProperty);
            listField.setFieldProp(dynamicProperty);
            AbstractColumnDesc listColumnDesc = fldHandle.getListColumnDesc(listField);
            listColumnDesc.setFormaType(2);
            Object valueObj = listColumnDesc.getValue(dynamicObject);
            if (valueObj instanceof Object[]) {
                Object[] val = (Object[])valueObj;
                if (listColumnDesc instanceof DateTimeColumnDesc && val[1] instanceof Date) {
                    return HRDateTimeUtils.format((Date)((Date)val[1]));
                }
                if (val.length > 0) {
                    Object o = val[0];
                    return o != null ? o.toString() : null;
                }
            }
            return valueObj != null ? valueObj.toString() : null;
        }
        catch (Exception e1) {
            try {
                IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                Object dispValueObj = fldHandle.getBasePropDisplayValue((Object)dynamicObject);
                return dispValueObj != null ? dispValueObj.toString() : null;
            }
            catch (Exception e) {
                return dynamicObject.getString(dynamicProperty.getName());
            }
        }
    }

    private String getMulBasedataPropValue(DynamicObjectCollection mulSelObjs, MulBasedataProp mulbdProp) {
        if (mulSelObjs == null || mulSelObjs.size() == 0 || mulbdProp == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject mulSelObj : mulSelObjs) {
            String value;
            IComplexProperty refBaseProp = mulbdProp.getRefBaseProp();
            DynamicObject refBaseObj = (DynamicObject)refBaseProp.getValue((Object)mulSelObj);
            Object displayPropObj = refBaseObj.get(mulbdProp.getDisplayProp());
            if (displayPropObj == null || StringUtils.isBlank((CharSequence)(value = displayPropObj.toString()))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private FieldModifyInfo buildFieldModifyInfo(DynamicObject obj, DynamicObject oldObj, IDataEntityProperty property, boolean isDelete) {
        LocaleString name = property.getDisplayName();
        String displayName = name != null ? name.toString() : property.getName();
        String newValue = null;
        if (obj != null && !isDelete) {
            newValue = this.getPropertyValue(obj, property);
        }
        String oldValue = null;
        if (oldObj != null) {
            oldValue = this.getPropertyValue(oldObj, property);
        }
        Object desensitizeNewValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)obj, (Object)newValue);
        Object desensitizeOldValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)obj, (Object)oldValue);
        if (HRStringUtils.equals((String)newValue, (String)oldValue)) {
            return null;
        }
        return new FieldModifyInfo(desensitizeOldValue, desensitizeNewValue, displayName);
    }

    private void parseDirtyProp(DynamicObject obj, List<IDataEntityProperty> dirtyProps, boolean isUpdate) {
        ArrayList<IDataEntityProperty> monitorProps = new ArrayList<IDataEntityProperty>();
        this.parseDirtyPropByMonitor(obj, monitorProps);
        if (isUpdate) {
            ArrayList<IDataEntityProperty> dirtyStateProps = new ArrayList<IDataEntityProperty>();
            this.parseDirtyPropByState(obj, dirtyStateProps);
            if (dirtyStateProps.size() == 0) {
                return;
            }
            for (IDataEntityProperty dirtyStateProp : dirtyStateProps) {
                if (dirtyStateProp instanceof CreaterProp || dirtyStateProp instanceof CreateDateProp || HRStringUtils.isEmpty((String)dirtyStateProp.getAlias()) || dirtyStateProp instanceof ISimpleProperty && ((ISimpleProperty)dirtyStateProp).isEncrypt()) continue;
                dirtyProps.add(dirtyStateProp);
            }
        } else {
            dirtyProps.addAll(monitorProps);
        }
        dirtyProps.sort(Comparator.comparingInt(IDataEntityProperty::getOrdinal));
    }

    private void parseDirtyPropByMonitor(DynamicObject obj, List<IDataEntityProperty> dirtyProps) {
        if (this.monitorFields == null || this.monitorFields.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        for (Map.Entry<String, IDataEntityProperty> stringIDataEntityPropertyEntry : this.monitorFields.entrySet()) {
            IDataEntityProperty prop;
            String key = stringIDataEntityPropertyEntry.getKey();
            IDataEntityProperty property = stringIDataEntityPropertyEntry.getValue();
            if (property instanceof CreaterProp || property instanceof CreateDateProp || HRStringUtils.isEmpty((String)property.getAlias()) || property instanceof ISimpleProperty && ((ISimpleProperty)property).isEncrypt() || (prop = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            dirtyProps.add(prop);
        }
    }

    private void parseDirtyPropByState(DynamicObject obj, List<IDataEntityProperty> dirtyProps) {
        Iterator iterator = obj.getDataEntityState().getBizChangedProperties().iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property;
            IDataEntityProperty realProperty = property = (IDataEntityProperty)iterator.next();
            if (property instanceof PKFieldProp && property.getName().endsWith("_id")) {
                String bdPropName = property.getName().substring(0, property.getName().length() - 3);
                realProperty = (IDataEntityProperty)property.getParent().getProperties().get((Object)bdPropName);
                if (realProperty == null) {
                    realProperty = property;
                }
            }
            dirtyProps.add(realProperty);
        }
    }

    private boolean isDeleteOperate() {
        return "delete".equals(this.operate);
    }

    public void batchInsertLog(DynamicObject[] dys) {
        try {
            List<AppLogInfo> appLogInfos = this.buildLogInfo(dys);
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            HRBaseServiceHelper logview = new HRBaseServiceHelper("hbss_logview");
            for (AppLogInfo appLogInfo : appLogInfos) {
                DynamicObject dyn = logview.generateEmptyDynamicObject();
                dyn.set("user", (Object)appLogInfo.getUserID());
                dyn.set("bizapp", (Object)appLogInfo.getBizAppID());
                dyn.set("bizobj", (Object)appLogInfo.getBizObjID());
                dyn.set("optime", (Object)appLogInfo.getOpTime());
                dyn.set("modifybillid", (Object)appLogInfo.getModifyBillID());
                dyn.set("modifybillno", (Object)appLogInfo.getModifyBillNo());
                dyn.set("modifyContent", (Object)appLogInfo.getModifyContent());
                dynamicObjectCollection.add((Object)dyn);
            }
            try (TXHandle txHandle = TX.requiresNew();){
                logview.save(dynamicObjectCollection);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

