/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.multimpt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MultiConfigService {
    public static Map<String, Set<String>> queryMultiConfig(String templateCode) {
        HashMap configMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject templateData = new HRBaseServiceHelper("hrcs_multientityimptmpl").queryOne("mainentitytmpl,id,assocentitytmplentry.assocentitytmpl,assocentitytmplentry.entityuniqueval,mainentityuniqueval", new QFilter[]{new QFilter("number", "=", (Object)templateCode)});
        if (Objects.isNull(templateData)) {
            return Maps.newHashMap();
        }
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        configMap.put(mainBizObjNum, MultiConfigService.splitUniqueVal(templateData.getString("mainentityuniqueval")));
        DynamicObjectCollection assocEntityTmplDyoColl = templateData.getDynamicObjectCollection("assocentitytmplentry");
        for (DynamicObject dynamicObject : assocEntityTmplDyoColl) {
            DynamicObject assocEntityTmplDyo = dynamicObject.getDynamicObject("assocentitytmpl");
            String assocBizObjNum = assocEntityTmplDyo.getString("bizobject.number");
            configMap.put(assocBizObjNum, MultiConfigService.splitUniqueVal(dynamicObject.getString("entityuniqueval")));
        }
        return configMap;
    }

    private static Set<String> splitUniqueVal(String splitString) {
        Set<Object> splitSet = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)splitString)) {
            return splitSet;
        }
        String[] split = splitString.split(",");
        splitSet = Arrays.stream(split).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
        return splitSet;
    }

    public static String getSelectFieldsByTemplateCode(String templateCode, String entityId) {
        HashMap configMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject templateData = new HRBaseServiceHelper("hrcs_multientityimptmpl").queryOne("mainentitytmpl,id,assocentitytmplentry.assocentitytmpl,assocentitytmplentry.entityuniqueval,mainentityuniqueval", new QFilter[]{new QFilter("number", "=", (Object)templateCode)});
        if (Objects.isNull(templateData)) {
            return "";
        }
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        configMap.put(mainBizObjNum, (Long)mainEntityTmplDyo.getPkValue());
        DynamicObjectCollection assocEntityTmplDyoColl = templateData.getDynamicObjectCollection("assocentitytmplentry");
        for (DynamicObject dynamicObject : assocEntityTmplDyoColl) {
            DynamicObject assocEntityTmplDyo = dynamicObject.getDynamicObject("assocentitytmpl");
            String assocBizObjNum = assocEntityTmplDyo.getString("bizobject.number");
            configMap.put(assocBizObjNum, (Long)dynamicObject.getDynamicObject("assocentitytmpl").getPkValue());
        }
        List<ExportWriterFormat> formats = MultiConfigService.loadExportFormat(entityId, (Long)configMap.get(entityId));
        ArrayList fields = Lists.newArrayListWithCapacity((int)16);
        fields.addAll(formats.get((int)0).fields);
        if (formats.get((int)0).next.size() > 0) {
            ExportWriterFormat exportWriterFormat = (ExportWriterFormat)formats.get((int)0).next.get(0);
            exportWriterFormat.fields.forEach(entryField -> {
                if (entryField.contains(exportWriterFormat.name)) {
                    fields.add(entryField);
                } else {
                    fields.add(exportWriterFormat.name + "." + entryField);
                }
            });
        }
        return String.join((CharSequence)",", Sets.newHashSet((Iterable)fields));
    }

    private static List<ExportWriterFormat> loadExportFormat(String entityNumber, long templateId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(entityNumber, templateId, null, null);
        return JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
    }
}

