/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.openservicehelper.search;

import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SearchServiceHelper {
    public static String MULTIPLE_LABELFIELD_PREX = "multiple_label_";
    public static String SEARCH_FIELD_LABEL_PRE = "label_";

    public static ListShowParameter getLabelValueF7ShowForm(String number, Long searchObjId) {
        HashSet<String> labelIds = SearchServiceHelper.getLabelIds(number, searchObjId);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hrcs_labelvaluedisplay", (boolean)true, (int)0, (boolean)true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"LabelApiTestPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("hrcs_labelvaluetreelistf7");
        showParameter.setBillFormId("hrcs_labelvaluedisplay");
        showParameter.setCustomParam("labelIds", (Object)String.join((CharSequence)",", labelIds));
        showParameter.setCustomParam("type", (Object)"display");
        return showParameter;
    }

    public static boolean isLabelField(String fieldAlias) {
        if (!fieldAlias.contains(SEARCH_FIELD_LABEL_PRE)) {
            return false;
        }
        String[] split = fieldAlias.split(SEARCH_FIELD_LABEL_PRE);
        if (split.length != 2) {
            return false;
        }
        if (split[0].endsWith(".") || HRStringUtils.isEmpty((String)split[0])) {
            return StringUtils.isNumeric((CharSequence)split[1]);
        }
        return false;
    }

    public static HashSet<String> getLabelIds(String number, Long searchObjId) {
        HashSet idRange = Sets.newHashSetWithExpectedSize((int)16);
        String multipleLabelViewId = SearchServiceHelper.getMultipleLabelViewId(number);
        if (HRStringUtils.isEmpty((String)multipleLabelViewId)) {
            if (SearchServiceHelper.isLabelField(number)) {
                String[] split = number.split(SEARCH_FIELD_LABEL_PRE);
                idRange.add(split[1]);
                return idRange;
            }
            return idRange;
        }
        HashSet labelIdSet = (HashSet)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSService", "getLabelBySearchObj", searchObjId);
        idRange.addAll(labelIdSet);
        return idRange;
    }

    public static String getMultipleLabelViewId(String fieldAlias) {
        if (!fieldAlias.contains(MULTIPLE_LABELFIELD_PREX)) {
            return null;
        }
        String[] split = fieldAlias.split(MULTIPLE_LABELFIELD_PREX);
        if (split.length != 2) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)split[1])) {
            String sql = "select flabeldefaultviewid from t_hrss_secondfilter where fentryid = ?";
            return (String)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, (Object[])new Object[]{Long.valueOf(split[1])}, rs -> {
                if (rs.next()) {
                    return rs.getString("flabeldefaultviewid");
                }
                return null;
            });
        }
        return null;
    }
}

