/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.basedata;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.basedata.BaseDataOriUpgradeService;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataOriStatusUpgradeService {
    private String jsonDataFolder = "bdupgrade";

    public String upgrade(String dbKey, Long oriUpCompDataPk) {
        DBRoute dbRoute = BaseDataOriUpgradeService.getDBRoute(dbKey);
        String jsonStr = this.readJsonFile(oriUpCompDataPk);
        if (HRStringUtils.isEmpty((String)jsonStr)) {
            throw new KDBizException("t_hbss_oriupcompdata not exists data : " + oriUpCompDataPk);
        }
        List upgradeCompDataList = SerializationUtils.fromJsonStringToList((String)jsonStr, Map.class);
        StringBuilder updateLog = new StringBuilder();
        for (Map singleTbCompData : upgradeCompDataList) {
            StringBuilder singleUpLog = this.updateSingleTableOriStatus(dbRoute, singleTbCompData);
            updateLog.append((CharSequence)singleUpLog);
        }
        return updateLog.toString();
    }

    private StringBuilder updateSingleTableOriStatus(DBRoute dbRoute, Map<String, Object> singleTbCompData) {
        StringBuilder updateLog = new StringBuilder();
        String tableName = (String)singleTbCompData.get("TABLE_NAME");
        String fields = (String)singleTbCompData.get("TABLE_FIELDS");
        List<String> dbDataList = BaseDataOriUpgradeService.queryDbPresetData(dbRoute, tableName, fields);
        String[] fieldArr = fields.split(",");
        String mulFields = (String)singleTbCompData.get("MULLANG_TABLE_FIELDS");
        if (mulFields != null) {
            dbDataList = BaseDataOriUpgradeService.resetMulLangField(dbRoute, mulFields, tableName, fieldArr, dbDataList);
        }
        int idIndex = BaseDataOriUpgradeService.getIndex(fieldArr, "FID");
        List compDataList = (List)singleTbCompData.get("DATALIST");
        Map jsonDataMap = compDataList.stream().map(data -> data.split(",")).collect(Collectors.toMap(data -> data[idIndex], Function.identity()));
        Object mulBDTabObj = singleTbCompData.get("MUL_TABLE_DATA");
        HashMap<String, Map<String, String>> mulBDDataMMPList = null;
        if (mulBDTabObj != null) {
            mulBDDataMMPList = new HashMap<String, Map<String, String>>(16);
            List mulBDTableList = (List)mulBDTabObj;
            Set<String> pkS = dbDataList.stream().map(data -> data.split(",")).map(data -> data[idIndex]).collect(Collectors.toSet());
            for (String mulBDTable : mulBDTableList) {
                Map<String, String> mulDataMapList = BaseDataOriUpgradeService.queryMulBDTableData(dbRoute, pkS, mulBDTable);
                mulBDDataMMPList.put(mulBDTable, mulDataMapList);
            }
        }
        HashSet modifiedPks = Sets.newHashSetWithExpectedSize((int)16);
        HashSet unModifiedPks = Sets.newHashSetWithExpectedSize((int)16);
        for (String dbDataStr : dbDataList) {
            Object[] dbDataArr = dbDataStr.split(",");
            String dataPkStr = dbDataArr[idIndex];
            Object[] jsonDataArr = (String[])jsonDataMap.get(dataPkStr);
            if (jsonDataArr == null) continue;
            boolean dataDiff = false;
            if (Arrays.equals(dbDataArr, jsonDataArr)) {
                if (mulBDDataMMPList != null) {
                    dataDiff = this.existMulBDDataIsDiff(singleTbCompData, mulBDDataMMPList, dataPkStr);
                }
            } else {
                dataDiff = true;
            }
            if (dataDiff) {
                modifiedPks.add(dataPkStr);
                continue;
            }
            unModifiedPks.add(dataPkStr);
        }
        if (modifiedPks.size() > 0) {
            String ori1UpdateSql = "UPDATE " + tableName + " SET FORISTATUS = '1' WHERE FID IN (" + String.join((CharSequence)",", modifiedPks) + ")";
            updateLog.append(tableName).append(":[").append(String.join((CharSequence)",", modifiedPks)).append("] foristatus->1").append(";\n");
            DB.update((DBRoute)dbRoute, (String)ori1UpdateSql);
        }
        if (unModifiedPks.size() > 0) {
            String ori0UpdateSql = "UPDATE " + tableName + " SET FORISTATUS = '0' WHERE FID IN (" + String.join((CharSequence)",", unModifiedPks) + ")";
            updateLog.append(tableName).append(":[").append(String.join((CharSequence)",", unModifiedPks)).append("] foristatus->0").append(";\n");
            DB.update((DBRoute)dbRoute, (String)ori0UpdateSql);
        }
        return updateLog;
    }

    private boolean existMulBDDataIsDiff(Map<String, Object> singleTbCompData, Map<String, Map<String, String>> mulBDDataMMPList, String dataPkStr) {
        for (Map.Entry<String, Map<String, String>> entry : mulBDDataMMPList.entrySet()) {
            String mulDBTable = entry.getKey();
            Object standardMulBDDataObj = singleTbCompData.get(mulDBTable);
            if (standardMulBDDataObj == null) continue;
            Map standardMulBDDataMap = (Map)standardMulBDDataObj;
            String standardMulBDDatas = (String)standardMulBDDataMap.get(dataPkStr);
            String dbMulBDDatas = entry.getValue().get(dataPkStr);
            if (standardMulBDDatas == null || dbMulBDDatas == null) {
                if (standardMulBDDatas == null && dbMulBDDatas == null) continue;
                return true;
            }
            String[] dbMulDataArr = standardMulBDDatas.split(",");
            String[] jsonMulDataArr = dbMulBDDatas.split(",");
            List dbMulDataList = Arrays.stream(dbMulDataArr).sorted().collect(Collectors.toList());
            List jsonMulDataList = Arrays.stream(jsonMulDataArr).sorted().collect(Collectors.toList());
            if (jsonMulDataList.equals(dbMulDataList)) continue;
            return true;
        }
        return false;
    }

    protected String readJsonFile(Long oriUpCompDataPk) {
        String sql = "SELECT FJSONDATA FROM T_HBSS_ORIUPCOMPDATA WHERE FID = ?";
        return (String)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, (Object[])new Object[]{oriUpCompDataPk}, rs -> {
            if (rs.next()) {
                return rs.getString("FJSONDATA");
            }
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    protected String readJsonFile(String jsonFileName, Class clazz) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getJsonDataFolder() {
        return this.jsonDataFolder;
    }

    public void setJsonDataFolder(String jsonDataFolder) {
        this.jsonDataFolder = jsonDataFolder;
    }
}

