/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.basedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataOriUpgradeService {
    public static final String KEY_TABLENAME = "TABLE_NAME";
    public static final String KEY_FIELDS = "TABLE_FIELDS";
    public static final String KEY_DATA = "DATALIST";
    public static final String KEY_MULBASEDATA = "MUL_TABLE_DATA";
    public static final String KEY_MULLANGFIELDS = "MULLANG_TABLE_FIELDS";
    public static final String TABLE_ORIUPCOMPDATA = "T_HBSS_ORIUPCOMPDATA";

    public static Map<String, String> queryMulBDTableData(DBRoute dbRoute, Set<String> pkS, String mulBDTable) {
        String mulQuerySql = "SELECT FID,FBASEDATAID FROM " + mulBDTable + " WHERE FID IN (" + String.join((CharSequence)",", pkS) + ")";
        return (Map)HRDBUtil.query((DBRoute)dbRoute, (String)mulQuerySql, null, rs -> {
            ArrayList tmpDataList = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("FID", rs.getString("FID"));
                map.put("FBASEDATAID", rs.getString("FBASEDATAID"));
                tmpDataList.add(map);
            }
            return tmpDataList.stream().collect(Collectors.groupingBy(data -> (String)data.get("FID"), Collectors.mapping(data -> (String)data.get("FBASEDATAID"), Collectors.joining(","))));
        });
    }

    public static List<String> queryDbPresetData(DBRoute dbRoute, String tableName, String fields) {
        String queryDataSql = " SELECT " + fields + " FROM " + tableName + " WHERE FISSYSPRESET = '1' ";
        String[] fieldArr = fields.split(",");
        return (List)HRDBUtil.query((DBRoute)dbRoute, (String)queryDataSql, null, rs -> {
            ArrayList<String> tmpDataList = new ArrayList<String>(10);
            while (rs.next()) {
                StringBuilder dataStr = new StringBuilder();
                for (int i = 0; i < fieldArr.length; ++i) {
                    String cellVal = rs.getString(fieldArr[i]);
                    if ("".equals(cellVal)) {
                        cellVal = " ";
                    }
                    dataStr.append(cellVal).append(',');
                }
                dataStr.deleteCharAt(dataStr.length() - 1);
                tmpDataList.add(dataStr.toString());
            }
            return tmpDataList;
        });
    }

    private static Map<String, String> queryDbMulData(DBRoute dbRoute, String tableName, String fields, Set<String> pkS) {
        String queryDataSql = " SELECT FID," + fields + " FROM " + tableName + "_L WHERE FID IN (" + String.join((CharSequence)",", pkS) + ") AND FLOCALEID = 'zh_CN' ";
        String[] fieldArr = fields.split(",");
        return (Map)HRDBUtil.query((DBRoute)dbRoute, (String)queryDataSql, null, rs -> {
            HashMap<String, String> tmpDataList = new HashMap<String, String>(16);
            while (rs.next()) {
                StringBuilder dataStr = new StringBuilder();
                for (int i = 0; i < fieldArr.length; ++i) {
                    String cellVal = rs.getString(fieldArr[i]);
                    if ("".equals(cellVal)) {
                        cellVal = " ";
                    }
                    dataStr.append(cellVal).append(',');
                }
                dataStr.deleteCharAt(dataStr.length() - 1);
                tmpDataList.put(rs.getString("FID"), dataStr.toString());
            }
            return tmpDataList;
        });
    }

    public static List<String> resetMulLangField(DBRoute dbRoute, String mulFields, String tableName, String[] fieldArr, List<String> dataList) {
        int idIndex = BaseDataOriUpgradeService.getIndex(fieldArr, "FID");
        Set<String> pkS = dataList.stream().map(data -> data.split(",")).map(data -> data[idIndex]).collect(Collectors.toSet());
        Map<String, String> dbMulDataMap = BaseDataOriUpgradeService.queryDbMulData(dbRoute, tableName, mulFields, pkS);
        String[] mulFieldArr = mulFields.split(",");
        ArrayList<String> dataCopyList = new ArrayList<String>(dataList.size());
        for (String dataStr : dataList) {
            CharSequence[] dataArr = dataStr.split(",");
            String pk = dataArr[idIndex];
            String mulDataStr = dbMulDataMap.get(pk);
            if (HRStringUtils.isEmpty((String)mulDataStr)) {
                dataCopyList.add(dataStr);
                continue;
            }
            String[] mulDataArr = mulDataStr.split(",");
            for (int i = 0; i < mulFieldArr.length; ++i) {
                String mulField = mulFieldArr[i];
                int dataIndx = BaseDataOriUpgradeService.getIndex(fieldArr, mulField);
                dataArr[dataIndx] = mulDataArr[i];
            }
            dataStr = String.join((CharSequence)",", dataArr);
            dataCopyList.add(dataStr);
        }
        return dataCopyList;
    }

    public static DBRoute getDBRoute(String dbKey) {
        DBRoute dbRoute;
        try {
            dbRoute = DBRoute.of((String)dbKey);
        }
        catch (Exception e) {
            throw new KDBizException("dbKey error:" + dbKey);
        }
        return dbRoute;
    }

    public static int getIndex(String[] arr, String item) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(item)) continue;
            return i;
        }
        return -1;
    }
}

