/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj;

import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.ksql.DimKSqlQueryService;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlQueryService;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;

public class ReportQueryPlanByKSql
extends IReportQueryPlan {
    private KSqlQueryService kSqlQueryService;

    public ReportQueryPlanByKSql(HRComplexObjContext context) {
        super(context);
        this.kSqlQueryService = "2".equals(context.getQueryMode()) ? new DimKSqlQueryService(context) : new KSqlQueryService(context);
    }

    @Override
    public DataSet queryDataSet() {
        return this.kSqlQueryService.query4DataSet();
    }

    @Override
    public DataSet queryDataSet(int start, int limit) {
        return this.kSqlQueryService.query4DataSet(start, limit);
    }

    @Override
    public List<Map<String, Object>> queryMap() {
        return this.kSqlQueryService.query4ListMap();
    }

    @Override
    public List<Map<String, Object>> queryMap(int start, int limit) {
        return this.kSqlQueryService.query4ListMap(start, limit);
    }

    @Override
    public long queryDataCount(int start, int limit) {
        return this.kSqlQueryService.queryDataCount(start, limit);
    }

    @Override
    public List<Map<String, DimensionData>> queryDimensionData() {
        if (this.kSqlQueryService instanceof DimKSqlQueryService) {
            return ((DimKSqlQueryService)this.kSqlQueryService).queryDim4ListMap();
        }
        return super.queryDimensionData();
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<OrderField> getOrderFields() {
        Table<String, String, String> orderFieldTable = this.kSqlQueryService.getParser().getAliasToOrderFieldTable();
        HRComplexObjContext complexObjCont = this.kSqlQueryService.getComplexObjCont();
        Map<String, String> sortTypeMap = complexObjCont.getSortFieldInfoList().stream().collect(Collectors.toMap(SortFieldInfo::getFieldAlias, sortFieldInfo -> {
            if (SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())) {
                return SortFieldInfo.SORTORD_DESC;
            }
            return sortFieldInfo.getSortord();
        }, (x, y) -> x));
        return orderFieldTable.cellSet().stream().filter(cell -> cell.getRowKey() != null && cell.getValue() != null && sortTypeMap.get(cell.getRowKey()) != null).map(cell -> new OrderField((String)cell.getRowKey(), (String)cell.getValue(), DataTypeEnum.INTEGER, (String)sortTypeMap.get(cell.getRowKey()), true)).collect(Collectors.toList());
    }
}

