/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;

public class DimPagingFilterMap
extends FilterFunction {
    private static final long serialVersionUID = -3913370062508870409L;
    private final int start;
    private final int limit;
    private final List<String> dimTopList;
    private final List<String> dimFieldAliases;
    private final Map<String, Integer> fieldIndexMap;
    private Set<String> dimSet;

    public DimPagingFilterMap(int start, int limit, List<String> dimFieldAliases, RowMeta sourceRowMeta) {
        this.start = start;
        this.limit = limit;
        this.dimFieldAliases = dimFieldAliases;
        this.dimTopList = Lists.newArrayListWithExpectedSize((int)(start + limit));
        this.fieldIndexMap = Maps.newHashMapWithExpectedSize((int)dimFieldAliases.size());
        for (String dimFieldAlias : this.dimFieldAliases) {
            int index = sourceRowMeta.getFieldIndex(dimFieldAlias);
            this.fieldIndexMap.put(dimFieldAlias, index);
        }
    }

    public boolean test(RowX rowX) {
        StringBuilder dimBuilder = new StringBuilder();
        for (String dimFieldAlias : this.dimFieldAliases) {
            Integer fieldIndex = this.fieldIndexMap.get(dimFieldAlias);
            dimBuilder.append(rowX.getString(fieldIndex.intValue())).append("|");
        }
        String key = dimBuilder.toString();
        if (this.dimTopList.size() < this.start + this.limit) {
            if (!this.dimTopList.contains(key)) {
                this.dimTopList.add(key);
            }
        } else if (this.dimSet == null) {
            this.dimSet = this.dimTopList.stream().skip(this.start).limit(this.limit).collect(Collectors.toSet());
        }
        if (this.dimSet == null) {
            return this.dimTopList.size() > this.start && this.dimTopList.size() <= this.start + this.limit;
        }
        return this.dimSet.contains(key);
    }
}

