/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.common.model.report.DateTransUtils;

public class TransferFieldValueMapFunction
extends MapFunction {
    private static final long serialVersionUID = 7559693908367121477L;
    private static final Log LOGGER = LogFactory.getLog(TransferFieldValueMapFunction.class);
    private final RowMeta rowMeta;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> fieldAliasIndexMap;
    private final Map<String, Set<String>> algoXAliasTransferFieldAliasMap;
    private final TimeZone timeZone = KDDateUtils.getTimeZone();

    public TransferFieldValueMapFunction(RowMeta rowMeta, AlgoXParser algoxParser) {
        this.rowMeta = rowMeta;
        this.newRowMeta = this.buildRowMeta(rowMeta, algoxParser);
        this.algoXAliasTransferFieldAliasMap = algoxParser.getAlgoXAliasTransferFieldAliasMap();
        LOGGER.info("TransferFieldValueMapFunction_algoXAliasTransferFieldAliasMap={}", this.algoXAliasTransferFieldAliasMap);
        Field[] fields = this.newRowMeta.getFields();
        this.fieldAliasIndexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            this.fieldAliasIndexMap.put(fields[index].getAlias(), index);
        }
    }

    public RowX map(RowX rowX) {
        RowX newRowX = new RowX(this.newRowMeta.getFieldCount());
        Field[] fields = this.rowMeta.getFields();
        for (int oldIndex = 0; oldIndex < fields.length; ++oldIndex) {
            DataType dataType;
            Field field = fields[oldIndex];
            String oldFieldName = field.getName();
            Set<String> transferTypes = this.algoXAliasTransferFieldAliasMap.get(oldFieldName);
            Integer newIndex = this.fieldAliasIndexMap.get(oldFieldName);
            if (newIndex != null) {
                newRowX.set(newIndex.intValue(), rowX.get(oldIndex));
            }
            if (transferTypes == null || transferTypes.isEmpty() || !DataType.DateType.equals((Object)(dataType = field.getDataType())) && !DataType.TimestampType.equals((Object)dataType)) continue;
            Date date = rowX.getDate(oldIndex);
            for (String transferType : transferTypes) {
                Integer transferIndex = this.fieldAliasIndexMap.get(oldFieldName + "_TRANSFER_ALIAS_SPLIT_" + transferType);
                if (transferIndex == null) continue;
                newRowX.set(transferIndex.intValue(), (Object)DateTransUtils.transferDate((Date)date, (String)transferType, (TimeZone)this.timeZone));
            }
        }
        return newRowX;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }

    private RowMeta buildRowMeta(RowMeta rowMeta, AlgoXParser algoxParser) {
        Field[] fields;
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)rowMeta.getFieldCount());
        for (Field field : fields = rowMeta.getFields()) {
            String algoXAlias = field.getName();
            fieldList.add(field);
            Set<String> algoXAliasTransferFieldAliases = algoxParser.getAlgoXAliasTransferFieldAliases(algoXAlias);
            if (algoXAliasTransferFieldAliases.isEmpty()) continue;
            LOGGER.info("buildRowMeta_algoXAliasTransferFieldAliases={}", algoXAliasTransferFieldAliases);
            for (String transferFieldAlias : algoXAliasTransferFieldAliases) {
                fieldList.add(new Field(algoXAlias + "_TRANSFER_ALIAS_SPLIT_" + transferFieldAlias, (DataType)DataType.StringType));
            }
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }
}

