/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.optimization.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.algox.optimization.Rule;
import kd.hr.hbp.business.service.complexobj.algox.optimization.rules.AlgoXFilterRuleParam;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;

public class DimCountRule
implements Rule<String> {
    private static final Log LOGGER = LogFactory.getLog(DimCountRule.class);
    private static final Set<String> NOT_HIT_FILTER_CP_SET = Sets.newHashSet((Object[])new String[]{"not in", "!=", "<>", "not exists", "not ilike", "not like", "is not null"});
    private final HRComplexObjContext context;
    private static final HRBaseServiceHelper DIM_COUNT_HELPER = new HRBaseServiceHelper("hrptmc_dimcount");
    private final Map<String, Integer> entityAliasToDimCount;
    private final Set<String> unableHitEntityNumber = Sets.newHashSetWithExpectedSize((int)16);

    public DimCountRule(HRComplexObjContext context, List<AlgoXFilterRuleParam> params) {
        this.context = context;
        this.entityAliasToDimCount = this.initDimCount(params);
        LOGGER.info("DimCountRule_entityAliasToDimCount_{}", (Object)String.valueOf(this.entityAliasToDimCount));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public boolean execute() {
        Set<Map.Entry<String, Integer>> entrySet = this.entityAliasToDimCount.entrySet();
        for (Map.Entry<String, Integer> entityAliasToDimCountEntry : entrySet) {
            Integer dimCount = entityAliasToDimCountEntry.getValue();
            if (dimCount != null && dimCount > this.context.getAlgoXOptimizedDimCount()) {
                LOGGER.info("DimCountRule_Hit_entityAlias={},dimCount={}", (Object)entityAliasToDimCountEntry.getKey(), (Object)dimCount);
                return true;
            }
            LOGGER.info("DimCountRule_not_Hit_entityAlias={},dimCount={}", (Object)entityAliasToDimCountEntry.getKey(), (Object)dimCount);
        }
        return false;
    }

    @Override
    public boolean executeWithParam(String entityAlias) {
        if (this.unableHitEntityNumber.contains(entityAlias)) {
            LOGGER.info("DimCountRule_not_Hit_cause_qFilter_query_EMPTY_entityAlias_{}", (Object)entityAlias);
            return false;
        }
        Integer dimCount = this.entityAliasToDimCount.get(entityAlias);
        if (dimCount != null && dimCount > this.context.getAlgoXOptimizedDimCount()) {
            LOGGER.info("DimCountRule_Hit_entityAlias={},count={}", (Object)entityAlias, (Object)dimCount);
            return true;
        }
        LOGGER.info("DimCountRule_not_Hit_entityAlias={},dimCount={}", (Object)entityAlias, (Object)dimCount);
        return false;
    }

    private Map<String, Integer> getQFilterDimCount(List<AlgoXFilterRuleParam> params) {
        HashMap tableNameToAliasMap = Maps.newHashMapWithExpectedSize((int)params.size());
        HashMap tableNameToFieldNameMap = Maps.newHashMapWithExpectedSize((int)params.size());
        HashSet dbFieldNames = Sets.newHashSetWithExpectedSize((int)params.size());
        for (AlgoXFilterRuleParam param : params) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)param.getEntityNumber());
            String tableName = dataEntityType.getAlias();
            tableNameToAliasMap.put(tableName, param.getEntityAlias());
            List<QFilter> qFilters = param.getqFilterList();
            Set<String> tableFieldNames = this.getFilterFieldNames(dataEntityType, qFilters);
            dbFieldNames.addAll(tableFieldNames);
            tableNameToFieldNameMap.putIfAbsent(tableName, tableFieldNames);
            tableNameToFieldNameMap.computeIfPresent(tableName, (key, value) -> {
                value.addAll(tableFieldNames);
                return value;
            });
        }
        QFilter tableNameQFilter = new QFilter("tablename", "in", tableNameToAliasMap.keySet());
        tableNameQFilter.and("fieldname", "in", (Object)dbFieldNames);
        String selectFields = "tablename,fieldname,dimcount";
        DynamicObject[] dimCounts = DIM_COUNT_HELPER.queryOriginalArray(selectFields, new QFilter[]{tableNameQFilter});
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)dimCounts.length);
        for (DynamicObject dimCount : dimCounts) {
            String tableName = dimCount.getString("tablename");
            String fieldName = dimCount.getString("fieldname");
            Set fieldNames = (Set)tableNameToFieldNameMap.get(tableName);
            if (!fieldNames.contains(fieldName)) continue;
            String entityAlias = (String)tableNameToAliasMap.get(tableName);
            countMap.putIfAbsent(entityAlias, 0);
            countMap.computeIfPresent(entityAlias, (key, value) -> {
                value = value + dimCount.getInt("dimcount");
                return value;
            });
        }
        return countMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private Set<String> getFilterFieldNames(MainEntityType dataEntityType, List<QFilter> qFilters) {
        HashSet tableFieldNames = Sets.newHashSetWithExpectedSize((int)16);
        boolean notHit = false;
        block0: for (QFilter qFilter : qFilters) {
            if (notHit) break;
            if (qFilter.getValue() instanceof QEmptyValue || NOT_HIT_FILTER_CP_SET.contains(qFilter.getCP())) {
                this.unableHitEntityNumber.add(dataEntityType.getName());
                break;
            }
            String propertyAlias = this.getAliasName(dataEntityType, qFilter.getProperty());
            if (HRStringUtils.isNotEmpty((String)propertyAlias)) {
                tableFieldNames.add(propertyAlias);
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter childFilter = nest.getFilter();
                if (childFilter.getValue() instanceof QEmptyValue || NOT_HIT_FILTER_CP_SET.contains(childFilter.getCP())) {
                    this.unableHitEntityNumber.add(dataEntityType.getName());
                    notHit = true;
                    continue block0;
                }
                String nestPropertyAlias = this.getAliasName(dataEntityType, nest.getFilter().getProperty());
                if (!HRStringUtils.isNotEmpty((String)nestPropertyAlias)) continue;
                tableFieldNames.add(nestPropertyAlias);
            }
        }
        return tableFieldNames;
    }

    private Map<String, Integer> initDimCount(List<AlgoXFilterRuleParam> params) {
        ArrayList queryParams = Lists.newArrayListWithExpectedSize((int)params.size());
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (AlgoXFilterRuleParam param : params) {
            if (FilterUtils.checkQFilterIsEmpty(param.getqFilterList())) continue;
            queryParams.add(param);
        }
        if (!queryParams.isEmpty()) {
            countMap.putAll(this.getQFilterDimCount(queryParams));
        }
        return countMap;
    }

    private String getAliasName(MainEntityType dataEntityType, String propertyName) {
        EntityType entityType;
        if (HRStringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        DynamicProperty property = dataEntityType.getProperty(propertyName);
        if (property != null) {
            return property.getAlias();
        }
        String[] splitArray = propertyName.split("\\.");
        property = dataEntityType.getProperty(splitArray[0]);
        if (property instanceof BasedataProp) {
            return property.getAlias();
        }
        if (property instanceof EntryProp && splitArray.length > 1 && (property = (entityType = (EntityType)dataEntityType.getAllEntities().get(splitArray[0])).getProperty(splitArray[1])) != null) {
            return property.getAlias();
        }
        return null;
    }
}

