/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.optimization.RuleChecker;
import kd.hr.hbp.business.service.complexobj.algox.optimization.RuleExecuteClient;
import kd.hr.hbp.business.service.complexobj.algox.optimization.rules.AlgoXFilterRuleParam;
import kd.hr.hbp.business.service.complexobj.algox.optimization.rules.DataCountRule;
import kd.hr.hbp.business.service.complexobj.algox.optimization.rules.DimCountRule;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjQFilterUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.report.DateTransUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.flink.api.java.tuple.Tuple2;

public class AlgoXFilterParser
implements IAlgoXParser,
RuleExecuteClient<String> {
    private static final Log LOGGER = LogFactory.getLog(AlgoXFilterParser.class);
    private static final long serialVersionUID = 4150472841524338118L;
    private static final String ALGOX_PARAM_PREFIX = "algox_param_";
    private static final char SPACE_CHAR = ' ';
    private static final long OPTIMIZE_DATA_COUNT = 10000L;
    private int paramIndex = 0;
    private final List<QFilter> mainEntityFilterList = new ArrayList<QFilter>();
    private final Map<String, List<QFilter>> relEntityFilterMap = new LinkedHashMap<String, List<QFilter>>();
    private final List<QFilter> mainEntityQueryEmptyFilterList = new ArrayList<QFilter>();
    private final Map<String, List<QFilter>> relEntityQueryEmptyFilterMap = new LinkedHashMap<String, List<QFilter>>();
    private final Map<String, AlgoXFieldInfo> mainEntityAlgoxFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap = new HashMap<String, Map<String, AlgoXFieldInfo>>();
    private final Map<String, List<QFilter>> relQFilterByMainData = Maps.newHashMapWithExpectedSize((int)16);
    private final List<QFilter> mailQFilterByRelData = Lists.newArrayListWithExpectedSize((int)10);
    private MainEntityType dataEntityType;
    private final HRComplexObjContext context;
    private final AlgoXParser algoxParser;
    private boolean isAllOptimizeMainQFilter = true;

    public AlgoXFilterParser(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                this.relEntityFilterMap.put(relEntityAlias, new ArrayList());
                this.relEntityQueryEmptyFilterMap.put(relEntityAlias, new ArrayList());
                this.relEntityAliasFieldInfoMap.put(relEntityAlias, new LinkedHashMap());
            });
        }
        this.dataEntityType = this.algoxParser.getEntityTypeByAlias(this.context.getEntityNumber());
        this.addInitFilter(this.context.getQfilterList());
    }

    public void addInitFilter(Collection<QFilter> qFilterList) {
        HashSet entityNumberHasOrNestSet = Sets.newHashSet();
        for (QFilter filter : qFilterList) {
            if (filter == null) continue;
            this.analyzeFilterHasOrNest(filter, entityNumberHasOrNestSet);
        }
        boolean isHasOr = entityNumberHasOrNestSet.size() > 1;
        String mainEntityNumber = this.context.getEntityNumber();
        ArrayList filters = Lists.newArrayList();
        for (QFilter filter : qFilterList) {
            QFilter newFilter;
            if (filter == null || (newFilter = this.transFtLike(filter)) == null) continue;
            filters.add(newFilter);
        }
        this.initMainEntityQFilter(isHasOr, mainEntityNumber, filters);
        this.initRelEntityQFilter(isHasOr, filters);
    }

    private void initMainEntityQFilter(boolean isHasOr, String mainEntityNumber, List<QFilter> filters) {
        for (QFilter filter : filters) {
            QFilter qFilter = this.analyzeFilter(mainEntityNumber, filter, true);
            if (qFilter == null || isHasOr) continue;
            if (!ComplexObjQFilterUtils.isOrNestQFilterCheck(qFilter)) {
                QFilter copy = qFilter.__copy(false);
                if (this.checkAdd(copy) && this.isAllMainEntityFilter(copy)) {
                    if (copy.getValue() instanceof QEmptyValue) {
                        this.mainEntityQueryEmptyFilterList.add(copy);
                    } else {
                        this.mainEntityFilterList.add(copy);
                    }
                }
                List nests = qFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    if (!this.checkAdd(nestFilter) || !this.isAllMainEntityFilter(nestFilter)) continue;
                    if (nestFilter.getValue() instanceof QEmptyValue) {
                        this.mainEntityQueryEmptyFilterList.add(nestFilter);
                        continue;
                    }
                    this.mainEntityFilterList.add(nestFilter);
                }
                continue;
            }
            if (ComplexObjQFilterUtils.isNullQFilterCheck(qFilter)) {
                if (!this.checkAdd(qFilter) || !this.isAllMainEntityFilter(qFilter)) continue;
                this.mainEntityQueryEmptyFilterList.add(qFilter);
                continue;
            }
            if (!this.checkAdd(qFilter) || !this.isAllMainEntityFilter(qFilter)) continue;
            this.mainEntityFilterList.add(qFilter);
        }
    }

    private void initRelEntityQFilter(boolean isHasOr, List<QFilter> filters) {
        for (String relEntityNumber : this.relEntityAliasFieldInfoMap.keySet()) {
            for (QFilter filter : filters) {
                QFilter qFilter = this.analyzeFilter(relEntityNumber, filter, false);
                if (qFilter == null || isHasOr) continue;
                if (!ComplexObjQFilterUtils.isOrNestQFilterCheck(qFilter)) {
                    this.buildAndRelEntityQFilterMap(relEntityNumber, qFilter);
                    continue;
                }
                if (ComplexObjQFilterUtils.isNullQFilterCheck(qFilter)) {
                    if (!this.checkAdd(qFilter) || !this.isAllRelEntityFilter(relEntityNumber, qFilter)) continue;
                    this.putRelEntityQueryEmptyFilterMap(relEntityNumber, qFilter);
                    continue;
                }
                if (!this.checkAdd(qFilter) || !this.isAllRelEntityFilter(relEntityNumber, qFilter)) continue;
                this.putRelEntityFilterMap(relEntityNumber, qFilter);
            }
        }
    }

    private void buildAndRelEntityQFilterMap(String relEntityNumber, QFilter qFilter) {
        QFilter copy = qFilter.__copy(false);
        if (this.checkAdd(copy) && this.isAllRelEntityFilter(relEntityNumber, copy)) {
            if (copy.getValue() instanceof QEmptyValue) {
                this.putRelEntityQueryEmptyFilterMap(relEntityNumber, copy);
            } else {
                this.putRelEntityFilterMap(relEntityNumber, copy);
            }
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            if (!this.checkAdd(nestFilter) || !this.isAllRelEntityFilter(relEntityNumber, nestFilter)) continue;
            if (nestFilter.getValue() instanceof QEmptyValue) {
                this.putRelEntityQueryEmptyFilterMap(relEntityNumber, nestFilter);
                continue;
            }
            this.putRelEntityFilterMap(relEntityNumber, nestFilter);
        }
    }

    private void analyzeFilterHasOrNest(QFilter filter, Set<String> entityNumberSet) {
        QFilter tempFilter = filter;
        List nests = filter.getNests(true);
        boolean hasOr = nests.stream().anyMatch(qFilterNest -> !qFilterNest.isAnd());
        if (hasOr) {
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                this.addOrEntityNumberSet(entityNumberSet, tempFilter.getProperty());
                this.addOrEntityNumberSet(entityNumberSet, nestFilter.getProperty());
                tempFilter = nestFilter;
            }
        }
    }

    private void addOrEntityNumberSet(Set<String> entityNumberSet, String propertyName) {
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(propertyName);
        String entityNumber = this.algoxParser.containsRelEntity(prefixAlias) ? prefixAlias : this.context.getEntityNumber();
        entityNumberSet.add(entityNumber);
    }

    private QFilter analyzeFilter(String entityNumber, QFilter sourceQFilter, boolean isMainEntity) {
        if (sourceQFilter == null) {
            return null;
        }
        String propertyName = sourceQFilter.getProperty();
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(propertyName);
        if (prefixAlias.contains("!")) {
            prefixAlias = prefixAlias.split("!")[0];
        }
        if (isMainEntity) {
            DynamicProperty property = this.dataEntityType.getProperty(prefixAlias);
            if (property != null || HRStringUtils.equals((String)propertyName, (String)"1") || this.checkPropertyIsNotEntityField(sourceQFilter)) {
                if (property != null || !this.checkPropertyIsNotEntityField(sourceQFilter)) {
                    String idPropertyName = this.getBaseDataIdPropertyName(propertyName);
                    this.updateCurrentAndOriginalQFilterPropertyName(sourceQFilter, propertyName, idPropertyName);
                    if (property != null) {
                        this.filterAddEntityFieldInfo(sourceQFilter, idPropertyName);
                    }
                }
                return this.analyzeFilterAndNests(entityNumber, sourceQFilter, true, new QFilter(sourceQFilter.getProperty(), sourceQFilter.getCP(), this.analyzeFilterValue(sourceQFilter)));
            }
            return this.analyzeFilterAndNests(entityNumber, sourceQFilter, true, null);
        }
        if (HRStringUtils.equals((String)entityNumber, (String)prefixAlias) || HRStringUtils.equals((String)propertyName, (String)"1") || this.checkPropertyIsNotEntityField(sourceQFilter)) {
            if (HRStringUtils.equals((String)entityNumber, (String)prefixAlias)) {
                DynamicProperty property = this.getDynamicPropertyByPropertyName(propertyName);
                if (!this.checkPropertyIsNotEntityField(sourceQFilter) || property != null) {
                    String idPropertyName = this.getBaseDataIdPropertyName(propertyName);
                    this.updateCurrentAndOriginalQFilterPropertyName(sourceQFilter, propertyName, idPropertyName);
                    if (property != null) {
                        this.filterAddEntityFieldInfo(sourceQFilter, idPropertyName);
                    }
                }
            }
            return this.analyzeFilterAndNests(entityNumber, sourceQFilter, false, new QFilter(sourceQFilter.getProperty(), sourceQFilter.getCP(), this.analyzeFilterValue(sourceQFilter)));
        }
        return this.analyzeFilterAndNests(entityNumber, sourceQFilter, false, null);
    }

    private Object analyzeFilterValue(QFilter sourceQFilter) {
        String propertyName = sourceQFilter.getProperty();
        DataType datatype = this.algoxParser.getFieldDataType(propertyName);
        if (datatype == null) {
            return sourceQFilter.getValue();
        }
        Object filterValue = sourceQFilter.getValue();
        if (datatype.equals((Object)DataType.BooleanType)) {
            if ("true".equals(String.valueOf(filterValue))) {
                filterValue = "1";
            } else if ("false".equals(String.valueOf(filterValue))) {
                filterValue = "0";
            }
        }
        return filterValue;
    }

    private QFilter analyzeFilterAndNests(String entityNumber, QFilter sourceQFilter, boolean isMainEntity, QFilter newQFilter) {
        for (QFilter.QFilterNest qFilterNest : sourceQFilter.getNests(false)) {
            QFilter tempQFilter = this.analyzeFilter(entityNumber, qFilterNest.getFilter(), isMainEntity);
            if (tempQFilter == null) continue;
            if (newQFilter == null) {
                newQFilter = tempQFilter;
                continue;
            }
            if (qFilterNest.isAnd()) {
                newQFilter.and(tempQFilter);
                continue;
            }
            newQFilter.or(tempQFilter);
        }
        return newQFilter;
    }

    @ExcludeFromJacocoGeneratedReport
    private void filterAddEntityFieldInfo(QFilter filter, String propertyName) {
        String expValue;
        String expPrefixAlias;
        this.algoxParser.addEntityFieldInfo(propertyName, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
        if (ComplexObjQFilterUtils.fieldEqualsQFilterCheck(filter.__copy(false))) {
            String valueFiledAlias = String.valueOf(filter.getValue()).replaceFirst("KEY_FILTER_FIELD_EQUALS_TAG_", "");
            valueFiledAlias = this.getBaseDataIdPropertyName(valueFiledAlias);
            this.algoxParser.addEntityFieldInfo(valueFiledAlias, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
        }
        if (filter.isExpressValue() && this.algoxParser.containsRelEntity(expPrefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(expValue = String.valueOf(filter.getOriginValue())))) {
            expValue = this.getBaseDataIdPropertyName(expValue);
            filter.__setValue((Object)expValue);
            this.algoxParser.addEntityFieldInfo(expValue, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
        }
    }

    private void putRelEntityFilterMap(String relEntityAlias, QFilter filter) {
        this.relEntityFilterMap.get(relEntityAlias).add(filter);
    }

    private void putRelEntityQueryEmptyFilterMap(String relEntityAlias, QFilter filter) {
        this.relEntityQueryEmptyFilterMap.get(relEntityAlias).add(filter);
    }

    private QFilter transFtLike(QFilter originFilter) {
        if (originFilter == null) {
            return null;
        }
        QFilter transferred = originFilter.copy();
        if (transferred != null) {
            transferred = this.doTransFtLike(transferred);
        }
        return transferred;
    }

    private QFilter doTransFtLike(QFilter filter) {
        QFilter newQFilter = null;
        if ("ftlike".equals(filter.getCP())) {
            String[] values;
            String filterValue = String.valueOf(filter.getValue());
            String[] properties = filter.getProperties();
            if (QMatches._isMatchSolt((String)filter.getProperty())) {
                int splitIndex = filterValue.indexOf(35);
                values = filterValue.substring(splitIndex + 1).split("\b");
            } else {
                values = new String[]{filterValue};
            }
            for (String property : properties) {
                for (String value : values) {
                    if (newQFilter == null) {
                        newQFilter = QFilter.like((String)property, (String)value);
                        continue;
                    }
                    newQFilter.or(QFilter.like((String)property, (String)value));
                }
            }
        } else {
            newQFilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
        }
        if (newQFilter != null) {
            List nestList = filter.getNests(false);
            for (QFilter.QFilterNest nest : nestList) {
                QFilter transfer = this.doTransFtLike(nest.getFilter());
                if (transfer == null) continue;
                if (nest.isAnd()) {
                    newQFilter.and(transfer);
                    continue;
                }
                newQFilter.or(transfer);
            }
        }
        return newQFilter;
    }

    public Tuple2<String, Map<String, Object>> getRelEntityWhereFilterStrParam() {
        ArrayList filters = Lists.newArrayList();
        for (QFilter filter : this.context.getQfilterList()) {
            QFilter newFilter;
            if (filter == null || (newFilter = this.transFtLike(filter)) == null) continue;
            filters.add(newFilter);
        }
        ArrayList exprList = Lists.newArrayList();
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        for (QFilter qFilter : filters) {
            String filterExpStr = this.filterToExp(qFilter, params);
            if (!HRStringUtils.isNotEmpty((String)filterExpStr)) continue;
            filterExpStr = "(" + filterExpStr + ")";
            exprList.add(filterExpStr);
        }
        String expr = String.join((CharSequence)" and ", exprList);
        return new Tuple2((Object)expr, (Object)params);
    }

    public String filterToExp(QFilter filter, Map<String, Object> params) {
        StringBuilder builder = new StringBuilder();
        if (filter.getCP().equalsIgnoreCase("not exists")) {
            QFilter qFilter = new QFilter(filter.getProperty(), "=", (Object)QEmptyValue.value);
            this.filterToExpBuilder(qFilter, params, builder);
        } else {
            this.filterToExpBuilder(filter, params, builder);
        }
        String property = filter.getProperty();
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestQFilter;
            builder.insert(0, '(');
            if (!HRStringUtils.equals((String)property, (String)"1")) {
                if (nest.isAnd()) {
                    builder.append(" and");
                } else {
                    builder.append(" or");
                }
            }
            if (!(nestQFilter = nest.getFilter()).getNests(false).isEmpty()) {
                builder.append(' ').append(this.filterToExp(nestQFilter, params));
            } else {
                builder.append(' ');
                this.filterToExpBuilder(nestQFilter, params, builder);
            }
            builder.append(')');
            property = nestQFilter.getProperty();
        }
        return builder.toString();
    }

    private void filterToExpBuilder(QFilter filter, Map<String, Object> params, StringBuilder builder) {
        if (HRStringUtils.equals((String)filter.getProperty(), (String)"1")) {
            return;
        }
        Object filterValue = this.getFilterValue(filter);
        DataType datatype = this.algoxParser.getFieldDataType(filter.getProperty());
        String propertyAlias = this.algoxParser.getAlgoXAliasByAlias(filter.getProperty());
        String cp = filter.getCP();
        if (filter.isExpressValue()) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            builder.append(this.algoxParser.getAlgoXAliasByAlias(String.valueOf(filterValue)));
        } else if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("like") || cp.equalsIgnoreCase("not like")) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            builder.append('\"').append(this.handleSpecilaChar(String.valueOf(filterValue))).append('\"');
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            builder.append('(').append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            String paramKey = this.buildParamKey();
            builder.append(paramKey).append(')');
            params.put(paramKey, filterValue);
        } else {
            builder.append('(');
            if (filter.getValue() == QEmptyValue.value && filterValue == null) {
                builder.append(propertyAlias).append(" is null ");
            } else if (ComplexObjQFilterUtils.fieldEqualsQFilterCheck(filter.__copy(false))) {
                builder.append(propertyAlias);
                builder.append(' ').append(cp).append(' ');
                builder.append(filterValue);
            } else {
                builder.append(propertyAlias);
                builder.append(' ').append(cp).append(' ');
                String paramKey = this.buildParamKey();
                builder.append(paramKey);
                params.put(paramKey, filterValue);
                if (filter.getValue() == QEmptyValue.value) {
                    builder.append(" or ").append(propertyAlias).append(" is null ");
                    if (datatype.equals((Object)DataType.StringType)) {
                        paramKey = this.buildParamKey();
                        builder.append(" or ").append(propertyAlias).append(" = ").append(paramKey);
                        params.put(paramKey, "");
                    }
                }
            }
            builder.append(')');
        }
    }

    private Object getFilterValue(QFilter filter) {
        String property;
        Object filterValue = filter.getOriginValue();
        DataType datatype = this.algoxParser.getFieldDataType(filter.getProperty());
        if (filterValue == QEmptyValue.value) {
            filterValue = datatype.equals((Object)DataType.IntegerType) ? Integer.valueOf(0) : (datatype.equals((Object)DataType.LongType) ? Long.valueOf(0L) : (datatype.equals((Object)DataType.StringType) ? " " : null));
        }
        if (datatype.equals((Object)DataType.BooleanType)) {
            if (filterValue instanceof List) {
                ArrayList<Boolean> tempFilterValue = new ArrayList<Boolean>(4);
                for (Object obj : (List)filterValue) {
                    if ("1".equals(String.valueOf(obj))) {
                        tempFilterValue.add(Boolean.TRUE);
                        continue;
                    }
                    if ("0".equals(String.valueOf(obj))) {
                        tempFilterValue.add(Boolean.FALSE);
                        continue;
                    }
                    tempFilterValue.add((Boolean)obj);
                }
                filterValue = tempFilterValue;
            } else if ("1".equals(String.valueOf(filterValue)) || "true".equals(String.valueOf(filterValue))) {
                filterValue = Boolean.TRUE;
            } else if ("0".equals(String.valueOf(filterValue)) || "false".equals(String.valueOf(filterValue))) {
                filterValue = Boolean.FALSE;
            }
        }
        if ((property = filter.getProperty()).contains("!")) {
            String[] keys = property.split("!");
            String transType = keys[1];
            if (filterValue instanceof List) {
                ArrayList tempFilterValue = Lists.newArrayListWithExpectedSize((int)((List)filterValue).size());
                for (Object obj : (List)filterValue) {
                    tempFilterValue.add(DateTransUtils.transferKey((String)String.valueOf(obj), (String)transType));
                }
                filterValue = tempFilterValue;
            } else if (filterValue instanceof Date) {
                filter.__setProperty(keys[0]);
            } else if (filterValue instanceof String) {
                filterValue = DateTransUtils.transferKey((String)((String)filterValue), (String)transType);
            }
        }
        if (ComplexObjQFilterUtils.fieldEqualsQFilterCheck(filter.__copy(false))) {
            filterValue = AlgoXFieldInfo.replaceAlgoxAlias(String.valueOf(filter.getValue()).replaceFirst("KEY_FILTER_FIELD_EQUALS_TAG_", ""));
        }
        return filterValue;
    }

    @ExcludeFromJacocoGeneratedReport
    private String handleSpecilaChar(String value) {
        return value.replace("\"", "\\\"");
    }

    private String buildParamKey() {
        return ALGOX_PARAM_PREFIX + this.paramIndex++;
    }

    public List<QFilter> getMainEntityFilterList() {
        ArrayList allMainFilter = Lists.newArrayListWithExpectedSize((int)(this.mainEntityFilterList.size() + this.mailQFilterByRelData.size()));
        allMainFilter.addAll(this.mainEntityFilterList.stream().map(QFilter::copy).collect(Collectors.toList()));
        allMainFilter.addAll(this.mailQFilterByRelData.stream().map(QFilter::copy).collect(Collectors.toList()));
        return allMainFilter;
    }

    public List<QFilter> getMainEntityFilterListWithQueryEmpty() {
        ArrayList allMainFilter = Lists.newArrayListWithExpectedSize((int)(this.mainEntityFilterList.size() + this.mailQFilterByRelData.size() + this.mainEntityQueryEmptyFilterList.size()));
        allMainFilter.addAll(this.mainEntityFilterList.stream().map(QFilter::copy).collect(Collectors.toList()));
        allMainFilter.addAll(this.mailQFilterByRelData.stream().map(QFilter::copy).collect(Collectors.toList()));
        allMainFilter.addAll(this.mainEntityQueryEmptyFilterList);
        return allMainFilter;
    }

    public List<QFilter> getMainEntityFilterListByRelData() {
        ArrayList allMainFilter = Lists.newArrayListWithExpectedSize((int)this.mailQFilterByRelData.size());
        allMainFilter.addAll(this.mailQFilterByRelData.stream().map(QFilter::copy).collect(Collectors.toList()));
        return allMainFilter;
    }

    public List<QFilter> getRelEntityFilterList(String relEntityAlias) {
        List<QFilter> relByMainDataQFilters;
        List<QFilter> relOriginalQFilters = this.relEntityFilterMap.get(relEntityAlias);
        int filterNum = 0;
        if (relOriginalQFilters != null) {
            filterNum += relOriginalQFilters.size();
        }
        if ((relByMainDataQFilters = this.relQFilterByMainData.get(relEntityAlias)) != null) {
            filterNum += relByMainDataQFilters.size();
        }
        ArrayList allRelQFilter = Lists.newArrayListWithExpectedSize((int)filterNum);
        if (relOriginalQFilters != null) {
            allRelQFilter.addAll(relOriginalQFilters.stream().map(QFilter::copy).collect(Collectors.toList()));
        }
        if (relByMainDataQFilters != null) {
            allRelQFilter.addAll(relByMainDataQFilters.stream().map(QFilter::copy).collect(Collectors.toList()));
        }
        return allRelQFilter;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getRelEntityFilterListWithQueryEmpty(String relEntityAlias) {
        List<QFilter> relEntityFilterList = this.getRelEntityFilterList(relEntityAlias);
        List<QFilter> relQueryEmptyQFilterList = this.relEntityQueryEmptyFilterMap.get(relEntityAlias);
        if (relQueryEmptyQFilterList != null) {
            relEntityFilterList.addAll(relQueryEmptyQFilterList);
        }
        return relEntityFilterList;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getRelEntityFilterListByMainData(String relEntityAlias) {
        List<QFilter> relByMainDataQFilters = this.relQFilterByMainData.get(relEntityAlias);
        if (relByMainDataQFilters != null) {
            return relByMainDataQFilters.stream().map(QFilter::copy).collect(Collectors.toList());
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public Collection<AlgoXFieldInfo> getMainEntityAlgoxFieldInfoCollection() {
        return this.mainEntityAlgoxFieldInfoMap.values();
    }

    public Map<String, AlgoXFieldInfo> getRelEntityFieldInfoMap(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias);
    }

    public Collection<AlgoXFieldInfo> getRelEntityFieldInfoCollection(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias).values();
    }

    public List<QFilter> replaceAliasToRealFileNameWithRelQFilterList(List<QFilter> relQFilterList) {
        ArrayList<QFilter> resultList = new ArrayList<QFilter>(relQFilterList.size());
        for (QFilter qFilter : relQFilterList) {
            QFilter filter = qFilter.copy();
            this.replaceAliasToRealFileNameWithRelQFilter(filter);
            resultList.add(filter);
        }
        return resultList;
    }

    private void replaceAliasToRealFileNameWithRelQFilter(QFilter qFilter) {
        String property = qFilter.getProperty();
        if (!HRStringUtils.equals((String)property, (String)"1")) {
            qFilter.__setProperty(this.algoxParser.getRealFileNameByAlias(property));
        }
        for (QFilter.QFilterNest qFilterNest : qFilter.getNests(false)) {
            QFilter subFilter = qFilterNest.getFilter();
            this.replaceAliasToRealFileNameWithRelQFilter(subFilter);
        }
    }

    private boolean checkIfOptimize(RuleChecker<String> ruleChecker, String entityAlias) {
        return ruleChecker.executeRules(entityAlias);
    }

    public final void initOptimizeFilterData() {
        List relEntityAliasList = this.context.getJoinRelationList();
        if (relEntityAliasList == null) {
            return;
        }
        boolean isOptimizeMainQFilter = false;
        ArrayList params = Lists.newArrayListWithExpectedSize((int)(this.context.getJoinRelationList().size() + 1));
        if (!relEntityAliasList.isEmpty()) {
            params.add(new AlgoXFilterRuleParam(this.context.getEntityNumber(), this.context.getEntityNumber(), relEntityAliasList, this.mainEntityFilterList));
        }
        HashMap relJoinEntityAliasToFilter = Maps.newHashMapWithExpectedSize((int)relEntityAliasList.size());
        for (HRComplexObjJoinRelation joinRelation : relEntityAliasList) {
            List<QFilter> qFilterList = this.replaceAliasToRealFileNameWithRelQFilterList(this.relEntityFilterMap.get(joinRelation.getRelEntityAlias()));
            params.add(new AlgoXFilterRuleParam(joinRelation.getRelEntityAlias(), joinRelation.getRelEntityNumber(), joinRelation, qFilterList));
            relJoinEntityAliasToFilter.put(joinRelation.getRelEntityAlias(), qFilterList);
        }
        RuleChecker<String> ruleChecker = new RuleChecker<String>();
        this.addRule(ruleChecker, new DataCountRule(this.context, params));
        this.addRule(ruleChecker, new DimCountRule(this.context, params));
        this.analyzeQFilterDataToRelFromLeft(ruleChecker, this.context.getEntityNumber(), this.context.getEntityNumber(), this.context.getJoinRelationList());
        isOptimizeMainQFilter = this.analyzeQFilterDataToRelFromRight(ruleChecker, this.context.getJoinRelationList(), relJoinEntityAliasToFilter, false);
        if (isOptimizeMainQFilter) {
            this.analyzeQFilterDataToRelFromLeft(ruleChecker, this.context.getEntityNumber(), this.context.getEntityNumber(), this.context.getJoinRelationList());
        }
    }

    private boolean analyzeRelQFilterToMain(HRComplexObjJoinRelation joinRelation, List<QFilter> qFilterList) {
        boolean isOptimizeMainQFilter = false;
        if (FilterUtils.checkQFilterIsEmpty(qFilterList) && JoinType.LEFT.getName().equals(joinRelation.getJoinType())) {
            return false;
        }
        ArrayList selectFieldInfo = Lists.newArrayListWithExpectedSize((int)16);
        this.algoxParser.addTempSelectFieldInfo(joinRelation.getRelEntityAlias(), selectFieldInfo, false);
        if (!selectFieldInfo.isEmpty()) {
            Map<String, Set<Object>> filterData = FilterUtils.getFilterData(selectFieldInfo, joinRelation.getRelEntityNumber(), qFilterList);
            long dataMax = filterData.values().stream().map(Set::size).collect(Collectors.summarizingInt(value -> value)).getMax();
            if (dataMax > 10000L) {
                LOGGER.info("analyzeRelQFilterToMain_filterData_is_more_than_max_count_{}", (Object)dataMax);
                return false;
            }
            if (!filterData.isEmpty()) {
                Set<Tuple2<String, String>> tuple2Set = this.algoxParser.relEntityAliasOnRealFileNameSet(joinRelation.getRelEntityAlias());
                for (Tuple2<String, String> tuple2 : tuple2Set) {
                    Set<Object> filterValues = filterData.get(tuple2.f1);
                    filterValues.remove(null);
                    QFilter qFilter = new QFilter((String)tuple2.f0, "in", filterValues);
                    FilterUtils.addFilterAndMerge(this.mailQFilterByRelData, qFilter);
                    isOptimizeMainQFilter = true;
                }
            }
        }
        return isOptimizeMainQFilter;
    }

    private void analyzeQFilterDataToRelFromLeft(RuleChecker<String> ruleChecker, String entityNumber, String entityAlias, List<HRComplexObjJoinRelation> joinRelationList) {
        block8: {
            ArrayList copyRelations;
            block9: {
                List<QFilter> queryQFilters;
                boolean isMain = this.context.getEntityNumber().equals(entityAlias);
                List<QFilter> list = queryQFilters = isMain ? this.getMainEntityFilterList() : this.getRelEntityFilterList(entityAlias);
                if (!isMain) {
                    queryQFilters = this.replaceAliasToRealFileNameWithRelQFilterList(queryQFilters);
                }
                copyRelations = Lists.newArrayList(joinRelationList);
                if (!this.checkIfOptimize(ruleChecker, entityAlias)) break block9;
                ArrayList selectFieldInfo = Lists.newArrayListWithExpectedSize((int)16);
                for (HRComplexObjJoinRelation joinRelation : copyRelations) {
                    if (!joinRelation.getEntityAlias().equals(entityAlias)) continue;
                    this.algoxParser.addTempSelectFieldInfo(joinRelation.getRelEntityAlias(), selectFieldInfo, true);
                }
                if (selectFieldInfo.isEmpty()) break block8;
                Map<String, Set<Object>> filterData = FilterUtils.getFilterData(selectFieldInfo, entityNumber, queryQFilters);
                long dataMax = filterData.values().stream().map(Set::size).collect(Collectors.summarizingInt(value -> value)).getMax();
                if (dataMax > 10000L) {
                    LOGGER.info("analyzeQFilterDataToRel_filterData_is_more_than_max_count_{}", (Object)dataMax);
                    return;
                }
                if (filterData.isEmpty()) break block8;
                Iterator iterator = copyRelations.iterator();
                while (iterator.hasNext()) {
                    HRComplexObjJoinRelation joinRelation = (HRComplexObjJoinRelation)iterator.next();
                    if (joinRelation.getEntityAlias().equals(entityAlias)) {
                        String relEntityAlias = joinRelation.getRelEntityAlias();
                        Set<Tuple2<String, String>> tuple2Set = this.algoxParser.relEntityAliasOnRealFileNameSet(relEntityAlias);
                        for (Tuple2<String, String> tuple2 : tuple2Set) {
                            Set<Object> filterValues = filterData.get(tuple2.f0);
                            if (filterValues.contains(null)) continue;
                            QFilter qFilter = new QFilter((String)tuple2.f1, "in", filterValues);
                            List<QFilter> qFilterList = this.relQFilterByMainData.get(relEntityAlias);
                            this.relQFilterByMainData.put(relEntityAlias, FilterUtils.addFilterAndMerge(qFilterList, qFilter));
                        }
                        iterator.remove();
                        continue;
                    }
                    this.analyzeQFilterDataToRelFromLeft(ruleChecker, joinRelation.getEntityNumber(), joinRelation.getEntityAlias(), Lists.newArrayList((Iterable)copyRelations));
                    break block8;
                }
                break block8;
            }
            Iterator iterator = copyRelations.iterator();
            while (iterator.hasNext()) {
                HRComplexObjJoinRelation joinRelation = (HRComplexObjJoinRelation)iterator.next();
                if (joinRelation.getEntityAlias().equals(entityAlias)) {
                    iterator.remove();
                    continue;
                }
                this.analyzeQFilterDataToRelFromLeft(ruleChecker, joinRelation.getEntityNumber(), joinRelation.getEntityAlias(), copyRelations);
                break;
            }
        }
    }

    private boolean analyzeQFilterDataToRelFromRight(RuleChecker<String> ruleChecker, List<HRComplexObjJoinRelation> joinRelationList, Map<String, List<QFilter>> relJoinEntityAliasToFilter, boolean lastOptimizeSuccess) {
        boolean isOptimizeMainQFilter = false;
        if (joinRelationList.isEmpty()) {
            return false;
        }
        LinkedList copyRelations = Lists.newLinkedList(joinRelationList);
        HRComplexObjJoinRelation joinRelation = (HRComplexObjJoinRelation)copyRelations.removeLast();
        String relEntityAlias = joinRelation.getRelEntityAlias();
        List<QFilter> queryQFilters = this.getRelEntityFilterList(relEntityAlias);
        boolean isMain = this.context.getEntityNumber().equals(joinRelation.getEntityAlias());
        if (!this.context.getEntityNumber().equals(relEntityAlias)) {
            queryQFilters = this.replaceAliasToRealFileNameWithRelQFilterList(queryQFilters);
        }
        List<QFilter> originalQFilters = relJoinEntityAliasToFilter.get(relEntityAlias);
        if (this.checkIfOptimize(ruleChecker, relEntityAlias) || lastOptimizeSuccess) {
            ArrayList selectFieldInfo = Lists.newArrayListWithExpectedSize((int)16);
            this.algoxParser.addTempSelectFieldInfo(relEntityAlias, selectFieldInfo, false);
            if (!selectFieldInfo.isEmpty()) {
                Map<String, Set<Object>> filterData = FilterUtils.getFilterData(selectFieldInfo, joinRelation.getRelEntityNumber(), queryQFilters);
                long dataMax = filterData.values().stream().map(Set::size).collect(Collectors.summarizingInt(value -> value)).getMax();
                if (dataMax > 10000L) {
                    LOGGER.info("analyzeQFilterDataToRel_filterData_is_more_than_max_count_{}", (Object)dataMax);
                    this.isAllOptimizeMainQFilter = false;
                    return false;
                }
                if (!filterData.isEmpty()) {
                    Set<Tuple2<String, String>> tuple2Set = this.algoxParser.relEntityAliasOnRealFileNameSet(relEntityAlias);
                    for (Tuple2<String, String> tuple2 : tuple2Set) {
                        Set<Object> filterValues = filterData.get(tuple2.f1);
                        if (filterValues.contains(null)) {
                            this.isAllOptimizeMainQFilter = false;
                            continue;
                        }
                        QFilter qFilter = new QFilter((String)tuple2.f0, "in", filterValues);
                        if (isMain) {
                            FilterUtils.addFilterAndMerge(this.mailQFilterByRelData, qFilter);
                            isOptimizeMainQFilter = true;
                            lastOptimizeSuccess = false;
                            continue;
                        }
                        List<QFilter> qFilterList = this.relQFilterByMainData.get(joinRelation.getEntityAlias());
                        this.relQFilterByMainData.put(joinRelation.getEntityAlias(), FilterUtils.addFilterAndMerge(qFilterList, qFilter));
                        this.isAllOptimizeMainQFilter = false;
                        lastOptimizeSuccess = true;
                    }
                }
            }
        } else if (!FilterUtils.checkQFilterIsEmpty(originalQFilters)) {
            this.isAllOptimizeMainQFilter = false;
        }
        boolean optimizeResult = this.analyzeQFilterDataToRelFromRight(ruleChecker, copyRelations, relJoinEntityAliasToFilter, lastOptimizeSuccess);
        if (!isOptimizeMainQFilter) {
            return optimizeResult;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private void updateCurrentAndOriginalQFilterPropertyName(QFilter newQFilter, String originalPropertyName, String newPropertyName) {
        if (originalPropertyName.equals(newPropertyName)) {
            return;
        }
        newQFilter.__setProperty(newPropertyName);
        List qFilterList = this.context.getQfilterList();
        for (QFilter qFilter : qFilterList) {
            if (qFilter.getProperty().equals(originalPropertyName)) {
                qFilter.__setProperty(newPropertyName);
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter filter = nest.getFilter();
                if (!filter.getProperty().equals(originalPropertyName)) continue;
                filter.__setProperty(newPropertyName);
            }
        }
    }

    private String getBaseDataIdPropertyName(String propertyName) {
        String fullPath;
        String realFieldName;
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(propertyName);
        MainEntityType mainEntityType = this.algoxParser.containsRelEntity(prefixAlias) ? this.algoxParser.getEntityTypeByAlias(prefixAlias) : this.dataEntityType;
        DynamicProperty property = mainEntityType.getProperty(realFieldName = AlgoXFieldInfo.replaceRealFieldName(fullPath = this.algoxParser.parseAliasReturnFullPath(prefixAlias, propertyName)));
        if (property instanceof BasedataProp) {
            return propertyName + ".id";
        }
        return propertyName;
    }

    private DynamicProperty getDynamicPropertyByPropertyName(String propertyName) {
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(propertyName);
        MainEntityType mainEntityType = this.algoxParser.containsRelEntity(prefixAlias) ? this.algoxParser.getEntityTypeByAlias(prefixAlias) : this.dataEntityType;
        String fullPath = this.algoxParser.parseAliasReturnFullPath(prefixAlias, propertyName);
        String realFieldName = AlgoXFieldInfo.replaceRealFieldName(fullPath);
        if (realFieldName.contains(".")) {
            realFieldName = realFieldName.substring(0, realFieldName.lastIndexOf("."));
        }
        if (realFieldName.contains(".")) {
            realFieldName = realFieldName.substring(0, realFieldName.lastIndexOf("."));
        }
        return mainEntityType.getProperty(realFieldName);
    }

    public boolean isAllOptimizeMainQFilter() {
        return this.isAllOptimizeMainQFilter;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean checkAdd(QFilter qFilter) {
        if (ComplexObjQFilterUtils.dataSpiltQFilterCheckAndChangeProperty(qFilter)) {
            return false;
        }
        if (this.checkPropertyIsNotEntityField(qFilter)) {
            return false;
        }
        if (ComplexObjQFilterUtils.fieldEqualsQFilterCheck(qFilter)) {
            return false;
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            if (ComplexObjQFilterUtils.dataSpiltQFilterCheckAndChangeProperty(nestFilter)) {
                return false;
            }
            if (this.checkPropertyIsNotEntityField(nestFilter)) {
                return false;
            }
            if (!ComplexObjQFilterUtils.fieldEqualsQFilterCheck(nestFilter)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNotEntityFieldQFilter(QFilter qFilter) {
        if (this.checkPropertyIsNotEntityField(qFilter)) {
            return true;
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            if (!this.checkPropertyIsNotEntityField(nest.getFilter())) continue;
            return true;
        }
        return false;
    }

    private boolean checkPropertyIsNotEntityField(QFilter qFilter) {
        return this.algoxParser.getNormalAlgoXFieldInfo(qFilter.getProperty()) == null;
    }

    private boolean isAllMainEntityFilter(QFilter filter) {
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(filter.getProperty());
        if (this.algoxParser.containsRelEntity(prefixAlias)) {
            return false;
        }
        List nests = filter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String nestPrefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(nestFilter.getProperty());
            if (!this.algoxParser.containsRelEntity(nestPrefixAlias)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllRelEntityFilter(String relEntityAlias, QFilter filter) {
        String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(filter.getProperty());
        if (!this.algoxParser.containsRelEntity(prefixAlias) || !relEntityAlias.equals(prefixAlias)) {
            return false;
        }
        List nests = filter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String nestPrefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(nestFilter.getProperty());
            if (this.algoxParser.containsRelEntity(nestPrefixAlias) && relEntityAlias.equals(nestPrefixAlias)) continue;
            return false;
        }
        return true;
    }
}

