/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class AlgoXOrderFieldParser
implements IAlgoXParser {
    private static final long serialVersionUID = 4150472841524338118L;
    public static final String CUSTOM_ORDER_FIELD_PREFIX = "CUSTOM_ORDER_";
    public static final String[] BASE_DATA_SUFFIX_ARRAY = new String[]{".name", "_DOC_SPLIT_name", ".number", "_DOC_SPLIT_number"};
    private final Map<String, AlgoXFieldInfo> mainEntityAlgoXFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap = new HashMap<String, Map<String, AlgoXFieldInfo>>();
    private final List<OrderField> orderFields = Lists.newArrayListWithExpectedSize((int)10);
    private final HRComplexObjContext context;
    private final AlgoXParser algoxParser;
    private final Map<String, Boolean> dependSortFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, Map<String, Integer>> customOrderMap = Maps.newHashMapWithExpectedSize((int)16);
    private SortFieldInfo firstSortField;

    public AlgoXOrderFieldParser(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                Map cfr_ignored_0 = this.relEntityAliasFieldInfoMap.put(joinRelation.getRelEntityAlias(), new LinkedHashMap());
            });
        }
        this.parseOrderBy();
    }

    private void parseOrderBy() {
        List sortFieldInfoList = this.context.getSortFieldInfoList();
        if (sortFieldInfoList != null) {
            for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
                String fieldAlias = sortFieldInfo.getFieldAlias();
                if (this.algoxParser.containsCalculateField(fieldAlias) || this.algoxParser.containsPluginField(fieldAlias)) continue;
                if (sortFieldInfo.isDependSort()) {
                    this.dependSortFieldMap.put(AlgoXFieldInfo.replaceAlgoxAlias(fieldAlias), true);
                }
                this.algoxParser.addEntityFieldInfo(fieldAlias, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoXFieldInfoMap);
                if (this.firstSortField == null) {
                    this.firstSortField = sortFieldInfo;
                }
                if (SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())) {
                    String baseDataIdAlias = AlgoXOrderFieldParser.getBaseDataIdAlias(fieldAlias);
                    if (baseDataIdAlias != null) {
                        this.algoxParser.addEntityFieldInfo(baseDataIdAlias, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoXFieldInfoMap);
                        AlgoXFieldInfo idFieldInfo = this.algoxParser.getNormalAlgoXFieldInfo(baseDataIdAlias);
                        List groupFieldList = this.context.getGroupFieldList();
                        groupFieldList.add(idFieldInfo.getFieldInfo());
                        List complexObjFieldInfoList = this.context.getComplexObjFieldInfoList();
                        complexObjFieldInfoList.add(idFieldInfo.getFieldInfo());
                        fieldAlias = idFieldInfo.getAlgoXAlias();
                    } else {
                        AlgoXFieldInfo fieldInfo = this.algoxParser.getNormalAlgoXFieldInfo(fieldAlias);
                        fieldAlias = "ORIGINAL_ENUM_VALUE_" + fieldInfo.getAlgoXAlias();
                    }
                    List value = sortFieldInfo.getValue();
                    if (!this.customOrderMap.containsKey(fieldAlias)) {
                        HashMap indexMap = null;
                        if (value != null) {
                            indexMap = Maps.newHashMapWithExpectedSize((int)value.size());
                            for (int index = 0; index < value.size(); ++index) {
                                indexMap.putIfAbsent(value.get(index), index);
                            }
                        }
                        this.customOrderMap.put(fieldAlias, indexMap);
                    }
                    this.orderFields.add(new OrderField(sortFieldInfo.getFieldAlias(), CUSTOM_ORDER_FIELD_PREFIX + AlgoXFieldInfo.replaceAlgoxAlias(fieldAlias), DataTypeEnum.INTEGER, SortFieldInfo.SORTORD_ASC, true));
                    continue;
                }
                this.orderFields.add(new OrderField(sortFieldInfo.getFieldAlias(), AlgoXFieldInfo.replaceAlgoxAlias(fieldAlias), sortFieldInfo.getDataType(), sortFieldInfo.getSortord(), false));
            }
        }
    }

    public String[] getOrderByAlgoXAliasArr() {
        return this.getOrderByAlgoXAliasArr(null);
    }

    public String[] getOrderByAlgoXAliasArr(List<String> orderByAlgoXAliasList) {
        List sortFieldInfoList;
        HashSet orderByAlgoXAliasSet = null;
        if (orderByAlgoXAliasList != null) {
            orderByAlgoXAliasSet = Sets.newHashSet(orderByAlgoXAliasList);
        }
        String queryMode = this.context.getQueryMode();
        List<String> dimDistinctAlgoXAliasArr = null;
        if ("2".equals(queryMode)) {
            dimDistinctAlgoXAliasArr = this.algoxParser.getDimDistinctAlgoXAliasArr();
        }
        if ((sortFieldInfoList = this.context.getSortFieldInfoList()) == null || sortFieldInfoList.isEmpty()) {
            if (dimDistinctAlgoXAliasArr == null) {
                return null;
            }
            sortFieldInfoList = Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        HashSet duplicateSet = Sets.newHashSetWithExpectedSize((int)sortFieldInfoList.size());
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            String algoXAlias = this.algoxParser.getAlgoXAliasByAlias(sortFieldInfo.getFieldAlias());
            if (duplicateSet.contains(algoXAlias) || orderByAlgoXAliasSet != null && !orderByAlgoXAliasSet.contains(algoXAlias)) continue;
            duplicateSet.add(algoXAlias);
            if (!SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())) {
                resultList.add(algoXAlias + " " + sortFieldInfo.getSortord());
                continue;
            }
            String baseDataIdAlias = AlgoXOrderFieldParser.getBaseDataIdAlias(algoXAlias);
            algoXAlias = baseDataIdAlias != null ? baseDataIdAlias : "ORIGINAL_ENUM_VALUE_" + algoXAlias;
            resultList.add(CUSTOM_ORDER_FIELD_PREFIX + algoXAlias + " " + SortFieldInfo.SORTORD_ASC);
        }
        if (dimDistinctAlgoXAliasArr != null && !dimDistinctAlgoXAliasArr.isEmpty()) {
            for (String dimAlgoXAlias : dimDistinctAlgoXAliasArr) {
                if (!duplicateSet.add(dimAlgoXAlias)) continue;
                resultList.add(dimAlgoXAlias + " " + SortFieldInfo.SORTORD_ASC);
            }
        }
        return resultList.toArray(new String[0]);
    }

    public Collection<AlgoXFieldInfo> getMainEntityAlgoxFieldInfoCollection() {
        return this.mainEntityAlgoXFieldInfoMap.values();
    }

    public Map<String, AlgoXFieldInfo> getRelEntityFieldInfoMap(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias);
    }

    public Collection<AlgoXFieldInfo> getRelEntityFieldInfoCollection(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias).values();
    }

    public Map<String, Map<String, Integer>> getCustomOrderMap() {
        return this.customOrderMap;
    }

    public static String getBaseDataIdAlias(String fieldAlias) {
        String baseIdAlias = null;
        if (HRStringUtils.isNotEmpty((String)fieldAlias)) {
            for (String suffix : BASE_DATA_SUFFIX_ARRAY) {
                if (!fieldAlias.endsWith(suffix)) continue;
                baseIdAlias = fieldAlias.substring(0, fieldAlias.length() - suffix.length());
                String idAliasPrefix = "_DOC_SPLIT_";
                if (fieldAlias.contains(".")) {
                    idAliasPrefix = ".";
                }
                baseIdAlias = baseIdAlias + idAliasPrefix + "id";
                break;
            }
        }
        return baseIdAlias;
    }

    public Map<String, AlgoXFieldInfo> getAllOrderFieldInfoAlgoXAliasMap() {
        if (this.context.isReturnDependOrderValue()) {
            return this.algoxParser.getAllFieldAlgoXAliasMap(this.mainEntityAlgoXFieldInfoMap, this.relEntityAliasFieldInfoMap);
        }
        return this.algoxParser.getAllSelectFieldAlgoXAliasMap(this.mainEntityAlgoXFieldInfoMap, this.relEntityAliasFieldInfoMap);
    }

    public List<OrderField> getOrderFields() {
        return this.orderFields;
    }

    public boolean isDependSortField(String algoXAlias) {
        Boolean isDependSort = this.dependSortFieldMap.get(algoXAlias);
        if (isDependSort == null) {
            return false;
        }
        return isDependSort;
    }

    public SortFieldInfo getFirstSortField() {
        return this.firstSortField;
    }
}

