/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXPagingOrderParser;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjRouteUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.complexobj.paging.Partition;
import kd.hr.hbp.common.util.time.CostTimeHelper;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.java.tuple.Tuple2;

public class AlgoXPagingOptimizeParser
implements IAlgoXParser {
    private static final Log LOGGER = LogFactory.getLog(AlgoXPagingOptimizeParser.class);
    private static final long serialVersionUID = 2927305119078094621L;
    private final HRComplexObjContext context;
    private final AlgoXParser algoXParser;
    private final Partition partition;
    private AlgoXPagingOrderParser algoXPagingOrderParser;
    private MainEntityType realMainEntityType;
    private final Map<String, List<QFilter>> filterByPagingData = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, HRComplexObjJoinRelation> relationMap;
    private boolean isEmptyPaging;
    private boolean isCanPagingOptimize = true;

    public AlgoXPagingOptimizeParser(HRComplexObjContext context, AlgoXParser algoXParser, Partition partition) {
        this.context = context;
        this.algoXParser = algoXParser;
        this.partition = partition;
        this.relationMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, joinRelation -> joinRelation));
        SortFieldInfo firstSortFieldInfo = algoXParser.getFirstSortFieldInfo();
        if (firstSortFieldInfo != null) {
            if ("2".equals(this.context.getQueryScheme())) {
                if (firstSortFieldInfo.getSortord().equals(SortFieldInfo.SORTORD_USER_DEFINED)) {
                    this.isCanPagingOptimize = false;
                } else {
                    String sortFieldAlias = firstSortFieldInfo.getFieldAlias();
                    String entityAlias = this.algoXParser.parseAliasReturnEntityAlias(sortFieldAlias);
                    if (!algoXParser.containsRelEntity(entityAlias)) {
                        entityAlias = this.context.getEntityNumber();
                    }
                    MainEntityType entityType = this.algoXParser.getEntityTypeByAlias(entityAlias);
                    try {
                        this.isCanPagingOptimize = !ComplexObjRouteUtil.sortFieldNeedSync((DynamicObjectType)entityType, this.algoXParser.getRealFileNameByAlias(sortFieldAlias));
                    }
                    catch (Exception exception) {
                        this.isCanPagingOptimize = false;
                    }
                }
            }
            this.algoXPagingOrderParser = new AlgoXPagingOrderParser(this.algoXParser, this.context);
            if (this.isCanPagingOptimize) {
                this.isCanPagingOptimize = !this.algoXPagingOrderParser.isAlgoX();
            }
        }
        this.init();
    }

    @Override
    public final void init() {
        this.analyzePartitionToQFilter();
    }

    private void analyzePartitionToQFilter() {
        if (this.partition.getMainEntityStart() == -1) {
            return;
        }
        CostTimeHelper costTimeHelper = CostTimeHelper.create(AlgoXPagingOptimizeParser.class);
        costTimeHelper.nestedStart(false);
        this.realMainEntityType = EntityMetadataCache.getDataEntityType((String)this.partition.getEntityNumber());
        SortFieldInfo sortFieldInfo = this.getRealMainEntitySortField(this.partition.getEntityAlias());
        List<AlgoXFieldInfo> selectFieldInfo = this.getRealMainEntitySelectAlgoXFields();
        if (!selectFieldInfo.isEmpty()) {
            int mainStart = this.partition.getMainEntityStart();
            int mainLimit = this.partition.getMainLimit() + 1;
            if (this.algoXPagingOrderParser != null && this.getRealMainEntitySortField(this.partition.getEntityAlias()) == null) {
                mainStart = -1;
                mainLimit = -1;
            }
            Map<String, Set<Object>> filterData = FilterUtils.getFilterData(selectFieldInfo, this.partition.getEntityNumber(), this.getQFilterByAlias(this.partition.getEntityAlias()), mainStart, mainLimit, false, sortFieldInfo);
            costTimeHelper.logCost("getPagingFilterData", true, "getPagingFilterData");
            if (!filterData.isEmpty()) {
                HashSet hasQueryEntityAliases = Sets.newHashSetWithExpectedSize((int)this.context.getJoinRelationList().size());
                Set<Object> realMainDataIds = filterData.get(this.realMainEntityType.getPrimaryKey().getName());
                this.putEntityFilterAndMerge(this.partition.getEntityAlias(), new QFilter(this.realMainEntityType.getPrimaryKey().getName(), "in", realMainDataIds));
                hasQueryEntityAliases.add(this.partition.getEntityAlias());
                if (!this.partition.getEntityAlias().equals(this.context.getEntityNumber())) {
                    filterData = this.getLeftPagingFilterData(this.partition.getEntityAlias(), filterData, hasQueryEntityAliases);
                    costTimeHelper.logCost("getBuMainEntityFilterData", true, "getBuMainEntityFilterData");
                }
                this.addPagingQFilter(this.context.getEntityNumber(), filterData, hasQueryEntityAliases);
            } else {
                this.isEmptyPaging = true;
                LOGGER.info("getPagingFilterData_is_empty");
            }
            costTimeHelper.logCost("endBuildPagingFilterData", "endBuildPagingFilterData");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Set<Object>> getBuMainEntityFilterData(Map<String, Set<Object>> filterData) {
        Set<Tuple2<String, String>> tuple2Set = this.algoXParser.relEntityAliasOnRealFileNameSet(this.partition.getEntityAlias());
        for (Tuple2<String, String> tuple2 : tuple2Set) {
            Set<Object> filterValues = filterData.get(tuple2.f1);
            filterValues.remove(null);
            QFilter qFilter = new QFilter((String)tuple2.f0, "in", filterValues);
            this.putEntityFilterAndMerge(this.context.getEntityNumber(), qFilter);
        }
        ArrayList tempSelectFieldInfo = Lists.newArrayListWithExpectedSize((int)10);
        for (HRComplexObjJoinRelation joinRelation : this.context.getJoinRelationList()) {
            if (joinRelation.getRelEntityAlias().equals(this.partition.getEntityAlias())) continue;
            this.algoXParser.addTempSelectFieldInfo(joinRelation.getRelEntityAlias(), tempSelectFieldInfo, true);
        }
        if (!tempSelectFieldInfo.isEmpty()) {
            filterData = FilterUtils.getFilterData(tempSelectFieldInfo, this.context.getEntityNumber(), this.getQFilterByAlias(this.context.getEntityNumber()), -1, -1, false, null);
        }
        return filterData;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Set<Object>> getLeftPagingFilterData(String entityAlias, Map<String, Set<Object>> filterData, Set<String> hasQueryEntityAliases) {
        HRComplexObjJoinRelation relation = this.relationMap.get(entityAlias);
        if (relation == null) {
            return filterData;
        }
        Set<Tuple2<String, String>> tuple2Set = this.algoXParser.relEntityAliasOnRealFileNameSet(entityAlias);
        for (Tuple2<String, String> tuple2 : tuple2Set) {
            Set<Object> filterValues = filterData.get(tuple2.f1);
            filterValues.remove(null);
            QFilter qFilter = new QFilter((String)tuple2.f0, "in", filterValues);
            hasQueryEntityAliases.add(relation.getEntityAlias());
            this.putEntityFilterAndMerge(relation.getEntityAlias(), qFilter);
        }
        ArrayList tempSelectFieldInfo = Lists.newArrayListWithExpectedSize((int)10);
        if (this.context.getEntityNumber().equals(relation.getEntityAlias())) {
            this.algoXParser.addTempSelectFieldInfo(relation.getRelEntityAlias(), tempSelectFieldInfo, true);
        } else {
            this.algoXParser.addTempSelectFieldInfo(relation.getEntityAlias(), tempSelectFieldInfo, true);
        }
        if (!tempSelectFieldInfo.isEmpty()) {
            filterData = FilterUtils.getFilterData(tempSelectFieldInfo, relation.getEntityNumber(), this.getQFilterByAlias(relation.getEntityAlias()));
            if ((relation = this.relationMap.get(relation.getEntityAlias())) != null) {
                filterData = this.getLeftPagingFilterData(relation.getRelEntityAlias(), filterData, hasQueryEntityAliases);
            }
        }
        return filterData;
    }

    private List<AlgoXFieldInfo> getRealMainEntitySelectAlgoXFields() {
        ArrayList selectFieldInfo = Lists.newArrayListWithExpectedSize((int)this.realMainEntityType.getProperties().size());
        if (this.partition.getEntityAlias().equals(this.context.getEntityNumber())) {
            for (HRComplexObjJoinRelation joinRelation : this.context.getJoinRelationList()) {
                if (!joinRelation.getEntityAlias().equals(this.partition.getEntityAlias())) continue;
                this.algoXParser.addTempSelectFieldInfo(joinRelation.getRelEntityAlias(), selectFieldInfo, true);
            }
        } else {
            this.algoXParser.addTempSelectFieldInfo(this.partition.getEntityAlias(), selectFieldInfo, false);
        }
        AlgoXFieldInfo primaryAlgoXFieldInfo = this.algoXParser.getAlgoXFieldInfoByAlgoXAlias(this.algoXParser.getPrimaryAlias(this.partition.getEntityNumber()));
        if (primaryAlgoXFieldInfo != null && selectFieldInfo.stream().noneMatch(selectField -> selectField.getRealFieldName().equals(primaryAlgoXFieldInfo.getRealFieldName()))) {
            selectFieldInfo.add(primaryAlgoXFieldInfo);
        }
        return selectFieldInfo;
    }

    public void putEntityFilterAndMerge(String relEntityAlias, QFilter filter) {
        List<QFilter> qFilterList = this.filterByPagingData.get(relEntityAlias);
        this.filterByPagingData.put(relEntityAlias, FilterUtils.addFilterAndMerge(qFilterList, filter));
    }

    public List<QFilter> getEntityPagingFilterList(String entityAlias) {
        List<QFilter> relByMainDataQFilters = this.filterByPagingData.get(entityAlias);
        if (relByMainDataQFilters != null) {
            return this.algoXParser.replaceQFilterAliasToRealFileName(relByMainDataQFilters);
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    @ExcludeFromJacocoGeneratedReport
    private List<QFilter> getQFilterByAlias(String entityAlias) {
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        if (this.context.getEntityNumber().equals(entityAlias)) {
            qFilterList.addAll(this.algoXParser.getMainEntityFilterListWithQueryEmpty());
        } else {
            qFilterList.addAll(this.algoXParser.getRelWhereQFilterListWithQueryEmpty(entityAlias));
        }
        if (this.algoXPagingOrderParser != null && this.getRealMainEntitySortField(entityAlias) == null && this.partition.getEntityAlias().equals(entityAlias)) {
            ISimpleProperty primaryKey = this.realMainEntityType.getPrimaryKey();
            FilterUtils.addFilterAndMerge(qFilterList, new QFilter(primaryKey.getName(), "in", this.algoXPagingOrderParser.getIds(this.partition.getMainEntityStart(), this.partition.getMainLimit() + 1)));
        }
        for (QFilter qFilter : this.getEntityPagingFilterList(entityAlias)) {
            FilterUtils.addFilterAndMerge(qFilterList, qFilter);
        }
        return qFilterList;
    }

    public SortFieldInfo getRealMainEntitySortField(String entityAlias) {
        SortFieldInfo firstSortField = this.algoXParser.getFirstSortFieldInfo();
        if (firstSortField != null) {
            String fieldEntityAlias = this.algoXParser.parseAliasReturnEntityAlias(firstSortField.getFieldAlias());
            if (this.algoXParser.getRealMainEntityAlias().equals(entityAlias)) {
                if (!this.algoXParser.containsRelEntity(fieldEntityAlias) && this.context.getEntityNumber().equals(entityAlias)) {
                    return firstSortField;
                }
                if (fieldEntityAlias.equals(entityAlias)) {
                    SortFieldInfo clone = (SortFieldInfo)SerializationUtils.clone((Serializable)firstSortField);
                    clone.setFieldAlias(this.algoXParser.getRealFileNameByAlias(clone.getFieldAlias()));
                    return clone;
                }
            }
        }
        return null;
    }

    public boolean isEmptyPaging() {
        return this.isEmptyPaging;
    }

    public AlgoXPagingOrderParser getAlgoXPagingOrderParser() {
        return this.algoXPagingOrderParser;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addPagingQFilter(String entityAlias, Map<String, Set<Object>> filterData, Set<String> hasQueryEntityAliases) {
        for (HRComplexObjJoinRelation joinRelation : this.context.getJoinRelationList()) {
            String relEntityAlias = joinRelation.getRelEntityAlias();
            if (hasQueryEntityAliases.contains(relEntityAlias)) continue;
            if (joinRelation.getEntityAlias().equals(entityAlias)) {
                Set<Tuple2<String, String>> tuple2Set = this.algoXParser.relEntityAliasOnRealFileNameSet(relEntityAlias);
                for (Tuple2<String, String> tuple2 : tuple2Set) {
                    Set<Object> filterValues = filterData.get(tuple2.f0);
                    if (filterValues == null) continue;
                    filterValues.remove(null);
                    QFilter qFilter = new QFilter((String)tuple2.f1, "in", filterValues);
                    this.putEntityFilterAndMerge(relEntityAlias, qFilter);
                }
                hasQueryEntityAliases.add(relEntityAlias);
                continue;
            }
            ArrayList selectFieldInfo = Lists.newArrayListWithExpectedSize((int)10);
            if (this.context.getEntityNumber().equals(joinRelation.getEntityAlias())) {
                this.algoXParser.addTempSelectFieldInfo(joinRelation.getRelEntityAlias(), selectFieldInfo, true);
            } else {
                this.algoXParser.addTempSelectFieldInfo(joinRelation.getEntityAlias(), selectFieldInfo, false);
            }
            Map<String, Set<Object>> nextFilterData = FilterUtils.getFilterData(selectFieldInfo, joinRelation.getEntityNumber(), this.getQFilterByAlias(joinRelation.getEntityAlias()));
            this.addPagingQFilter(joinRelation.getEntityAlias(), nextFilterData, hasQueryEntityAliases);
        }
    }

    public boolean isCanPagingOptimize() {
        return this.isCanPagingOptimize;
    }
}

