/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjRouteUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;

@ExcludeFromJacocoGeneratedReport
public class AlgoXPagingOrderParser
implements IAlgoXParser {
    private static final Log LOGGER = LogFactory.getLog(AlgoXPagingOrderParser.class);
    private static final long serialVersionUID = 1758607889259311464L;
    private final SortFieldInfo firstSortField;
    private final AlgoXParser algoXParser;
    private final HRComplexObjContext context;
    private List<Object> ids;
    private boolean isOrderFieldInRealMainEntity = false;
    private final HRComplexObjContext orderContext;
    private boolean isAlgoX = false;

    public AlgoXPagingOrderParser(AlgoXParser algoXParser, HRComplexObjContext context) {
        this.algoXParser = algoXParser;
        this.firstSortField = algoXParser.getFirstSortFieldInfo();
        this.context = context;
        this.orderContext = this.createHRComplexObjContext();
        this.init();
    }

    @Override
    public final void init() {
        if (this.firstSortField == null) {
            return;
        }
        String entityAlias = this.algoXParser.parseAliasReturnEntityAlias(this.firstSortField.getFieldAlias());
        if (!this.algoXParser.containsRelEntity(entityAlias) && this.algoXParser.getRealMainEntityAlias().equals(this.context.getEntityNumber())) {
            this.isOrderFieldInRealMainEntity = true;
        } else if (this.algoXParser.getRealMainEntityAlias().equals(entityAlias)) {
            this.isOrderFieldInRealMainEntity = true;
        }
        this.isAlgoX = ComplexObjRouteUtil.useAlgoXQuery(this.orderContext.getQueryScheme(), this.orderContext);
    }

    public List<Object> getIds(int start, int limit) {
        if (this.isOrderFieldInRealMainEntity) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        if (this.ids != null) {
            return this.ids;
        }
        long startTime = System.currentTimeMillis();
        String idAlias = ((HRComplexObjFieldInfo)this.orderContext.getComplexObjFieldInfoList().get(0)).getAlias();
        ReportQueryService queryService = new ReportQueryService(this.orderContext);
        List<Map<String, Object>> realMainEntityIds = queryService.queryMap(start, limit);
        this.ids = realMainEntityIds.stream().map(data -> data.get(idAlias)).collect(Collectors.toList());
        LOGGER.info("AlgoXPagingOrderParser_get_order_ids_cost_{}", (Object)(System.currentTimeMillis() - startTime));
        this.context.addOrderPartitions(this.orderContext.getOrderPartitions());
        return this.ids;
    }

    private HRComplexObjContext createHRComplexObjContext() {
        HRComplexObjContext orderContext = new HRComplexObjContext();
        orderContext.setEntityNumber(this.context.getEntityNumber());
        orderContext.setEntityTable(this.context.getEntityTable());
        String realMainEntityNumber = this.algoXParser.getRealMainEntityNumber();
        String realMainEntityAlias = this.algoXParser.getRealMainEntityAlias();
        ArrayList queryField = Lists.newArrayListWithExpectedSize((int)1);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)realMainEntityNumber);
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        DataTypeEnum idDataType = DataTypeEnum.LONG;
        if (primaryKey instanceof VarcharProp) {
            idDataType = DataTypeEnum.STRING;
        }
        if (this.context.getEntityNumber().equals(realMainEntityAlias)) {
            queryField.add(new HRComplexObjFieldInfo(primaryKey.getName(), idDataType, primaryKey.getName()));
        }
        String orderFieldEntityAlias = this.algoXParser.parseAliasReturnEntityAlias(this.firstSortField.getFieldAlias());
        List joinRelationList = this.context.getJoinRelationList();
        ArrayList newJoinRelList = Lists.newArrayListWithExpectedSize((int)joinRelationList.size());
        Set<String> allSortEntityAlias = this.getAllSortEntityAlias(joinRelationList, orderFieldEntityAlias);
        Set<String> orFilterEntityAliases = this.getOrFilterRelEntityAliases();
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            if (allSortEntityAlias.contains(joinRelation.getRelEntityAlias())) {
                newJoinRelList.add(this.createNewJoinRelation(joinRelation));
                continue;
            }
            if (realMainEntityAlias.equals(joinRelation.getRelEntityAlias())) {
                String idAlias = joinRelation.getRelEntityAlias() + "." + primaryKey.getName();
                newJoinRelList.add(this.createNewJoinRelation(joinRelation));
                queryField.add(new HRComplexObjFieldInfo(idAlias, idDataType, idAlias));
                continue;
            }
            if (orderFieldEntityAlias.equals(joinRelation.getRelEntityAlias())) {
                newJoinRelList.add(this.createNewJoinRelation(joinRelation));
                continue;
            }
            if (!orFilterEntityAliases.contains(joinRelation.getRelEntityAlias())) continue;
            newJoinRelList.add(this.createNewJoinRelation(joinRelation));
        }
        queryField.add(new HRComplexObjFieldInfo(this.firstSortField.getFieldAlias(), this.firstSortField.getDataType(), this.firstSortField.getFieldAlias()));
        orderContext.setOrderPartitionQuery(true);
        orderContext.setComplexObjFieldInfoList((List)queryField);
        orderContext.setJoinRelationList((List)newJoinRelList);
        orderContext.setSortFieldInfoList((List)Lists.newArrayList((Object[])new SortFieldInfo[]{this.firstSortField}));
        orderContext.setQfilterList(this.analyzeNewQFilter(orderContext));
        orderContext.addOrderPartitions(this.context.getOrderPartitions());
        return orderContext;
    }

    private List<QFilter> analyzeNewQFilter(HRComplexObjContext orderContext) {
        List qFilters = this.context.getQfilterList();
        if (qFilters == null || qFilters.isEmpty()) {
            return qFilters;
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)qFilters.size());
        HashSet entityAliasSet = Sets.newHashSetWithExpectedSize((int)(orderContext.getJoinRelationList().size() + 1));
        for (Object joinRelation : orderContext.getJoinRelationList()) {
            entityAliasSet.add(joinRelation.getRelEntityAlias());
        }
        Set<String> notNeedAliases = this.context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).filter(alias -> !entityAliasSet.contains(alias)).collect(Collectors.toSet());
        for (QFilter qFilter : qFilters) {
            String prefixAlias = this.algoXParser.parseAliasReturnRelEntityAlias(qFilter.getProperty());
            QFilter parentQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (!notNeedAliases.contains(prefixAlias)) {
                parentQFilter = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
                qFilterList.add(parentQFilter);
            }
            List nests = qFilter.getNests(false);
            for (QFilter.QFilterNest nest : nests) {
                this.parseNestFilter(nest, parentQFilter, notNeedAliases);
            }
        }
        List<QFilter> mainEntityFilterListWithQueryEmpty = this.algoXParser.getMainEntityFilterListWithQueryEmpty();
        for (QFilter filter : mainEntityFilterListWithQueryEmpty) {
            FilterUtils.addFilterAndMerge(qFilterList, filter);
        }
        return qFilterList;
    }

    private void parseNestFilter(QFilter.QFilterNest nest, QFilter parentQFilter, Set<String> notNeedAliases) {
        QFilter filter = nest.getFilter();
        String nestPrefixAlias = this.algoXParser.parseAliasReturnRelEntityAlias(filter.getProperty());
        if (!notNeedAliases.contains(nestPrefixAlias)) {
            QFilter newFilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
            List nests = filter.getNests(false);
            for (QFilter.QFilterNest childNest : nests) {
                this.parseNestFilter(childNest, newFilter, notNeedAliases);
            }
            if (nest.isAnd()) {
                parentQFilter.and(newFilter);
            } else {
                parentQFilter.or(newFilter);
            }
        }
    }

    private Set<String> getOrFilterRelEntityAliases() {
        List qFilters = this.context.getQfilterList();
        if (qFilters == null || qFilters.isEmpty()) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet orEntityAliases = Sets.newHashSetWithExpectedSize((int)this.context.getJoinRelationList().size());
        Set relEntityAliases = this.context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        for (QFilter qFilter : qFilters) {
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter filter;
                String nestPrefixAlias;
                if (nest.isAnd() || !relEntityAliases.contains(nestPrefixAlias = this.algoXParser.parseAliasReturnRelEntityAlias((filter = nest.getFilter()).getProperty()))) continue;
                orEntityAliases.add(nestPrefixAlias);
            }
        }
        return orEntityAliases;
    }

    private HRComplexObjJoinRelation createNewJoinRelation(HRComplexObjJoinRelation oldJoinRelation) {
        HRComplexObjJoinRelation newJoinRelation = new HRComplexObjJoinRelation(oldJoinRelation.getEntityNumber(), oldJoinRelation.getEntityAlias(), oldJoinRelation.getRelEntityNumber(), oldJoinRelation.getRelEntityAlias(), oldJoinRelation.getJoinType());
        newJoinRelation.setCondition(oldJoinRelation.getCondition());
        return newJoinRelation;
    }

    public boolean isAlgoX() {
        return this.isAlgoX;
    }

    private Set<String> getAllSortEntityAlias(List<HRComplexObjJoinRelation> relationList, String relEntityAlias) {
        HashSet aliasSet = Sets.newHashSetWithExpectedSize((int)relationList.size());
        for (HRComplexObjJoinRelation joinRelation : relationList) {
            if (!joinRelation.getRelEntityAlias().equals(relEntityAlias)) continue;
            aliasSet.add(relEntityAlias);
            if (joinRelation.getEntityAlias().equals(this.context.getEntityNumber())) continue;
            aliasSet.addAll(this.getAllSortEntityAlias(relationList, joinRelation.getEntityAlias()));
        }
        return aliasSet;
    }
}

