/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;

public class AlgoXSelectFieldParser
implements IAlgoXParser {
    private static final long serialVersionUID = 4748532507171683536L;
    private final Map<String, AlgoXFieldInfo> mainEntityAlgoxFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap = new HashMap<String, Map<String, AlgoXFieldInfo>>();
    private final HRComplexObjContext context;
    private final AlgoXParser algoxParser;

    public AlgoXSelectFieldParser(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                Map cfr_ignored_0 = this.relEntityAliasFieldInfoMap.put(joinRelation.getRelEntityAlias(), new LinkedHashMap());
            });
        }
        this.parseComplexObjFieldInfoList();
        this.parsePresetIndexFieldInfoList();
    }

    private void parseComplexObjFieldInfoList() {
        List complexObjFieldInfoList = this.context.getComplexObjFieldInfoList();
        this.algoxParser.parseAndAddEntityFieldInfo(complexObjFieldInfoList, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
    }

    private void parsePresetIndexFieldInfoList() {
        for (HRComplexObjFieldInfo presetFieldInfo : this.context.getPresetIndexFieldInfoList()) {
            this.algoxParser.addPresetIndexFieldInfo(presetFieldInfo);
        }
    }

    public List<String> getDistinctAlgoXAliasList() {
        List complexObjFieldInfoList = this.context.getComplexObjFieldInfoList();
        return this.algoxParser.getDistinctAlgoXAliasList(complexObjFieldInfoList);
    }

    public List<String> getDistinctAlgoXAliasListWithDepend() {
        List complexObjFieldInfoList = this.context.getComplexObjFieldInfoList();
        return this.algoxParser.getDistinctAlgoXAliasListWithDepend(complexObjFieldInfoList);
    }

    public Map<String, AlgoXFieldInfo> getAllSelectFieldAlgoxAliasMap() {
        return this.algoxParser.getAllSelectFieldAlgoXAliasMap(this.mainEntityAlgoxFieldInfoMap, this.relEntityAliasFieldInfoMap);
    }

    public Collection<AlgoXFieldInfo> getMainEntityAlgoxFieldInfoCollection() {
        return this.mainEntityAlgoxFieldInfoMap.values().stream().filter(field -> !field.getFieldInfo().isAnObjPivotIndex()).collect(Collectors.toList());
    }

    public Map<String, AlgoXFieldInfo> getRelEntityFieldInfoMap(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias);
    }

    public Collection<AlgoXFieldInfo> getRelEntityFieldInfoCollection(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias).values().stream().filter(field -> !field.getFieldInfo().isAnObjPivotIndex()).collect(Collectors.toList());
    }
}

