/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;

public class ComplexObjContextUtils {
    public static HRComplexObjContext createSingleQueryContext(String entityName, QFilter[] filters, RowMeta rowMeta, SortFieldInfo sortFieldInfo) {
        HRComplexObjContext context = new HRComplexObjContext();
        context.setEntityNumber(entityName);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        context.setEntityTable(dataEntityType.getAlias());
        context.setQfilterList(Arrays.stream(filters).collect(Collectors.toList()));
        ArrayList queryFields = Lists.newArrayListWithExpectedSize((int)rowMeta.getFieldCount());
        for (Field field : rowMeta.getFields()) {
            queryFields.add(new HRComplexObjFieldInfo(field.getName(), AlgoDataTypeTransUtil.getDataTypeEnum(field.getDataType()), field.getName()));
        }
        if (sortFieldInfo != null) {
            queryFields.add(new HRComplexObjFieldInfo(sortFieldInfo.getFieldAlias(), sortFieldInfo.getDataType(), sortFieldInfo.getFieldAlias()));
            context.setSortFieldInfoList((List)Lists.newArrayList((Object[])new SortFieldInfo[]{sortFieldInfo}));
        }
        context.setJoinRelationList((List)Lists.newArrayListWithExpectedSize((int)0));
        context.setComplexObjFieldInfoList((List)queryFields);
        return context;
    }
}

