/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.FieldStoreInfo;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;

public class BaseDataTableJoinParser {
    private final KSqlParser kSqlParser;

    public BaseDataTableJoinParser(KSqlParser kSqlParser) {
        this.kSqlParser = kSqlParser;
    }

    public String getBaseDataJoinSql() {
        StringBuilder joinSql = new StringBuilder(" ");
        HashMap loadRecordAliasMap = new HashMap(16);
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        HashSet<String> tableAndAlias = new HashSet<String>(16);
        for (EntityFieldInfo fieldInfo : entityFieldInfoList) {
            String table;
            String tableAndField;
            FieldStoreInfo fieldStoreInfo = fieldInfo.getFieldStoreInfo();
            if (fieldStoreInfo == null) continue;
            String fieldEntityAlias = fieldInfo.getFieldEntityAlias();
            Set loadTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, fieldEntityAlias);
            if (!loadTable.contains(tableAndField = (table = fieldStoreInfo.getTable()) + "#" + fieldInfo.getAlias())) {
                String tableAliasKey;
                String tableAlias = this.kSqlParser.getTableAlias(fieldEntityAlias, tableAndField);
                String mainTableAndField = fieldInfo.getTable();
                if (fieldStoreInfo.isMultilingual()) {
                    mainTableAndField = fieldInfo.getTable() + "#" + fieldInfo.getAlias();
                }
                if (tableAndAlias.contains(tableAliasKey = table + "*" + tableAlias)) continue;
                tableAndAlias.add(tableAliasKey);
                String mainTableAlias = this.kSqlParser.getTableAlias(fieldEntityAlias, mainTableAndField);
                joinSql.append(" ").append(KsqlJoinHint.LEFTJOIN.getJoin()).append(" ").append(table).append(" ").append(tableAlias).append(" ON ").append(tableAlias).append(".").append(fieldStoreInfo.getTablePk());
                if (fieldStoreInfo.isMultilingual()) {
                    joinSql.append(" = ").append(mainTableAlias).append(".").append(fieldStoreInfo.getTablePk()).append(" ").append(" AND ").append(tableAlias).append(".").append("FLOCALEID = ").append("#{flocalid}").append(' ');
                } else {
                    joinSql.append(" = ").append(mainTableAlias).append(".").append(fieldStoreInfo.getStoreField()).append(" ");
                }
            }
            loadTable.add(tableAndField);
            FieldStoreInfo reference = fieldStoreInfo.getReference();
            if (reference != null && !loadTable.contains(reference.getTable())) {
                String referenceTable = reference.getTable();
                String refTableAndField = referenceTable + "#" + reference.getFieldAlias();
                String tableAlias = this.kSqlParser.getTableAlias(fieldEntityAlias, refTableAndField);
                String mainTableAlias = this.kSqlParser.getTableAlias(fieldEntityAlias, tableAndField);
                String tableAliasKey = referenceTable + "*" + tableAlias;
                if (tableAndAlias.contains(tableAliasKey)) continue;
                tableAndAlias.add(tableAliasKey);
                joinSql.append(" ").append(KsqlJoinHint.LEFTJOIN.getJoin());
                joinSql.append(" ").append(referenceTable).append(" ").append(tableAlias).append(" ON ").append(tableAlias).append(".").append(reference.getTablePk());
                if (reference.isMultilingual()) {
                    joinSql.append(" = ").append(mainTableAlias).append(".").append(reference.getTablePk()).append(" ").append(" AND ").append(tableAlias).append(".").append("FLOCALEID = ").append("#{flocalid}").append(' ');
                } else {
                    joinSql.append(" = ").append(mainTableAlias).append(".").append(reference.getStoreField()).append(" ");
                }
                loadTable.add(refTableAndField);
            }
            loadRecordAliasMap.put(fieldEntityAlias, loadTable);
        }
        return joinSql.toString();
    }
}

