/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;

@ExcludeFromJacocoGeneratedReport
public class DateFormatMapFunction
extends MapFunction {
    private static final long serialVersionUID = 4195609034802528723L;
    private final TimeZone timeZone = KDDateUtils.getTimeZone();
    private RowMeta oriRowMeta;

    public DateFormatMapFunction(RowMeta oriRowMeta) {
        this.oriRowMeta = oriRowMeta;
    }

    public Object[] map(Row row) {
        String[] fieldNames = this.oriRowMeta.getFieldNames();
        Object[] objects = new Object[fieldNames.length];
        String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Object rowVal = row.get(fieldName);
            if (rowVal instanceof Date) {
                Date date = (Date)rowVal;
                String dateStr = HRDateTimeUtils.format((Date)date, (String)YYYY_MM_DD_HH_MM_SS, (TimeZone)this.timeZone);
                try {
                    rowVal = HRDateTimeUtils.parseDate((String)dateStr, (String)YYYY_MM_DD_HH_MM_SS, (TimeZone)this.timeZone);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            objects[i] = rowVal;
        }
        return objects;
    }

    public RowMeta getResultRowMeta() {
        return this.oriRowMeta;
    }
}

