/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.service.complexobj.ksql.AddRowNumMapFunction;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlQueryService;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.BaseDataLoadUtil;
import kd.hr.hbp.business.service.complexobj.util.DataTypeConvertUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.business.service.complexobj.util.SplitDateByDBTransFunction;
import kd.hr.hbp.business.service.complexobj.util.SplitDateTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.QuerySegment;
import kd.hr.hbp.common.model.report.DateTransUtils;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DimKSqlQueryService
extends KSqlQueryService {
    private static final Log LOGGER = LogFactory.getLog(DimKSqlQueryService.class);
    private List<Map<String, Object>> dimListMap;
    private final TimeZone timeZone = KDDateUtils.getSysTimeZone();
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;

    public DimKSqlQueryService(HRComplexObjContext complexObjCont) {
        super(complexObjCont);
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(complexObjCont, complexObjCont.getComplexObjFieldInfoList());
    }

    @Override
    protected List<Map<String, Object>> queryFromDb(int start, int limit) {
        return this.queryFromDbByTuple(start, limit);
    }

    private List<Map<String, Object>> queryFromDbByTuple(int start, int limit) {
        LOGGER.info("DimKSqlQuery queryFromDbByTuple:start:{},limit:{}", (Object)start, (Object)limit);
        List extQFilterList = null;
        List<Object> listDB = Lists.newArrayListWithCapacity((int)0);
        try {
            QuerySegment querySegment = this.getSourceComplexObjCont().getQuerySegment();
            int segmentStart = -1;
            if (querySegment == null) {
                if (start >= 0 && limit > 0) {
                    extQFilterList = this.genDimQFilter(start, limit);
                    List glangFilterProps = extQFilterList.stream().map(QFilter::getProperty).collect(Collectors.toList());
                    HRComplexObjContext dimCompObj = this.getSourceComplexObjCont();
                    dimCompObj.getQfilterList().addAll(extQFilterList);
                    dimCompObj.setGlangFilterProps(glangFilterProps);
                    HRComplexObjContext complexObjCont = this.getComplexObjCont();
                    complexObjCont.getQfilterList().addAll(extQFilterList);
                    complexObjCont.setGlangFilterProps(glangFilterProps);
                }
                Long detailCount = super.queryDataCount(-1, -1);
                LOGGER.info("DimKSqlQuery detailCount:{}", (Object)detailCount);
                if (detailCount > (long)(limit * 3) && detailCount > (long)this.getSourceComplexObjCont().getkSqlSumThreshold()) {
                    querySegment = new QuerySegment(detailCount.longValue(), this.getSourceComplexObjCont().getkSqlSumBatch());
                    querySegment.setExtQFilterList(extQFilterList);
                    extQFilterList = null;
                    segmentStart = 0;
                }
            } else if (querySegment.hasNext()) {
                segmentStart = querySegment.nextStart();
                if (!querySegment.hasNext()) {
                    extQFilterList = querySegment.getExtQFilterList();
                }
            } else {
                extQFilterList = querySegment.getExtQFilterList();
                if (CollectionUtils.isNotEmpty((Collection)extQFilterList)) {
                    this.getSourceComplexObjCont().getQfilterList().removeAll(extQFilterList);
                    this.getSourceComplexObjCont().getGlangFilterProps().clear();
                    this.getComplexObjCont().getQfilterList().removeAll(extQFilterList);
                    this.getComplexObjCont().getGlangFilterProps().clear();
                }
                LOGGER.error("DimKSqlQuery QuerySegment no next page data");
                ArrayList detailCount = listDB;
                return detailCount;
            }
            this.getSourceComplexObjCont().setQuerySegment(querySegment);
            String sqlStr = segmentStart >= 0 ? this.getParser().getSqlStr(this.getTmpTableSQLOfSyncMap(), segmentStart, this.getSourceComplexObjCont().getkSqlSumBatch()) : this.getParser().getSqlStr(this.getTmpTableSQLOfSyncMap());
            LOGGER.info("complexobj execute sql:{}", (Object)sqlStr);
            Object[] params = this.getSQLParames(sqlStr);
            sqlStr = this.localTransPlaceholder(sqlStr);
            if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                DB.beginThreadWrite();
            }
            listDB = this.queryData(this.getParser(), sqlStr, params, segmentStart);
            if (CollectionUtils.isNotEmpty((Collection)extQFilterList)) {
                this.getSourceComplexObjCont().getQfilterList().removeAll(extQFilterList);
                this.getComplexObjCont().getQfilterList().removeAll(extQFilterList);
            }
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.error(kdBizException.getMessage());
                ArrayList arrayList = listDB;
                return arrayList;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            if (exception.getCause() instanceof SQLException) {
                throw new KDBizException(ResManager.loadKDString((String)"KSql\u6267\u884c\u5931\u8d25\u3002", (String)"KSqlQueryService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            throw new KDBizException(exception.getMessage());
        }
        finally {
            if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                DB.endThreadReadWrite();
            }
            this.closePKTempTable(this.getTmpTableSQLOfSyncMap());
        }
        return this.filterByDimTuple(listDB);
    }

    private List<Map<String, Object>> filterByDimTuple(List<Map<String, Object>> listDB) {
        StringBuilder allDimStb;
        if (CollectionUtils.isEmpty(this.dimListMap)) {
            return listDB;
        }
        Set<String> dimFieldAliasSet = this.dimListMap.get(0).keySet();
        HashSet<String> allDimStbCache = new HashSet<String>(16);
        for (Map<String, Object> dimData : this.dimListMap) {
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                Object dimVal = dimData.get(dimFieldName);
                allDimStb.append(dimFieldName).append(dimVal);
            }
            allDimStbCache.add(allDimStb.toString());
        }
        Iterator<Map<String, Object>> iterator = listDB.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            allDimStb = new StringBuilder();
            for (String dimFieldName : dimFieldAliasSet) {
                String splitDateTypeKey = null;
                String originField = dimFieldName;
                if (dimFieldName.contains("!")) {
                    String[] propAliaSplit = dimFieldName.split("!");
                    originField = propAliaSplit[0];
                    splitDateTypeKey = propAliaSplit[1];
                }
                Object dimVal = next.get(originField);
                if (HRStringUtils.isNotEmpty(splitDateTypeKey) && dimVal instanceof Date) {
                    Date date = (Date)dimVal;
                    dimVal = DateTransUtils.transferDateToDbVal((Date)date, (String)splitDateTypeKey, (TimeZone)this.timeZone);
                }
                allDimStb.append(dimFieldName).append(dimVal);
            }
            if (allDimStbCache.contains(allDimStb.toString())) continue;
            iterator.remove();
        }
        return listDB;
    }

    /*
     * WARNING - void declaration
     */
    private List<QFilter> genDimQFilter(int start, int limit) {
        void var13_17;
        HRComplexObjContext dimCompObj = this.genDimComplexObjCont(this.getComplexObjCont());
        KSqlParser dimParser = new KSqlParser(dimCompObj);
        this.dimListMap = this.queryDimFromDb(dimParser, start, limit);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (CollectionUtils.isEmpty(this.dimListMap)) {
            qFilterList.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            return qFilterList;
        }
        List<HRComplexObjFieldInfo> queryFieldList = this.genDimQueryFieldList(this.getComplexObjCont());
        Map<String, DataTypeEnum> fieldAliasMap = queryFieldList.stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, HRComplexObjFieldInfo::getDataType, (x, y) -> x));
        Map<String, String> idTypeMap = BaseDataLoadUtil.getIdTypeMap(dimParser.getEntityFieldInfoList());
        Map<String, String> baseDataFieldIdMap = dimParser.getEntityFieldInfoList().stream().filter(fi -> idTypeMap.containsKey(fi.getConvertField())).collect(Collectors.toMap(EntityFieldInfo::getAlias, EntityFieldInfo::getConvertField, (x, y) -> x));
        HashMap dimDataMap = new HashMap(16);
        HashSet<String> nvlValFieldSet = new HashSet<String>(16);
        for (Map<String, Object> map : this.dimListMap) {
            for (String fieldAlias : fieldAliasMap.keySet()) {
                Object dataVal;
                String baseDataFieldId = baseDataFieldIdMap.get(fieldAlias);
                if (HRStringUtils.isNotEmpty((String)baseDataFieldId)) {
                    fieldAlias = baseDataFieldId;
                }
                if ((dataVal = map.get(fieldAlias)) == null) {
                    nvlValFieldSet.add(fieldAlias);
                    continue;
                }
                Set<String> dataList = (Set)dimDataMap.get(fieldAlias);
                if (dataList == null) {
                    dataList = new HashSet<String>(16);
                }
                dataList.add((String)dataVal);
                if (dataVal instanceof String && "".equals(dataVal)) {
                    dataList.add(" ");
                }
                dimDataMap.put(fieldAlias, dataList);
            }
        }
        for (Map.Entry entry : dimDataMap.entrySet()) {
            String fieldAlias = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) {
                qFilterList.add(QFilter.isNull((String)fieldAlias));
                nvlValFieldSet.remove(fieldAlias);
                continue;
            }
            DataTypeEnum valueType = fieldAliasMap.get(fieldAlias);
            if (valueType == null) {
                String idType = idTypeMap.get(fieldAlias);
                valueType = "bigint".equals(idType) ? DataTypeEnum.LONG : DataTypeEnum.STRING;
            }
            HashSet<Object> dbVals = new HashSet<Object>(value.size());
            for (Object obj : value) {
                if (obj instanceof Date) {
                    dbVals.add(obj);
                    continue;
                }
                dbVals.add(DataTypeConvertUtil.toConvertDbStore(valueType, obj));
            }
            QFilter qFilter = new QFilter(fieldAlias, "in", dbVals);
            if (nvlValFieldSet.contains(fieldAlias)) {
                qFilter.or(QFilter.isNull((String)fieldAlias));
            }
            qFilterList.add(qFilter);
        }
        LOGGER.info("before SplitDateFilterTrans: {}", qFilterList);
        SplitDateByDBTransFunction transUtil = new SplitDateByDBTransFunction();
        boolean bl = false;
        while (var13_17 < qFilterList.size()) {
            QFilter qFilter = (QFilter)qFilterList.get((int)var13_17);
            qFilter = qFilter.trans((Function)transUtil);
            qFilterList.set((int)var13_17, qFilter);
            ++var13_17;
        }
        LOGGER.info("after SplitDateFilterTrans: {}", qFilterList);
        return qFilterList;
    }

    public List<Map<String, DimensionData>> queryDim4ListMap() {
        HRComplexObjContext dimCompObj = this.genDimComplexObjCont(this.getComplexObjCont());
        KSqlParser dimParser = new KSqlParser(dimCompObj);
        List<Map<String, Object>> dataList = this.queryDimFromDb(dimParser, -1, -1);
        List<EntityFieldInfo> entityFieldInfos = dimParser.getEntityFieldInfoList().stream().filter(field -> !dimParser.getExtraField4TbJoin().contains(field.getAlias())).collect(Collectors.toList());
        BaseDataLoadUtil.reloadBdProp(dataList, entityFieldInfos);
        List<Map<String, DimensionData>> dimensionList = DimensionData.convertToDimensionDataMap(dataList, (String[])dimCompObj.getComplexObjFieldInfoList().stream().map(HRComplexObjFieldInfo::getAlias).toArray(String[]::new), this.getComplexObjCont().getSortFieldInfoList());
        this.resetSplitDateFieldType(dimParser);
        this.formatSplitDateFieldVal(dimParser, dimensionList);
        this.fillDimensionFunctionField(dimensionList);
        this.dimensionDataTypeConvert(dimParser, dimensionList);
        if (!this.getComplexObjCont().isTransferField()) {
            BaseDataLoadUtil.dimensionDataTransfer(dimensionList, dimParser.getEntityFieldInfoList(), dimParser.getComplexObjCont().getComplexObjFieldInfoList(), dimParser.getComplexObjCont());
        }
        return dimensionList;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Long queryDataCount(int start, int limit) {
        Long count;
        block18: {
            DataSet dataSet;
            block16: {
                HRComplexObjContext dimCompObj = this.genDimComplexObjCont(this.getComplexObjCont());
                KSqlParser dimParser = new KSqlParser(dimCompObj);
                dimParser.setProcessDateByDb(true);
                count = 0L;
                dataSet = null;
                try {
                    Object countSqlStr = dimParser.getDistinctCountSqlStr(this.getTmpTableSQLOfSyncMap(), start, limit);
                    Object[] params = this.getSQLParames((String)countSqlStr);
                    countSqlStr = this.localTransPlaceholder((String)countSqlStr);
                    if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                        DB.beginThreadWrite();
                    }
                    if (!(dataSet = DB.queryDataSet((String)"kd.hr.hbp.business.service.complexobj.ksql.DimKSqlQueryService", (DBRoute)dimParser.getDBRoute(), (String)countSqlStr, (Object[])params)).isEmpty()) {
                        count = ((Row)dataSet.iterator().next()).getLong(0);
                        if (start >= 0 && limit >= 0 && count > (long)limit) {
                            count = limit;
                        }
                    }
                    if (null == dataSet) break block16;
                }
                catch (KDBizException kdBizException) {
                    block17: {
                        if (!kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) break block17;
                        LOGGER.warn(kdBizException.getMessage());
                        Long l = count;
                        return l;
                    }
                    LOGGER.error((Throwable)kdBizException);
                    throw kdBizException;
                }
                catch (Exception exception) {
                    LOGGER.error((Throwable)exception);
                    if (exception.getCause() instanceof SQLException) {
                        throw new KDBizException(ResManager.loadKDString((String)"KSql\u6267\u884c\u5931\u8d25\u3002", (String)"KSqlQueryService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                    }
                    throw new KDBizException(exception.getMessage());
                }
                dataSet.close();
            }
            if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                DB.endThreadReadWrite();
            }
            for (Map.Entry entry : this.getTmpTableSQLOfSyncMap().entrySet()) {
                ((PKTempTable)entry.getValue()).close();
            }
            break block18;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (null != dataSet) {
                    dataSet.close();
                }
                if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                    DB.endThreadReadWrite();
                }
                for (Map.Entry<String, PKTempTable> entry : this.getTmpTableSQLOfSyncMap().entrySet()) {
                    entry.getValue().close();
                }
            }
        }
        return count;
    }

    protected List<Map<String, Object>> queryDimFromDb(KSqlParser dimParser, int start, int limit) {
        ArrayList listDB = Lists.newArrayListWithCapacity((int)16);
        dimParser.setProcessDateByDb(true);
        try {
            String sqlStr = dimParser.getDistinctSqlStr(this.getTmpTableSQLOfSyncMap());
            LOGGER.info("complexobj query dimension execute sql:{}", (Object)sqlStr);
            Object[] params = this.getSQLParames(sqlStr);
            sqlStr = this.localTransPlaceholder(sqlStr);
            if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                DB.beginThreadWrite();
            }
            sqlStr = sqlStr.replaceAll("\\$", "_S_");
            sqlStr = this.transDateSplitSelectList(sqlStr);
            try (AlgoContext context = Algo.newContext();){
                DataSet dataSet = this.queryDataSet(sqlStr, dimParser.getDBRoute(), params);
                String selectListSql = dimParser.getSelectListParser().getSelectListSql(true, true, true, true);
                selectListSql = selectListSql.replaceAll("\\$", "_S_");
                selectListSql = selectListSql.replace("!", "_F_");
                dataSet = dataSet.map((MapFunction)new AddRowNumMapFunction(dataSet.getRowMeta(), "dimsortnum"));
                dataSet = dataSet.groupBy(selectListSql.toUpperCase(Locale.ROOT).split(",")).min("dimsortnum").finish();
                dataSet = dataSet.orderBy(new String[]{"dimsortnum asc"});
                if (start >= 0 && limit > 0) {
                    dataSet = dataSet.range(start, limit);
                }
                Map<String, String> propMap = dimParser.getOriginalPropMap();
                for (Row row : dataSet) {
                    HashMap tempMap = Maps.newHashMapWithExpectedSize((int)16);
                    for (Map.Entry<String, String> entry : propMap.entrySet()) {
                        String fieldAlias = entry.getValue().toUpperCase().replaceAll("\\$", "_S_");
                        if (fieldAlias.contains("!")) {
                            String[] split = fieldAlias.split("!");
                            fieldAlias = fieldAlias.replace("!", "_F_");
                            if ("int".equals(SplitDateTypeUtil.getDataType(split[1]))) {
                                tempMap.put(entry.getKey(), row.getInteger(fieldAlias));
                                continue;
                            }
                            tempMap.put(entry.getKey(), row.get(fieldAlias));
                            continue;
                        }
                        tempMap.put(entry.getKey(), row.get(fieldAlias));
                    }
                    listDB.add(tempMap);
                }
            }
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.warn(kdBizException.getMessage());
                ArrayList arrayList = listDB;
                return arrayList;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            if (exception.getCause() instanceof SQLException) {
                throw new KDBizException(ResManager.loadKDString((String)"KSql\u6267\u884c\u5931\u8d25\u3002", (String)"KSqlQueryService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            throw new KDBizException(exception.getMessage());
        }
        finally {
            if (MapUtils.isNotEmpty(this.getTmpTableSQLOfSyncMap())) {
                DB.endThreadReadWrite();
            }
            this.closePKTempTable(this.getTmpTableSQLOfSyncMap());
        }
        return listDB;
    }

    private String transDateSplitSelectList(String sqlStr) {
        String selectList = sqlStr.substring(0, sqlStr.indexOf(" FROM "));
        String fromStr = sqlStr.substring(sqlStr.indexOf(" FROM "));
        selectList = selectList.replace("!", "_F_");
        return selectList + fromStr;
    }

    private DataSet queryDataSet(String sql, DBRoute dbRoute, Object[] params) {
        String algoKey = "DimKSqlQueryService.queryDimFromDb";
        return (DataSet)HRDBUtil.query((DBRoute)dbRoute, (String)sql, (Object[])params, resultSet -> {
            Map<String, Integer> columnDataTypeMap = this.getDBColumnDataType(resultSet);
            Field[] fields = new Field[columnDataTypeMap.size()];
            int idx = 0;
            for (Map.Entry<String, Integer> entry : columnDataTypeMap.entrySet()) {
                fields[idx++] = new Field(entry.getKey(), DataType.fromSqlType((int)entry.getValue()), true);
            }
            RowMeta nowDsRm = new RowMeta(fields);
            DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(nowDsRm);
            ArrayList<Object[]> rowList = new ArrayList<Object[]>(10);
            while (resultSet.next()) {
                Object[] objects = new Object[columnDataTypeMap.size()];
                idx = 0;
                for (Map.Entry<String, Integer> entry : columnDataTypeMap.entrySet()) {
                    String columnKey = entry.getKey();
                    if (entry.getValue() == 93) {
                        Timestamp timestamp = resultSet.getTimestamp(columnKey);
                        objects[idx++] = timestamp;
                        continue;
                    }
                    objects[idx++] = resultSet.getObject(columnKey);
                }
                rowList.add(objects);
            }
            for (Object[] objects : rowList) {
                dataSetBuilder.append(objects);
            }
            return dataSetBuilder.build();
        });
    }

    private HRComplexObjContext genDimComplexObjCont(HRComplexObjContext originalCompObj) {
        List<HRComplexObjFieldInfo> queryFieldList = this.genDimQueryFieldList(originalCompObj);
        HRComplexObjContext dimCompObj = new HRComplexObjContext();
        dimCompObj.setQfilterList(new ArrayList(originalCompObj.getQfilterList()));
        dimCompObj.setJoinRelationList(new ArrayList(originalCompObj.getJoinRelationList()));
        dimCompObj.setComplexObjFieldInfoList(queryFieldList);
        dimCompObj.setEntityTable(originalCompObj.getEntityTable());
        dimCompObj.setEntityNumber(originalCompObj.getEntityNumber());
        dimCompObj.setDataExtractQuery(originalCompObj.isDataExtractQuery());
        dimCompObj.setSortFieldInfoList(new ArrayList(originalCompObj.getSortFieldInfoList()));
        return dimCompObj;
    }

    private List<HRComplexObjFieldInfo> genDimQueryFieldList(HRComplexObjContext originalCompObj) {
        List groupFieldList = originalCompObj.getGroupFieldList();
        ArrayList<HRComplexObjFieldInfo> queryFieldList = new ArrayList<HRComplexObjFieldInfo>(originalCompObj.getGroupFieldList().size());
        HashSet allDependFieldAliasMap = new HashSet(16);
        HashSet<String> calFieldAliasSet = new HashSet<String>(16);
        for (HRComplexObjFieldInfo fieldInfo : groupFieldList) {
            if ("1".equals(fieldInfo.getFieldType())) {
                queryFieldList.add(fieldInfo);
                continue;
            }
            calFieldAliasSet.add(fieldInfo.getAlias());
            Set refFieldAliasSet = fieldInfo.getRefFieldAliasSet();
            allDependFieldAliasMap.addAll(refFieldAliasSet);
        }
        Set loadField = queryFieldList.stream().map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        for (String fieldAlias : allDependFieldAliasMap) {
            if (loadField.contains(fieldAlias) || calFieldAliasSet.contains(fieldAlias)) continue;
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(fieldAlias, "1", fieldAlias);
            fieldInfo.setDataType(DataTypeEnum.STRING);
            queryFieldList.add(fieldInfo);
        }
        return queryFieldList;
    }

    protected void dimensionDataTypeConvert(KSqlParser parser, List<Map<String, DimensionData>> listDB) {
        Map<String, DataTypeEnum> dataTypeMap = parser.getEntityFieldInfoList().stream().collect(Collectors.toMap(EntityFieldInfo::getAlias, EntityFieldInfo::getDataType));
        for (Map<String, DimensionData> mapData : listDB) {
            for (Map.Entry<String, DimensionData> entry : mapData.entrySet()) {
                String key = entry.getKey();
                DimensionData dimensionData = entry.getValue();
                Object val = DataTypeConvertUtil.toConvert(dataTypeMap.get(key), dimensionData.getValue());
                dimensionData.setValue(val);
            }
        }
    }

    private void formatSplitDateFieldVal(KSqlParser parser, List<Map<String, DimensionData>> listDB) {
        Map<String, SplitDateTypeEnum> splitDateFieldMap = parser.getEntityFieldInfoList().stream().filter(field -> field.getSplitDateType() != null).collect(Collectors.toMap(EntityFieldInfo::getAlias, EntityFieldInfo::getSplitDateType, (x, y) -> x));
        for (Map<String, DimensionData> mapData : listDB) {
            for (Map.Entry<String, DimensionData> entry : mapData.entrySet()) {
                String key = entry.getKey();
                if (!splitDateFieldMap.containsKey(key)) continue;
                DimensionData dimensionData = entry.getValue();
                Object val = DateTransUtils.dateDbValFormat((String)dimensionData.getValue(), (String)splitDateFieldMap.get(key).getKey());
                dimensionData.setValue(val);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected void fillDimensionFunctionField(List<Map<String, DimensionData>> listDB) {
        List calFieldList = this.getComplexObjCont().getComplexObjFieldInfoList().stream().filter(af -> !af.getFieldType().equals("1")).collect(Collectors.toList());
        for (HRComplexObjFieldInfo complexObjFieldInfo : calFieldList) {
            String formula = complexObjFieldInfo.getFullPath();
            String alias = complexObjFieldInfo.getAlias();
            Expr expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
            LOGGER.info("complexobj load formula fieldalias:{}, formula:{}", (Object)alias, (Object)formula);
            Set refFieldAliasSet = complexObjFieldInfo.getRefFieldAliasSet();
            for (Map<String, DimensionData> dataMap : listDB) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                for (String key : refFieldAliasSet) {
                    DimensionData dimensionData = dataMap.get(key);
                    if (dimensionData != null) {
                        paramMap.putIfAbsent(key, dimensionData.getValue());
                        continue;
                    }
                    paramMap.putIfAbsent(key, null);
                }
                Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
                dataMap.put(alias, new DimensionData(val, false, null));
            }
        }
    }

    private String[] getFieldNames(List<EntityFieldInfo> entityFieldInfoList) {
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)entityFieldInfoList.size());
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            if (entityFieldInfo.getAlias() != null) {
                fieldNameSet.add(entityFieldInfo.getAlias());
            }
            if (entityFieldInfo.getConvertField() == null) continue;
            fieldNameSet.add(entityFieldInfo.getConvertField());
        }
        return fieldNameSet.toArray(new String[0]);
    }
}

