/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.FieldQueryAliasUtil;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class KSqlFieldParser {
    private final KSqlParser kSqlParser;

    public KSqlFieldParser(KSqlParser kSqlParser) {
        this.kSqlParser = kSqlParser;
    }

    public Map<String, String> getAllFields() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        List fieldInfoList = this.kSqlParser.getEntityFieldInfoList().stream().filter(field -> !this.kSqlParser.getExtraField4TbJoin().contains(field.getAlias())).collect(Collectors.toList());
        for (EntityFieldInfo entityFieldInfo : fieldInfoList) {
            try {
                SplitDateTypeEnum splitDateType = entityFieldInfo.getSplitDateType();
                if (!this.kSqlParser.isProcessDateByDb()) {
                    splitDateType = null;
                }
                String convertField = entityFieldInfo.getConvertField();
                fieldMap.put(convertField, FieldQueryAliasUtil.genFieldQueryAliasNoQuotation(convertField, splitDateType));
            }
            catch (KDBizException kdBizException) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\u3002\u5b9e\u4f53\u7f16\u7801\uff1a%1$s\uff0c\u5b57\u6bb5\uff1a%2$s\u3002", (String)"KSqlFieldParser_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityFieldInfo.getFieldEntityNumber(), entityFieldInfo.getAlias());
                throw new KDBizException(errMsg);
            }
        }
        return fieldMap;
    }

    public Map<String, String> getExcludeExtraFields() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        List entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList().stream().filter(field -> !this.kSqlParser.getExtraFieldAliasSet().contains(field.getAlias())).filter(field -> !this.kSqlParser.getExtraField4TbJoin().contains(field.getAlias())).collect(Collectors.toList());
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            String convertField = entityFieldInfo.getConvertField();
            if (HRStringUtils.isEmpty((String)convertField)) {
                throw new KDBizException("queryfield param error: " + entityFieldInfo.getAlias());
            }
            SplitDateTypeEnum splitDateType = entityFieldInfo.getSplitDateType();
            if (!this.kSqlParser.isProcessDateByDb()) {
                splitDateType = null;
            }
            String key = convertField;
            if (splitDateType != null) {
                key = key + "!" + splitDateType.getKey();
            }
            fieldMap.put(key, FieldQueryAliasUtil.genFieldQueryAliasNoQuotation(convertField, splitDateType));
        }
        return fieldMap;
    }
}

