/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.CustomSortInfo;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.FieldStoreInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class KSqlOrderByParser {
    private final HRComplexObjContext complexObjCont;
    private final KSqlParser kSqlParser;
    private final Map<String, EntityFieldInfo> fieldInfoMap;

    public KSqlOrderByParser(HRComplexObjContext complexObjCont, KSqlParser kSqlParser) {
        this.complexObjCont = complexObjCont;
        this.kSqlParser = kSqlParser;
        this.fieldInfoMap = kSqlParser.getEntityFieldInfoList().stream().collect(Collectors.toMap(EntityFieldInfo::getAlias, Function.identity(), (x, y) -> x));
    }

    public String transforOrderBy(Table<String, String, String> aliasToOrderByField) {
        List sortFieldInfoList = this.complexObjCont.getSortFieldInfoList();
        if (CollectionUtils.isEmpty((Collection)sortFieldInfoList)) {
            return "";
        }
        StringBuilder orderBys = new StringBuilder();
        HashSet<String> customSortField = new HashSet<String>(16);
        for (int i = 0; i < sortFieldInfoList.size(); ++i) {
            SortFieldInfo sortFieldInfo = (SortFieldInfo)sortFieldInfoList.get(i);
            EntityFieldInfo fieldInfo = this.fieldInfoMap.get(sortFieldInfo.getFieldAlias());
            if (fieldInfo == null) continue;
            if (sortFieldInfo.isCustomSort() || fieldInfo.getCustomSortInfo() != null) {
                if (customSortField.contains(sortFieldInfo.getFieldAlias())) continue;
                this.customSort(aliasToOrderByField, orderBys, sortFieldInfo, fieldInfo);
                customSortField.add(sortFieldInfo.getFieldAlias());
                continue;
            }
            if (!sortFieldInfo.isSqlSort()) continue;
            this.normalSort(aliasToOrderByField, orderBys, sortFieldInfo, fieldInfo);
        }
        String orderByStr = orderBys.toString();
        if (orderByStr.endsWith(",")) {
            orderByStr = orderByStr.substring(0, orderByStr.length() - 1);
        }
        return orderByStr;
    }

    private void customSort(Table<String, String, String> aliasToOrderByField, StringBuilder orderBys, SortFieldInfo sortFieldInfo, EntityFieldInfo fieldInfo) {
        CustomSortInfo customSortInfo = fieldInfo.getCustomSortInfo();
        if (customSortInfo != null && customSortInfo.getCustomSortPk() == null) {
            return;
        }
        String orderBy = "desc";
        if (sortFieldInfo.isSqlSort() && customSortInfo != null) {
            orderBy = sortFieldInfo.getSortord();
        }
        String tableAlias = "custom_sort" + sortFieldInfo.getSeq();
        orderBys.append(tableAlias).append('.').append("findex").append(' ').append(orderBy).append(',');
        if (aliasToOrderByField != null) {
            aliasToOrderByField.put((Object)sortFieldInfo.getFieldAlias(), (Object)(tableAlias + '.' + "findex"), (Object)(tableAlias + "_" + "findex"));
        }
    }

    private void normalSort(Table<String, String, String> aliasToOrderByField, StringBuilder orderBys, SortFieldInfo sortFieldInfo, EntityFieldInfo fieldInfo) {
        String table;
        CustomSortInfo customSortInfo = fieldInfo.getCustomSortInfo();
        if (customSortInfo != null && customSortInfo.getCustomSortPk() == null) {
            return;
        }
        String fieldEntityAlias = fieldInfo.getFieldEntityAlias();
        String shamTable = table = fieldInfo.getTable();
        String dbField = fieldInfo.getDbField();
        FieldStoreInfo fieldStoreInfo = fieldInfo.getFieldStoreInfo();
        if (fieldStoreInfo != null) {
            table = fieldStoreInfo.getTable();
            shamTable = fieldStoreInfo.getAliasAndTable();
            dbField = fieldStoreInfo.getRealDbField();
            FieldStoreInfo reference = fieldStoreInfo.getReference();
            if (reference != null) {
                table = reference.getTable();
                shamTable = reference.getAliasAndTable();
                dbField = reference.getRealDbField();
            }
        }
        if (fieldInfo.isMultiLangField()) {
            table = fieldInfo.getMultiLanguageTb();
        }
        if (HRStringUtils.isEmpty((String)dbField)) {
            return;
        }
        this.kSqlParser.addUnIgnoreTable(fieldEntityAlias, table);
        String aliasName = this.kSqlParser.getTableAliasMap().get(fieldEntityAlias).get(shamTable);
        orderBys.append(aliasName).append('.').append(dbField).append(' ').append(sortFieldInfo.getSortord());
        orderBys.append(',');
        if (aliasToOrderByField != null) {
            aliasToOrderByField.put((Object)sortFieldInfo.getFieldAlias(), (Object)(aliasName + '.' + dbField), (Object)(aliasName + "_" + dbField));
        }
    }

    public String transforOrderBy() {
        return this.transforOrderBy(null);
    }
}

