/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.ksql.ComplexMultiLangFielder;
import kd.hr.hbp.business.service.complexobj.ksql.ComplexPrivacyFiledLoader;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.ksql.KsqlSplitParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.BaseDataLoadUtil;
import kd.hr.hbp.business.service.complexobj.util.DataSetTransUtil;
import kd.hr.hbp.business.service.complexobj.util.DataTypeConvertUtil;
import kd.hr.hbp.business.service.complexobj.util.FilterTransJoinFunction;
import kd.hr.hbp.business.service.complexobj.util.JoinConditionTrans;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.business.service.complexobj.util.SplitDateQFilterUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.report.DateTransUtils;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import org.apache.commons.collections.MapUtils;

public class KSqlQueryService {
    private static final Log LOGGER = LogFactory.getLog(KSqlQueryService.class);
    private HRComplexObjContext complexObjCont;
    private final HRComplexObjContext sourceComplexObjCont;
    private KSqlParser kSqlParser;
    private final Map<String, PKTempTable> tmpTableSQLOfSyncMap = new HashMap<String, PKTempTable>();
    protected RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;

    public KSqlQueryService(HRComplexObjContext complexObjCont) {
        this.sourceComplexObjCont = complexObjCont;
        this.complexObjCont = complexObjCont;
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(complexObjCont, complexObjCont.getComplexObjFieldInfoList());
    }

    public DataSet query4DataSet() {
        return this.query4DataSet(-1, -1);
    }

    public DataSet query4DataSet(int start, int limit) {
        KSqlParser parser = this.getParser();
        List<Map<String, Object>> dataList = this.query4ListMap(start, limit);
        List<HRComplexObjFieldInfo> calFieldList = this.complexObjCont.getComplexObjFieldInfoList().stream().filter(af -> !af.getFieldType().equals("1")).collect(Collectors.toList());
        Table<String, String, String> orderFieldTable = parser.getAliasToOrderFieldTable();
        return DataSetTransUtil.convertToDataSet(this.complexObjCont, dataList, parser.getEntityFieldInfoList(), calFieldList, orderFieldTable);
    }

    public List<Map<String, Object>> query4ListMap() {
        return this.query4ListMap(-1, -1);
    }

    @ExcludeFromJacocoGeneratedReport
    private List<HRComplexObjContext> getSplitComplexObjCxtList(KsqlSplitParser splitParser) {
        ArrayList<HRComplexObjContext> splitCxtList = new ArrayList<HRComplexObjContext>(10);
        boolean first = true;
        Set<String> entityAlias = splitParser.getNextSplitEntityAlias();
        while (!CollectionUtils.isEmpty(entityAlias)) {
            HRComplexObjContext context = this.getSplitComplexObjCxt(splitParser.getComplexObjCont(), entityAlias, first);
            splitCxtList.add(context);
            first = false;
            entityAlias = splitParser.getNextSplitEntityAlias();
        }
        return splitCxtList;
    }

    @ExcludeFromJacocoGeneratedReport
    private HRComplexObjContext getSplitComplexObjCxt(HRComplexObjContext complexObjCont, Set<String> entityAlias, boolean first) {
        try {
            HRComplexObjContext context = complexObjCont.clone();
            List joinList = complexObjCont.getJoinRelationList().stream().filter(r -> entityAlias.contains(r.getRelEntityAlias())).collect(Collectors.toList());
            context.setJoinRelationList(joinList);
            List allEntityNumbers = complexObjCont.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toList());
            List entityNumbers = joinList.stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toList());
            List fieldList = complexObjCont.getComplexObjFieldInfoList().stream().filter(field -> {
                String curEntity = field.getFullPath().split("\\.")[0];
                return entityNumbers.contains(curEntity) || first && !allEntityNumbers.contains(curEntity);
            }).collect(Collectors.toList());
            if (fieldList.stream().noneMatch(info -> info.getAlias().equals("id"))) {
                if (null != complexObjCont.getIdType()) {
                    HRComplexObjFieldInfo idInfo = new HRComplexObjFieldInfo("id", complexObjCont.getIdType(), "id");
                    fieldList.add(idInfo);
                } else {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)complexObjCont.getEntityNumber());
                    if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                        HRComplexObjFieldInfo idInfo = new HRComplexObjFieldInfo("id", DataTypeEnum.LONG, "id");
                        fieldList.add(idInfo);
                        complexObjCont.setIdType(DataTypeEnum.LONG);
                    } else {
                        HRComplexObjFieldInfo idInfo = new HRComplexObjFieldInfo("id", DataTypeEnum.STRING, "id");
                        fieldList.add(idInfo);
                        complexObjCont.setIdType(DataTypeEnum.STRING);
                    }
                }
            }
            context.setComplexObjFieldInfoList(fieldList);
            if (!first) {
                context.setOrder(false);
                context.setOrderBy("");
                context.setSortFieldInfoList(null);
                context.setQfilterList(null);
            }
            return context;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Throwable)e);
            return complexObjCont;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap(int start, int limit) {
        List dataList;
        KSqlParser parser = this.getParser();
        long sqlRunStartTime = System.currentTimeMillis();
        if ("1".equals(this.complexObjCont.getQueryMode()) && this.complexObjCont.isKSQLDetailOptimize()) {
            KsqlSplitParser splitParser = new KsqlSplitParser(this.complexObjCont);
            if (splitParser.isSplit()) {
                int i;
                List<HRComplexObjContext> splitCxtList = this.getSplitComplexObjCxtList(splitParser);
                Set<Object> pks = new HashSet(16);
                ArrayList<List<Map<String, Object>>> resultList = new ArrayList<List<Map<String, Object>>>();
                for (i = 0; i < splitCxtList.size(); ++i) {
                    List<Map<String, Object>> splitList;
                    KSqlParser ksqlParser;
                    HRComplexObjContext context = splitCxtList.get(i);
                    if (i == 0) {
                        ksqlParser = new KSqlParser(context);
                        splitList = this.queryFromDb(ksqlParser, start, limit);
                        pks = splitList.stream().map(m -> {
                            if (splitParser.getComplexObjCont().getIdType() == DataTypeEnum.LONG) {
                                return Long.parseLong((String)m.get("id"));
                            }
                            return m.get("id");
                        }).collect(Collectors.toSet());
                        resultList.add(splitList);
                        continue;
                    }
                    context.setQfilterList(Collections.singletonList(new QFilter("id", "in", pks)));
                    ksqlParser = new KSqlParser(context);
                    splitList = this.queryFromDb(ksqlParser, -1, -1);
                    resultList.add(splitList);
                }
                this.assembleResult(resultList);
                dataList = (List)resultList.get(0);
                for (i = 0; i < dataList.size(); ++i) {
                    ((Map)dataList.get(i)).put("rptdbsortidx", i + 1);
                }
            } else {
                dataList = this.queryFromDb(start, limit);
            }
        } else {
            dataList = this.queryFromDb(start, limit);
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("complexobj sql execute elapsed time:{}", (Object)(startTime - sqlRunStartTime));
        List<EntityFieldInfo> entityFieldInfos = parser.getEntityFieldInfoList().stream().filter(field -> !parser.getExtraField4TbJoin().contains(field.getAlias())).collect(Collectors.toList());
        BaseDataLoadUtil.reloadBdProp(dataList, entityFieldInfos);
        long loadPropTime = System.currentTimeMillis();
        LOGGER.info("complexobj load basedataprop elapsed time:{}", (Object)(loadPropTime - startTime));
        ComplexMultiLangFielder multiLangFielder = new ComplexMultiLangFielder(true);
        multiLangFielder.reloadSpecialField(dataList, this.complexObjCont, parser.getEntityFieldInfoList());
        long loadMulTime = System.currentTimeMillis();
        LOGGER.info("complexobj load multi-language elapsed time:{}", (Object)(loadMulTime - loadPropTime));
        ComplexPrivacyFiledLoader privacyFiledLoader = new ComplexPrivacyFiledLoader(true);
        privacyFiledLoader.reloadSpecialField(dataList, this.complexObjCont, parser.getEntityFieldInfoList());
        long privacy = System.currentTimeMillis();
        LOGGER.info("complexobj load privacy field elapsed time:{}", (Object)(privacy - loadMulTime));
        long dataConvert = System.currentTimeMillis();
        this.dataTypeConvert(parser, dataList);
        this.splitDateField(parser, dataList);
        long fillFormula = System.currentTimeMillis();
        this.fillFunctionField(dataList);
        LOGGER.info("complexobj load formula field elapsed time:{}", (Object)(fillFormula - dataConvert));
        if (!this.complexObjCont.isTransferField()) {
            BaseDataLoadUtil.dataTransfer(dataList, parser.getEntityFieldInfoList(), this.complexObjCont.getComplexObjFieldInfoList(), this.complexObjCont);
        }
        LOGGER.info("complexobj data type trans elapsed time:{}", (Object)(dataConvert - privacy));
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public Long queryDataCount(int start, int limit) {
        String countSqlStr;
        KSqlParser parser = this.getParser();
        try {
            countSqlStr = parser.getCountSqlStr(this.tmpTableSQLOfSyncMap, start, limit);
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.error(kdBizException.getMessage());
                return 0L;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        Object[] params = this.getSQLParames(countSqlStr);
        countSqlStr = this.localTransPlaceholder(countSqlStr);
        Long count = 0L;
        DataSet dataSet = null;
        try {
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.beginThreadWrite();
            }
            if (!(dataSet = DB.queryDataSet((String)"kd.hr.hbp.business.service.complexobj.ksql.KSqlQueryService", (DBRoute)parser.getDBRoute(), (String)countSqlStr, (Object[])params)).isEmpty()) {
                count = ((Row)dataSet.iterator().next()).getLong(0);
                if (start >= 0 && limit >= 0 && count > (long)limit) {
                    count = limit;
                }
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.endThreadReadWrite();
            }
            for (Map.Entry<String, PKTempTable> entry : this.tmpTableSQLOfSyncMap.entrySet()) {
                entry.getValue().close();
            }
        }
        return count;
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Map<String, Object>> queryFromDb(int start, int limit) {
        KSqlParser parser = this.getParser();
        try {
            String sqlStr = start >= 0 && limit > 0 ? parser.getSqlStr(this.tmpTableSQLOfSyncMap, start, limit) : parser.getSqlStr(this.tmpTableSQLOfSyncMap);
            LOGGER.info("complexobj execute sql:{}", (Object)sqlStr);
            Object[] params = this.getSQLParames(sqlStr);
            sqlStr = this.localTransPlaceholder(sqlStr);
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.beginThreadWrite();
            }
            List<Map<String, Object>> list = this.queryData(parser, sqlStr, params);
            return list;
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.error(kdBizException.getMessage());
                List<Map<String, Object>> list = Collections.emptyList();
                return list;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            if (exception.getCause() instanceof SQLException) {
                throw new KDBizException(ResManager.loadKDString((String)"KSql\u6267\u884c\u5931\u8d25\u3002", (String)"KSqlQueryService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            throw new KDBizException(exception.getMessage());
        }
        finally {
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.endThreadReadWrite();
            }
            this.closePKTempTable(this.tmpTableSQLOfSyncMap);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Map<String, Object>> queryFromDb(KSqlParser parser, int start, int limit) {
        try {
            String sqlStr = start >= 0 && limit > 0 ? parser.getSqlStr(this.tmpTableSQLOfSyncMap, start, limit) : parser.getSqlStr(this.tmpTableSQLOfSyncMap);
            LOGGER.info("complexobj execute sql:{}", (Object)sqlStr);
            Object[] params = this.getSQLParames(sqlStr);
            sqlStr = this.localTransPlaceholder(sqlStr);
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.beginThreadWrite();
            }
            List<Map<String, Object>> list = this.queryData(parser, sqlStr, params);
            return list;
        }
        catch (KDBizException kdBizException) {
            if (kdBizException.getErrorCode().getCode().equals(ComplexConstant.NO_QUERY.getCode())) {
                LOGGER.error(kdBizException.getMessage());
                List<Map<String, Object>> list = Collections.emptyList();
                return list;
            }
            LOGGER.error((Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            if (exception.getCause() instanceof SQLException) {
                throw new KDBizException(ResManager.loadKDString((String)"KSql\u6267\u884c\u5931\u8d25\u3002", (String)"KSqlQueryService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            throw new KDBizException(exception.getMessage());
        }
        finally {
            if (MapUtils.isNotEmpty(this.tmpTableSQLOfSyncMap)) {
                DB.endThreadReadWrite();
            }
            this.closePKTempTable(this.tmpTableSQLOfSyncMap);
        }
    }

    protected List<Map<String, Object>> queryData(KSqlParser kSqlParser, String sqlStr, Object[] params) {
        return this.queryData(kSqlParser, sqlStr, params, 1);
    }

    protected List<Map<String, Object>> queryData(KSqlParser kSqlParser, String sqlStr, Object[] params, int startRowNum) {
        return (List)HRDBUtil.query((DBRoute)kSqlParser.getDBRoute(), (String)sqlStr, (Object[])params, rs -> {
            ArrayList listDB = Lists.newArrayListWithCapacity((int)16);
            Map<String, Integer> columnDataTypeMap = this.getDBColumnDataType(rs);
            Map<String, String> propMap = kSqlParser.getPropMap();
            Table<String, String, String> orderFieldTable = kSqlParser.getAliasToOrderFieldTable();
            int rowNum = startRowNum;
            while (rs.next()) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)propMap.size());
                for (Map.Entry<String, String> entry : propMap.entrySet()) {
                    String columnName = entry.getValue().toLowerCase();
                    if (columnDataTypeMap.get(columnName) == 93) {
                        tempMap.put(entry.getKey(), rs.getTimestamp(columnName));
                        continue;
                    }
                    tempMap.put(entry.getKey(), rs.getString(columnName));
                }
                for (Table.Cell orderFieldNameCell : orderFieldTable.cellSet()) {
                    String orderFieldName = (String)orderFieldNameCell.getValue();
                    tempMap.put(orderFieldName, rs.getString(orderFieldName));
                }
                tempMap.put("rptdbsortidx", rowNum++);
                listDB.add(tempMap);
            }
            return listDB;
        });
    }

    protected Map<String, Integer> getDBColumnDataType(ResultSet rs) throws SQLException {
        HashMap<String, Integer> columnDataTypeMap = new HashMap<String, Integer>(16);
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            int columnType = rs.getMetaData().getColumnType(i);
            String columnName = rs.getMetaData().getColumnLabel(i);
            columnDataTypeMap.put(columnName.toLowerCase(), columnType);
        }
        return columnDataTypeMap;
    }

    protected void fillFunctionField(List<Map<String, Object>> listDB) {
        List calFieldList = this.complexObjCont.getComplexObjFieldInfoList().stream().filter(af -> !af.getFieldType().equals("1")).collect(Collectors.toList());
        for (HRComplexObjFieldInfo complexObjFieldInfo : calFieldList) {
            String formula = complexObjFieldInfo.getFullPath();
            String alias = complexObjFieldInfo.getAlias();
            Expr expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
            LOGGER.info("complexobj load formula fieldalias:{}, formula:{}", (Object)alias, (Object)formula);
            Set refFieldAliasSet = complexObjFieldInfo.getRefFieldAliasSet();
            for (Map<String, Object> dataMap : listDB) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                for (String key : refFieldAliasSet) {
                    paramMap.putIfAbsent(key, dataMap.get(key));
                }
                Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
                val = QueryEntityUtil.convertDataValueType((DataTypeEnum)complexObjFieldInfo.getDataType(), (Object)val, null, (HRComplexObjContext)this.complexObjCont);
                dataMap.put(alias, val);
            }
        }
    }

    protected void resetSplitDateFieldType(KSqlParser parser) {
        List<EntityFieldInfo> entityFieldInfoList = parser.getEntityFieldInfoList();
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            SplitDateTypeEnum splitDateType = entityFieldInfo.getSplitDateType();
            if (splitDateType == null) continue;
            entityFieldInfo.setDataType(DataTypeEnum.STRING);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected void splitDateField(KSqlParser parser, List<Map<String, Object>> listDB) {
        if (parser.isProcessDateByDb()) {
            return;
        }
        Map<String, SplitDateTypeEnum> dataTypeMap = parser.getEntityFieldInfoList().stream().filter(field -> field.getSplitDateType() != null).collect(Collectors.toMap(EntityFieldInfo::getAlias, EntityFieldInfo::getSplitDateType));
        if (dataTypeMap.isEmpty()) {
            return;
        }
        for (Map<String, Object> mapData : listDB) {
            dataTypeMap.forEach((fieldAlias, splitDateType) -> {
                String[] fieldSplit = fieldAlias.split("!");
                String propVal = null;
                Object dateObj = mapData.get(fieldSplit[0]);
                if (dateObj instanceof Date) {
                    Date date = (Date)dateObj;
                    propVal = DateTransUtils.transferDate((Date)date, (String)splitDateType.getKey(), null);
                } else if (dateObj instanceof String) {
                    try {
                        Date date = HRDateTimeUtils.parseDate((String)((String)dateObj));
                        propVal = DateTransUtils.transferDate((Date)date, (String)splitDateType.getKey(), null);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                mapData.put((String)fieldAlias, propVal);
            });
        }
    }

    protected void dataTypeConvert(KSqlParser parser, List<Map<String, Object>> listDB) {
        Map<String, DataTypeEnum> dataTypeMap = parser.getEntityFieldInfoList().stream().collect(Collectors.toMap(EntityFieldInfo::getAlias, EntityFieldInfo::getDataType));
        if (dataTypeMap.isEmpty()) {
            return;
        }
        for (Map<String, Object> mapData : listDB) {
            for (Map.Entry<String, Object> entry : mapData.entrySet()) {
                String key = entry.getKey();
                Object val = DataTypeConvertUtil.toConvert(dataTypeMap.get(key), entry.getValue());
                mapData.put(key, val);
            }
        }
    }

    protected Object[] getSQLParames(String sqlStr) {
        int len3;
        int len2;
        Object[] params = null;
        String langStr = RequestContext.get().getLang().name();
        int len1 = sqlStr.length();
        int paramesCount = (len1 - (len2 = (sqlStr = this.localTransPlaceholder(sqlStr)).length())) / (len3 = "#{flocalid}".length() - 1);
        if (paramesCount > 0) {
            params = new Object[paramesCount];
            for (int j = 0; j < paramesCount; ++j) {
                params[j] = langStr;
            }
        }
        return params;
    }

    protected String localTransPlaceholder(String sqlStr) {
        return sqlStr.replaceAll("#\\{flocalid}", "?");
    }

    protected void closePKTempTable(Map<String, PKTempTable> tmpTableMap) {
        if (tmpTableMap != null) {
            for (Map.Entry<String, PKTempTable> entry : tmpTableMap.entrySet()) {
                entry.getValue().close();
            }
            tmpTableMap.clear();
        }
    }

    public HRComplexObjContext getComplexObjCont() {
        return this.complexObjCont;
    }

    public HRComplexObjContext getSourceComplexObjCont() {
        return this.sourceComplexObjCont;
    }

    public Map<String, PKTempTable> getTmpTableSQLOfSyncMap() {
        return this.tmpTableSQLOfSyncMap;
    }

    public KSqlParser getParser() {
        if (this.kSqlParser == null) {
            this.initKsqlParser();
        }
        return this.kSqlParser;
    }

    private void initKsqlParser() {
        try {
            this.complexObjCont = HRComplexObjContext.copyComplexObjContext((HRComplexObjContext)this.sourceComplexObjCont);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JoinConditionTrans joinConditionTrans = new JoinConditionTrans(this.complexObjCont);
        joinConditionTrans.resetJoinCondition();
        this.complexObjCont.setQfilterList(SplitDateQFilterUtil.resetQFilterList(this.complexObjCont.getQfilterList()));
        LOGGER.info("after SplitDateQFilterUtil: {}", (Object)this.complexObjCont.getQfilterList());
        if (!this.complexObjCont.getSortFieldInfoList().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.complexObjCont.getEntityNumber());
            SortFieldInfo idSort = new SortFieldInfo();
            idSort.setFieldAlias(mainEntityType.getPrimaryKey().getName());
            idSort.setSeq(this.complexObjCont.getSortFieldInfoList().size() + 10);
            if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                idSort.setDataType(DataTypeEnum.LONG);
            } else {
                idSort.setDataType(DataTypeEnum.STRING);
            }
            idSort.setSortord(SortFieldInfo.SORTORD_ASC);
            this.complexObjCont.getSortFieldInfoList().add(idSort);
        }
        this.bdFilterTransJoin();
        this.kSqlParser = new KSqlParser(this.complexObjCont);
    }

    private void bdFilterTransJoin() {
        FilterTransJoinFunction filterTransJoinFunction = new FilterTransJoinFunction(this.complexObjCont);
        List<QFilter> oldQFilterList = QFilterUtil.copyQFilters(this.complexObjCont.getQfilterList());
        List qfilterList = oldQFilterList.stream().map(filter -> filter.trans((Function)filterTransJoinFunction)).collect(Collectors.toList());
        List<HRComplexObjJoinRelation> addJoinRelationList = filterTransJoinFunction.getAddJoinRelationList();
        if (addJoinRelationList.size() > 0) {
            LOGGER.info("bdFilterTransJoin_add joinCondition: {}", addJoinRelationList);
            LOGGER.info("bdFilterTransJoin_qfilterTransTo: {}", qfilterList);
            this.complexObjCont.setQfilterList(qfilterList);
            this.complexObjCont.getJoinRelationList().addAll(addJoinRelationList);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void assembleResult(List<List<Map<String, Object>>> resultList) {
        int resultSize = resultList.get(0).size();
        HashMap<Integer, Map<String, Map>> allMap = new HashMap<Integer, Map<String, Map>>(16);
        for (int j = 0; j < resultSize; ++j) {
            Map<String, Object> tempMap = resultList.get(0).get(j);
            for (int i = 1; i < resultList.size(); ++i) {
                Map<String, Map> resultMap;
                if (allMap.containsKey(i)) {
                    resultMap = (Map<String, Map>)allMap.get(i);
                } else {
                    resultMap = resultList.get(i).stream().collect(Collectors.toMap(map -> String.valueOf(map.get("id")), map -> map, (x, y) -> x));
                    allMap.put(i, resultMap);
                }
                if (!resultMap.containsKey(String.valueOf(tempMap.get("id")))) continue;
                tempMap.putAll(resultMap.get(String.valueOf(tempMap.get("id"))));
            }
        }
    }
}

