/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.AnObjJoinRelationNode;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;

@ExcludeFromJacocoGeneratedReport
public class KsqlSplitParser {
    private static final Log LOGGER = LogFactory.getLog(KsqlSplitParser.class);
    private final int separateThreshold = 8;
    private final int separateNum = 5;
    private HRComplexObjContext complexObjCont;
    private final AnObjJoinRelationNode root;
    private final List<AnObjJoinRelationNode> allNodes = new ArrayList<AnObjJoinRelationNode>(10);
    private int supplementSize;
    private int count = 0;
    private static final String LONG_SEPARATOR = "!";

    public KsqlSplitParser(HRComplexObjContext complexObjCont) {
        try {
            this.complexObjCont = complexObjCont.clone();
        }
        catch (CloneNotSupportedException e) {
            this.complexObjCont = complexObjCont;
        }
        this.root = this.getAnObjJoinRelationTree();
    }

    public boolean isSplit() {
        return this.complexObjCont.getJoinRelationList().stream().noneMatch(r -> r.getRelEntityLongNumber().split(LONG_SEPARATOR).length > 5) && this.complexObjCont.getJoinRelationList().stream().noneMatch(r -> "RightJoin".equals(r.getJoinType())) && this.complexObjCont.getJoinRelationList().size() >= 8 && this.getQfilterAndSortEntitiesSize() <= 5;
    }

    private int getQfilterAndSortEntitiesSize() {
        int queryEntitySize = this.getQfilterAndSortEntityAlias().size();
        List customSortField = this.complexObjCont.getSortFieldInfoList().stream().filter(sort -> SortFieldInfo.SORTORD_USER_DEFINED.equals(sort.getSortord())).map(SortFieldInfo::getFieldAlias).collect(Collectors.toList());
        return queryEntitySize + customSortField.size();
    }

    private Set<String> getQfilterAndSortEntityAlias(Set<String> qfilterAndSortEntities, Map<String, String> entityNumberMaps) {
        ArrayList<String> longEntityAliasList = new ArrayList<String>(qfilterAndSortEntities.size());
        for (String entity : qfilterAndSortEntities) {
            longEntityAliasList.add(entityNumberMaps.getOrDefault(entity, this.complexObjCont.getEntityNumber()));
        }
        HashSet<String> entityAlias = new HashSet<String>(16);
        for (String longEntityAlias : longEntityAliasList) {
            entityAlias.addAll(Arrays.stream(longEntityAlias.split(LONG_SEPARATOR)).collect(Collectors.toSet()));
        }
        return entityAlias;
    }

    private void recursive(List<AnObjJoinRelationNode> fields, Consumer<AnObjJoinRelationNode> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (AnObjJoinRelationNode children : fields) {
            consumer.accept(children);
            if (!CollectionUtils.isNotEmpty((Collection)children.getChildren())) continue;
            this.recursive(children.getChildren(), consumer);
        }
    }

    private Set<String> getQfilterAndSortEntityAlias() {
        Map<String, String> entityAliasMaps = this.getEntityAliasMaps();
        Set<String> qfilterAndSortFields = this.getQfilterAndSortField();
        Set<String> qfilterAndSortEntities = qfilterAndSortFields.stream().map(str -> this.getFieldAliasEntity(entityAliasMaps.keySet(), (String)str)).collect(Collectors.toSet());
        return this.getQfilterAndSortEntityAlias(qfilterAndSortEntities, entityAliasMaps);
    }

    private Map<String, String> getEntityAliasMaps() {
        HashMap<String, String> entityAliasMaps = new HashMap<String, String>(16);
        entityAliasMaps.put(this.root.getEntityAlias(), this.root.getLongEntityAlias());
        this.recursive(this.root.getChildren(), node -> entityAliasMaps.put(node.getEntityAlias(), node.getLongEntityAlias()));
        return entityAliasMaps;
    }

    private Set<String> getFirstSplitEntityAlias() {
        Set<String> qfilterAndSortEntityAlias = this.getQfilterAndSortEntityAlias();
        if (CollectionUtils.isEmpty(qfilterAndSortEntityAlias)) {
            return this.getSplitEntityAlias();
        }
        List customSortField = this.complexObjCont.getSortFieldInfoList().stream().filter(sort -> SortFieldInfo.SORTORD_USER_DEFINED.equals(sort.getSortord())).map(SortFieldInfo::getFieldAlias).collect(Collectors.toList());
        this.supplementSize = 5 - customSortField.size();
        if (this.supplementSize > qfilterAndSortEntityAlias.size()) {
            ArrayList<AnObjJoinRelationNode> selectNodes = new ArrayList<AnObjJoinRelationNode>(qfilterAndSortEntityAlias.size());
            for (String entityAlias : qfilterAndSortEntityAlias) {
                this.addNode(selectNodes, this.findNode(this.root, entityAlias));
            }
            List<AnObjJoinRelationNode> sortNodes = selectNodes.stream().sorted((x, y) -> y.getLongNumber().split(LONG_SEPARATOR).length - x.getLongNumber().split(LONG_SEPARATOR).length).collect(Collectors.toList());
            this.firstFill(selectNodes, sortNodes);
            if (this.supplementSize > 0) {
                this.secondFill(selectNodes, sortNodes);
            }
            qfilterAndSortEntityAlias.addAll(selectNodes.stream().map(AnObjJoinRelationNode::getEntityAlias).collect(Collectors.toSet()));
        }
        LOGGER.info("entityAlias:{}", qfilterAndSortEntityAlias);
        return qfilterAndSortEntityAlias;
    }

    private Set<String> getSplitEntityAlias() {
        HashSet<String> splitEntityAlias = new HashSet<String>(16);
        this.supplementSize = 5;
        ArrayList<AnObjJoinRelationNode> selectNodes = new ArrayList<AnObjJoinRelationNode>(5);
        List<AnObjJoinRelationNode> sortNodes = this.allNodes.stream().filter(n -> !n.isSelected()).sorted((x, y) -> y.getLongNumber().split(LONG_SEPARATOR).length - x.getLongNumber().split(LONG_SEPARATOR).length).collect(Collectors.toList());
        this.firstFill(selectNodes, sortNodes);
        if (this.supplementSize > 0) {
            this.secondFill(selectNodes, sortNodes);
        }
        splitEntityAlias.addAll(selectNodes.stream().map(AnObjJoinRelationNode::getEntityAlias).collect(Collectors.toSet()));
        LOGGER.info("entityAlias:{}", splitEntityAlias);
        return splitEntityAlias;
    }

    private void addChildren(List<AnObjJoinRelationNode> selectNodes, AnObjJoinRelationNode node) {
        List unSelectedNodes = node.getUnSelectedChildren();
        unSelectedNodes.forEach(n -> n.setSelected(true));
        selectNodes.addAll(unSelectedNodes);
        this.supplementSize -= unSelectedNodes.size();
    }

    private void addNode(List<AnObjJoinRelationNode> selectNodes, AnObjJoinRelationNode node) {
        if (node == null) {
            return;
        }
        node.setSelected(true);
        selectNodes.add(node);
        --this.supplementSize;
    }

    private void addParent(List<AnObjJoinRelationNode> selectNodes, AnObjJoinRelationNode node) {
        AnObjJoinRelationNode tempNode = node;
        while (!this.hasParentNode(selectNodes, tempNode)) {
            AnObjJoinRelationNode parentNode = this.getParentNode(this.root, tempNode.getLongEntityAlias());
            if (parentNode == null) {
                return;
            }
            this.addNode(selectNodes, parentNode);
            tempNode = parentNode;
        }
    }

    private void secondFill(List<AnObjJoinRelationNode> selectNodes, List<AnObjJoinRelationNode> sortNodes) {
        for (AnObjJoinRelationNode node : sortNodes) {
            int nUnselectSize;
            int unselectSize;
            if (!node.isSelected()) {
                this.addParent(selectNodes, node);
                this.addNode(selectNodes, node);
            }
            if ((unselectSize = node.getUnSelectedChildSize()) <= 0) continue;
            if (unselectSize <= this.supplementSize) {
                this.addChildren(selectNodes, node);
                continue;
            }
            for (AnObjJoinRelationNode n : node.getChildren()) {
                nUnselectSize = n.getUnSelectedChildSize();
                if (nUnselectSize <= 0 || !n.isSelected()) continue;
                if (nUnselectSize <= this.supplementSize) {
                    this.addChildren(selectNodes, n);
                } else {
                    this.secondFill(selectNodes, n.getChildren());
                }
                if (this.supplementSize != 0) continue;
                return;
            }
            for (AnObjJoinRelationNode n : node.getChildren()) {
                nUnselectSize = n.getUnSelectedChildSize();
                if (nUnselectSize <= 0 || n.isSelected()) continue;
                this.addNode(selectNodes, n);
                if (this.supplementSize == 0) {
                    return;
                }
                if (nUnselectSize <= this.supplementSize) {
                    this.addChildren(selectNodes, n);
                    continue;
                }
                this.secondFill(selectNodes, n.getChildren());
            }
        }
    }

    private boolean hasParentNode(List<AnObjJoinRelationNode> selectNodes, AnObjJoinRelationNode node) {
        return selectNodes.stream().anyMatch(n -> n.getLongEntityAlias().equals(this.getParentLongPrefix(node.getLongEntityAlias())));
    }

    private void firstFill(List<AnObjJoinRelationNode> selectNodes, List<AnObjJoinRelationNode> sortNodes) {
        for (AnObjJoinRelationNode node : sortNodes) {
            this.addParent(selectNodes, node);
            int unselectSize = node.getUnSelectedChildSize();
            if (unselectSize > 0 && unselectSize <= this.supplementSize) {
                this.addChildren(selectNodes, node);
            }
            if (this.supplementSize != 0) continue;
            break;
        }
    }

    private AnObjJoinRelationNode getAnObjJoinRelationTree() {
        AnObjJoinRelationNode root = new AnObjJoinRelationNode();
        root.setEntityNumber(this.complexObjCont.getEntityNumber());
        root.setEntityAlias(this.complexObjCont.getEntityNumber());
        root.setLongEntityAlias(this.complexObjCont.getEntityNumber());
        root.setLongNumber("0");
        this.allNodes.add(root);
        for (HRComplexObjJoinRelation joinRelation : this.complexObjCont.getJoinRelationList()) {
            AnObjJoinRelationNode child = this.joinRelation2node(joinRelation);
            this.allNodes.add(child);
            String parentLongNumber = this.getParentLongPrefix(child.getLongNumber());
            AnObjJoinRelationNode parentNode = this.findNodeByNumber(root, parentLongNumber);
            if (null == parentNode) continue;
            child.setLongEntityAlias(parentNode.getLongEntityAlias() + LONG_SEPARATOR + child.getEntityAlias());
            parentNode.addChild(child);
        }
        return root;
    }

    private AnObjJoinRelationNode getParentNode(AnObjJoinRelationNode node, String longEntityAlias) {
        String parentLongEntityAlias = this.getParentLongPrefix(longEntityAlias);
        return this.findNode(node, parentLongEntityAlias);
    }

    private AnObjJoinRelationNode findNode(AnObjJoinRelationNode node, String longEntityAlias) {
        if (node.getLongEntityAlias().equals(longEntityAlias)) {
            return node;
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (AnObjJoinRelationNode children : node.getChildren()) {
                AnObjJoinRelationNode tempNode = this.findNode(children, longEntityAlias);
                if (null == tempNode) continue;
                return tempNode;
            }
        }
        return null;
    }

    private AnObjJoinRelationNode findNodeByNumber(AnObjJoinRelationNode node, String longNumber) {
        if (node.getLongNumber().equals(longNumber)) {
            return node;
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (AnObjJoinRelationNode children : node.getChildren()) {
                AnObjJoinRelationNode tempNode = this.findNodeByNumber(children, longNumber);
                if (null == tempNode) continue;
                return tempNode;
            }
        }
        return null;
    }

    private String getParentLongPrefix(String longPrefix) {
        if (longPrefix.contains(LONG_SEPARATOR)) {
            return longPrefix.substring(0, longPrefix.lastIndexOf(LONG_SEPARATOR));
        }
        return "";
    }

    private AnObjJoinRelationNode joinRelation2node(HRComplexObjJoinRelation joinRelation) {
        AnObjJoinRelationNode child = new AnObjJoinRelationNode();
        child.setEntityNumber(joinRelation.getRelEntityNumber());
        child.setEntityAlias(joinRelation.getRelEntityAlias());
        child.setLongNumber(joinRelation.getRelEntityLongNumber());
        return child;
    }

    public Set<String> getNextSplitEntityAlias() {
        ++this.count;
        LOGGER.info("count:{}", (Object)this.count);
        if (this.count == 1) {
            return this.getFirstSplitEntityAlias();
        }
        return this.getSplitEntityAlias();
    }

    private Set<String> getQfilterAndSortField() {
        HashSet<String> fields = new HashSet<String>(16);
        for (QFilter qFilter : this.complexObjCont.getQfilterList()) {
            if (qFilter == null || StringUtils.isEmpty((CharSequence)qFilter.toString()) || qFilter.toString().equals("1 = 1")) continue;
            if (qFilter.toString().equals("1 != 1")) break;
            List nests = qFilter.getNests(false);
            fields.addAll(nests.stream().map(qFilterNest -> qFilterNest.getFilter().getProperty()).collect(Collectors.toSet()));
        }
        fields.addAll(this.complexObjCont.getSortFieldInfoList().stream().map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet()));
        return fields;
    }

    public String getFieldAliasEntity(Set<String> entityNumbers, String fieldAlias) {
        String entityAlias = fieldAlias.split("\\.")[0];
        if (entityNumbers.contains(entityAlias)) {
            return entityAlias;
        }
        return this.complexObjCont.getEntityNumber();
    }

    public HRComplexObjContext getComplexObjCont() {
        return this.complexObjCont;
    }
}

