/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class QFilterTransFunction
implements Function<QFilter, QFilter> {
    private static final Log LOGGER = LogFactory.getLog(QFilterTransFunction.class);
    private final HRComplexObjContext context;
    private final KSqlParser kSqlParser;

    public QFilterTransFunction(HRComplexObjContext context, KSqlParser kSqlParser) {
        this.context = context;
        this.kSqlParser = kSqlParser;
    }

    @Override
    public QFilter apply(QFilter filter) {
        NestedBasicDataPropertyVO vo;
        String entityName;
        if ("ftlike".equals(filter.getCP())) {
            filter.__setCP("like");
        }
        if (filter.toString().equalsIgnoreCase("1 != 1")) {
            return filter;
        }
        if (filter.getProperty().equals("1")) {
            return filter;
        }
        filter = QFilterUtil.convertPermQFilterEx(filter, this.context, this.kSqlParser.entityTypeUtil);
        Boolean isMainEntity = false;
        String propAlias = filter.getProperty();
        SplitDateTypeEnum splitDateTypeEnum = null;
        if (propAlias.contains("!")) {
            String[] propAliaSplit = propAlias.split("!");
            propAlias = propAliaSplit[0];
            splitDateTypeEnum = SplitDateTypeEnum.getEnum((String)propAliaSplit[1]);
        }
        if ((entityName = QFilterUtil.getSubEntityName(propAlias, this.context)) == null) {
            entityName = this.context.getEntityNumber();
            isMainEntity = true;
        }
        if ((vo = QFilterUtil.changeSecondLvBDToFirstLvBDByFilterEx(propAlias, filter, this.context, this.kSqlParser.entityTypeUtil)) == null) {
            vo = QFilterUtil.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity, this.context, this.kSqlParser.entityTypeUtil);
        }
        StringBuilder whereSql = new StringBuilder();
        String tableName = vo.mainEntityType.getAlias();
        if (vo.mutileLang.booleanValue() && !this.context.getGlangFilterProps().contains(propAlias) && !this.isSkipJoinMulTableForDataExtract()) {
            tableName = tableName + "_L";
        } else {
            String tableGroup = vo.dataEntityProperty.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                tableName = tableName + "_" + tableGroup;
            }
        }
        if (vo.getDataEntityProperty() instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)vo.getDataEntityProperty();
            tableName = entryProp.getItemType().getAlias();
            DynamicObjectType itemPropertyType = entryProp.getDynamicCollectionItemPropertyType();
            vo.dataEntityProperty = this.findProperty((EntityType)itemPropertyType, propAlias);
        }
        String fieldEntityAlias = QFilterUtil.getFieldEntityAlias(propAlias, this.context);
        this.kSqlParser.addUnIgnoreTable(fieldEntityAlias, tableName);
        String aliasName = this.kSqlParser.getTableAliasMap().get(fieldEntityAlias).get(tableName);
        whereSql.append(aliasName);
        whereSql.append(".").append(vo.dataEntityProperty.getAlias());
        try {
            this.processSpecialFilter(vo.filter, vo.dataEntityProperty);
        }
        catch (Exception er) {
            LOGGER.error((Throwable)er);
        }
        if (!vo.filter.getProperty().equals("1")) {
            String nowPropName = whereSql.toString();
            if (splitDateTypeEnum != null) {
                nowPropName = nowPropName + "!" + splitDateTypeEnum.getKey();
            }
            vo.filter.__setProperty(nowPropName);
        }
        return vo.filter;
    }

    private boolean isSkipJoinMulTableForDataExtract() {
        return this.context.isDataExtractQuery() && HRStringUtils.equals((String)Lang.zh_CN.getLangTag(), (String)RequestContext.get().getLang().getLangTag());
    }

    private IDataEntityProperty findProperty(EntityType relationEntityType, String propertyName) {
        IDataEntityProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.findProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    @ExcludeFromJacocoGeneratedReport
    private void processSpecialFilter(QFilter filter, IDataEntityProperty property) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Collection cl;
        if (filter.getCP().equalsIgnoreCase("not exists") && filter.getValue().toString().equalsIgnoreCase("1 = 1")) {
            filter.__setCP("=");
            filter.__setValue((Object)0L);
            return;
        }
        String[] nameKeys = filter.getProperty().split("\\.");
        if (nameKeys[nameKeys.length - 1].equalsIgnoreCase("id")) {
            if (null != filter.getValue() && filter.getValue() instanceof QEmptyValue) {
                if (property instanceof BasedataProp) {
                    IDataEntityProperty refIdProp = ((BasedataProp)property).getRefIdProp();
                    if (refIdProp instanceof LongProp) {
                        this.resetDecimalFilter(filter);
                    } else if (refIdProp instanceof VarcharProp) {
                        this.resetVarcharFilter(filter);
                    } else {
                        filter.__setCP("is null");
                    }
                } else {
                    filter.__setCP("is null");
                }
            }
        } else if (filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            Class propertyType = property.getPropertyType();
            if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE) || propertyType.equals(Long.class) || propertyType.equals(Long.TYPE) || propertyType.equals(BigDecimal.class)) {
                this.resetDecimalFilter(filter);
            } else if (propertyType.equals(String.class) || propertyType.equals(Boolean.class) || propertyType.equals(ILocaleString.class)) {
                this.resetVarcharFilter(filter);
            } else {
                filter.__setCP("is null");
            }
        }
        if (filter.getCP().equalsIgnoreCase("in") && filter.getValue() == null) {
            filter.__setCP("is null");
        }
        if (filter.getValue() != null && filter.getValue() instanceof Collection && (cl = (Collection)filter.getValue()).isEmpty()) {
            filter.__setProperty("1");
            filter.__setCP("!=");
            filter.__setValue((Object)1);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void resetVarcharFilter(QFilter filter) throws NoSuchFieldException, IllegalAccessException {
        Field field = filter.getClass().getDeclaredField("cp");
        field.setAccessible(true);
        field.set(filter, QFilterUtilHR.hrEmptyText);
    }

    @ExcludeFromJacocoGeneratedReport
    private void resetDecimalFilter(QFilter filter) throws NoSuchFieldException, IllegalAccessException {
        Field field = filter.getClass().getDeclaredField("cp");
        field.setAccessible(true);
        field.set(filter, QFilterUtilHR.hrEmptyDecimal);
    }
}

