/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.tracker;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.tracker.HRQueryMethodInfo;
import kd.hr.hbp.business.service.complexobj.tracker.HRQueryTrackConfig;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.log.HRLog;
import kd.hr.hbp.common.log.HRLogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.slf4j.helpers.MessageFormatter;

public class HRQueryLog {
    private static final Log logger = LogFactory.getLog(HRQueryLog.class);
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String INFO = " INFO ";
    private static final String ERROR = " ERROR ";
    private static final ThreadLocal<HRQueryTrackConfig> current = new ThreadLocal();
    private static final String HR_REPORT_APP = "HRPTMC";
    private static final String SPLIT_SYMBOL = ":";

    public static void initTrackConfig(long bizDataId) {
        if (bizDataId <= 0L) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        String configCacheId = bizDataId + SPLIT_SYMBOL + currUserId;
        String trackConfigStr = (String)HRAppCache.get((String)HR_REPORT_APP).get(configCacheId, String.class);
        if (HRStringUtils.isEmpty((String)trackConfigStr)) {
            return;
        }
        HRQueryTrackConfig trackConfig = (HRQueryTrackConfig)SerializationUtils.fromJsonString((String)trackConfigStr, HRQueryTrackConfig.class);
        if (bizDataId == Long.parseLong(trackConfig.getBizDataId())) {
            if (trackConfig.isEnable()) {
                current.set(trackConfig);
            } else {
                HRAppCache.get((String)HR_REPORT_APP).remove(configCacheId);
                current.remove();
            }
        }
    }

    public static String info(String message) {
        return HRQueryLog.outputString(message, INFO);
    }

    public static String info(String message, Object obj) {
        return HRQueryLog.outputString(message, INFO, obj);
    }

    public static String info(String message, Object obj, Object obj1) {
        return HRQueryLog.outputString(message, INFO, obj, obj1);
    }

    public static String info(String message, Object ... objects) {
        return HRQueryLog.outputString(message, INFO, objects);
    }

    public static String error(String message) {
        return HRQueryLog.outputString(message, ERROR);
    }

    public static String error(String message, Object obj) {
        return HRQueryLog.outputString(message, ERROR, obj);
    }

    public static String error(String message, Object obj, Object obj1) {
        return HRQueryLog.outputString(message, ERROR, obj, obj1);
    }

    public static String error(String message, Object ... objects) {
        return HRQueryLog.outputString(message, ERROR, objects);
    }

    public static String error(Throwable throwable) {
        return HRQueryLog.outputThrowable(null, throwable);
    }

    public static String error(String message, Throwable throwable) {
        return HRQueryLog.outputThrowable(message, throwable);
    }

    private static String outputString(String message, String type) {
        if (HRQueryLog.isDisableOutputLog() || HRStringUtils.isEmpty((String)message)) {
            return message;
        }
        try {
            HRQueryMethodInfo queryMethodInfo = HRQueryLog.getCurrentMethodInfo();
            String curMethodStr = HRQueryLog.getCurrentMethodTraceString(queryMethodInfo, type);
            HRQueryLog.outputHRReportLog(queryMethodInfo, curMethodStr + message);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return message;
    }

    private static String outputString(String message, String type, Object paramOne) {
        if (HRQueryLog.isDisableOutputLog() || HRStringUtils.isEmpty((String)message)) {
            return message;
        }
        try {
            HRQueryMethodInfo queryMethodInfo = HRQueryLog.getCurrentMethodInfo();
            String curMethodStr = HRQueryLog.getCurrentMethodTraceString(queryMethodInfo, type);
            message = MessageFormatter.arrayFormat((String)(curMethodStr + message), (Object[])new Object[]{paramOne}).getMessage();
            HRQueryLog.outputHRReportLog(queryMethodInfo, message);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return message;
    }

    private static String outputString(String message, String type, Object paramOne, Object paramTwo) {
        if (HRQueryLog.isDisableOutputLog() || HRStringUtils.isEmpty((String)message)) {
            return message;
        }
        try {
            HRQueryMethodInfo queryMethodInfo = HRQueryLog.getCurrentMethodInfo();
            String curMethodStr = HRQueryLog.getCurrentMethodTraceString(queryMethodInfo, type);
            message = MessageFormatter.arrayFormat((String)(curMethodStr + message), (Object[])new Object[]{paramOne, paramTwo}).getMessage();
            HRQueryLog.outputHRReportLog(queryMethodInfo, message);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return message;
    }

    private static String outputString(String message, String type, Object ... params) {
        if (HRQueryLog.isDisableOutputLog() || HRStringUtils.isEmpty((String)message)) {
            return message;
        }
        try {
            HRQueryMethodInfo queryMethodInfo = HRQueryLog.getCurrentMethodInfo();
            String curMethodStr = HRQueryLog.getCurrentMethodTraceString(queryMethodInfo, type);
            message = MessageFormatter.arrayFormat((String)(curMethodStr + message), (Object[])params).getMessage();
            HRQueryLog.outputHRReportLog(queryMethodInfo, message);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return message;
    }

    private static void outputHRReportLog(HRQueryMethodInfo methodInfo, String msg) {
        HRLog hrLog = HRLogFactory.getLog((String)current.get().getLogEntity(), HRQueryLog.class);
        DynamicObject dynamicObject = hrLog.getDynamicObject();
        String bizDataId = current.get().getBizDataId();
        dynamicObject.set("bizobjid", (Object)bizDataId);
        dynamicObject.set("opdesc", (Object)RequestContext.get().getTraceId());
        dynamicObject.set("opname", (Object)bizDataId);
        dynamicObject.set("classname", (Object)methodInfo.getClassName());
        dynamicObject.set("methodname", (Object)methodInfo.getMethodName());
        dynamicObject.set("userid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("opdate", (Object)new Date());
        dynamicObject.set("logmessage", (Object)methodInfo.toString());
        dynamicObject.set("logmessage_tag", (Object)msg);
        hrLog.info(dynamicObject);
    }

    private static String outputThrowable(String message, Throwable throwable) {
        if (HRQueryLog.isDisableOutputLog()) {
            return message;
        }
        try {
            HRQueryMethodInfo queryMethodInfo = HRQueryLog.getCurrentMethodInfo();
            String curMethodStr = HRQueryLog.getCurrentMethodTraceString(queryMethodInfo, ERROR);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(outputStream));
            String throwableMsg = HRStringUtils.isEmpty((String)message) ? curMethodStr + SPLIT_SYMBOL + outputStream.toString() : curMethodStr + message + SPLIT_SYMBOL + outputStream.toString();
            HRQueryLog.outputHRReportLog(queryMethodInfo, throwableMsg);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return message;
    }

    public static boolean isEnableOutputLog() {
        return !HRQueryLog.isDisableOutputLog();
    }

    private static boolean isDisableOutputLog() {
        HRQueryTrackConfig trackConfig = current.get();
        return trackConfig == null || !trackConfig.isEnable();
    }

    private static String getCurrentMethodTraceString(HRQueryMethodInfo queryMethodInfo, String type) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HRDateTimeUtils.format((Date)new Date(), (String)YYYY_MM_DD_HH_MM_SS_SSS)).append("[").append(queryMethodInfo.getClassName()).append(".").append(queryMethodInfo.getMethodName()).append("(").append(queryMethodInfo.getLineNumber()).append(")").append("/traceId:").append(RequestContext.get().getTraceId()).append("/time:").append(System.currentTimeMillis()).append("]").append(type).append(SPLIT_SYMBOL);
        return stringBuilder.toString();
    }

    private static HRQueryMethodInfo getCurrentMethodInfo() {
        HRQueryMethodInfo queryMethodInfo = new HRQueryMethodInfo();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement stElement = stackTraceElements[4];
        queryMethodInfo.setClassName(stElement.getClassName());
        queryMethodInfo.setMethodName(stElement.getMethodName());
        queryMethodInfo.setLineNumber(stElement.getLineNumber());
        return queryMethodInfo;
    }
}

